;---------------------------------------------------------------------------;
;                    kod rdowy gry "BOMB JACK" na C64                    ;
;                         stan na dzie 03.12.2007                          ;
;                                                                           ;
; rda dla konwersji tej gry na najlepszy 8-bitowy komputer - ATARI XL/XE ;
;---------------------------------------------------------------------------;

; CONSTANS
ScreenBuff40x25 = $5000  ; obszar nr 1 pamici ekranu (znaki)
ScreenText40x25 = $5400  ; obszar nr 2 pamici ekranu (znaki)
ColorRAM40x25   = $D800  ; obszar pamici koloru (atrybuty)
CharsetRAM      = $4800  ; obszar z ksztatami znakw wywietlanymi przez VIC-a - 2KB
IRQ_VECT        = $0314  ; wektor wskazujcy na proc. obs. przerwanie IRQ (np: RCI - Raster Compare Interrupt)
NMI_VECT        = $0318  ; wektor wskazujcy na proc. obs. przerwanie NMI (np: RESET)

; ZERO PAGE
address1        = $FB    ; word
address2        = $FD    ; word


                  org $0400

tab_Screen_BOMB   :40*25 .byte $00 ; tablica(1KB) odzwierciedlajca rozkad BOMB na ekranie gry (jeeli bajt=$01 tzn. e w tym miejscu jest lewy grny rg BOMB-y do zebrania przez BOMB JACK-a)

                  :22    .byte $00 ; nie uywane???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; po uruchomieniu gry - tutaj skaczemy najpierw!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
0821              lda #$F8
                  txs            ; ustaw wskanik stosu na $F8 (czyli prawie pusty, tylko 7 bajtw na stosie)
                  jsr StartGame  ; dziwne, e JSR bo jak bdzie RTS to sypnie si bo dalej jakie wartoci bez sensu???

; tab 1
0827              .byte $1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D,$1D
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Tutaj zaczyna si waciwa cz gry BOMB JACK!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
StartGame         lda #$FF
                  sta pos_Scroll_Text               ; ustawienie ? danej
                  jsr proc093B                      ; ustawienie danych (blokada na chwile przerwa)
                  jsr proc0D02                      ; te ustawia jakie dane?

                  sei
                  lda #$00
                  sta D022  ;VicBgClr1              ; kolor 1
                  sta D020  ;VicBorderClr           ; kolor ramki = 0
                  sta D418  ;SidFltMode             ; wyzeruj gono i filtry (TYLKO ZAPIS!)
                  sta D015  ;VicMobEnable           ; wyacz wszystkie 8 sprite'w (kady bit ustawiamy na 0)
                  lda #$04
                  sta D023  ;VicBgClr2              ; kolor 2
                  lda #$06
                  sta D021  ;VicBgClr0              ; kolor ta

                  mwa #$140C NMI_VECT               ; $140C - ustaw adres przerwania NMI - wywoywane jeeli RESET zrobimy!

                  jsr Set_Charset_SpritesON_Fill    ; ustawia szeroko/wysoko spritw, modyfikuje kod proc. rys. 40znakw*25 wierszy na ekranie

                  lda #$50
                  sta D018  ;VicMemCtrl             ; w trybie tekstowym - przesunicie 0,w trybie graficznym - przesunicie $1400 (obszar banku 16KB VIC)
                  lda D016  ;VicCtrl2               ; wczenie trybu MULTICOLOR
                  ora #$10
                  sta D016  ;VicCtrl2
                  lda #$00
                  sta D020  ;VicBorderClr           ; kolor ramki
                  jsr Set_RCI                       ; ustaw przerwanie RCI na Int_RCI!
                  jmp StartGame_Skip1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ustawienie adresu proc. odgrywajcej SID-a i przesuwajcej pyncy napis na dole ekranu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_RCI           lda #<Int_RCI                     ; RCI - Raster Compare Interrupt
                  sta Set_Int_RCI+2                 ; ustawienie adresu przerwania RCI w procedurze Set_Int_RCI (modyfikacja kodu!)
                  lda #>Int_RCI
                  sta Set_Int_RCI+7
                  jsr Set_Bank_VIC                  ; procedura ust. bank #1 dla VIC-a
                  jsr Set_Int_RCI                   ; procedura ust. przerwanie RCI dla lini ekranu 0
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
StartGame_Skip1   lda #06
                  sta D021  ;VicBgClr0              ; kolor 0
                  lda #00
                  sta D022  ;VicBgClr1              ; kolor 1
                  sta D015  ;VicMobEnable           ; sprity = OFF
                  lda #04
                  sta D023  ;VicBgClr2              ; kolor 2

                  jsr Clear_Screen40x25             ; czyci ekran i Color RAM
                  jsr Draw_Screen_TITLE             ; narysuj ekran TITLE
                  jsr StartGame_Skip3               ; wykonaj procedur czekajca kilka sekund chyba, e wcinito FIRE - to wyjcie natychmiastowe (RTS)

                  lda fire_game                     ; Czy wcinito FIRE w joy2?
                  bne StartGame_Skip2               ; =1 tak!

                  jsr Clear_Screen40x25             ; czyci ekran i Color RAM
                  jsr Add_Player_Score              ; wprowadza rezultat gracza do listy HI-SCORE
                  jsr Draw_Screen_HI_SCORE          ; narysuj ekran HI-SCORE
                  jsr StartGame_Skip3               ; wykonaj procedur czekajca kilka sekund chyba, e wcinito FIRE - to wyjcie natychmiastowe (RTS)

                  lda fire_game                     ; Czy wcinito FIRE w joy2?
                  bne StartGame_Skip2               ; =1 tak!

                  jmp StartGame_Skip1

StartGame_Skip2   lda #$00                           ; tutaj skaczemy jeeli nacinito FIRE w joy2!
                  sta D418  ;SidFltMode              ; wycisz i wycz filtry SID-a
                  sei
                  jsr Clear_Buffor40x25              ; czyci buffor ekranu 40x25
                  jmp Game_FIRE1                     ; BASIC=OFF, sei - i ta procka ustawia jakie wartoci??? - skok do rozpoczcia GRY!!!

count_game        .byte $12                          ; zlicza ilo przebiegw ptli
fire_game         .byte $00                          ; =1 nacinito FIRE w joysticku nr 2

StartGame_Skip3   mva #$12 count_game                ; x18 - tyle razy wykonaj ptle
StartGame_loop1   ldx #$FF
StartGame_loop2   ldy #$FF

                  dey
                  bne *-1                            ; $08D5

                  lda $DC00  ;Cia1DataA              ; sprawd czy FIRE nacinito?
                  cmp #$6F
                  beq StartGame_Skip4

                  dex
                  bne StartGame_loop2

                  dec count_game
                  bne StartGame_loop1
                                                     ; wyjcie bez wcinitego FIRE
                  mva #$00 fire_game
                  rts

StartGame_Skip4   inc fire_game                      ; wyjcie z wcinitym FIRE
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; dupa
;--------------------------------------------------------------------------------------------------------------------------------------------------------
08F1              sei
                  jsr BASIC_OFF
                  jsr proc8400
                  jsr SetDatas2
                  jsr BASIC_ON
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
08FF              sei
                  jsr BASIC_OFF
                  jsr proc8C4F
                  jsr SetDatas2
                  jsr BASIC_ON
                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
090E              sei
                  jsr BASIC_OFF
                  jsr proc8D59
                  jsr SetDatas2
                  jsr BASIC_ON
                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
091D              sei
                  jsr BASIC_OFF
                  jsr proc8F25
                  jsr SetDatas2
                  jsr BASIC_ON
                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
092C              sei
                  jsr BASIC_OFF
                  jsr proc8FF5
                  jsr SetDatas2
                  jsr BASIC_ON
                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc093B          sei
                  jsr BASIC_OFF
                  jsr proc9119
                  jsr SetDatas2
                  jsr BASIC_ON
                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wycza BASIC ($A000-$BF00) 8KB
;--------------------------------------------------------------------------------------------------------------------------------------------------------
BASIC_OFF         lda 01  ;CpuDataPort
                  and #FE
                  sta 01  ;CpuDataPort
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wcza BASIC ($A000-$BF00) 8KB
;--------------------------------------------------------------------------------------------------------------------------------------------------------
BASIC_ON          lda 01  ;CpuDataPort
                  ora #01
                  sta 01  ;CpuDataPort
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; przerwania IRQ - rdo RCI - Raster Compare Interrupt - $0958
; Odgrywamy tutaj SID-a i obsugujemy SCROLL tekstu na dole ekranu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Int_RCI           mva #$D8 $D016    ; VicCtrl2               - wczenie 40 kolumn i trybu MULTICOLOR
                  jsr BASIC_OFF
                  jsr proc7448      ; ustaw. SID-a???
                  jsr proc7448      ; ustaw. SID-a???
                  jsr proc7E3E      ; player SID???
                  jsr BASIC_ON
                  inc Color_Scroll_Text
                  jsr Nxt_Value_XScroll        ; oblicza kolejn warto jak naley wstawi, aby uzyska przesw o 2 pixele
                  lda Is_Scroll_Char
                  beq Int_RCI1

                  jsr Char_XScroll_RCI         ; przesw wiersza o jeden znak

Int_RCI1          mwa #Fine_XScroll_RCI IRQ_VECT
                  mva #$F2              $D012  ; VicRaster - w tym rastrze wywoaj ponownie przerwanie RCI
                  jmp End_RCI                  ; zakocz obsug przerwania RCI

; przesunicie o 2pixele w obrbie jednego znaku
Fine_XScroll_RCI  lda $D018            ; VicMemCtrl
                  and #$50             ; kasuj bity 1-3 czyli znaki zdefiniowane s w pierwszych (0*2KB) 2KB przestrzeni adresowej VIC-a $4000 (16KB)
                  cmp #$50             ; Czy obszar Matrycy Video jest od adresu $5400? ($4000+$1400)
                  beq Fine_XScroll1    ; TAK!

                  jmp Int_RCI2         ; Obszar Matrycy Video nie jest od adresu $5400

Fine_XScroll1     lda Value_XScroll
                  and #$07               ; zachowaj bity 0-2 (HORIZONTAL RASTER SCROLL)
                  ora #$10               ; ustaw bit 4 (MULTICOLOR MODE ON)
                  sta $D016              ; VicCtrl2 - przesuwa znak o 2 pixele!
                  lda Is_Sprites_Disable ; Czy SPRITE'y s wyczone?
                  bne Int_RCI2           ; TAK!

                  mva #$00      $D015      ; VicMobEnable - SPRITES OFF

Int_RCI2          mwa #Again_Int_RCI IRQ_VECT ; start przerwania RCI od pocztku
                  mva #$FC      $D012      ; VicRaster
                  jmp End_RCI              ; zakocz obsug przerwania RCI
; ??? przerw RCI
Again_Int_RCI     lda Is_Scroll_Char       ;??? - zbdny rozkaz
                  jmp Int_RCI

; ustawienie indeksu z kolejn wartoi, ktr naley wpisa, aby uzyska przesw o 2pixele (bo tryb MULTICOLOR)
Nxt_Value_XScroll lda Value_XScroll
                  sub #$02
                  and #$07                ; 7,5,3,1,7 (-1 = %11111111 = %00000111)
                  sta Value_XScroll
                  bcs Int_RCI_rts         ;slow

                  mva #01 Is_Scroll_Char  ; ustaw znacz. infor., e przesunito ju o 8pixeli w obrbie jednego znaku-teraz naley przesun zgrubnie o znak
                  rts

; przesunicie tekstu o jeden znak w lewo i zmiana koloru caego wiersza (migajcy rnymi kolorami tekst)
Char_XScroll_RCI  ldx #00

Char_XScroll_lop1 mva ScreenText40x25+$03C1,x ScreenText40x25+$03C0,x  ; przepisanie caego wiersza o jeden znak w lewo - SCROLL
                  lda D018              ; VicMemCtrl
                  and #50               ; kasuj bity 1-3 czyli znaki zdefiniowane s w pierwszych (0*2KB) 2KB przestrzeni adresowej VIC-a $4000 (16KB)
                  cmp #50               ; Czy obszar Matrycy Video jest od adresu $5400? ($4000+$1400)
                  bne Char_XScroll_skp1 ; NIE!

                  lda Color_Scroll_Text
                  ora #$09
                  sta ColorRAM40x25+$03C0,x        ; Color RAM

Char_XScroll_skp1 inx
                  cpx #$28                         ; Czy ju zmieniono atrybut dla 40 znakw?
                  bne Char_XScroll_lop1

                  inc pos_Scroll_Text              ; przy pierwszym przejciu $FF+1 = $00

; wstawia kolejny znak tekstu SCROLL na pozycji 40x25
Char_XScroll_lop2 ldx pos_Scroll_Text              ; wskanik pozycji kolejnego znaku tekstu SCROLL do wywietlenia na poz. 40x25
Char_XScroll_mod  lda Text_Scroll1,x               ; pobierz kolejny znak  (modyfikacja wartoci Text_Scroll1)
                  cmp #$FF                         ; Czy koniec tekstu?
                  beq Char_XScroll_skp2                         ; TAK!

                  add #$D0
                  sta ScreenText40x25+$03E7        ; wstaw znak na pozycji 40x25
                  mva #$00 Is_Scroll_Char          ; zeruj wskanik koniecznoci przesunicia caego wiersza o jeden znak!

Int_RCI_rts       rts

Char_XScroll_skp2 lda #$00 pos_Scroll_Text         ; tekst SCROLL bdzie wywietlany od pocztku!
                  jmp Char_XScroll_lop2

pos_Scroll_Text    .byte $04 ; wskanik pozycji kolejnego znaku tekstu SCROLL do wywietlenia na poz. 40x25
Value_XScroll      .byte $06 ; wato wykorzystywana do obliczenia wartoci jak naley wstawi, aby uzyska przesw o 2 pixele w lewo
Is_Scroll_Char     .byte $00 ; wskanik koniecznoci przesunicia caego wiersza o jeden znak! =1 naley przesun o cay znak w lewo
Color_Scroll_Text  .byte $11 ; po operacji ORA #$09 - otrzymujemy kolor uywanego tekstu SCROLL
Is_Sprites_Disable .byte $00 ; wskazuje czy SPRITE'y s wyczone = 1 SPRITES OFF
Hi_Score_Player    .byte $00,$00,$00 ; pamita najwyszy wynik HI SCORE

; Game_FIRE2 ??? data
0A1E               .byte $00
0A1F               .byte $00
0A20               .byte $00
0A21               .byte $00

; tab. 8-bajtowa (nr 0) - pierwszy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score0       .byte $10,$00,$00
                  .byte $07,$15,$04
                  .byte $00,$00
; tab. 8-bajtowa (nr 1) - drugi wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score1       .byte $09,$00,$00
                  .byte $0C,$15,$0B
                  .byte $00,$00
; tab. 8-bajtowa (nr 2) - trzeci wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score2       .byte $08,$00,$00
                  .byte $17,$09,$16
                  .byte $00,$00
; tab. 8-bajtowa (nr 3) - czwarty wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score3       .byte $07,$00,$00
                  .byte $19,$0F,$12
                  .byte $00,$00
; tab. 8-bajtowa (nr 4) - pity wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score4       .byte $06,$00,$00
                  .byte $0E,$05,$17
                  .byte $00,$00
; tab. 8-bajtowa (nr 5) - szsty wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score5       .byte $05,$00,$00
                  .byte $0A,$0F,$02
                  .byte $00,$00
; tab. 8-bajtowa (nr 6) - sidmy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score6       .byte $04,$90,$00
                  .byte $07,$12,$08
                  .byte $00,$00
; tab. 8-bajtowa (nr 7) - smy wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score7       .byte $03,$80,$00
                  .byte $02,$19,$05
                  .byte $00,$00
; tab. 8-bajtowa (nr 8) - dziewity wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score8       .byte $02,$70,$00
                  .byte $06,$0F,$12
                  .byte $00,$00
; tab. 8-bajtowa (nr 9) - dziesity wiersz z punktami+ksyw pokaz. na ekr. HI-SCORE (3 bajty-zakodowany w BCD rezultat, 3 bajty-ksywa(+$D0), 2 bajty-nieuywane)
tab8_score9       .byte $01,$60,$00
                  .byte $0E,$0F,$17
                  .byte $00,$00

; tutaj jest przepisywana cz listy HI-SCORE jeeli wpisano lepszy rezultat gracza na list HI-SCORE!
tab8_score_hide   .byte $00,$00,$00,$07,$01,$0B,$00,$00

0A7A 00           brk
0A7B 00           brk
0A7C 00           brk
0A7D 00           brk
0A7E 00           brk
0A7F 00           brk
0A80 00           brk
0A81 00           brk

0A82 00           brk
0A83 00           brk
0A84 00           brk

count_tab8        .byte 0 ; zlicza ktry aktualnie testujemy wiersz z listy HI-SCORE
address1_hlp1     .word 0 ; pomocnicza - zapamituje pocztkow warto address1

; tablica 8-bajtowa
tab8_player1      .byte $00,$00,$00,$18,$18,$18,$00,$00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura sprawdza czy wynik gracza nie jest lepszy ni jaka pozycja w licie HI-SCORE, jeeli tak to wpisuje nowy rezultat na liste
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Add_Player_Score  mva #$00 count_tab8

Add_Player_loop1  lda count_tab8
                  :3 asl @              ;*8
                  tax

                  ldy #$00

Add_Player_loop2  lda tab8_player1,y    ; sprawd HI-SCORE gracza z rezultatami...
                  cmp tab8_score0,x     ; ... na licie
                  beq Add_Player_skip0  ; takie same dwie cyfry
                  bcs Add_Player_skip2  ; wynik HI-SCORE gracza jest wikszy od aktualnego z listy - WIC ZAPISZ NOWY REKORD na licie!
                  jmp Add_Player_skip1  ; wynik HI-SCORE gracza jest mniejszy od aktualnego z listy

Add_Player_skip0  iny                   ; przejd do bajtu z kolejnymi dwiema cyframi
                  cpy #$03
                  beq Add_Player_skip1

                  inx                      ; przejd do kolejnego bajtu z danego wiersza HI-SCORE
                  jmp Add_Player_loop2

Add_Player_skip1  inc count_tab8           ; kolejny wiersz z listy HI-SCORE
                  lda count_tab8
                  cmp #$0A                 ; Czy ju wszystkie 10 wierszy z listy HI-SCORE porwnane z tab8_player1?
                  bne Add_Player_loop1     ; NIE!

                  jmp Add_Player_rts       ; koniec

Add_Player_skip2  lda count_tab8
                  :3 asl @                 ;*8
                  add #<tab8_score0
                  sta address1
                  sta address1_hlp1        ; zachowaj modszy bajt adresu gdzie wpisa rezultat gracza

                  lda #>tab8_score0
                  adc #$00
                  sta address1+1
                  sta address1_hlp1+1      ; zachowaj starszy bajt adresu gdzie wpisa rezultat gracza

                  clc
                  mwa address1 address1_hlp2

                  lda #<tab8_score_hide    ; ustaw adresy, eby przepisa blok HI-SCORE tak aby zrobi miejsce na rezultat gracza
                  sta address1
                  add #$08
                  sta address2
                  lda #>tab8_score_hide
                  sta address1+1
                  adc #$00
                  sta address2+1

; ponisza procedura przesuwa wyniki HI-SCORE gracza w d (tak, eby zrobi miejsce na nowy, lepszy rezultat gracza)
Add_Player_loop3  ldy #$00
                  mva (address1),y (address2),y
                  jsr address1_SBW_1byte       ; poprzednia kolumna

                  sbw address2 #$01

                  lda address2
                  cmp address1_hlp2
                  bne Add_Player_loop3  ;slow

                  lda address2+1
                  cmp address1_hlp2+1
                  bne Add_Player_loop3  ;slow

                  mwa address1_hlp1 address1         ; kopiuj adres gdzie wpisa rezultat gracza

; ponisza ptla wpisuje rezultat gracza na list HI-SCORE i kasuje jego rezultat
                  ldy #$07

Add_Player_loop4  mva tab8_player1,y (address1),y
                  mva #$00           tab8_player1,y
                  dey
                  bpl Add_Player_loop4

Add_Player_rts    rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
text_top_ten_bombjackers_ ; kady znak +#$D0(zestaw znakw ma na odp. pozycjach litery! np: na $D1 jest"A")
                  .byte $14,$0F,$10,$56,$14,$05,$0E,$56,$02,$0F,$0D,$02,$0A,$01,$03,$0B,$05,$12,$13,$56

pos_tab8_score    .byte $00 ; wskazuje na aktualn pozycje w tablicy tab8_score (HI-SCORE)
address1_hlp2     .word $00 ; pomocnicza
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje ekran HI-SCORE
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Screen_HI_SCORE
                  ldx #$13                        ; 0-19

HI_SCORE_loop1    lda text_top_ten_bombjackers_,x ; ptla wypisuje na ekranie tekst: "TOP TEN BOMBJACKERS "
                  clc                             ; zbdna instrukcja!
                  jsr add_D0                      ; proc. wykonuje - add #$D0
                  sta ScreenText40x25+$0B,x       ; ekran 40x25 (1000 bajtw)
                  lda #$0B                        ; kolor ciemnoszary (ale uwzgldnia tylko niektre bity wic kolor jasno niebiesko-zielony (nr 3))
                  sta ColorRAM40x25+$0B,x         ; Color RAM
                  dex
                  bpl HI_SCORE_loop1

                  ldx #$09
                  mwa #tab8_score0 address2            ; zapamitaj adres pierwszej tablicy HI-SCORE
                  mwa #ScreenText40x25+$87 address1    ; zapamitaj adres w pamici ekranu odkd zaczniemy pisa

HI_SCORE_loop2    mvy #$00 pos_tab8_score

HI_SCORE_loop3    ldy pos_tab8_score                   ; ta ptla wypisuje rezultat np: "10000000" (4bajty w kodzie BCD)
                  lda (address2),y
                  jsr lsr_4                            ; podziel A przez 16 - aby uzyska starszy nibbel (bity 4-7)
                  jsr add_EB                           ; dodaj $EB
                  ldy #00
                  sta (address1),y                     ; zapisz na ekranie jeden znak
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  ldy pos_tab8_score
                  lda (address2),y
                  and #$0F                             ; teraz pobierz z bieacego bajta tylko modszy nibble (bity 0-3)
                  jsr add_EB
                  ldy #$00
                  sta (address1),y                     ; zapisz na ekranie jeden znak
                  inc pos_tab8_score
                  lda pos_tab8_score
                  cmp #$03
                  beq HI_SCORE_skip1
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  jmp HI_SCORE_loop3

HI_SCORE_skip1    ldy pos_tab8_score                   ; w tej czci wywietlana jest ksywa (3 znaki)
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  lda (address2),y
                  ldy #$00
                  jsr add_D0
                  sta (address1),y
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  inc pos_tab8_score
                  ldy pos_tab8_score
                  lda (address2),y
                  ldy #$00
                  jsr add_D0
                  sta (address1),y
                  inc pos_tab8_score
                  ldy pos_tab8_score
                  jsr address1_ADW_1byte               ; nastpna kolumna
                  lda (address2),y
                  ldy #$00
                  jsr add_D0
                  sta (address1),y

                  adw address1 #$46                    ; dodaj 70 (40 znakw + 30znakw) - przenosi kursor o 2 wiersze w d aby wywietli kolejne HI-SCORE
                  adw address2 #$08                    ; dodaj 8 bajtw aby wskanik wskazywa na kolejn tablic 8-bajtow (kada tablica to jeden HI-SCORE)

                  dex
                  bmi HI_SCORE_rts
                  jmp HI_SCORE_loop2

HI_SCORE_rts      rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dodaje do A warto $EB
;--------------------------------------------------------------------------------------------------------------------------------------------------------
add_EB            add #EB
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dodaje do A warto $DO - od tego miejsca w zestawie znakw s litery
;--------------------------------------------------------------------------------------------------------------------------------------------------------
add_D0            add #$D0
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura pokazuje ekran gdzie wpisujemy nick gracza, umoliwia wpisanie 3-literowego nicka i zapisuje wynik+nicka gracza w tablicy tab8_player1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Get_Nick_Screen
                  sei
                  lda #$00
                  sta D022                         ; VicBgClr1     - kolor ta #1
                  sta D023                         ; VicBgClr2     - kolor ta #2
                  sta D015                         ; VicMobEnable  - SPRITES OFF
                  sta D017                         ; VicMobZoomY   - SPRITES ZoomY OFF
                  mva #$01 Is_Sprites_Disable      ; =1 wskanik SPRITES OFF

; sprawd czy wynik osignity przez gracza jest wyszy ni najgorszy rezultat w wynikach HI SCORE
                  lda tab8_score9+$00
                  cmp Score_Player+$00
                  beq Get_Nick_skip1
                  bcc Get_Nick_skip4
                  jmp Get_Nick_skip3                         ; wynik jest gorszy wic nie wpisuj na list HI SCORE i uruchom gr od pocztku

Get_Nick_skip1    lda tab8_score9+$01
                  cmp Score_Player+$01
                  beq Get_Nick_skip2
                  bcc Get_Nick_skip4
                  jmp Get_Nick_skip3                         ; wynik jest gorszy wic nie wpisuj na list HI SCORE i uruchom gr od pocztku

Get_Nick_skip2    lda tab8_score9+$02
                  cmp Score_Player+$02
                  bcc Get_Nick_skip4                         ; wynik jest gorszy wic nie wpisuj na list HI SCORE i uruchom gr od pocztku

Get_Nick_skip3    jmp StartGame

; gracz osign lepszy wynik ni ten najgorszy z listy HI SCORE
Get_Nick_skip4    jsr 08FF
                  mwa #GREAT_SCORE_YOUVE_GONE Char_XScroll_mod+$01  ; zmodyfikuj adres, z ktrego bdzie pobierany tekst do scroll'a na TITLE SCREEN
                  mva #$FF pos_Scroll_Text         ; $FF(+1) wywietlaj tekst od pierwszego znaku
                  jsr Set_RCI                      ; ustaw przerwanie wykonujce SCROLL
                  mva #$50 D018                    ; VicMemCtrl - w trybie tekstowym - przesunicie 0,w trybie graficznym - przesunicie $1400 (obszar banku 16KB VIC)
                  mva #$18 Fill40x25_mod1+$01      ; 24 wiersze  (MODYFIKACJA KODU!)
                  jsr Clear_Screen40x25            ; czycimy ekran
                  jsr Print_YOUR_AN_ACE_BOMBJACKER ; wypisz tekst "YOUR AN ACE BOMBJACKER....."

                  mva #$73 D001                    ; VicMob0PosY - pozycja Y
                  mva #$92 D000                    ; VicMob0PosX - pozycja X
                  mva #$C8 ScreenText40x25+$03F8
                  mva #$07 D027                    ; VicMob0Clr - rejestr koloru dla sprite'a nr.#0
                  mva #$00 0DAD
                  mva #$01 D015                    ; VicMobEnable - SPRITES ON
                  sta 0DAC

; tutaj pobieramy 3 litery wpisane z wykorzystaniem JOYSTICK'a - nick gracza, ktry wraz z punktami znajdzie si na licie HI SCORE
Get_Nick_loop1    lda 0DAC
                  jsr add_D0                       ; pierwsze - "A"
                  ldx 0DAD
                  sta ScreenText40x25+$0179,x
                  mva #$09 ColorRAM+$0179,x
                  jsr Wait_Time1
                  lda DC00                         ; Cia1DataA
                  cmp #$7B                         ; czy w lewo JOYSTICK? (port 2)
                  bne Get_Nick_skip5               ; NIE!

                  lda 0DAC
                  cmp #$01                         ; czy litera "A"?
                  bne Get_Nick_skip44              ; NIE!

                  mva #$1B 0DAC                    ; ustaw litere "Z"

Get_Nick_skip44   dec 0DAC
                  jmp Get_Nick_loop1

Get_Nick_skip5    cmp #$77                         ; czy w prawo JOYSTICK?
                  bne Get_Nick_skip7               ; NIE!

                  lda 0DAC
                  cmp #$1A                         ; czy litera "Z"?
                  bne Get_Nick_skip6               ; NIE!

                  mva #$00 0DAC                    ; ustaw litere "A"

Get_Nick_skip6    inc 0DAC
                  jmp Get_Nick_loop1

Get_Nick_skip7    cmp #$6F                         ; czy wcinieto FIRE?
                  jne Get_Nick_loop1               ; NIE!

                  lda 0DAD
                  cmp #$02                         ; czy ju wpisano nick o 3 literach?
                  beq Get_Nick_skip8               ; TAK!

                  inc 0DAD                         ; przesu pozycj o kolumne w prawo
                  mva #$06 Choose_Play_SFX
                  jsr Wait_Time1
                  jmp Get_Nick_loop1

Get_Nick_skip8    jsr Wait_Time1

; ptla przepisuje wynik gracza+nick do tablicy, ktra potem zostanie wpisana do listy HI SCORE
                  ldx #$02

Get_Nick_loop2    mva Score_Player,x tab8_player1+$00,x
                  lda ScreenText40x25+$0179,x
                  sub #$D0
                  sta tab8_player1+$03,x
                  dex
                  bpl Get_Nick_loop2

                  jsr proc093B                             ; ustaw dane???
                  jsr proc0D02
                  jsr Set_Charset_SpritesON_Fill
                  cli
                  jmp 08AA                                 ; ustaw dane??? i zakocz procedure

; ustawienie orginalnego tekstu dla dolnego SCROLL'a
proc0D02          mwa #Text_Scroll1 Char_XScroll_mod+$01   ; ustaw standardowy tekst dla wywietlanego SCROLL'a na dole ekranu
                  mva #$FF          pos_Scroll_Text        ; ustaw pozycje SCROLL'a na pocztek
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje tekst "YOUR AN ACE BOMBJACKER...."
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Print_YOUR_AN_ACE_BOMBJACKER
                  ldx #$00

Print_YOUR_loop1  lda YOUR_AN_ACE_BOMBJACKER,x
                  cmp #$FF                       ; czy koniec tekstu do wypisania?
                  beq Print_YOUR_RTS             ; TAK!

                  jsr add_D0                     ; dodaj +$D0 bo od tej pozycji w zestawie znakw zaczynaj si litery
                  sta ScreenText40x25+$00C8,x    ; wypisz litere...
                  mva #$0D ColorRAM40x25+$00C8,x ; ...i jej atrybut
                  inx
                  jmp Print_YOUR_loop1

Print_YOUR_RTS    rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Opnienie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Wait_Time1        ldx #$B4

Wait_Time1_loop1  ldy #$B4

Wait_Time1_loop2  dey
                  bne Wait_Time1_loop2

                  dex
                  bne Wait_Time1_loop1

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ustawienie rnych zmiennych
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_Charset_SpritesON_Fill
                  mva #$00 Index_charset            ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany
                  sta Is_Sprites_Disable            ; =0 wskanik SPRITES ON
                  mvx #$00 150F                     ; "SIDE 2 x" - modyfikacja x
                  sta $D017                         ; VicMobZoomY  - bity = 0 wic sprite'y nie s podwjnej wysokoci...
                  sta $D01D                         ; VicMobZoomX  - ... ani podwjnej szerokoci
                  mva #$18 Fill40x25_mod1+$01       ; modyfikacja kodu w procedurze rysujcej na ekranie txt  - $18 = 24+1 wierszy
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; napis "YOUR AN ACE BOMBJACKER  YOUR NAME PLEASE"
YOUR_AN_ACE_BOMBJACKER
                  .byte $19,$0F,$15
0D52 12           kil
0D53 56 01        lsr 01,x
0D55 0E 56 01     asl 0156
0D58 03 05        slo (05,x)
0D5A 56 02        lsr 02,x
0D5C 0F 0D 02     slo 020D
0D5F 0A           asl a
0D60 01 03        ora (03,x)
0D62 0B 05        anc #05
0D64 12           kil
0D65 56 56        lsr 56,x
0D67 19 0F 15     ora proc1252,y
0D6A 12           kil
0D6B 56 0E        lsr 0E,x
0D6D 01 0D        ora (0D,x)
0D6F 05 56        ora 56
0D71 10 0C        bpl 0D7F
0D73 05 01        ora 01  ;CpuDataPort
0D75 13 05        slo (05),y
0D77 FF           .byte $FF

; napis "GREAT SCORE YOUVE GONE DOWN IN BOMBJACK HISTORY"
GREAT_SCORE_YOUVE_GONE
                  .byte $56,$07
0D7A 12           kil
0D7B 05 01        ora 01  ;CpuDataPort
0D7D 14 56        nop 56,x
0D7F 13 03        slo (03),y
0D81 0F 12 05     slo 0512
0D84 56 19        lsr 19,x
0D86 0F 15 16     slo 1615
0D89 05 56        ora 56
0D8B 07 0F        slo 0F
0D8D 0E 05 56     asl 5605
0D90 04 0F        nop 0F
0D92 17 0E        slo 0E,x
0D94 56 09        lsr 09,x
0D96 0E 56 02     asl 0256
0D99 0F 0D 02     slo 020D
0D9C 0A           asl a
0D9D 01 03        ora (03,x)
0D9F 0B 56        anc #56
0DA1 08           php
0DA2 09 13        ora #13
0DA4 14 0F        nop 0F,x
0DA6 12           kil
0DA7 19 56 56     ora 5656,y
0DAA 56 FF        .byte $56,$FF

0DAC              .byte $00
0DAD              .byte $00

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje ekran TITLE
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Screen_TITLE jsr BASIC_OFF
                  mwa #ScreenText40x25  address2       ; zapamitaj adres ekranu
                  mwa #title_chars_9800 address1       ; zapamitaj skd pobra znaki kopiowane na ekran (1024 bajty)

; ponisza ptla rysuje ekran TITLE (przepisuje znaki)
                  ldx #$13                  ; 0-19 (20 wierszy)
TITLE_loop1       ldy #$27                  ; 0-39 (40 znakw)

TITLE_loop2       lda (address1),y          ; kopiuj na ekran jeden wiersz (40 znakw)
                  sta (address2),y
                  dey
                  bpl TITLE_loop2

                  adw address1 #$28         ; dodaj 40 znakw (nastpny wiersz)
                  adw address2 #$28         ; dodaj 40 znakw (nastpny wiersz)

                  dex
                  bpl TITLE_loop1

                  mwa #ColorRAM40x25     address2       ; zapamitaj adres obszaru Color RAM
                  mwa #title_attrib_9C00 address1       ; zapamitaj adres skd pobra atrybuty znakw (kolory) kopiowane do Color RAM (1024 bajty)

; ponisza ptla rysuje ekran TITLE (przepisuje atrybuty znakw)
                  ldx #$18                  ; 0-24 (25 wierszy)
TITLE_loop3       ldy #$27                  ; 0-39 (40 znakw)

TITLE_loop4       cpx #$05                  ; zostao do wywietlenia wicej wierszy ni 5?
                  bcs TITLE_skip1  ;slow    ; TAK!

                  lda #$08                  ; od tej chwili kolor pomaraczowy?
                  jmp TITLE_skip2

TITLE_skip1       lda (address1),y          ; pobierz kolor

TITLE_skip2       sta (address2),y          ; zapis do Color RAM
                  dey
                  bpl TITLE_loop4  ;slow

                  adw address1 #$28         ; dodaj 40 znakw (nastepny wiersz)
                  adw address2 #$28         ; dodaj 40 znakw (nastpny wiersz)

                  dex
                  bpl TITLE_loop3  ;slow

                  jsr BASIC_ON
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procka wypenia 24 wiersze po 40 znakw wartoci akumulatora
; A  - dana
; YX - adres startowy od ktrego rozpocznie si wypenianie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Fill40x25         sta fill_screen_data
                  stx address1
                  sty address1+1

Fill40x25_mod1    ldx #$17              ; 23+1 wiersze  (#$17 MODYFIKACJA KODU!)

Fill40x25_loop0   ldy #$27              ; 39+1 znakw w wierszu (bajtw)

Fill40x25_loop1   lda fill_screen_data
                  sta (address1),y      ; $5000, $5400, $D800 (Color RAM = 1000 bytes)
                  dey
                  bpl Fill40x25_loop1    ; wykonaj 40x ptle (Y <0,39>)

                  adw address1 #$28     ; +40 bajtw (nastpny wiersz)

                  dex
                  bpl Fill40x25_loop0

                  lda #$17              ; uaktualnij dan
                  sta Fill40x25_mod1+1
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura czyci ekran i Color RAM
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Clear_Screen40x25 lda #$26                       ; pusty znak
                  ldx #<ScreenText40x25
                  ldy #>ScreenText40x25          ; $5400 - obszar tekstowy ekranu 40x25
                  jsr Fill40x25
                  lda #$09                       ; kolor jasno zielono-niebieski (tylko bity 0-2)
                  ldx #<ColorRAM40x25
                  ldy #>ColorRAM40x25            ; $D800 - Color RAM - 1000 bytes (40znakw * 25wierszy)  (dla MULTICOR - kolor punktw %11 w polu 8x8)
                  jsr Fill40x25
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura czyci buffor (ekranu) 40x25
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Clear_Buffor40x25 lda #$20
                  ldx #<ScreenBuff40x25
                  ldy #>ScreenBuff40x25          ; $5000
                  jsr Fill40x25
                  rts

fill_screen_data .byte $09                       ; zawiera dan jak wypeniamy cay ekran 40x25
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia jakie wartoci???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Game_FIRE1        jsr BASIC_OFF
                  jsr proc8400            ; procedura ustawia jakie wartoci???
                  sei
                  jsr SetDatas2
                  jsr BASIC_ON
                  jmp Game_FIRE2
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia jakie wartoci???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
SetDatas2         mva $4B  $7E2F
                  mva $4C  $7E30
                  lda $4D  $7E31
                  lda $4E  $7E32
                  lda #$00 $73D2
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; po wciniciu przycisku FIRE - tutaj skaczemy i zaczyna si waciwa gra
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Game_FIRE2        sei
                  jsr Draw_Right_Panel               ; procka rysuje prawy panel z informacjami na ekranie gry
                  mva #$01 pos_tab_addr_live         ; =1 wskazuje na drugi adres tablicy z pozycjami gdzie mona rysowa ycie BOMB JACK-a

                  ldx #$02

Game_FIRE2_loop0  mva #$00          Score_Player,x    ; wyzeruj aktualny wynik gracza "SCORE"
                  mva #$01          Number_Round_BCD  ; ustaw, e to jest ROUND 01 (01 zakodowane w kodzie BCD)
                  mva tab8_score0,x Hi_Score_Player,x ; pobierz z "listy HI SCORE" najlepszy wynik HI-SCORE
                  dex
                  bpl Game_FIRE2_loop0

Game_FIRE2_loop1  sei

                  lda #$00
                  sta index_Address_BOMBS       ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y
                  sta Counter_Collected_BOMBS
                  sta 11F8
                  sta Counter_Blink_BOMBS       ; wyzeruj liczb migajcych BOMB (przez BOMB JACK-a)

                  mva #$01 $536B                ; BuffText40x25
                  sta $DB6A                     ; Color RAM
                  sta $DB6B                     ; Color RAM

                  jsr Draw_Screen_Number_Round  ; procka pobiera starszy i modszy nibble z Number_Round_BCD i zapisuje w ScreenBuff40x25 ($5165-$5166)
                  sta $5166                     ; ScreenBuff40x25
                  lda $D011                     ; VicCtrl1
                  and #$EF                      ; bit 4=0
                  sta $D011                     ; VicCtrl1   - SCREEN OFF!
                  lda #$42                      ; ustawiamy: Char Memory - $4800-$4FFF (2KB) i Screen Memory - $5000-$53FF (2KB)
                  sta $D018                     ; VicMemCtrl

                  jsr Draw_Back_Set_Charset            ; rysujemy plansze (to) i kopiujemy waciwy zestaw znakw 2KB do obszaru $4800-$4FFF
                  jsr Draw_Bombs_On_Screen             ; rysuje BOMB-y na ekranie
                  jsr Set_CODE_BOMB_in_tab_Screen_BOMB ; procedura ustawia kod BOMB-y($01, lewy grny rg) na odpowiedniej pozycji w tab_Screen_BOMB(40x25) UWAGA: dla wszystkich 24 BOMB!
                  jsr Print_Score_Player               ; procedura wypisuje na ekranie aktualn ilo punktw gracza
                  jsr Print_Hi_Score_Player            ; procedura wypisuje na ekranie najwyszy wynik HI SCORE
                  jsr Blink_Score_&_Bar                ; procedura pobiera kolejny kolor z tablicy dla napisu SCORE i prostokta (prawy, dolny rg) - daje to efekt migania
                  jsr Draw_Panel_skip1                 ; procedura zapisuje atrybuty dla napisw, ikonek ycia na prawym panelu informacyjnym
                  jsr Draw_Green_Border                ; procedura rysuje zielon ramk, ktra otacza ekran gry

Game_FIRE2_loop2  sei
                  jsr Draw_Bars                    ; procedura rysuje na ekranie paski, po ktrych skacze BOMB JACK
                  jsr Set_XY_Addr_Sprite0          ; procedura ustawia dane dla SPRITE #0
                  mva #<Int_RCI_Game Set_Int_RCI+2 ; ustaw adres procedury przerwania RCI
                  mva #>Int_RCI_Game Set_Int_RCI+6
                  jsr Set_Bank_VIC                 ; procedura ustawia bank #2 16KB dla VIC-a

                  lda #00
                  sta 162C
                  sta Sprite0_7_PosX_8bit
                  sta 1E94
                  sta Is_Dance_BOMB_JACK
                  sta 162B
                  sta Is_Dead_BOMB_JACK
                  sta Counter_9th_BOMBS_to_Show_LETTER_P
                  sta 11E9
                  sta 11E8
                  sta Counter_5th_BOMBS_to_Show_LETTER_B
                  sta Time_Get_SmilingFace_Soon_Finish
                  sta 11EE
                  sta 11EF
                  sta index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform
                  sta $D021                        ; VicBgClr0 - Kolor ta 0

                  mva #$0A Actual_Color_Blink_BOMB ; ustaw aktualny kolor migajcej BOMB-y
                  mva #$64 $122E
                  lda Counter_Collected_BOMBS
                  cmp #$17
                  beq Game_FIRE2_skip1

                  lda #$00

Game_FIRE2_skip1  sta Is_Blink_BOMB             ; =0 nie migaj BOMB-
                  lda #$C8                      ; Horizontal Scroll = 0 / Screen width = 40 columns (bity 7-5 nie s wykorzystywane)
                  ora #$10                      ; MULTICOLOR MODE ON
                  sta $D016                     ; VicCtrl2
                  lda $D011                     ; VicCtrl1
                  ora #$10
                  sta $D011                     ; VicCtrl1 SCREEN ON!

                  jsr Anim_START_Sprites        ; procedura animuje napis "START !" przed rozpoczciem gry (z wykorzystaniem sprite'w)
                  jsr Random_Value_Value_x2                      ; jakie losowanie losowej wartoci???
                  jsr 08F1                      ; ustawia jakie dane???
                  jsr Set_Int_RCI

Game_FIRE2_skip2  jsr Random_Value_Value_x2                      ; jakie losowanie losowej wartoci???
                  jsr Print_Score_Player
                  jsr Update_HI_SCORE           ; procedura testuje SCORE PLAYER > HI SCORE, jeeli tak to HI SCORE = SCORE PLAYER i pisze to na ekranie

                  lda 1E94
                  beq Game_FIRE2_skip3

                  mva #$00 $D418                ; SidFltMode - wycisz dwik do zera i wykasuj filtry
                  jsr Show_Bonus_Screen         ; poka ekran z BONUSem
                  jmp Game_FIRE2_skipT

Game_FIRE2_skip3  lda 11EC
                  jne Game_FIRE2_skipO

                  lda 11E8
                  beq Game_FIRE2_skip6

                  sei

Game_FIRE2_loop3  jsr Blink_BOMB                ; miganie BOMBY do zebrania w rnych kolorach
                  lda Actual_Color_Blink_BOMB   ; pobierz aktualny kolor migajcej BOMB-y
                  cmp #$0A
                  bne Game_FIRE2_loop3

                  mva #$00 Is_Dead_BOMB_JACK
                  lda pos_tab_addr_live
                  bpl Game_FIRE2_skip5

                  lda #$03
                  sta $D01D                     ; VicMobZoomX - podwjna szeroko sprite'a nr.0 i 1
                  sta $D017                     ; VicMobZoomY - podwjna wysoko sprite'a nr. 0 i 1
                  mva #$BF $53F8
                  mva #$C0 $53F9
                  lda #$6E
                  sta $D001                     ; VicMob0PosY - ustaw pozycje Y sprite #0
                  sta $D003                     ; VicMob1PosY - ustaw pozycje Y sprite #1
                  sta $D000                     ; VicMob0PosX - ustaw pozycje X sprite #0
                  lda #$9E
                  sta $D002                     ; VicMob1PosX - ustaw pozycje Y sprite #1
                  jsr 092C
                  jsr Set_RCI
                  jsr StartGame_Skip3
                  jmp Show_Get_Nick_Screen

Game_FIRE2_skip5  jsr Clear_Live_Jack           ; kasuje jedno ycie BOMB JACK-a
                  dec pos_tab_addr_live
                  mva #$00 11E8
                  sta $D418                     ; SidFltMode - wycisz dwik do zera i wykasuj filtry
                  jmp Game_FIRE2_loop2

Game_FIRE2_skip6  lda Is_Dance_BOMB_JACK
                  jne Game_FIRE2_skipM

                  lda Is_Dead_BOMB_JACK
                  jne Game_FIRE2_skip2

                  lda 162C
                  jeq Game_FIRE2_skip2

                  jsr Detect_Collision_BOMB_JACK_with_SPRITES ; procedura sprawdza czy nastpia kolizja BOMB JACK-a z jakim SPRITem #1-#7
                  lda Is_Collision_BOMB_JACK_with_SPRITE      ; Czy BOMB JACK zderzy si z jakim SPRIT-em?
                  jeq Game_FIRE2_skipD                        ; NIE!

                  ldx Collision_BOMB_JACK_with_SPRITE         ; TAK! wic zaczynamy obsug tego zdarzenia
                  mva tab_Type_SPRITES_1_7,x Collision_BOMB_JACK_with_Type_Sprite
                  cmp #$08                                    ; Czy BOMB JACK zebra litere "P"?
                  bne Game_FIRE2_skipC                        ; NIE!

; TAK! wic przeksztacamy wszystkich przeciwnikw na "UMIECHNITE BUKI", ktre moe zebra BOMB JACK
                  mva #$96 Time_Get_SmilingFace_Soon_Finish
                  sta      11EE
                  mva #$07 $D026                              ; (kolor ty) VicMltClr1 - ustawia extra sprite kolor #1 (tylko bity 0-3) - para bitw %11 dla spritw wielokolorowych bdzie tego koloru
                  mva #$06 Choose_Play_SFX
                  mva #$00 tab_Type_SPRITES_1_7+6

                  ldx #$05                                    ; sprawd wszystkich 5-ciu przeciwnikw
Game_FIRE2_loop4  mva #$00 index_tab_clips_Move_Opponent,x
                  sta      tab_Every_Third_Frame_Move_Sprite,x
                  sta      Counter_Add_100_600_Points_for_Every_SmilingFace
                  mva #$01                   tab_Points_100_600_SPRITES_1_7,x
                  mva tab_Type_SPRITES_1_7,x 11F0,x           ; Czy na tej pozycji jest aktywny SPRITE?
                  beq Game_FIRE2_skipB                        ; NIE!

                  cmp #$0E                                    ; Czy wolne miejsce, eby pojawi si nowy przeciwnik?
                  beq Game_FIRE2_skipB                        ; TAK!

                  mva #$07 tab_Type_SPRITES_1_7,x             ; wstaw "7" jako typ SPRITE'a - "UMIECHNITA BUKA"

Game_FIRE2_skipB  dex                                         ; kolejny SPRITE
                  bpl Game_FIRE2_loop4

                  jsr 08FF                                    ;ustawia dane???
                  jmp Game_FIRE2_skip2
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Game_FIRE2_skipC  cmp #$07                                    ; Czy BOMB JACK zebra "UMIECHNIT BUK"?
                  bne Game_FIRE2_skipE                        ; NIE!

; TAK! wic naley pokaza na ekranie punkty i doda je do wyniku BOMB JACK-a
                  ldx Collision_BOMB_JACK_with_SPRITE
                  lda Counter_Add_100_600_Points_for_Every_SmilingFace
                  add #$01                                    ; +1 zebranie kadej kolejnej "UMIECHNITEJ BUKI" (zaraz po zebranej "LITERZE P") to +100 punktw
                  sta tab_Points_100_600_SPRITES_1_7,x        ; adres wskanika ile punktw ma si pokaza na ekranie za zebran "BUKE" $4000+(wskanik+$C0)*$40
                  sta Counter_Add_100_600_Points_for_Every_SmilingFace

                  ldy Collision_BOMB_JACK_with_SPRITE
                  lda 11F9,y
                  tax
                  lda #00
                  ldy #00

                  jsr Add_Points_to_SCORE_PLAYER_AXY          ; dodanie punktw AXY (3 bajty w kodzie BCD)

                  mva #$03 Choose_Play_SFX
                  mva #$0C Collision_BOMB_JACK_with_SPRITE                     ; kolizja BOMB JACK-a z przeciwnikiem
                  sta tab_Type_SPRITES_1_7,x                                   ; wstaw "12" jako typ SPRITE'a - (pojawienie si nowego przeciwnika)
                  mva #$0F tab_Show_Type_Sprite1_7_After_Animation_Appearing,x ; typ "PUNKTY" - zapamitaj
Game_FIRE2_skipD  jmp Game_FIRE2_skipJ
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Game_FIRE2_skipE  cmp #$00
                  beq Game_FIRE2_skipJ  ;slow

                  cmp #$0A
                  bne Game_FIRE2_skipF

                  lda #$05
                  ldx Collision_BOMB_JACK_with_SPRITE
                  sta tab_Points_100_600_SPRITES_1_7,x
       
                  inc ScreenBuff40x25+$036B                   ; "x1" - zwiksza na ekranie gry t "1" w migajcym kwadracie (czyli mamy: "x1", "x2", "x3" itd.)
                  jmp Add_Points_to_SCORE_PLAYER              ; dodanie 500 punktw graczowi

Game_FIRE2_skipF  cmp #$09                                    ; Czy "LITERA E lub B"?
                  bne Game_FIRE2_skipG                        ; NIE!

                  mva #$07 Choose_Play_SFX
                  mva #$0C tab_Type_SPRITES_1_7+6
                  ldx Collision_BOMB_JACK_with_SPRITE
                  mva #$0D tab_Show_Type_Sprite1_7_After_Animation_Appearing,x          ; typ "DODATKOWE YCIE" - zapamitaj
                  jmp Game_FIRE2_skip2

Game_FIRE2_skipG  cmp #0C
                  beq Game_FIRE2_skipJ  ;slow

                  cmp #0D
                  beq Game_FIRE2_skipJ  ;slow

                  cmp #0F
                  beq Game_FIRE2_skipJ  ;slow

                  cmp #0E
                  beq Game_FIRE2_skipJ  ;slow

                  lda 122E
                  beq Game_FIRE2_skipH

                  jmp Game_FIRE2_skip2

Game_FIRE2_skipH  lda Is_Dance_BOMB_JACK
                  beq Game_FIRE2_skipI

                  jmp Game_FIRE2_skip2

; zabito BOMB JACK-a!
Game_FIRE2_skipI  mva #$01 Is_Dead_BOMB_JACK
                  lda #00
                  sta Collision_BOMB_JACK_with_SPRITE
                  sta 162C
                  sta Collision_BOMB_JACK_with_Type_Sprite
                  sta Sprite1_PosX
                  sta Sprite1_PosY
                  sta Is_No_Flight_BOMB_JACK
                  mva #$BB tab_Addr_SPRITE_Pattern ; ustaw 'ptaszek' dla SPRITE'a #1
                  mva #$03 Choose_Play_SFX
                  jmp Game_FIRE2_skip2

                  jmp StartGame   ; zbdny rozkaz???

Game_FIRE2_skipJ  lda Number_Round_BIN
                  and #$03
                  cmp #$03
                  bne Game_FIRE2_skipL

                  lda Counter_Collected_BOMBS
                  cmp #$06
                  bne Game_FIRE2_skipL

                  lda 11F8
                  bne Game_FIRE2_skipL

                  lda tab_Type_SPRITES_1_7+6
                  bne Game_FIRE2_skipL

                  jsr Random_Register_A                     ; wylosuj warto w rej.A
                  cmp #$0A
                  bcc Game_FIRE2_skipK
                  jmp Game_FIRE2_skipL

Game_FIRE2_skipK  mva #$09 tab_Type_SPRITES_1_7+6
                  mva #$FF Can_Show_LetterEB_on_Board
                  inc 11F8

Game_FIRE2_skipL  jmp Game_FIRE2_skip2

Game_FIRE2_skipM  lda 11E9
                  bne Game_FIRE2_skipN

                  inc 11E9
                  jsr 090E                      ; ustawia jakie dane???

Game_FIRE2_skipN  jmp Game_FIRE2_skip7

Game_FIRE2_skipO  lda Is_Dance_BOMB_JACK
                  bne Game_FIRE2_skipN

                  jsr 08F1                      ; ustawia jakie dane???
                  cli
                  mva #$02 $D026  ; VicMltClr1 (kolor czerwony) - ustawia extra sprite kolor #1 (tylko bity 0-3) - para bitw %11 dla spritw wielokolorowych bdzie tego koloru

                  ldx #05

Game_FIRE2_loop5  lda tab_Type_SPRITES_1_7,x
                  cmp #$07                                 ; Czy "UMIECHNITA BUKA"?
                  bne Game_FIRE2_skipP

                  mva 11F0,x tab_Type_SPRITES_1_7,x

Game_FIRE2_skp1   dex
                  bpl Game_FIRE2_loop5

                  jmp Game_FIRE2_skipS

Game_FIRE2_skipP  lda Number_Round_BIN                      ; pobierz nr.rundy
                  asl @                                     ; *2
                  tay
                  mwa tab_parameters_for_sprites,y address1 ; pobranie adresu zgodnie z nr.rundy
                  txa
                  tay
                  mva (address1),y tab_Type_SPRITES_1_7,x   ; zapisz typ SPRITE'a #1-#7
                  clc
                  lda address1
                  adc #$07
                  sta address1
                  bcc Game_FIRE2_skipR

                  inc address1+1
                  clc

Game_FIRE2_skipR  txa
                  asl @
                  tay
                  mva (address1),y Sprite1_PosX,y
                  iny
                  mva (address1),y Sprite1_PosX,y
                  mva #$00 tab_Is_Sprite1_7_on_Screen,x
                  sta      tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,x
                  sta      index_tab_clips_Move_Opponent,x
                  sta      tab_Every_Third_Frame_Move_Sprite,x
                  sta      tab_Is_Astronaut_Change_PosX,x
                  sta      tab_Every_100th_Move_Follow_BOMB_JACK,x
                  jmp Game_FIRE2_skp1

Game_FIRE2_skipS  lda #$00
                  sta 11EE
                  sta 11EC
                  sta index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform
                  cli
                  mva #$64 $122E
                  jmp Game_FIRE2_skip2

Game_FIRE2_skipT  ldx Index_charset
                  cpx #$04
                  bne Game_FIRE2_skipW

                  ldx #$FF

Game_FIRE2_skipW  inx
                  stx Index_charset
                  ldx Number_Round_BIN
                  cpx #$11
                  bne Game_FIRE2_skipX

                  ldx #$02

Game_FIRE2_skipX  inx
                  stx Number_Round_BIN
                  jsr Add_One_ROUND                    ; dodanie +1 do ROUND (kod BCD)
                  jmp Game_FIRE2_loop1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Collision_BOMB_JACK_with_Type_Sprite .byte $00         ; przechowuje typ SPRITE'a ($01-$0F), ktry zderzy si z BOMB JACK-iem

11E8 00           brk
11E9 00           brk

;data
Counter_Collected_BOMBS .byte $00 ; zlicza ile BOMB zebra ju 'bomb jack'
Actual_Color_Blink_BOMB .byte $00 ; aktualny kolor migajcej BOMB-y

11EC 00           brk
Time_Get_SmilingFace_Soon_Finish .byte $00 ; czas jaki zosta jeszcze na zebranie "UMIECHNITYCH BUZI" przez BOMB JACK-a
11EE 00           brk
11EF 00           brk
11F0 00           brk
11F1 00           brk
11F2 00           brk
11F3 00           brk
11F4 00           brk
11F5 00           brk
11F6 00           brk
11F7 00           brk

;data
11F8              .byte 0

11F9 01 02        ora (02,x)
11FB 03 04        slo (04,x)
11FD 05 06        ora 06
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; dodaje 500 punktw graczowi
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Add_Points_to_SCORE_PLAYER
                  mva #$06 Choose_Play_SFX
                  mva #$0C tab_Type_SPRITES_1_7+6
                  mva #$0F tab_Show_Type_Sprite1_7_After_Animation_Appearing+6  ; SPRITE w postaci punktw
                  mva #$00 tab_Move_Left_or_Right_or_Down_LetterEB+6
                  sta      D02E                        ; VicMob7Clr - rejestr koloru sprite'a nr.7
                  sta      Sprite0_7_PosX_8bit         ; wyzeruj bit8 dla SPRITES #0-#7
                  lda #$00
                  ldx #$05
                  ldy #$00                             ; $000500 - liczba punktw w kodzie BCD
                  jsr Add_Points_to_SCORE_PLAYER_AXY   ; dodanie punktw AXY
                  jmp Game_FIRE2_skip2                 ; powrt do gwnej ptli GRY
;--------------------------------------------------------------------------------------------------------------------------------------------------------
1225 .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00

Score_Player              .byte $00,$00,$00
Add_Value_to_Score_Player .byte $00,$00,$00  ; warto dodawana do SCORE PLAYER
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje na ekranie aktualn ilo punktw gracza
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Print_Score_Player
                  ldy #$00
                  ldx #$00

Print_Score_1     lda Score_Player,y
                  jsr lsr_4                       ; pobierz starszy nibble
                  sta ScreenBuff40x25+$00C0,x
                  inx
                  lda Score_Player,y
                  and #$0F                        ; pobierz modszy nibble
                  sta ScreenBuff40x25+$00C0,x
                  inx
                  iny
                  cpy #$03
                  bne Print_Score_1

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procka pobiera starszy i modszy nibble numeru ROUND w kodzie BCD i zapisuje na ekran
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Screen_Number_Round
                  lda Number_Round_BCD
                  jsr lsr_4
                  sta ScreenBuff40x25+$0165
                  lda Number_Round_BCD
                  and #0F
                  sta ScreenBuff40x25+$0166
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje aktualne punkty gracza (pobierajc te punkty z - 3-ch bajtw w kodzie BCD)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Print_Score_Player_On_Screen
                  ldy #$00
                  ldx #$00

Print_Score_loop1 lda Score_Player,y
                  jsr lsr_4                       ; starszy nibble
                  jsr add_EB
                  sta ScreenText40x25+$02DC,x
                  inx
                  lda Score_Player,y
                  and #$0F                        ; modszy nibble
                  jsr add_EB
                  sta ScreenText40x25+$02DC,x
                  inx
                  iny
                  cpy #$03                        ; czy ju wypisano 3 bajty ?
                  bne Print_Score_loop1           ; NIE!

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura testuje czy aktualny wynik gracza nie jest lepszy od HI SCORE, jeeli tak to w HI SCORE zapisuje wynik gracza
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Update_HI_SCORE   lda tab8_score0+$00
                  cmp Score_Player+$00
                  beq Update_HI_skip1
                  bcc Update_HI_skip3

                  jmp Update_HI_print_end

Update_HI_skip1   lda tab8_score0+$01
                  cmp Score_Player+$01
                  beq Update_HI_skip2
                  bcc Update_HI_skip3

                  jmp Update_HI_print_end

Update_HI_skip2   lda tab8_score0+$02
                  cmp Score_Player+$02
                  bcc Update_HI_skip3

                  jmp Update_HI_print_end

Update_HI_skip3   ldx #02

Update_HI_loop1   lda Score_Player,x              ; przepisanie wyniku gracza do Hi Score
                  sta Hi_Score_Player,x
                  dex
                  bpl Update_HI_loop1

Update_HI_print_end
                  jsr Print_Hi_Score_Player       ; wypisanie HI SCORE na ekranie
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje na ekranie najwyszy wynik HI SCORE
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Print_Hi_Score_Player
                  ldy #$00
                  ldx #$00

Hi_Score_1        lda Hi_Score_Player,y
                  jsr lsr_4                       ; pobierz starszy nibble
                  sta ScreenBuff40x25+$0228,x
                  inx
                  lda Hi_Score_Player,y
                  and #$0F                        ; pobierz modszy nibble
                  sta ScreenBuff40x25+$0228,x
                  inx
                  iny
                  cpy #$03
                  bne Hi_Score_1

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wypisuje na ekranie (ScreenText40x25) i dodaje punkty do SCORE PLAYER
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Print_&_Add_Points
                  ldy #$00
                  ldx #$00

Print_Points_loop1
                  lda Add_BYTE_to_SCORE_PLAYER,y
                  jsr lsr_4          ; pobierz starszy nibble
                  jsr add_EB         ; dodaj +$EB bo od $EC s cyfry 1,2,3.....(zestaw znakw dla TITLE SCREEN i HI SCORE SCREEN - nie dla GAME SCREEN)
                  cpx #$00
                  beq Print_Points_skip1

                  sta ScreenText40x25+$01EC,x

Print_Points_skip1
                  inx
                  lda Add_BYTE_to_SCORE_PLAYER,y
                  and #$0F           ; pobierz modszy nibble
                  jsr add_EB
                  sta ScreenText40x25+$01EC,x
                  inx
                  iny
                  cpy #$03
                  bne Print_Points_loop1

                  lda Add_BYTE_to_SCORE_PLAYER
                  ldx #$00
                  ldy #$00
                  jsr Add_Points_to_SCORE_PLAYER_AXY
                  rts

; dodanie wartoci (rej. A,X,Y) do SCORE PLAYER
Add_Points_to_SCORE_PLAYER_AXY
                  sed
                  sta Add_Value_to_Score_Player+$00
                  stx Add_Value_to_Score_Player+$01
                  sty Add_Value_to_Score_Player+$02
                  clc
                  lda Score_Player+$02
                  adc Add_Value_to_Score_Player+$02
                  sta Score_Player+$02
                  lda Score_Player+$01
                  adc Add_Value_to_Score_Player+$01
                  sta Score_Player+$01
                  lda Score_Player+$00
                  adc Add_Value_to_Score_Player+$00
                  sta Score_Player+$00
                  cld
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dodaje +1 do numeru ROUND (kod BCD)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Add_One_ROUND     sed
                  lda Number_Round_BCD
                  add #01
                  sta Number_Round_BCD
                  cld
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; podziel A przez 16 - aby uzyska starszy nibbel (bit 4-7)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
lsr_4             :4 lsr @
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura pobiera kolejny kolor z tablicy dla napisu SCORE i prostokta (prawy, dolny rg) - daje to efekt migania
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Blink_Score_&_Bar inc Counter_Blink
                  ldx Counter_Blink
                  lda Tab_Blink_Color,x
                  beq Blink_Score_skip2

                  ldx #$06

Blink_Score_loop1 sta ColorRAM40x25+$0070,x        ; atrybut dla SCORE
                  sta ColorRAM40x25+$033F,x        ; atrybut dla biaego paska (na samym dole, 1-szy wiersz)
                  cpx #$03
                  beq Blink_Score_skip1            ; pomi 3-ci bajt...

                  cpx #$04                         ; ...i 4-ty bajt bo tam jest inny atrybut dla napisu "X1"
                  beq Blink_Score_skip1

                  sta ColorRAM40x25+$0367,x        ; atrybut dla biaego paska (2-gi wiersz)

Blink_Score_skip1 sta ColorRAM40x25+$038F,x        ; atrybut dla biaego paska (3-ci wiersz)
                  dex
                  bpl Blink_Score_loop1

                  rts

Blink_Score_skip2 mva #$FF Counter_Blink
                  jmp Blink_Score_&_Bar
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Counter_Blink     .byte $00                        ; wskazuje na kolejny kolor w tablicy poniej

Tab_Blink_Color   .byte $06,$06
1372 06 06        asl 06
1374 06 06        asl 06
1376 02           kil
1377 02           kil
1378 02           kil
1379 02           kil
137A 02           kil
137B 02           kil
137C 04 04        nop 04
137E 04 04        nop 04
1380 04 04        nop 04
1382 03 03        slo (03,x)
1384 03 03        slo (03,x)
1386 03 03        slo (03,x)
1388 07 07        slo 07
138A 07 07        slo 07
138C 07 07        slo 07
138E 01 01        ora (01,x)
1390 01 01        ora (01,x)
1392 01 01        ora (01,x)
1394 07 07        slo 07
1396 07 07        slo 07
1398 07 07        slo 07
139A 03 03        slo (03,x)
139C 03 03        slo (03,x)
139E 03 03        slo (03,x)
13A0 04 04        nop 04
13A2 04 04        nop 04
13A4 04 04        nop 04
13A6 02           kil
13A7 02           kil
13A8 02           kil
13A9 02           kil
13AA 02           kil
13AB 02           kil
13AC 00           .byte $00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura sprawdza czy nastpia kolizja BOMB JACK-a z jakim SPRITem #1-#7
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Detect_Collision_BOMB_JACK_with_SPRITES
                  lda Sprite0_PosX        ; wsp. X SPRITE #0
                  cmp #$EB                ; 235 - Czy BOMB JACK jest przy prawym zielonym marginesie (obszaru gry)?
                  bcc Collision_skip1     ; JESZCZE NIE!

                  lda #$EB                ; TAK!

; wyznaczanie i zapamitanie wsp. kwadratu, w ktrym mieci si BOMB JACK (prawdopodobnie dla pniejszej detekcji kolizji)
Collision_skip1   add #$14                ; +20
                  sta BOMB_JACK_PosX2     ; zapamitaj dokd siga prawa cz postaci BOMB JACK-a
                  sub #$26                ; -38
                  sta BOMB_JACK_PosX1     ; zapamitaj dokd siga lewa cz postaci BOMB JACK-a

                  lda Sprite0_PosY        ; wsp.Y SPRITE #0
                  add #$11                ; +17
                  sta BOMB_JACK_PosY2     ; zapamitaj dokd siga dolna cz postaci BOMB JACK-a
                  sub #$23                ; -35
                  sta BOMB_JACK_PosY1     ; zapamitaj dokd siga grna cz postaci BOMB JACK-a

                  ldx #$06                ; ptla dla wszystkich SPRITE'w #1 - #7

Collision_loop1   txa
                  asl @                   ; *2
                  tay
                  lda Sprite1_PosX,y      ; wsp.X SPRITE #1-#7
                  cmp BOMB_JACK_PosX1     ; porwnaj ze wsp.X lewej strony postaci BOMB JACK-a
                  bcc Collision_skip2     ; wsprzdne X nie nachodz, wic nie badaj dalej

                  cmp BOMB_JACK_PosX2     ; porwnaj ze wsp.X prawej strony postaci BOMB JACK-a
                  bcc Collision_skip3     ; wsprzdne X nachodz!

Collision_skip2   dex                     ; nastpny SPRITE (-1)
                  bpl Collision_loop1

                  mva #$00 Is_Collision_BOMB_JACK_with_SPRITE
                  rts

; Wsprzdne X postaci BOMB JACK-a i SPRITE'a #1-#7 nachodz na siebie!
Collision_skip3   lda Sprite1_PosY,y      ; wsp.Y SPRITE #1-#7
                  cmp BOMB_JACK_PosY1     ; porwnaj ze wsp.Y grnej krawdzi postaci BOMB JACK-a
                  bcc Collision_skip2     ; wsprzdne Y nie nachodz, wic nie badaj dalej

                  cmp BOMB_JACK_PosY2     ; porwnaj ze wsp.Y dolnej krawdzi postaci BOMB JACK-a
                  bcc Collision_skip4     ; wsprzdne Y nachodz!

                  jmp Collision_skip2

; Wsprzdne X i Y postaci BOMB JACK-a i SPRITE'a #1-#7 nachodz na siebie! Oznacza to wykryt KOLIZJE!
Collision_skip4   stx      Collision_BOMB_JACK_with_SPRITE          ; zapamitaj z jakim SPRIT-em nastpia kolizja BOMB JACK-a
                  mva #$01 Is_Collision_BOMB_JACK_with_SPRITE       ; ustaw wskanik, e nastpia kolizja BOMB JACK-a i SPRITE'a #1-#7

                  rts

Collision_BOMB_JACK_with_SPRITE    .byte $00 ; zapamituje z jakim SPRIT-em nastpia kolizja BOMB JACK-a
Is_Collision_BOMB_JACK_with_SPRITE .byte $00 ; =1 ten wskanik mwi, e nastpia kolizja BOMB JACK-a i SPRITE'a #1-#7

1407 00           brk

; wsp.X1,Y1 definiuj lewy-grny rg, a wsp.X2,Y2 definiuj prawy-dolny rg kwadratu, w ktrym jest narysowany BOMB JACK
BOMB_JACK_PosX1   .byte $00               ; wsp.X1 - zapamitaj dokd siga lewa cz postaci BOMB JACK-a
BOMB_JACK_PosX2   .byte $00               ; wsp.X2 - zapamitaj dokd siga prawa cz postaci BOMB JACK-a
BOMB_JACK_PosY2   .byte $00               ; wsp.Y2 - zapamitaj dokd siga dolna cz postaci BOMB JACK-a
BOMB_JACK_PosY1   .byte $00               ; wsp.Y1 - zapamitaj dokd siga grna cz postaci BOMB JACK-a
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Po wciniciu RESETu - tutaj startuje program!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
NMI_RES           sei
                  ldx #$FF
                  txs                           ; pusty stos
                  jmp StartGame
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wpisuje napisy na "staym" prawym panelu - informacje
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Right_Panel  ldx #$07

; wypisujemy napisy (znaki) na prawym "staym" panelu z informacjami (SCORE, ROUND 00, HI-SCORE itp.)
Draw_Panel_loop1  mva text_score_scr,x   BuffText40x25+$006F,x
                  mva text_round_scr,x   BuffText40x25+$015F,x
                  mva text_hiscore_scr,x BuffText40x25+$01D7,x
                  lda text_line_scr,x
                  sta BuffText40x25+$033F,x
                  sta BuffText40x25+$0367,x
                  sta BuffText40x25+$038F,x
                  dex
                  bpl Draw_Panel_loop1

                  jsr Draw_Panel_skip1
                  jmp Draw_Panel_skip2

Draw_Panel_skip1  ldx #07

Draw_Panel_loop2  lda #$01                          ; kolor biay
                  sta ColorRAM40x25+$0228,x
                  sta ColorRAM40x25+$0070,x
                  sta ColorRAM40x25+$00C0,x
                  mva #$03 ColorRAM40x25+$015F,x    ; kolor cyjan
                  mva #$07 ColorRAM40x25+$01D7,x    ; kolor ty
                  dex
                  bpl Draw_Panel_loop2

                  rts

Draw_Panel_skip2  mva #$0A BuffText40x25+$036A   ; "x" wypisz na ekranie
                  lda #$01                       ; kolor biay
                  sta ColorRAM40x25+$0342
                  sta ColorRAM40x25+$0343
                  mvx #$FF pos_tab_addr_live

Draw_Panel_loop3  inc pos_tab_addr_live
                  jsr Draw_Live_Jack             ; Procka rysuje ycie BOMB JACK-a
                  lda pos_tab_addr_live
                  cmp #$01
                  bne Draw_Panel_loop3           ; x2 wykonaj ptle

                  rts

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Procka rysuje ycie BOMB JACK-a w jednym z szeciu moliwych miejsc
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Live_Jack    lda pos_tab_addr_live
                  cmp #$06
                  bcs Draw_Live_Jack2

                  asl @
                  tay
                  mwa tab_char_panel,y  address1     ; Y=0 ScreenBuff40x25+$0277  Y=1 ScreenBuff40x25+$027A
                  mwa tab_color_panel,y address2     ; Y=0   ColorRAM40x25+$0277  Y=1   ColorRAM40x25+$027A
                  ldy #$00
                  mva #$E9 (address1),y    ; pierwszy z czterech - znak BOMB JACKA symbolizujcy dodatkowe ycie (rys. na ekranie)
                  mva #$09 (address2),y    ; kolor brzowy?
                  iny
                  mva #$EA (address1),y    ; 2-gi znak BOMB JACK-a
                  mva #$09 (address2),y
                  ldy #$28                 ; przejd wiersz niej
                  mva #$EB (address1),y    ; 3-ci znak BOMB JACK-a
                  mva #$09 (address2),y
                  iny
                  mva #$EC (address1),y    ; 4-ty znak BOMB JACK-a
                  mva #$09 (address2),y
                  rts

Draw_Live_Jack2   dec pos_tab_addr_live
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Clear_Live_Jack   lda pos_tab_addr_live
                  asl @
                  tay
                  mwa tab_char_panel,y address1      ; Y=0 ScreenBuff40x25+$0277  Y=1 ScreenBuff40x25+$027A
                  lda #$20                           ; kasuje jedno ycie BOMB JACK-a
                  ldy #$00
                  sta (address1),y
                  iny
                  sta (address1),y
                  ldy #$28                           ; przejd do wiersza niej
                  sta (address1),y
                  iny
                  sta (address1),y
                  rts

tab_char_panel    .word ScreenBuff40x25+$0277      ; tablica z adresami gdzie mona rys dodatkowe ycie (znaki)
                  .word ScreenBuff40x25+$027A
                  .word ScreenBuff40x25+$027D
                  .word ScreenBuff40x25+$02C7
                  .word ScreenBuff40x25+$02CA
                  .word ScreenBuff40x25+$02CD

tab_color_panel   .word ColorRAM40x25+$0277        ; tablica z adresami gdzie mona rys dodatkowe ycie (atrybuty)
                  .word ColorRAM40x25+$027A
                  .word ColorRAM40x25+$027D
                  .word ColorRAM40x25+$02C7
                  .word ColorRAM40x25+$02CA
                  .word ColorRAM40x25+$02CD

pos_tab_addr_live .byte $00                              ; wskazuje na pozycje w tablicy, gdzie jest adres, pod ktrym mona narysowa ycie BOMB JACK-a

text_score_scr    .byte $20,$0B,$14,$0F,$11,$0E,$20,$20  ; " SCORE  " - ten tekst jest wypisywany na ekranie gry
1500              .byte $0B,$0C,$0D,$0E,$20,$02,$20,$20  ; "SIDE 2  "???
text_round_scr    .byte $11,$0F,$12,$10,$0D,$20          ; "ROUND 00" - tekst wypis. na ekranie gry UWAGA: $00 (+6 pozycja) - numer rundy w kodzie BCD | $00 (+7 pozycja) - numer rundy w normalnym formacie
Number_Round_BCD  .byte $00                              ; numer rundy w kodzie BCD
Number_Round_BIN  .byte $00                              ; numer rundy w kodzie BINARNYM (normalnym)
text_hiscore_scr  .byte $13,$0C,$20,$0B,$14,$0F,$11,$0E  ; "HI SCORE"
text_line_scr     .byte $20,$FE,$FE,$FE,$FE,$FE,$FE,$20  ; " XXXXXX "   - tekst wywietlany w trzech wierszach dla narysowania prostoktu
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia kod BOMB-y($01, lewy grny rg) na odpowiedniej pozycji w tab_Screen_BOMB(40x25) UWAGA: dla wszystkich 24 BOMB!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_CODE_BOMB_in_tab_Screen_BOMB
                  ldx #$00                                 ; rej.X: 0-23 (max. liczba BOMB do zebrania na planszy wynosi 24!)

Set_BOMB_loop1    txa
                  asl @                                    ; rej.A*2     (0-46)
                  tay
                  mwa ScreenText40x25+$0000,y address1     ; ustawia kolejno: $042C,$042F,$0432,  $043E,$0441,$0444,   $04D5,$04D8,$04DB,$04DE,  $0541...itd.
                  ldy #$00
                  mva #$01 (address1),y                    ; wstaw znacznik "01", ktry oznacza, e na tym polu jest lewy grny rg BOMB-y do zebrania na planszy gry
                  inx
                  cpx #$18                                 ; 0..23
                  bne Set_BOMB_loop1

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura animuje napis "START !" przed rozpoczciem gry (z wykorzystaniem sprite'w)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_START_Sprites
                  lda #$FF
                  sta $D01C                            ; VicMobDepth - wczenie MULTICOLOROWYCH SPRITE'w (bit0-7 = 1 ON)
                  sta $D015                            ; VicMobEnable - SPRITES ON
                  ldy #$07                             ; 7-0

Anim_Sprites_loop1 mva tab_definition_sprites,y ScreenBuff40x25+$03F8,y   ; ustawia adresy 64 bajtowych blokw dla spritw 0-7 - dana*64 (ostatnie 8bajtw pamici ekranu)
                  mva #$01   $D027,y                   ; $D027-$D01E (rejestr koloru sprite'a 0-7)
                  tya
                  asl @
                  tax
                  mva #$82   $D001,x                   ; ustaw wsp.Y dla sprite'w 0-7
                  dey
                  bpl Anim_Sprites_loop1

                  ldy #$07                             ; 7-0

Anim_Sprites_loop2 tya
                  asl @
                  tax
                  mva tab_x_sprites,y $D000,x          ; ustaw wsp.X dla sprite'w 0-7
                  dey
                  bpl Anim_Sprites_loop2

                  mva #$01 $D026                       ; VicMltClr1 - okrela kolor dla pary bitw %11 - sprite nr.1
                  mva #$00 $D025                       ; VicMltClr0 - okrela kolor dla pary bitw %11 - sprite nr.0

Anim_Sprites_loop3 lda $D000                            ; VicMob0PosX - pobiera wsp.X sprite'a nr.0
                  cmp #$60
                  beq Anim_Sprites_skip2

                  inc $D000                            ; VicMob0PosX - wsp.X - sprite nr.0
                  inc $D002                            ; VicMob1PosX
                  inc $D004                            ; VicMob2PosX
                  inc $D006                            ; VicMob3PosX
                  dec $D008                            ; VicMob4PosX
                  dec $D00A                            ; VicMob5PosX
                  dec $D00C                            ; VicMob6PosX
                  dec $D00E                            ; VicMob7PosX
                  jsr Anim_Sprites_skip1
                  jmp Anim_Sprites_loop3

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - najkrtsze opnienie
Anim_Sprites_skip1 ldx #$32

Anim_Sprites_loop4 ldy #$37

Anim_Sprites_loop5 dey
                  bne Anim_Sprites_loop5

                  dex
                  bne Anim_Sprites_loop4

                  rts

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - najdusze opnienie
Anim_Sprites_skip2 jsr Anim_Sprites_skip3
                  jsr Anim_Sprites_skip3
                  jmp Anim_Sprites_End

; procedura(ptla) wprowadza pewne opnienie w wykonywaniu kodu - rednie opnienie
Anim_Sprites_skip3 ldx #$FF
                  ldy #$FF

Anim_Sprites_loop6 dey
                  bne Anim_Sprites_loop6

                  dex
                  bne Anim_Sprites_loop6

                  rts

; wyjcie z procedury
Anim_Sprites_End  mva #$02 $D026                         ; VicMltClr1 - okrela kolor dla pary bitw %11 - sprite nr.1
                  mva #$00 $D025                         ; VicMltClr0 - okrela kolor dla pary bitw %11 - sprite nr.0
                  mva #$01 $D027                         ; VicMob0Clr - kolor sprite'a nr.0
                  mva #$00  Is_No_Flight_BOMB_JACK       ; =0 BOMB JACK lata
                  rts

;dane
tab_x_sprites          .byte $18,$30,$48,$60,$A8,$C0,$D8,$F0  ; wsprzdna X - sprite'y 0-7
tab_definition_sprites .byte $9A,$9B,$9C,$9D,$9F,$A0,$A1,$A2  ; *64+$4000 wskazuje na adres definicji sprite'a (64 bajty)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia bank #2 16KB dla VIC-a
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_Bank_VIC      lda $DD02  ;Cia2DirA
                  ora #$03                      ; bity 0,1 w porcie A mog by R/W
                  sta $DD02  ;Cia2DirA
                  lda #00
                  sta $D020  ;VicBorderClr      ; kolor ramki
                  lda $DD00  ;Cia2DataA
                  and #FC
                  ora #$02
                  sta $DD00  ;Cia2DataA         ; ustawiamy bank #1 dla VIC-a ($4000-$7FFF)
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Inicjuj przerwanie RCI
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_Int_RCI       sei
                  lda #<Int_RCI                 ; zapis #58 (modyfikacja kodu!)
                  sta IRQ_VECT
                  lda #>Int_RCI                 ; zapis #09 (modyfikacja kodu!)
                  sta IRQ_VECT+1                ; ustawienie wektora przerwania RCI = Int_RCI
                  lda D01A  ;VicIrqMask
                  ora #$01
                  sta D01A  ;VicIrqMask         ; wcza przerwanie rastra
                  lda D011  ;VicCtrl1
                  and #$7F
                  sta D011  ;VicCtrl1
                  lda #$00
                  sta D012  ;VicRaster          ; ustawienie linii dla przerwania RCI = 0  (bity 0-7)$D012 + (bit 7)$D011
                  sta DC0E  ;Cia1CtrlA          ; Timer A = 0

                  lda DC0E  ;Cia1CtrlA          ; ???
                  and #$FE
                  sta DC0E  ;Cia1CtrlA

                  lda #$FF
                  sta D01C  ;VicMobDepth        ; wszystkie bity = 1 wic sprity bd w MULTICOLOR
                  lda #$FF
                  sta D015  ;VicMobEnable       ; wszystkie bity = 1 wic wcz sprity (na ekranie)

                  cli
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura obsugujca przerwanie RCI na ekranie gry - obsuguje m.in. sprite'y
;--------------------------------------------------------------------------------------------------------------------------------------------------------
162B              .byte $00
162C              .byte $00

Int_RCI_Game      lda D012                             ; VicRaster
                  cmp #$32
                  beq Init_RCI_G_skip1
                  jmp Init_RCI_G_skip5

                 .byte $00

Init_RCI_G_skip1  lda 122E
                  beq Init_RCI_G_skip2

                  dec 122E

Init_RCI_G_skip2  jsr RCI_BOMB_JACK_Joystick_Part1
                  lda Is_Dead_BOMB_JACK
                  bne Init_RCI_G_skip3

                  lda 11E8
                  bne Init_RCI_G_skip3

                  lda Is_Dance_BOMB_JACK
                  bne Init_RCI_G_skip4

                  jsr Do_Move_SPRITES_1_7

Init_RCI_G_skip3  jsr RCI_BOMB_JACK_Joystick_Part2

Init_RCI_G_skip4  jsr Blink_BOMB
                  jsr Blink_Score_&_Bar
                  jsr BOMB_JACK_Get_BOMB
                  jsr BASIC_OFF
                  jsr proc7448
                  jsr proc7E3E
                  mva #$FC $D012                ;VicRaster
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wyjcia z przerwania RCI (IRQ)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
End_RCI           lda $D019    ; VicIrqFlag
                  ora #$01
                  sta $D019    ; VicIrqFlag - po w stawieniu 1 moliwe jest wygenerowanie kolejnego przerwania
                  jsr BASIC_ON
                  lda $DC0D    ; Cia1Irq  ??? - zbdny rozkaz
                  pla          ; zdjcie rejestrw ze stosu
                  tay
                  pla
                  tax
                  pla
                  rti
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Init_RCI_G_skip5  jsr BASIC_OFF
                  jsr proc7448
                  lda 11EE
                  beq Init_RCI_G_skip8

                  lda 11EF
                  beq Init_RCI_G_skip6

                  lda Time_Get_SmilingFace_Soon_Finish
                  beq Init_RCI_G_skip7

                  dec Time_Get_SmilingFace_Soon_Finish

Init_RCI_G_skip6  lda 11EF
                  eor #$01
                  sta 11EF
                  jmp Init_RCI_G_skip8

Init_RCI_G_skip7  inc 11EC

Init_RCI_G_skip8  mva Sprite0_PosX        D000                   ; VicMob0PosX
                  mva Sprite0_PosY        D001                   ; VicMob0PosY
                  mva Sprite0_7_PosX_8bit D010                   ; VicMobMsbX   - bit.8 wsp. X dla SPRITES #0-7

                  ldy #$06                                       ; ptla dla siedmiu sprite'w

Init_RCI_G_loop1  mva tab_Addr_SPRITE_Pattern,y ScreenBuff40x25+$03F9,y  ; ustaw wywietlany wzr dla kadego ze sprite'w #1-#7
                  dey
                  bpl Init_RCI_G_loop1

                  ldx #$0C                                       ; 12..0

Init_RCI_G_loop2  mva Sprite1_PosX,x D002,x                      ; Sprite #1 X-coordinate (only bits #0-#7).
                  mva Sprite1_PosY,x D003,x                      ; Sprite #1 Y-coordinate.
                  dex
                  bpl Init_RCI_G_loop2

                  mva #$32 D012                                  ; VicRaster
                  lda 162C
                  bne Init_RCI_G_END

                  mva #$01 162C

Init_RCI_G_END    jmp End_RCI

index_Blink_BOMB .byte $00   ; licznik wskazujcy na kolejn pozycj w tab_Blink_BOMB

; tablica z kolorami jakimi miga BOMBA do zebrania
tab_Blink_BOMB    .db $0F,$0F,$0F,$0F,$0F,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0A,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$0C,$00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura miga BOMB- w rnych kolorach (za jej zebranie wiksza liczba punktw ni normalnie?)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Blink_BOMB        lda Is_Blink_BOMB         ; czy miga BOMB-?
                  beq Blink_BOMB_RTS        ; =0 NIE!

                  lda index_Address_BOMBS   ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y
                  asl @
                  tax
                  adw ScreenText40x25,x #$D400 address1 ; pobierz adres lewego grnego rogu BOMB-y(od $5400 zapisane s kolejne offsety pozycji BOMB powikszone o $0400), dodaj +$D400 aby obl. bezwzgldny adres w ColorRAM

                  ldy #$00

; pobierz kolejny kolor z tablicy
Blink_BOMB_loop1  inc index_Blink_BOMB
                  ldx index_Blink_BOMB
                  lda tab_Blink_BOMB,x
                  bne Blink_BOMB_skip1

                  mva #$FF index_Blink_BOMB
                  jmp Blink_BOMB_loop1

; zmie kolor dla BOMBY (4 atrybuty)
Blink_BOMB_skip1  lda tab_Blink_BOMB,x
                  sta Actual_Color_Blink_BOMB
                  sta (address1),y
                  iny                       ; kolumna w prawo
                  sta (address1),y
                  ldy #$28                  ; nastpny wiersz
                  sta (address1),y
                  iny                       ; kolumna w prawo
                  sta (address1),y

Blink_BOMB_RTS    rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia wsp. X i Y, wsp. Ground oraz wygld dla Sprite #0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Set_XY_Addr_Sprite0
                  mva #$86 Sprite0_PosX
                  mva #$77 Sprite0_PosY
                  mva #$00 Offset_PosY_Ground    ; ile doda do wsp.Y, aby BOMB JACK wrci na ziemie lub kadke
                  mva #$07 Repeat_PosY_Ground    ; ile razy wykona ptle
                  mva #$A8 ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($A8*$40 = $6A00) - klatka z BOMB JACK'iem z uniesionymi rkami i spuszczon peleryn
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura obsugujca BOMB JACK-a na przerwaniu RCI (Raster)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
RCI_BOMB_JACK_Joystick_Part2
                  lda Is_No_Flight_BOMB_JACK
                  jne RCI_JACK1_skipS

                  jsr Calculate_address1_BOMB_JACK_in_ScreenBuff40x25
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  beq RCI_JACK2_skip1

                  rts

RCI_JACK2_skip1   jsr address1_SBW_1byte                       ; poprzednia kolumna
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  beq RCI_JACK2_skip2

                  rts

RCI_JACK2_skip2   jsr address1_ADW_1byte                       ; nastpna kolumna
                  jsr address1_ADW_1byte                       ; nastpna kolumna
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  beq RCI_JACK2_skip3

                  rts

RCI_JACK2_skip3   dec Repeat_PosY_Ground
                  lda Repeat_PosY_Ground
                  bne RCI_JACK2_skip4

                  mva #$07 Repeat_PosY_Ground
                  lda Offset_PosY_Ground
                  cmp #$08
                  beq RCI_JACK2_skip4

                  inc Offset_PosY_Ground

RCI_JACK2_skip4   adb Sprite0_PosY Offset_PosY_Ground
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura obsugujca BOMB JACK-a na przerwaniu RCI (Raster)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
RCI_BOMB_JACK_Joystick_Part1
                  lda Is_Dance_BOMB_JACK
                  jne RCI_JACK1_Dance

                  lda Is_Dead_BOMB_JACK
                  jne Animate_Dead_BOMB_JACK

                  lda DC00                ; Cia1DataA
                  and #$04                ; Joystick w lewo ?
                  jeq RCI_JACK1_Left      ; TAK!

                  lda DC00                ; Cia1DataA
                  and #$08                ; Joystick w prawo ?
                  jeq RCI_JACK1_Right     ; TAK!

RCI_JACK1_loop1   lda DC00                ; Cia1DataA
                  and #$10                ; czy wcinito FIRE ?
                  bne RCI_JACK1_NO_Fire   ;slow  NIE!

                  lda Is_FIRE_Still_Pressed
                  beq RCI_JACK1_skip1

                  rts

RCI_JACK1_skip1   mva #$01 Is_FIRE_Still_Pressed
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  jne RCI_JACK1_skipP

RCI_JACK1_skip0   mva #$00 Offset_PosY_Ground
                  sta      Is_No_Flight_BOMB_JACK  ; =0 BOMB JACK lata!
                  mva #$06 Repeat_PosY_Ground
                  lda DC00                         ; Cia1DataA
                  and #$04                         ; Joystick w lewo ?
                  bne RCI_JACK1_skip3              ; NIE!

                  rts

RCI_JACK1_skip2   mva #$A8 ScreenBuff40x25+$03F8   ; 64-bajtowy blok danych - sprite #0 ($A8*$40 = $6A00) - klatka z BOMB JACK'iem z uniesionymi rkami i spuszczon peleryn
                  rts

RCI_JACK1_skip3   lda DC00                         ; Cia1DataA
                  and #$08                         ; Joystick w prawo ?
                  bne RCI_JACK1_skip2              ; NIE!

                  rts

; tutaj obsuga BOMB JACK-a jeeli nie wcinito FIRE oraz nie ruszono joystickiem ani w prawo ani w lewo
RCI_JACK1_NO_Fire mva #$00 Is_FIRE_Still_Pressed
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  bne RCI_JACK1_RTS

                  lda DC00                ; Cia1DataA
                  and #$04                ; Joystick w lewo?
                  bne RCI_JACK1_skip5     ; NIE!

                  rts

RCI_JACK1_skip5   lda DC00                ; Cia1DataA
                  and #$08                ; Joystick w prawo?
                  bne RCI_JACK1_skip6     ; NIE!

                  rts

RCI_JACK1_skip6   lda Is_No_Flight_BOMB_JACK
                  beq RCI_JACK1_skip7

                  mva #$A8 ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($A8*$40 = $6A00) - klatka z BOMB JACK'iem z uniesionymi rkami i spuszczon peleryn
                  rts

RCI_JACK1_skip7   mva #$A9 ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($A9*$40 = $6A40) - klatka z BOMB JACK'iem z uniesionymi rkami i uniesion peleryn

RCI_JACK1_RTS     rts

; skok tutaj jeeli Joystick w lewo
RCI_JACK1_Left    lda Sprite0_PosX

                  cmp #$1B                       ; Czy wsp.X BOMB JACK-a osigna lewy margines? (badamy czy PosX=$1B or PosX=$1C bo przesuwamy o -2 piksele)
                  beq RCI_JACK1_RTS              ; TAK!
                  cmp #$1C
                  beq RCI_JACK1_RTS              ; TAK!

                  mva #$01     Is_Set_Store_Action
                  jsr Calculate_address1_BOMB_JACK_in_ScreenBuff40x25 ; oblicz adres(korzystajc z wsp. X i Y) w ScreenBuff40x25, na ktrym aktualnie jest wywietlany SPRITE
                  sbw address1 #$0052                              ; -82
                  mva #$01     Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action               ; Czy na pozycji BOMB JACK-a jest zielony margines lub kadka?
                  beq RCI_JACK1_skip9

                  dec Store_Action
                  rts

RCI_JACK1_skip9   jsr address1_SBW_40bytes
                  mva #$01 Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action               ; Czy na pozycji BOMB JACK-a (wiersz wyej) jest zielony margines lub kadka?
                  beq RCI_JACK1_skipA

                  dec Store_Action
                  rts

RCI_JACK1_skipA   jsr address1_ADW_40bytes
                  jsr address1_ADW_40bytes
                  mva #$01 Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action               ; Czy na pozycji BOMB JACK-a (wiersz niej) jest zielony margines lub kadka?
                  beq RCI_JACK1_skipB

                  dec Store_Action
                  rts

RCI_JACK1_skipB   :2 dec Sprite0_PosX            ; przesu w lewo BOMB JACK-a o -2 piksele
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  bne RCI_JACK1_skipD

                  lda Is_No_Flight_BOMB_JACK
                  beq RCI_JACK1_skipC

                  mva #$AD ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($AD*$40 = $6B40) - klatka z BOMB JACK'iem zwrconym w lewo
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipC   mva #$AB ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($AB*$40 = $6AC0) - klatka z BOMB JACK'iem spadajcym i zwrconym w lewo
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipD   lda Delay_Move_BOMB_JACK_Left_or_Right
                  cmp #$03
                  beq RCI_JACK1_skipE

                  inc Delay_Move_BOMB_JACK_Left_or_Right
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipE   mva #$00 Delay_Move_BOMB_JACK_Left_or_Right
                  ldx index_tab4clips_Move_BOMB_JACK      ; pobierz wskanik wsk. na kolejn klatk przesuwajc w lewo BOMB JACK-a

RCI_JACK1_skipF   lda tab_4clips_Move_BOMB_JACK_Left,x    ; pobierz kolejn klatk z przesuwajcych BOMB JACK-a w lewo (s ich 4-ry)
                  beq RCI_JACK1_skipG

                  sta ScreenBuff40x25+$03F8               ; 64-bajtowy blok danych - sprite #0 (rej.A*$40)
                  inc index_tab4clips_Move_BOMB_JACK      ; +1 wskanik
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipG   mvx #$00 index_tab4clips_Move_BOMB_JACK ; =0 ustaw wskanik na pierwsz klatk przesuwajc BOMB JACK-a w lewo!
                  jmp RCI_JACK1_skipF                     ; skocz pobra t pierwsz klatk

RCI_JACK1_RTS2    rts

; skok tutaj jeeli Joystick w prawo
RCI_JACK1_Right   lda Sprite0_PosX
                  cmp #$F2
                  beq RCI_JACK1_RTS2

                  cmp #$F3
                  beq RCI_JACK1_RTS2

                  mva #$01 Is_Set_Store_Action
                  jsr Calculate_address1_BOMB_JACK_in_ScreenBuff40x25
                  sbw address1 #$004E
                  mva #$01     Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action
                  beq RCI_JACK1_skipH

                  dec Store_Action
                  rts

RCI_JACK1_skipH   jsr address1_SBW_40bytes
                  mva #$01 Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action
                  beq RCI_JACK1_skipI

                  dec Store_Action
                  rts

RCI_JACK1_skipI   jsr address1_ADW_40bytes
                  jsr address1_ADW_40bytes
                  mva #$01 Is_Set_Store_Action
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Store_Action
                  beq RCI_JACK1_skipJ

                  dec Store_Action
                  rts

RCI_JACK1_skipJ   inc Sprite0_PosX
                  inc Sprite0_PosX
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  bne RCI_JACK1_skipL

                  lda Is_No_Flight_BOMB_JACK
                  beq RCI_JACK1_skipK

                  mva #$AC ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($AC*$40 = $6B00) - klatka z BOMB JACK'iem odwrconym w prawo i stojcym nieruchomo!
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipK   mva #$AA ScreenBuff40x25+$03F8 ; 64-bajtowy blok danych - sprite #0 ($AA*$40 = $6A80) - klatka z BOMB JACK'iem odwrconym w prawo - ldujcym po wykonanym skoku!
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipL   lda Delay_Move_BOMB_JACK_Left_or_Right
                  cmp #$03
                  beq RCI_JACK1_skipM

                  inc Delay_Move_BOMB_JACK_Left_or_Right
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipM   mva #$00 Delay_Move_BOMB_JACK_Left_or_Right
                  ldx index_tab4clips_Move_BOMB_JACK        ; pobierz wskanik na kolejn klatk przesuwajc w prawo BOMB JACK-a

RCI_JACK1_skipN   lda tab_4clips_Move_BOMB_JACK_Right,x     ; pobierz kolejn klatk z przesuwajcych BOMB JACK-a w prawo (s ich 4-ry)
                  beq RCI_JACK1_skipO

                  sta ScreenBuff40x25+$03F8                 ; 64-bajtowy blok danych - sprite #0 (rej.A*$40)
                  inc index_tab4clips_Move_BOMB_JACK        ; +1 wskanik
                  jmp RCI_JACK1_loop1

RCI_JACK1_skipO   mvx #$00 index_tab4clips_Move_BOMB_JACK   ; =0 ustaw wskanik na pierwsz klatk przesuwajc BOMB JACK-a w prawo!
                  jmp RCI_JACK1_skipN                                  ; skocz pobra t pierwsz klatk

                  rts

RCI_JACK1_skipP   lda Is_No_Flight_BOMB_JACK                ; Czy BOMB JACK nie lata?
                  jne RCI_JACK1_skip0                       ; TAK!

                  lda #$00
                  ldx #$00
                  ldy #$10                                  ; +100.000 punktw
                  jsr Add_Points_to_SCORE_PLAYER_AXY
                  mva #$01 Is_No_Flight_BOMB_JACK           ; =1 BOMB JACK nie lata!
                  mva #$05 Add_PosY_BOMB_JACK_Better_Jump
                  mva #$00 Is_Collision_with_LEDGE_BOMB_JACK
                  lda DC00                                  ; Cia1DataA
                  and #$01                                  ; Joystick w gr?
                  bne RCI_JACK1_skipR                       ; NIE!

                  mva #$06 Add_PosY_BOMB_JACK_Better_Jump                             ; TAK! - to chyba spr. czy skaczc joy zosta skierowany w gr? jeeli tak to skok jest wyszy

RCI_JACK1_skipR   mva #$0A Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK
                  rts

RCI_JACK1_skipS   jsr Calculate_address1_BOMB_JACK_in_ScreenBuff40x25
                  sbw address1 #$00A0
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  beq RCI_JACK1_skipU

RCI_JACK1_skipT   mva #$07 Repeat_PosY_Ground
                  mva #$00 Offset_PosY_Ground
                  sta      Is_No_Flight_BOMB_JACK
                  sta      Is_Collision_with_LEDGE_BOMB_JACK
                  rts

RCI_JACK1_skipU   jsr address1_SBW_1byte                      ; poprzednia kolumna
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  jne RCI_JACK1_skipT

                  jsr address1_ADW_1byte                      ; nastpna kolumna
                  jsr address1_ADW_1byte                      ; nastpna kolumna
                  jsr Get_Action_from_tab_Action_for_256Chars
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  jne RCI_JACK1_skipT

                  dec Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK
                  lda Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK
                  bne RCI_JACK1_skipV

                  mva #$07 Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK
                  lda Add_PosY_BOMB_JACK_Better_Jump
                  beq RCI_JACK1_skipW

                  dec Add_PosY_BOMB_JACK_Better_Jump

RCI_JACK1_skipV   clc
                  lda Sprite0_PosY
                  cmp #$40            ;64
                  bcc RCI_JACK1_skipW

                  sbb Sprite0_PosY Add_PosY_BOMB_JACK_Better_Jump
                  rts

RCI_JACK1_skipW   mva #$00 Is_No_Flight_BOMB_JACK
                  sta      Offset_PosY_Ground
                  mva #$07 Repeat_PosY_Ground
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura liczy adres SPRITE'a #0 na ScreenBuff40x25 (wynik w address1)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Calculate_address1_BOMB_JACK_in_ScreenBuff40x25
                  lda Sprite0_PosX
                  cmp #$0C                 ; 12
                  bcs Calc_Addr_skip1

                  ldx #$1F                 ; 31
                  jmp Calc_Addr_skip3

Calc_Addr_skip1   lda Sprite0_PosX
                  sub #$0C                 ; -12  - ustawienie wsp.X do 12 pikseli powoduje, e SPRITE jest niewidoczny na ekranie
                  jmp Calc_Addr_skip2

                  lda Sprite0_PosX         ; zbdny rozkaz???

Calc_Addr_skip2   :3 lsr @                 ; /8   - obliczenie, w ktrej kolumnie jest BOMB JACK (wsp.X / 8)
                  tax                      ; zapamitaj to w rej.X
                  lda Sprite0_7_PosX_8bit  ; spr. bit8 dla SPRITE'a #0
                  and #$01
                  beq Calc_Addr_skip3

                  txa                      ; bit8=1(wsp.X>255) wic dla obliczenia, w ktrej kolumnie znajduje si SPRITE #0 naley doda +32 kolumny
                  add #$20
                  tax

Calc_Addr_skip3   txa
                  sta Sprite0_7_PosX_div_8 ; wsp. X / 8 - dla obliczenia kolumny
                  lda Sprite0_PosY
                  sub #$1A                 ; -26  - ustawienie wsp.Y do 26 pikseli powoduje, e SPRITE jest niewidoczny na ekranie
                  :3 lsr @                 ; /8   - obliczenie, w ktrym wierszu jest BOMB JACK (wsp.Y / 8)
                  sta Sprite0_7_PosY_div_8 ; zapamitaj
                  asl @                    ; *2   - bo bdzie to wskanik do tablicy o elementach dugoci "WORD"
                  add Sprite0_7_PosY_div_8
                  tay
                  mwa tab_Addr_SPRITE_ScreenBuff40x25,y address1

                  adb address1 Sprite0_7_PosX_div_8 ; dodaj kolumn, w ktrej jest SPRITE #0 do adresu
                  bcc Calc_Addr_skip4

                  inc address1+1

Calc_Addr_skip4   tya
                  tax
                  stx index_tab_Addr_SPRITE_ScreenBuff40x25
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura pobiera "kod akcji" dla wartoci spod (address1) przeszukujc tablice - tab_Action_for_256Chars
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_Action_from_tab_Action_for_256Chars
                  ldy #$00
                  lda (address1),y                   ; pobranie kodu znaku z pozycji, na ktrej jest wywietlany SPRITE
                  tax
                  lda tab_Action_for_256Chars,x      ; pobranie dla tego znaku "kodu akcji"
                  cmp #$01                           ; Czy akcja = $01?
                  jeq Get_Action_skip1

                  lda Is_Set_Store_Action
                  beq Get_Action_skip0

                  mva #$00 Store_Action              ; "kod akcji" = $00 (dla wszystkich kodw <> $01)
                  sta      Is_Set_Store_Action
                  rts

Get_Action_skip0  mva #$00 Is_Collision_with_LEDGE_BOMB_JACK
                  rts

Get_Action_skip1  lda Is_Set_Store_Action
                  beq Get_Action_skip2

                  dec      Is_Set_Store_Action
                  mva #$01 Store_Action              ; "kod akcji" = $01
                  rts

Get_Action_skip2  mva #$01 Is_Collision_with_LEDGE_BOMB_JACK            ; trafiono na zielon ramk lub podkadke wic BOMB JACK wraca na ziemie
                  ldx index_tab_Addr_SPRITE_ScreenBuff40x25
                  mva tab_Addr_SPRITE_ScreenBuff40x25+2,x Sprite0_PosY
                  inc Sprite0_PosY
                  mva #$00 Offset_PosY_Ground        ; dodaj w pierwszym przejciu +0 do wsp.Y BOMB JACK-a (w nastpnych przejciach +1,+2,+3 itd.)
                  mva #$07 Repeat_PosY_Ground        ; wykonaj 7 razy ptle
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura obsugujca taczenie BOMB JACK-a (po zebraniu wszystkich BOMB)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
RCI_JACK1_Dance   inc Delay_Dance_BOMB_JACK
                  lda Delay_Dance_BOMB_JACK
                  cmp #$0A
                  beq RCI_Dance_skip1

                  rts

RCI_Dance_skip1   ldy index_tab_Dance_BOMB_JACK
                  lda tab_Dance_BOMB_JACK,y       ; pobierz kolejn klatk z cigu, ktry powoduje taczenie BOMB JACK-a (jak zbierze wszystkie bomby)
                  beq RCI_Dance_skip2             ;slow  =0 koniec taczenia!

                  sta ScreenBuff40x25+$03F8       ; 64-bajtowy blok danych - sprite #0 (rej.A*$40)
                  inc index_tab_Dance_BOMB_JACK
                  mva #$00 Delay_Dance_BOMB_JACK
                  lda DC00                        ; Cia1DataA (Joystick w porcie #2)
                  cmp #$6F                        ; Czy wcinito FIRE???? (albo odczyt klawiatury - nie bardzo wiem o co chodzi???)
                  beq RCI_Dance_skip2             ; TAK!

                  rts

RCI_Dance_skip2   mva #$01 1E94
                  sta      Dance_Nothing          ; zbdna dana???
                  mva #$00 Delay_Dance_BOMB_JACK
                  sta      index_tab_Dance_BOMB_JACK
                  sta      Is_Dance_BOMB_JACK
                  sta      D418                   ; SidFltMode - wyciszenie i wyczenie filtrw SID-a
                  rts

Delay_Dance_BOMB_JACK     .byte $00 ; opnienie pomidzy kolejnymi klatkami robicymi animacje taczcego BOMB JACK-a
Dance_Nothing             .byte $00 ; zbdna dana???? nie jest nigdzie w grze wykorzystywana
index_tab_Dance_BOMB_JACK .byte $00 ; wskazuje na kolejn klatk cigu powodujcego taczenie BOMB JACK-a (po zebraniu wszystkich bomb)

; tablica z kolejnymi klatkami powodujcymi taczenie BOMB JACK-a (po zebraniu wszystkich BOMB)
tab_Dance_BOMB_JACK dta $AF,$B0,$B1,$AF,$B0,$B1,$B0,$AF,$B1,$B0,$AF,$B1,$B0,$AF,$B0,$AF,$B1,$B0,$B1,$AF,$AF,$B1,$B0,$AF,$B1,$B0,$AF
                    dta $B0,$B0,$AF,$B1,$B1,$B0,$B1,$B0,$AF,$AF,$B0,$B1,$AF,$B0,$B1,$B0,$AF,$B1,$B0,$AF,$B1,$B0,$AF,$B0,$AF,$B1,$00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura animujca martwego BOMB JACK-a
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Animate_Dead_BOMB_JACK
                  lda Is_Collision_with_LEDGE_BOMB_JACK
                  bne Dead_JACK_skip1

                  mva #$04 Time_Delay_Animate_Dead_BOMB_JACK
                  jmp Dead_JACK_skip2

Dead_JACK_skip1   mva #$0F Time_Delay_Animate_Dead_BOMB_JACK
                  mva #$AE ScreenBuff40x25+$03F8     ; 64-bajtowy blok danych - sprite #0 ($AE*$40 = $6B80) - klatka z BOMB JACK'iem do gry nogami (jeeli zabity przez przeciwnika to ona si pojawia)
                  mva Sprite0_PosX Sprite1_PosX
                  sbb Sprite0_PosY #$15 Sprite1_PosY ; -21
                  mva #$01 D028                      ; VicMob1Clr - SPRITE #1 COLOR - kolor ptaszka wywietlanego nad gow gracza jak zginie

Dead_JACK_skip2   inc Delay_Animate_Dead_BOMB_JACK
                  lda Delay_Animate_Dead_BOMB_JACK
                  cmp Time_Delay_Animate_Dead_BOMB_JACK
                  beq Dead_JACK_skip3

                  rts

Dead_JACK_skip3   lda Is_Collision_with_LEDGE_BOMB_JACK
                  bne Dead_JACK_skip4

                  mva #$00 Delay_Animate_Dead_BOMB_JACK
                  lda index_tab_Dead_BOMB_JACK
                  eor #$01
                  sta index_tab_Dead_BOMB_JACK
                  tay
                  mva tab_Dead_BOMB_JACK,y ScreenBuff40x25+$03F8 ; tablica z 2 klatkami animujcymi mier BOMB JACK-a po dotkniciu przez wroga (raz do gry nogami, a raz normalnie ustawiony BOMB JACK)-$6A40 i $6B80
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Dead_JACK_skip4   mva #$00 Delay_Animate_Dead_BOMB_JACK
                  ldy index_tab_Bird_Over_BOMB_JACK
                  lda tab_Bird_Over_BOMB_JACK,y                  ; tablica z animacj ptaszka nad BOMB JACKIEM, jeeli ten zgin ($BA*$40 = $6E80)
                  beq Dead_JACK_skip5                            ; =0 ostatnia klatka z tablicy wic trzeba od pocztku zacz bra klatki!

                  sta tab_Addr_SPRITE_Pattern
                  inc index_tab_Bird_Over_BOMB_JACK
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Dead_JACK_skip5   mva #$00 tab_Type_SPRITES_1_7
                  sta      index_tab_Bird_Over_BOMB_JACK
                  sta      Is_Dead_BOMB_JACK
                  mva #$A8 ScreenBuff40x25+$03F8  ; 64-bajtowy blok danych - sprite #0 ($A8*$40 = $6A00) - klatka z BOMB JACK'iem z rkami uniesionymi do gry i peleryn opuszczon w d
                  mva #$01 11E8
                  rts

Delay_Animate_Dead_BOMB_JACK  .byte $00                             ; opnienie pomidzy wywietlaniem kolejnych klatek mierci BOMB JACK-a
index_tab_Bird_Over_BOMB_JACK .byte $00                             ; wskanik nastpnej klatki w tablicy poniej
tab_Bird_Over_BOMB_JACK       .byte $BA,$BB,$BC,$BB,$BA,$BB,$BC,$00 ; tablica z animacj ptaszka nad BOMB JACKIEM, jeeli ten zgin ($BA*$40 = $6E80)
Is_Dead_BOMB_JACK             .byte $00                             ; =1 zabito BOMB JACK-a!
tab_Dead_BOMB_JACK            .byte $A9,$AE                         ; tablica z 2 klatkami animujcymi mier BOMB JACK-a po dotkniciu przez wroga (raz do gry nogami, a raz normalnie ustawiony BOMB JACK)-$6A40 i $6B80
index_tab_Dead_BOMB_JACK      .byte $00                             ; zawiera warto 0 lub 1 i wskazuj, ktr z dwch klatek z tab_Dead_BOMB_JACK pobra!

Time_Delay_Animate_Dead_BOMB_JACK dta $00                           ; jak dugie ma by opnienie pomidzy klatkami animujcymi mier BOMB JACK-a
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura odejmuje 40 bajtw od address1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
address1_SBW_40bytes
                  sbw address1 #$0028     ; -40
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dodaje 40 bajtw do address1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
address1_ADW_40bytes
                  adw address1 #$0028     ; +40
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; przesuwa kursor w lewo
;--------------------------------------------------------------------------------------------------------------------------------------------------------
address1_SBW_1byte
                  sbw address1 #$01       ; -1
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; przesuwa kursor w prawo
;--------------------------------------------------------------------------------------------------------------------------------------------------------
address1_ADW_1byte
                  adw address1 #$01       ; +1
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura oblicza (address1) i (address2)
; (address1) - adres w ColorRAM gdzie narysujemy atrybut na zebranej bombie (powodujc tym samym zniknicie atrybutu bomby)
; (address2) - adres atrybutw ta(30x25) dla planszy nr. x - narysujemy spod tego adresu to na zebranej bombie (poczwszy od adresu $F400 co 1KB s zapamitane kolejne atrybuty plansz gry 30x25)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Calculate_Screen_Address_and_Attribute_Address_Collected_BOMB
                  lda address1+1                  ; Czy starszy bajt adresu rwny $50?
                  cmp #$50
                  bne Attrib_Collected_skip1      ; NIE!

                  lda address1                    ; Czy modszy bajt adresu w zakresie $00-$9F?
                  cmp #$A0
                  bcs Attrib_Collected_skip1      ; NIE!

; jeeli tutaj dojdziemy tzn, e address1 ma warto w przedziale $5000-$509F!
                  lda Index_charset               ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany (warto w przedziale 0-4)
                  asl @                           ; *2
                  tax
                  mwa Attrib_Board1,x address2    ; 1KB atrybutw - plansza gry #rej.X*2 (ekran gry #rej.X*2) - wskazuje na adres planszy z atrybutami(30x25) gdzie wlatuje BOMB JACK

                  mva address1        StoreA_address1   ; zapamitaj w (StoreA_address1) = address1...
                  add #$00                              ; ...a nastpnie dodaj do address1 + $8800...
                  sta address1
                  mva address1+1      StoreA_address1+1 ; ...i w (address1) mamy wtedy adres pamici atrybutw ColorRAM+Offset
                  adc #$88
                  sta address1+1
                  rts

; jeeli tutaj dojdziemy tzn, e address1 ma warto poza przedzialem $5000-$509F! (czyli ma warto w przedziaach $0000-$4FFF lub $50A0-$FFFF)
Attrib_Collected_skip1
                  mva address1        StoreA_address1   ; zapamitaj w (StoreA_address1) = address1...
                  sub #$A0                              ; ...a nastpnie odejmij od address1 - $50A0...
                  sta address1
                  mva address1+1      StoreA_address1+1 ; ...i obliczony offset zapamitaj w (address1)
                  sbc #$50
                  sta address1+1

                  lda Index_charset               ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany (warto w przedziale 0-4)
                  asl @                           ; *2
                  tax
                  mwa Attrib_Board1,x address2    ; 1KB atrybutw - plansza gry #rej.X*2 (ekran gry #rej.X*2) - wskazuje na adres planszy z atrybutami(30x25) gdzie wlatuje BOMB JACK

                  adw address1 address2 address2  ; oblicz address2 = address2 + offset
                  adw StoreA_address1   #$8800   address1  ; oblicz adres w ColorRAM - address1 = adres na ekranie(ScreenBuff40x25) + $8800
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura oblicza (address1) i (address2)
; (address1) - adres na ekranie(ScreenBuff40x25) gdzie narysujemy to na zebranej bombie (powodujc tym samym zniknicie bomby)
; (address2) - adres ta(30x25) dla planszy nr. x  (poczwszy od adresu $E000 co 1KB s zapamitane kolejne plansze gry 30x25 znakw)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Calculate_Screen_Address_and_Background_Address_Collected_BOMB
                  lda address1+1                   ; Czy starszy bajt adresu rwny $50?
                  cmp #$50
                  bne Back_Collected_skip1         ; NIE!

                  lda address1                     ; Czy modszy bajt adresu w zakresie $00-$9F?
                  cmp #$A0
                  bcs Back_Collected_skip1         ; NIE!

; jeeli tutaj dojdziemy tzn, e address1 ma warto w przedziale $5000-$509F!
                  lda Index_charset                ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany (warto w przedziale 0-4)
                  :2 asl @                         ; *2
                  tax

                  mwa Char_Board1,x address2        ; 1KB znakw - plansza gry #rej.X*2 (ekran gry #rej.X*2) - wskazuje na adres planszy z tem(30x25) gdzie wlatuje BOMB JACK
                  mwa address1      StoreA_address1 ; zapamitaj (StoreA_address1) = address1 - wskazuje na adres na ekranie(ScreenBuff40x25) gdzie wlatuje BOMB JACK
                  rts

; jeeli tutaj dojdziemy tzn, e address1 ma warto poza przedzialem $5000-$509F! (czyli ma warto w przedziaach $0000-$4FFF lub $50A0-$FFFF)
Back_Collected_skip1
                  mva address1      StoreA_address1   ; zapamitaj w (StoreA_address1) = address1...
                  sub #$A0                            ; ...a nastpnie odejmij od address1 - $50A0...
                  sta address1
                  mva address1+1    StoreA_address1+1 ; ...i zapisz offset w address1
                  sbc #$50
                  sta address1+1

                  lda Index_charset                ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany (warto w przedziale 0-4)
                  :2 asl @                         ; *2
                  tax
                  mwa Char_Board1,x address2       ; 1KB znakw - plansza gry #rej.X*2 (ekran gry #rej.X*2)

                  adw address1 address2 address2   ; oblicz address2 = address2 + offset - wskazuje na adres planszy z tem(30x25) gdzie wlatuje BOMB JACK
                  mwa StoreA_address1     address1 ; address1 - wskazuje na adres na ekranie(ScreenBuff40x25) gdzie wlatuje BOMB JACK
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ??? nigdzie nie wykorzystywane ???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
1CEB              sbb address2 3C43
                  bcs 1CF7

                  dec address2+1

1CF7              rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ??? nigdzie nie wykorzystywane ???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
1CF8              adb address2 3C44
                  bcs 1D04

                  inc address2+1

1D04              rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura sprawdza czy BOMB JACK trafi na BOMB-, jeeli tak to zbiera on j (zamazujemy BOMB- poprzez narysuwanie na niej ta spod spodu(znaki+atrybuty) i dodajemy punkty za zebran BOMB-
; procedura wykonywana podczas przerwania RCI co 1/50s
;--------------------------------------------------------------------------------------------------------------------------------------------------------
BOMB_JACK_Get_BOMB
                  jsr Calculate_address1_BOMB_JACK_in_ScreenBuff40x25 ; oblicz jaki adres pamici ekranu przykrywa sprajt BOMB JACK-a
                  jsr address1_SBW_40bytes                            ; poprzedni wiersz
                  jsr address1_SBW_40bytes                            ; poprzedni wiersz

                  ldy #$00
                  lda (address1),y                                    ; pobierz kod znaku z pozycji dwa wiersze wyej ni BOMB JACK
                  tax
                  lda tab_Action_for_256Chars,x                       ; pobierz "kod akcji" dla danego znaku z tablicy 256-cio bajtowej
                  cmp #$02                                            ; Czy BOMB JACK trafi na lewy grny rg BOMB-y do zebrania?
                  jeq Get_BOMB_skip1                                  ; TAK!

                  cmp #$03                                            ; Czy BOMB JACK trafi na prawy grny rg BOMB-y do zebrania?
                  jeq Get_BOMB_mov1                                   ; TAK! ale przesu (address1) tak, eby wskazywa na prawy grny rg BOMB-y!

                  cmp #$04                                            ; Czy BOMB JACK trafi na lewy dolny rg BOMB-y do zebrania?
                  jeq Get_BOMB_mov2                                   ; TAK! ale przesu (address1) tak, eby wskazywa na prawy grny rg BOMB-y!

                  cmp #$05                                            ; Czy BOMB JACK trafi na prawy dolny rg BOMB-y do zebrania?
                  jeq Get_BOMB_mov3                                   ; TAK! ale przesu (address1) tak, eby wskazywa na prawy grny rg BOMB-y!

                  rts                                                 ; NIE! BOMB JACK nie trafi na aden z 4-rech znakw BOMBY!

Get_BOMB_skip1    lda Is_Dead_BOMB_JACK                               ; Czy BOMB JACK jest martwy?
                  beq Get_BOMB_skip3                                  ; NIE!

Get_BOMB_skip2    rts                                                 ; TAK! wyjcie z procedury
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_skip3    lda 1E94                                            ; ???
                  bne Get_BOMB_skip2                                  ; TAK! wyjcie z procedury

                  jsr Calculate_Screen_Address_and_Background_Address_Collected_BOMB
                  jsr Draw_Background_on_BOMB                         ; procedura odtwarza to(znaki) w miejscu zebrania bomby przez BOMB JACK-a (4-ry znaki)
                  jsr Calculate_Screen_Address_and_Attribute_Address_Collected_BOMB
                  jsr Draw_Background_on_BOMB                         ; procedura odtwarza to(atrybuty) w miejscu zebrania bomby przez BOMB JACK-a (4-ry znaki)

                  inc Counter_Collected_BOMBS

                  mwa StoreA_address1 address1                        ; odtwrz zapamitany poprzednio (address1)!

                  sbb address1 #$00                                   ; odejmij od (address1) - $4C00 ...
                  sta StoreB_address1                                 ; ...i zapamietaj offset powikszony o $0400 w (address1) i w ($StoreB_address1)
                  lda address1+1
                  sbc #$4C
                  sta address1+1
                  sta StoreB_address1+1
            ;dupa
                  lda Is_Blink_BOMB                                   ; Czy naley miga bomb?
                  jne Get_BOMB_skipB                                  ; TAK!

                  lda Counter_Collected_BOMBS                         ; NIE!
                  cmp #$01
                  beq Get_BOMB_skip4

                  inc Is_Blink_BOMB                                   ; +1 naley miga BOMB-
                  jmp Get_BOMB_skipB

Get_BOMB_skip4    ldy #$01                                            ; pobierz warto z odpowiedniej pozycji tablicy tab_Screen_BOMB+1
                  mva (address1),y index_Address_BOMBS                ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y

                  sty Is_Blink_BOMB                                   ; <>0 naley miga BOMB-
                  mwa StoreB_address1 address1                        ; odtwrz zapamitany (address1)
                  ldy #$00
                  lda #$00
                  sta (address1),y

                  lda index_Address_BOMBS                             ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y
                  asl @
                  tax
                  mwa ScreenText40x25,x address1                      ; pobierz adres lewego grnego rogu BOMB-y (od $5400 zapisane s kolejne adresy BOMB powikszone o $0400)
                  ldy #$00
                  mva #$02             (address1),y                   ; wpisz kod "$02" (w miejscu gdzie kiedy byo "$01" dla oznaczenia lewego grnego rogu BOMB-y)
                  jmp Get_BOMB_skip6
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_skip5    lda #$00
                  tay
                  sta (address1),y

Get_BOMB_skip6    mwa StoreA_address1 address1                        ; odtwrz zapamitany poprzednio (address1)!
                  lda tab_Type_SPRITES_1_7+6
                  beq Get_BOMB_skip7

                  rts

Get_BOMB_skip7    lda Counter_5th_BOMBS_to_Show_LETTER_B
                  cmp #$05
                  beq Get_BOMB_skip8

                  inc Counter_5th_BOMBS_to_Show_LETTER_B
                  jmp Get_BOMB_skip9

Get_BOMB_skip8    mva #$00 Counter_5th_BOMBS_to_Show_LETTER_B
                  mva #$0A tab_Type_SPRITES_1_7+6
                  mva #$FF Can_Show_LetterEB_on_Board
                  rts

Get_BOMB_skip9    lda Counter_9th_BOMBS_to_Show_LETTER_P
                  cmp #$09
                  bne Get_BOMB_skipA  ;slow

                  mva #$00 Counter_9th_BOMBS_to_Show_LETTER_P
                  sta      tab_Can_Show_LetterP_on_Board+6
                  mva #$08 tab_Type_SPRITES_1_7+6
                  mva #$00 index_tab_clips_Move_Opponent+6
                  sta      tab_Every_Third_Frame_Move_Sprite+6
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
1E00              cmp #$08        ; niewykorzystywane??? kod gry nigdy tutaj nie skacze???
                  beq *+5

                  dec Counter_9th_BOMBS_to_Show_LETTER_P
                  rts

Get_BOMB_skipA    inc Counter_9th_BOMBS_to_Show_LETTER_P
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_skipB    ldy #$00
                  lda (address1),y
                  cmp #$02
                  jeq Get_BOMB_skipC

; warto $01 - wic BOMB JACK zebra kolejn BOMB-
                  lda #$00
         ;dupa
                  ldx ScreenBuff40x25+$036B                  ; pobierz liczb umiejscowion w migajcym prostokcie na ekranie "x1" (tam gdzie "1" moe by dowolna liczba)
                  ldy #$00
                  jsr Add_Points_to_SCORE_PLAYER_AXY         ; dodaj punkty zawarte w rej. A,X,Y do punktw gracza
                  jmp Get_BOMB_skip5
         ; dupa
Get_BOMB_skipC    lda ScreenBuff40x25+$036B                  ; pobierz liczb umiejscowion w migajcym prostokcie na ekranie "x1" (tam gdzie "1" moe by dowolna liczba)
                  asl @                                      ; *2
                  tax
                  lda #$00
                  ldy #$00
                  jsr Add_Points_to_SCORE_PLAYER_AXY         ; dodaj punkty zawarte w rej. A,X,Y do punktw gracza
                  inc Counter_Blink_BOMBS                    ; liczba zebranych BOMB +1
                  ldy #$01
                  mva (address1),y 1E97
                  dey                                        ; rej.Y=0
                  mva #$00         (address1),y
                  sta              1E98

Get_BOMB_loop1    inc 1E98
                  lda 1E98
                  cmp #$19
                  beq Get_BOMB_skipE

                  lda 1E97
                  asl @
                  tay
                  mwa ScreenText40x25+$0001,y address1
                  ldy #$00
                  lda (address1),y
                  bne Get_BOMB_skipD

                  ldy #$01
                  mva (address1),y 1E97
                  jmp Get_BOMB_loop1

                  mva #$00 1E97                      ; nie wykorzystywane??? kod gry nigdy tu nie skacze???
                  jmp Get_BOMB_loop1

Get_BOMB_skipD    ldy #$00
                  mva #$02 (address1),y
                  mva 1E97 index_Address_BOMBS       ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y
                  jmp Get_BOMB_skip6

Get_BOMB_skipE    mva #$01 Is_Dance_BOMB_JACK        ; =1 BOMB JACK taczy
                  sta      1E92
                  mva #$00 Is_Blink_BOMB             ; =0 bomba nie miga
                  jmp Get_BOMB_skip6

1E92              .byte $00

1E93 00           brk          ; nie wykorzystywane???

1E94                .byte $00   ; 0 lub 1
Is_Dance_BOMB_JACK  .byte $00   ; Czy BOMB JACK taczy? (po zebraniu wszystkich BOMB na planszy)

index_Address_BOMBS .byte $00   ; wskanik*2+ScreenText40x25 - wskazuje na adres lewego grnego rogu migajcej BOMB-y
1E97                .byte $00
1E98                .byte $00

StoreB_address1     .word $0000 ; tymczasowy adres dla zapamietania (address1), eby potem odtworzy ten adres

Counter_9th_BOMBS_to_Show_LETTER_P .byte $00 ; licznik zliczajcy, e po 5-ciu zebranych BOMB-ach ma si pokaza "LITERA P" do zebrania
Counter_5th_BOMBS_to_Show_LETTER_B .byte $00 ; licznik zliczajcy, e po 5-ciu zebranych BOMB-ach ma si pokaza "LITERA B" do zebrania

1E9D 00           brk          ; nie wykorzystywane???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura odtwarza to w miejscu zebrania bomby przez BOMB JACK-a (4-ry znaki)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Background_on_BOMB
                  lda $01                          ; CpuDataPort
                  and #$FD                         ; wcz pami RAM pomidzy $E000-$FFFF
                  sta $01                          ; CpuDataPort

; odtworzenie ta w miejscu zebrania bomby przez BOMB JACK-a (4-ry znaki)
; (address2) - adres ta(30x25) dla planszy nr. x  (poczwszy od adresu $E000 co 1KB s zapamitane kolejne plansze gry 30x25 znakw)
; (address1) - adres na ekranie(ScreenBuff40x25) gdzie narysujemy to na zebranej bombie (powodujc tym samym zniknicie bomby)
                  ldy #$00
                  mva (address2),y (address1),y
                  iny                              ; +1  - kolumna w prawo
                  mva (address2),y (address1),y
                  ldy #$28                         ; +40 - wiersz niej
                  mva (address2),y (address1),y
                  iny                              ; +1  - kolumna w prawo
                  mva (address2),y (address1),y

                  lda $01                          ; CpuDataPort
                  ora #$02                         ; wcz pami KERNAL ROM pomidzy $E000-$FFFF
                  sta $01                          ; CpuDataPort
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_mov1     jsr address1_SBW_1byte           ; -1  - kolumna wczeniej
                  jmp Get_BOMB_skip1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_mov2     jsr address1_SBW_40bytes         ; -40 - wiersz wczeniej
                  jmp Get_BOMB_skip1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Get_BOMB_mov3     jsr address1_SBW_40bytes         ; -40 - wiersz wczeniej...
                  jsr address1_SBW_1byte           ; ...i kolumna wczeniej
                  jmp Get_BOMB_skip1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; rysujemy plansze (to) 30x25 i kopiujemy waciwy zestaw znakw 2KB do obszaru $4800-$4FFF
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Back_Set_Charset
                  lda Index_charset
                  :2 asl @                      ;*4
                  tax
                  mwa Char_Board1,x   address1  ; $E000 - tutaj s plansze 30x20 wierszy - co 1KB
                  mwa Attribute1,x $D022        ; VicBgClr1 - kolor ta #1, VicBgClr2 - kolor ta #2
                  ldx Index_charset
                  lda tab5_char,x               ; pobierz znak jakim wypeni 5 pierwszych wierszy od gry ekranu - zwykle symulacja nieba
                  tay
                  mwa #ScreenBuff40x25+$00A0 address2

                  ldx #$1D                      ; 29-0

; rysujemy jasnoniebieskie to (niebo) na ekranie gry - pierwsze 5 wierszy
Draw_Back_loop1   tya
                  sta ScreenBuff40x25+$0000,x   ; wiersz 0
                  sta ScreenBuff40x25+$0028,x   ; wiersz 1
                  sta ScreenBuff40x25+$0050,x   ; wiersz 2
                  sta ScreenBuff40x25+$0078,x   ; wiersz 3
                  sta ScreenBuff40x25+$00A0,x   ; wiersz 4
                  lda #$0E                      ; kolor jasnoniebieski
                  sta ColorRAM40x25+$0000,x
                  sta ColorRAM40x25+$0028,x
                  sta ColorRAM40x25+$0050,x
                  sta ColorRAM40x25+$0078,x
                  sta ColorRAM40x25+$00A0,x
                  dex
                  bpl Draw_Back_loop1

                  jsr Draw_Back_skip1
                  jmp Draw_Back_Set_Charset2

; rysujemy pozostae 20 wierszy planszy 30x20
Draw_Back_skip1   sei
                  lda $01  ;CpuDataPort
                  and #$FD
                  sta $01  ;CpuDataPort         ; wcza RAM w obszarach $A000-$BFFF i $E000-$FFFF

; rysujemy plansze - pozostae 20 wierszy
                  mva #$14 $count_loop1         ; 20-1

Draw_Back_loop2   ldy #1E                       ; 30-0

Draw_Back_loop3   mva (address1),y (address2),y
                  dey
                  bpl Draw_Back_loop3

                  adw address1 #$28             ; +40 wiersz niej
                  adw address2 #$28             ; +40 wiersz niej

                  dec count_loop1
                  bne Draw_Back_loop2

                  lda 01  ;CpuDataPort
                  ora #02
                  sta 01  ;CpuDataPort          ; wcza RAM w obszarze $A000-$BFFF; wcza KERNAL ROM w obszarze $E000-$FFFF

                  rts

; kopiujemy waciwe ksztaty znakw 2KB do obszaru $4800-$4FFF
Draw_Back_Set_Charset2
                  lda Index_charset
                  asl @                         ;*2
                  tax
                  mwa Attrib_Board1,x address1  ; atrybuty plansz 30x20 - co 1KB
                  mwa #ColorRAM+$00A0 address2
                  jsr Draw_Back_skip1

                  lda 01  ;CpuDataPort
                  ora #02
                  sta 01  ;CpuDataPort          ; wcza RAM w obszarze $A000-$BFFF; wcza KERNAL ROM w obszarze $E000-$FFFF

                  sei
                  jsr BASIC_OFF
                  lda Index_charset
                  asl @
                  tay
                  mwa tab_addr_charsets,y address1           ; 2KB ksztatw znakw
                  mwa #CharsetRAM         address2           ; zapamitaj adres pamici ksztatw znakw

Draw_Back_loop4   ldy #00
                  mva (address1),y (address2),y
                  jsr address1_ADW_1byte                     ; nastpna kolumna
                  clc

                  lda address2
                  cmp #$FF
                  bne Draw_Back_skip2

                  lda address2+1
                  cmp #$4F
                  bne Draw_Back_skip2

                  mva #$00 $D021                             ; VicBgClr0
                  jsr BASIC_ON
                  rts

Draw_Back_skip2   adw address2 #$01

                  jmp Draw_Back_loop4
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje belki na ekranie gry - te po ktrych mona skaka zbierajc BOMBY
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Bars         lda Number_Round_BIN                    ; pobierz nr. RUNDY
                  asl @                                   ; *2
                  tax
                  mwa tab_addr_char_bars,x address1

; pobieramy 6 bajtw danych z tablicy
Draw_Bars_loop1   lda #$00
                  ldy #$00
                  lda (address1),y
                  tax
                  dex
                  txa
                  sta              Count_Char_Bar         ; przechowuje dugo na jak rozrysujemy pasek
                  iny
                  mva (address1),y Attrib_Char_Bar        ; przechowuje atrybut(kolor) jakim narysujemy pasek
                  iny
                  mva (address1),y Char_Bar               ; przechowuje znak paska
                  iny
                  lda (address1),y                        ; o ile przesun pozycje, aby rys. kolejny znak paska
                  bne Draw_Bars_skip1  ;slow

                  :3 iny                                  ; przejcie do kolejnej 6-bajtowej paczki danych
                  ldx #$00

; pobranie 7 typw SPRITE'w #1-#7 jakie pojawi si na tej planszy gry
Draw_Bars_loop2   mva (address1),y tab_Type_SPRITES_1_7,x
                  sta              1226,x
                  mva #$00         tab_Is_Sprite1_7_on_Screen,x
                  sta              tab_Move_Left_or_Right_or_Down_LetterEB,x
                  sta              tab_Can_Show_LetterP_on_Board,x
                  sta              tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,x
                  sta              tab_Is_Astronaut_Change_PosX,x
                  sta              tab_Every_100th_Move_Follow_BOMB_JACK,x
                  iny
                  inx
                  cpx #$07
                  bne Draw_Bars_loop2  ;slow

; ustaw pocztkowe wsprzdne X i Y dla SPRITE'w #1-#7
                  ldx #$00
Draw_Bars_loop3   mva (address1),y Sprite1_PosX,x
                  iny
                  inx
                  cpx #$0E
                  bne Draw_Bars_loop3

; zapamitaj 5 jaki wartoci w odwrotnej kolejnoci
                  ldx #$04
Draw_Bars_loop4   mva (address1),y tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform,x
                  iny
                  dex
                  bpl Draw_Bars_loop4

                  rts

; obliczenie adresu, od ktrego zaczniemy rysowa pasek
Draw_Bars_skip1   sta Pos_Char_Bar
                  iny
                  lda (address1),y
                  sta address2
                  sta Offset_Char_Bar
                  iny
                  lda (address1),y
                  sta address2+1
                  sta Offset_Char_Bar+1

                  adw address1 #$0006            ; nastpny pakiet danych (kady pakiet ma 6 bajtw)
                  adw address2 #ScreenBuff40x25

                  ldx Count_Char_Bar
                  jsr Draw_Bars_loop5
                  jmp Draw_Bars_skip3

; narysowanie paska na ekranie(ScreenBuff40x25) lub w pamici koloru(ColorRAM40x25)
Draw_Bars_loop5   ldy #$00
                  mva Char_Bar (address2),y            ; znak z "belk" zapisywany na ekranie
                  clc
                  lda address2
                  adc Pos_Char_Bar
                  sta address2                         ; skoryguj pozycj, od ktrej narysujemy kolejny znak belki (zwykle o +1)
                  bcc Draw_Bars_skip2

                  inc address2+1

Draw_Bars_skip2   dex
                  bpl Draw_Bars_loop5

                  rts

; Obliczenie adresu, od ktrego wstawimy atrybut dla paska i zapis tego
Draw_Bars_skip3   adw Offset_Char_Bar #ColorRAM40x25 address2
                  mva Attrib_Char_Bar Char_Bar
                  ldx Count_Char_Bar
                  jsr Draw_Bars_loop5
                  jmp Draw_Bars_loop1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura rysuje wszystkie BOMBY jakie maj si pojawi na danym ekranie
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Draw_Bombs_On_Screen
                  mva #$00 count_draw
                  lda Number_Round_BIN              ; numer rundy - ekranu
                  asl @                             ;*2
                  tay
                  mwa tab_pos_bombs_on_screens,y address1

Draw_Bombs_0      ldy #$00
                  lda (address1),y
                  cmp #$FF                          ; Czy koniec danych?
                  bne Draw_Bombs_1

                  rts                               ; TAK!

Draw_Bombs_1      :2 asl @                          ;*4
                  tax
                  mwa tab_bombs+$00,x BOMB+0        ; pobiera 2 grne i 2 dolne bajty z definicj "bomby" (ta ktr zbiera BOMB JACK)
                  mwa tab_bombs+$02,x BOMB+2
                  iny
                  mva (address1),y Pos_Bomb         ; o ile zmieni pozycje rysowania BOMBY?
                  iny
                  mva (address1),y Count_Bomb       ; ile BOMB narysowa?
                  iny

; obliczenie pozycji na ekranie od ktrego zaczniemy rysowa BOMBY
                  clc
                  lda (address1),y
                  adc #<ScreenBuff40x25
                  sta address2
                  iny
                  lda (address1),y
                  adc #>ScreenBuff40x25
                  sta address2+1

                  mva #$00 Char_Or_Attrib            ; =0 - wypisywanie znakw na ekranie
                  jsr Draw_Row_Bombs

                  lda #$0A                           ; atrybut - kolor
                  sta BOMB+0                         ; zapisz ten kolor na pozycji 4-rech znakw skadajcych si na BOMB...
                  sta BOMB+1                         ; ...dziki temu uzyskuje ona swj kolor
                  sta BOMB+2
                  sta BOMB+3

                  clc
                  ldy #$02
                  mva (address1),y Count_Bomb        ; ile BOMB narysowa? ponowny zapis

; obliczamy adres odkd zaczniemy zmienia atrybuty, eby uzyska czerwony kolor BOMB
                  iny
                  lda (address1),y
                  adc #<ColorMAP40x25
                  sta address2
                  iny
                  lda (address1),y
                  adc #>ColorRAM40x25
                  sta address2+1

                  mva #$01 Char_Or_Attrib            ; =1 - wypisywanie atrybutw na ekranie
                  jsr Draw_Row_Bombs

                  adw address1 #$05                  ; natpne pi bajtw z danymi jak narysowa wiersz (kolumne) BOMB

                  jmp Draw_Bombs_0

; rysujemy cay wiersz z BOMB-ami (np: 3 sztuki)
Draw_Row_Bombs    dec Count_Bomb
                  lda Count_Bomb
                  bpl Draw_Bombs_2

                  rts

; przechowuj chwilowo pewne wartoci
Store_help1       .byte $00
Store_help2       .byte $00
Store_help3       .byte $00
Store_help4       .byte $00

; rys
Draw_Bombs_2      lda Char_Or_Attrib             ; Czy znak?
                  beq Draw_Bombs_3               ; TAK!

                  jmp Draw_Bomb                  ; NIE!

; Procedura robi jakie dziwne rzeczy???
Draw_Bombs_3      lda count_draw                 ; licznik wskazujcy, ktr BOMB- aktualnie rysujemy...
                  asl @                          ; ... *2
                  tax
                  mva address2   Store_help1     ; zapamitaj, eby pniej odtworzy
                  sub #$00                       ; [adres BOMB-y na ekranie-$4C00] zapisujemy w (address2) i w ScreenText40x25,x
                  sta address2                   ; wyliczony adres jest w zakresie $0400-$07FF (czyli jest to tablica tab_Screen_BOMB)
                  sta ScreenText40x25,x
                  mva address2+1 Store_help2     ; zapamitaj, eby pniej odtworzy
                  sbc #$4C
                  sta address2+1
                  sta ScreenText40x25+1,x

                  lda #$01
                  ldy #$00
                  sta (address2),y               ; zapisz warto $01 w odpowiedniej pozycji tablicy tab_Screen_BOMB+0
                  mwa address1 Store_help3       ; zapamitaj, eby pniej odtworzy

                  lda Number_Round_BIN           ; jaka runda (ekran)?
                  asl @                          ; *2
                  tay
                  mwa tab_Address_Next_Blink_Bomb_BOARD,y address1  ; ustaw np: "Pointer_Address_Next_Blink_Bomb_BOARD_01" dla pierwszej planszy gry
                  ldy count_draw
                  lda (address1),y
                  ldy #$01
                  sta (address2),y               ; zapisz warto w odpowiedniej pozycji tablicy tab_Screen_BOMB+1

                  mwa Store_help3 address1       ; odtworzenie wartoci np: $38F4
                  mwa Store_help1 address2       ; odtworzenie wartoci np: $5000
                  inc count_draw                 ; +1 kolejna BOMB-a narysowana (dla cisoci: waciwie za chwile dopiero zostanie narysowana na ekranie)

; rysujemy jedn BOMB
Draw_Bomb         ldy #$00
                  mva BOMB+0 (address2),y   ; rysuje 1-szy bajt BOMBY
                  iny
                  mva BOMB+1 (address2),y   ; rysuje 2-gi bajt BOMBY
                  ldy #$28                  ; przejd wiersz niej
                  mva BOMB+2 (address2),y   ; rysuje 3-ci bajt BOMBY
                  iny
                  mva BOMB+3 (address2),y   ; rysuje 4-ty bajt BOMBY

                  clc
                  lda address2
                  adc Pos_Bomb              ;+3
                  sta address2
                  bcc Draw_Bomb_End

                  inc address2+1

Draw_Bomb_End     jmp Draw_Row_Bombs
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Char_Or_Attrib             .byte $00                         ; znacznik czy wypisywa znaki czy atrybuty na ekranie?
tab_First_PosX_SPRITES_0_7 .byte $00,$19,$32,$4B,$64,$7D,$96 ; tablica zawiera pocztkow wsp.X dla SPRITE'w #1-#7 (wykorzystywana np: zaraz jak rozpoczyna si gra)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura wywietla ekran z BONUSem
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Show_Bonus_Screen sei
                  lda Counter_Blink_BOMBS
                  cmp #$14
                  jcc Show_Bonus_RTS

                  mva #$50 D018               ; VicMemCtrl - w trybie tekstowym - przesunicie 0,w trybie graficznym - przesunicie $1400 (obszar banku 16KB VIC)
                  mva #$18 Fill40x25_mod1+1   ; modyfikacja kodu w procedurze wypisujcej na ekranie tekst - $18 = 24+1 wierszy
                  jsr Clear_Screen40x25       ; czy ekran
                  lda #$00
                  sta D015                    ; VicMobEnable - SPRITES OFF
                  sta D022                    ; VicBgClr1    - kolor ta nr.1
                  mva #$1D HI_YOU_HAVE_GOTTEN ; liczba zebranych BOMB 2x (starsza cyfra)
                  lda Counter_Blink_BOMBS
                  cmp #$17
                  beq Show_Bonus_skip1

                  cmp #$16
                  beq Show_Bonus_skip2

                  cmp #$15
                  beq Show_Bonus_skip3

                  lda #$1B                          ;"0"
                  ldx #$02
                  ldy #$00                          ; $0002
                  jmp Show_Bonus_skip4

Show_Bonus_skip1  lda #$1E                          ;"3"
                  ldx #$05
                  ldy #$00                          ; $0005
                  jmp Show_Bonus_skip4

Show_Bonus_skip2  lda #$1D                          ;"2"
                  ldx #$02
                  ldy #$20                          ; $2002
                  jmp Show_Bonus_skip4

Show_Bonus_skip3  lda #$1C                          ;"1"
                  ldx #$02
                  ldy #$10                          ; $1002

Show_Bonus_skip4  sta LO_YOU_HAVE_GOTTEN            ; liczba zebranych BOMB 2x (modsza cyfra) - $1C,$1D,$1E lub $1B  (po dodaniu $D0 mamy 1,2,3 lub 0)
                  stx Add_BYTE_to_SCORE_PLAYER+$00
                  sty Add_BYTE_to_SCORE_PLAYER+$01
                  jsr Print_&_Add_Points            ; procedura wypisuje na ekranie (ScreenText40x25) i dodaje punkty do SCORE PLAYER
                  ldx #$00

Show_Bonus_loop1  lda text_YOU_HAVE_GOTTEN,x        ; "YOU HAVE GOTTEN A xx FIREBOMBS BONUS OF"
                  cmp #$FF
                  beq Show_Bonus_skip5

                  adc #$D0                          ; +$D0 bo od $D1 mamy A,B,C.....itd (UWAGA! tylko dla zestawu znakw dla TITLE i HI SCORE)
                  sta ScreenText40x25+$0191,x
                  mva #$0F ColorRAM40x25+$0191,x
                  lda #$09
                  sta ColorRAM40x25+$01ED,x
                  sta ColorRAM40x25+$01C6,x
                  inx
                  jmp Show_Bonus_loop1`

Show_Bonus_skip5  jsr Print_Score_Player_On_Screen  ; wypisz punkty gracza na ekranie
                  ldx #$14

Show_Bonus_loop2  lda text_GIVING_YOU,x             ; "GIVING YOU A SCORE OF"
                  add #$D0                          ; +$D0 bo od $D1 mamy A,B,C.....itd (UWAGA! tylko dla zestawu znakw dla TITLE i HI SCORE)
                  sta ScreenText40x25+$0239,x
                  mva #$0D ColorRAM40x25+$0239,x
                  dex
                  bpl Show_Bonus_loop2

                  ldx #$05

Show_Bonus_loop3  lda text_POINTS,x                 ; "POINTS"
                  add #$D0                          ; +$D0 bo od $D1 mamy A,B,C.....itd (UWAGA! tylko dla zestawu znakw dla TITLE i HI SCORE)
                  sta ScreenText40x25+$01F4,x
                  sta ScreenText40x25+$02E4,x
                  lda #$0B
                  sta ColorRAM40x25+$01F4,x
                  sta ColorRAM40x25+$02E4,x
                  dex
                  bpl Show_Bonus_loop3

                  mwa #text_KEEP_UP_THE_GOOD Char_XScroll_mod+$01
                  mva #$FF                   pos_Scroll_Text
                  jsr Set_RCI
                  jsr 08FF                          ; ustawiamy jakie dane???
                  cli
                  jsr Wait_Time1                    ; czekaj pewien czas
                  jsr StartGame_Skip3
                  mva #$00 D418                     ; SidFltMode - gono=0 i filtry OFF

Show_Bonus_RTS    rts

; tekst "YOU HAVE GOTTEN A xx FIREBOMBS BONUS OF"
text_YOU_HAVE_GOTTEN
                  .byte $19,$0F,$15
22AD 56 08        lsr 08,x
22AF 01 16        ora (16,x)
22B1 05 56        ora 56
22B3 07 0F        slo 0F
22B5 14 14        nop 14,x
22B7 05 0E        ora 0E
22B9 56 01        lsr 01,x
22BB               .byte $56
HI_YOU_HAVE_GOTTEN .byte $00         ; modyfikacja tej wartoci! - odwrcona kolejno HI/LO bo to wywietlane jako tekst! (a nie jako warto word)
LO_YOU_HAVE_GOTTEN .byte $00         ; modyfikacja tej wartoci!
22BE 56 06        lsr 06,x
22C0 09 12        ora #12
22C2 05 02        ora 02
22C4 0F 0D 02     slo 020D
22C7 56 02        lsr 02,x
22C9 0F 0E 15     slo 150E
22CC 13 56        slo (56),y
22CE 0F 06 FF     .byte $0F,$06,$FF

; tekst "GIVING YOU A SCORE OF"
text_GIVING_YOU   .byte $07,$09
22D3 16 09        asl 09,x
22D5 0E 07 56     asl 5607
22D8 19 0F 15     ora 150F,y
22DB 56 01        lsr 01,x
22DD 56 13        lsr 13,x
22DF 03 0F        slo (0F,x)
22E1 12           kil
22E2 05 56        ora 56
22E4 0F 06 56     slo 5606                                                                                                                

; "POINTS"
text_POINTS       .byte $10,$0F
22E9 09 0E        ora #0E
22EB 14 13        nop 13,x

; "KEEP UP THE GOOD WORK JACK"
text_KEEP_UP_THE_GOOD
                  .byte $0B,$05
22EF 05 10        ora 10
22F1 56 15        lsr 15,x
22F3 10 56        bpl 234B  ;slow
22F5 14 08        nop 08,x
22F7 05 56        ora 56
22F9 07 0F        slo 0F
22FB 0F 04 56     slo 5604
22FE 17 0F        slo 0F,x
2300 12           kil
2301 0B 56        anc #56
2303 0A           asl a
2304 01 03        ora (03,x)
2306 0B 56        anc #56
2308 56 56        lsr 56,x
230A              .byte $FF

;########################################################################################################################################################
; gwna procedura obsugujca wszystkie ruchome obiekty na ekranie poza BOMB JACK-iem
;########################################################################################################################################################
Do_Move_SPRITES_1_7
                  ldy #$06                               ; wykonaj ptle dla siedmiu SPRITE'w ($06-$00)

Do_Move_loop1     sty Do_Number_SPRITE_1_7               ; zapametaj rej.Y - aktualny numer SPRITE'a #1-#7
                  lda tab_Type_SPRITES_1_7,y             ; pobierz typ SPRITE'a
                  bne Do_Move_skip1                      ; <>0 to ten SPRITE jest aktualnie uywany!

; jeeli procedura tutaj przechodzi to oznacza, e dany SPRITE jest nieuywany aktualnie i naley go schowa poza ekranem
Do_Move_loop2     lda tab_First_PosX_SPRITES_0_7,y       ; tablica zawiera pocztkow wsp.X dla SPRITE'w #1-#7 (wykorzystywana np: zaraz jak rozpoczyna si gra)
                  tax
                  tya
                  asl @                                  ; *2
                  tay
                  txa
                  sta      Sprite1_PosX,y                ; ustaw pozycje SPRITE #1-#7
                  mva #$00 Sprite1_PosY,y                ; ustaw wsp.Y=0 SPRITE #1-#7 (czyli poza widzialnym ekranem)
                  ldy Do_Number_SPRITE_1_7               ; odtwrz rej.Y - aktualny numer SPRITE'a #1-#7
                  jmp Do_Move_skip3

Do_Move_skip1     cmp #$01                               ; UWAGA! tak naprawd to wartoi $01-$0F oznaczaj prawdopodobnie typ SPRITE'a (dopiero wysze wartoci oznaczaj wsp.X)
                  bne Do_Move_skip2

                  tya                                    ; #$01
                  tax                                    ; rej.X = Do_Number_Sprite_1_7
                  jmp Do_Animation_Astronaut_Sprite

Do_Move_skip2     cmp #$02
                  jeq Do_Animation_Drill_Sprite

                  cmp #$03
                  jeq Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite  ; P - Power Ball - po zebraniu mona zebra przeciwnikw

                  cmp #$04
                  jeq Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite

                  cmp #$05
                  jeq Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite

                  cmp #$06
                  jeq Do_Animation_UFO_Sprite

                  cmp #$07
                  jeq Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite

                  cmp #$08
                  jeq Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite

                  cmp #$09
                  jeq Do_Animation_Letter_E_B_Sprite    ; E - Extra - 1 dodatkowe ycie

                  cmp #$0A
                  jeq Do_Animation_Letter_E_B_Sprite    ; B - Bonus - punkty na ekranie s zwikszone o 2 do 4 razy

                  cmp #$0B
                  jeq Do_Animation_Bird_Sprite

                  cmp #$0C
                  jeq Do_Animation_New_Opponent_Appear_Sprite

                  cmp #$0D                               ; 13 - ikonka ycia latajc po polu gry, ktr BOMB JACK moe zebra
                  jeq Do_Animation_Extra_Life_Sprite

                  cmp #$0F                               ; 15 - SPRITE w postaci punktw (100-600)
                  jeq Do_Animation_Score_Sprite

                  jmp Do_Move_loop2

Do_Move_skip3     ldy Do_Number_SPRITE_1_7               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  dey
                  jpl Do_Move_loop1

                  rts

Add_BYTE_to_SCORE_PLAYER .byte $00,$00,$00          ; punkty zapisywane tutaj na chwile a potem dodawane do wyniku gracza

;########################################################################################################################################################
; procedura obsugujca pojawiajce si punkty(SPRITE) na ekranie (1sek)
;########################################################################################################################################################
Do_Animation_Score_Sprite
                  ldy Do_Number_SPRITE_1_7                         ; pobierz jaki naley obsuy SPRITE #1-#7
                  mva #$00 D028,y                                  ; ustaw kolor czarny dla SPRITE'a #1-#7
                  sta      Sprite0_7_PosX_8bit                     ; ustaw bit.8=0 dla wsp.Y dla SPRITE'w #1-#7

                  lda D028,y                                       ; ustaw kolor biay(eor #$01 na czarnym) dla SPRITE'a #1-#7
                  eor #$01
                  sta D028,y
                  lda tab_Points_100_600_SPRITES_1_7,y             ; pobierz warto od $01 do $06 (odpowiada to zdefiniowanym SPRITE'om w ksztacie punktw 100-600)
                  adc #$BF                                         ; warto znacznika C=1! wic +$C0
                  sta tab_Addr_SPRITE_Pattern,y                    ; zapisz adres definicji SPRITE'a #1-#7 (wskanik*64+$4000)
                  lda tab_Delay_Points_100_600_SPRITES_1_7,y
                  cmp #$32                                         ; czy opnienie = 50?
                  beq Do_Score_skip1                               ; TAK!

                  add tab_Delay_Points_100_600_SPRITES_1_7,y #$01  ; licznik zliczajcy opnienie +1
                  jmp Do_Move_skip3                                ; powrt do gwnej ptli skd wywoano t procedure

Do_Score_skip1    mva #$00 tab_Delay_Points_100_600_SPRITES_1_7,y  ; zeruj licznik zliczajcy opnienie
                  sta      tab_Type_SPRITES_1_7,y                  ; =0 wyczy wsp.X(lub typ) SPRITE'a, ktry zderzy si z BOMB JACK-iem
                  jmp Do_Move_skip3                                ; powrt do gwnej ptli skd wywoano t procedure

tab_Delay_Points_100_600_SPRITES_1_7             .byte $00,$00,$00,$00,$00,$00,$00 ; tablica zliczajca od 0-50, po osigniciu 50 SPRITE z punktami znika z widocznego ekranu (wic punkty na planszy gry wida tylko przez 1s)
tab_Points_100_600_SPRITES_1_7                   .byte $00,$00,$00,$00,$00,$00,$00 ; zawiera aktualne adresy ((wskanik+$C0)*64+$4000) danych def. wzr SPRITE'a - punkty! (100-600) ($7040,$7080,$70C0....itd. - def.100, 200, 300....itd.)
Counter_Add_100_600_Points_for_Every_SmilingFace .byte $00                         ; licznik zwikszany o +1 po zebraniu kadej kolejnej "UMIECHNITEJ BUKI", dziki temu za kad kolejn zebran "BUK" dostajemy o 100 punktw wicej

;########################################################################################################################################################
; procedura obsuguje ikonk ycia latajc po polu gry, ktr BOMB JACK moe zebra
;########################################################################################################################################################
Do_Animation_Extra_Life_Sprite
                  ldy Do_Number_SPRITE_1_7
                  mva #$01 D028,y                    ; ustaw biay kolor dla SPRITE'a #1-#7
                  mva #$C7 tab_Addr_SPRITE_Pattern,y ; ustaw wzr SPRITE'a #1-#7 z ikonk BOMB JACK-a(symbolizujc ycie) - $71C0
                  tya
                  asl @                              ; numer aktualnego SPRITE'a * 2
                  tay

; sprawd wsp.Y
                  lda Sprite1_PosY,y                 ; odczytaj wsp.Y aktualnego SPRITE'a
                  cmp #$A9                           ; Czy wsp.Y SPRITE'a osigna dolny zielony margines planszy gry (169)?
                  jeq Do_Life_skip1                  ; TAK!

                  cmp #$AA                           ; Czy wsp.Y SPRITE'a osigna dolny zielony margines planszy gry (170)?
                  jeq Do_Life_skip1                  ; TAK!
                  bcc Do_Life_skip4                  ; NIE! i jest z lewej strony zielonego marginesu
                  bcs Do_Life_skip5                  ; NIE! i jest z prawej strony zielonego marginesu

; sprawd wsp.X
Do_Life_skip1     lda Sprite1_PosX,y                 ; Czy wsp.X SPRITE'a #1-#7 rwna jest $FF?
                  cmp #$FF                           ; =255 (wsp.X SPRITE'a moe przekroczy warto, ktr zabisuje si w bajcie i potrzebny dodatkowy bit)
                  jeq Do_Life_skip2                  ; TAK!

                  cmp #$FE                           ; Czy wsp.X SPRITE'a #1-#7 rwna jest $FE? (moe te by taka warto bo przesuwamy o 2 pixele naraz)
                  bne Do_Life_skip3                  ; NIE!

Do_Life_skip2     lda Sprite0_7_PosX_8bit            ; ustawienie bit.8=1 wsp.X dla SPRITE'a #7
                  ora #$80
                  sta Sprite0_7_PosX_8bit

Do_Life_skip3     lda Sprite1_PosX,y                 ; Czy wsp.X aktualnego SPRITE'a #1-#7 jest rwna 30? UWAGA! Badamy dla 30 i 31 bo SPRITE'y s przesuwane co 2 piksele
                  cmp #$1E                           ; Czy dotarlimy do lewego zielonego marginesu? (30)
                  beq Do_Life_skip6                  ; TAK!

                  cmp #$1F                           ; Czy wsp.X aktualnego SPRITE'a #1-#7 jest rwna 31?
                  beq Do_Life_skip6                  ; TAK!

                  add Sprite1_PosX,y #$02            ; wsp.X +2
                  jmp Do_Move_skip3

Do_Life_skip4     add Sprite1_PosY,y #$02            ; wsp.Y +2
                  jmp Do_Move_skip3

Do_Life_skip5     sbb Sprite1_PosY,y #$01            ; wsp.Y -1
                  jmp Do_Move_skip3

; dodaj dodatkowe ycie BOMB JACK-owi
Do_Life_skip6     mva #$00 tab_Type_SPRITES_1_7+6
                  sta      tab_Move_Left_or_Right_or_Down_LetterEB+6
                  sta      Sprite0_7_PosX_8bit       ; wyzeruj bit8 wsp.X dla SPRITE'w #0-#7
                  inc pos_tab_addr_live              ; wskazuje na pozycje w tablicy, gdzie jest adres, pod ktrym mona narysowa ycie BOMB JACK-a
                  jsr Draw_Live_Jack                 ; rysuj dodatkowe ycie dla BOMB JACK-a!
                  jmp Do_Move_skip3

tab_Every_Second_Frame_Atronaut_Sprite .byte $00,$00,$00,$00,$00,$00,$00  ; 0-rysuj "ASTRONAUTE", 1-nie rysuj "ASTRONAUTE" (dziki temu rysujemy co 2-g ramke)

;########################################################################################################################################################
; procedura odpowiada za animacje SPRITE'a "ASTRONAUTY"
;########################################################################################################################################################
Do_Animation_Astronaut_Sprite
                  ldy Do_Number_SPRITE_1_7                           ; pobierz numer aktualnego SPRITE'a #1-#7 (0-6)
                  lda Number_Round_BCD                               ; pobierz numer rundy w kodzie BCD???
                  cmp #$0B                                           ; Czy numer rundy>=11? (tak naprawd to sprawdzamy czy nr_rundy>=$09)
                  bcs Anim_Astro_skip2                               ; TAK! (od rundy 10 "ASTRONAUCI" poruszaj si 2x szybciej)

                  lda tab_Every_Second_Frame_Atronaut_Sprite,y       ; Czy to pierwsza ramka?
                  beq Anim_Astro_skip1                               ; TAK! wic rys. "ASTRONAUTE"

                  eor #$01                                           ; zamiana 1->0
                  sta tab_Every_Second_Frame_Atronaut_Sprite,y
                  jmp Do_Move_skip3                                  ; powrt do gwnej ptli animujcej SPRITE #1-#7

; obsuga ruchu "ASTRONAUTY"
Anim_Astro_skip1  eor #$01                                           ; zamiana 0->1
                  sta tab_Every_Second_Frame_Atronaut_Sprite,y

Anim_Astro_skip2  sty Store_Do_Number_SPRITE_1_7                     ; zapamitaj numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Sprite1_7_on_Screen,y                   ; Czy SPRITE ju narysowany na ekranie?
                  bne Anim_Astro_skip3                               ; TAK!

; jeszcze nienarysowany wic najpierw musi by animacja jego pojawienia si na ekranie
                  mva #$0C tab_Type_SPRITES_1_7,y                    ; wstaw "12" jako typ SPRITE'a - pojawienie si nowego przeciwnika
                  mva #$01 tab_Is_Sprite1_7_on_Screen,y
                  sta      tab_Show_Type_Sprite1_7_After_Animation_Appearing,y                ; typ "ASTRONAUTA" - zapamitaj
                  jsr Restore_Do_Number_SPRITE_1_7
                  jmp Do_Move_skip3                                  ; powrt do gwnej ptli animujcej SPRITE #1-#7
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; obsuga ruchu i badania z czym "ASTRONAUTA" zetkn si na planszy
; uwaga! s tutaj reguy, ktre powoduj, e "ASTRONAUTA" zachowuje si w pewien cile okrelony sposb
Anim_Astro_skip3  mva #$0F D028,y                                    ; ustaw jasnoszary kolor dla SPRITE'a #1-#7
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25  ; oblicz adres bajtu w ScreenBuff40x25 gdzie znajduje si aktualnie dany SPRITE
                                                                     ;      ...
                                                                     ;      ...
                                                                     ;      .X.
                  ldy #$00
                  lda (address1),y                                   ; pobierz bajt z obliczonej wyej pozycji - (address1)
                  tax
                  lda tab_Action_for_256Chars,x                      ; przeszukaj tablice, aby dla danego bajtu odczyta "kod akcji"
                  cmp #$01                                           ; Czy "kod akcji" = $01? czyli natrafiono na murek lub kadke? w rodkowym bajcie pod nogami "ASTRONAUTY"
                  jeq Anim_Astro_skip9                               ; TAK!

                  ldy Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; Czy "ASTRONAUTA" stoi w miejscu?
                  jeq Astronaut_Stand                               ; TAK!

                  cmp #$01                                           ; Czy przesuwa si w prawo?
                  bne Anim_Astro_skip6  ;slow                        ; NIE!

; teraz badamy co znajduje si pod nogami "ASTRONAUTY" z lewej strony (a przesuwa si on w prawo)
                                                                     ;                     ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna  ...
                  ldy #$00                                           ;                     X..
                  lda (address1),y                                   ; pobierz bajt z obliczonej wyej pozycji - (address1)
                  tax
                  lda tab_Action_for_256Chars,x                      ; przeszukaj tablice, aby dla danego bajtu odczyta "kod akcji"
                  cmp #$01                                           ; Czy "kod akcji" = $01? czyli natrafiono na murek lub kadke? z lewej strony pod nogami "ASTRONAUTY"
                  beq Anim_Astro_skip5  ;slow                        ; TAK!

; natrafiono na jakie to planszy
Anim_Astro_skip4  jsr Astronaut_Reach_Left_or_Right_Edge_FootBridge
                  mva #$02 Opposite_Direction_Move_New_Apper_Astronaut_than_Old_Astronaut ; Nowy "ASTRONAUTA", ktry si pojawi ma przesuwa si w lewo
                  lda Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                              ; *2
                  tay
                  adb Sprite1_PosX,y #$08 Store_Sprite1_PosX         ; dodaj +8 do wsp.X - z prawej strony pojawi si nowy przeciwnik - "ASTRONAUTA"

; miejsce gdzie inicjujemy pojawienie si nowego przeciwnika - "ASTRONAUTY"
Anim_Astro_loop1  ldy Do_Number_SPRITE_1_7                           ; numer SPRITE'a
                  mva #$00 tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,y
                  sta      tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y
                  jsr Show_New_Astronaut
                  lda  Is_New_Astronaut_Appear                       ; Czy nowy przeciwnik "ASTRONAUTA" si pojawi? (bo np: jak ju jest max. liczba przeciwnikw na ekranie to nie pokae si)
                  jne Anim_Astro_skip9                               ; TAK!

; NIE pojawi si nowy przeciwnik "ASTRONAUTA"
                  jsr Restore_Do_Number_SPRITE_1_7
                  jmp Do_Move_skip3                                  ; powrt do gwnej ptli obs. SPRITE'w #1-#7

; natrafiono na murek lub kadk z lewej strony pod nogami "ASTRONAUTY"
Anim_Astro_skip5  jsr Astronaut_Reach_Left_or_Right_Edge_FootBridge  ; "ASTRONAUTA" osign PRAWY brzeg "kadki" (bo z lewej jest "kadka" a porodku nie ma kadki)

                  lda tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,y
                  cmp #$04                                           ; Czy 4-ry razy lub wicej "ASTRONAUTA" osign lew lub praw krawd "kadki"? (czyli w sumie 2x przeszed z lewej do prawej strony "kadki")
                  jcs Anim_Astro_skip7                               ; TAK!

                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$02 tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; =2 "ASTRONAUTA" przesuwa si w lewo
                  jmp Anim_Astro_skip9

; teraz badamy co znajduje si pod nogami "ASTRONAUTY" z prawej strony (a przesuwa si on w lewo)
                                                                     ;                  ...
Anim_Astro_skip6  jsr address1_ADW_1byte                             ; nastpna kolumna ...
                  ldy #$00                                           ;                  ..X
                  lda (address1),y                                   ; pobierz bajt z obliczonej wyej pozycji - (address1)
                  tax
                  lda tab_Action_for_256Chars,x                      ; przeszukaj tablice aby dla danego bajtu odczyta "kod akcji"
                  cmp #$01                                           ; Czy "kod akcji" = $01? czyli natrafiono na murek lub kadke? z prawej strony pod nogami "ASTRONAUTY"
                  beq Anim_Astro_skip8                               ; TAK!

Anim_Astro_skip7  jsr Astronaut_Reach_Left_or_Right_Edge_FootBridge
                  mva #$01 Opposite_Direction_Move_New_Apper_Astronaut_than_Old_Astronaut ; Nowy "ASTRONAUTA", ktry si pojawi ma przesuwa si w prawo
                  lda Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  sbb Sprite1_PosX,y #$08 Store_Sprite1_PosX         ; odejmij -8 do wsp.X - w tym miejscu pojawi si nowy przeciwnik!
                  jmp Anim_Astro_loop1                               ; skocz do miejsca gdzie inicjujemy pojawienie si nowego przeciwnika "ASTRONAUTY"

; natrafiono na murek lub kadk
Anim_Astro_skip8  jsr Astronaut_Reach_Left_or_Right_Edge_FootBridge  ; "ASTRONAUTA" osign LEWY brzeg "kadki" (bo z lewej jest "kadka" a porodku nie ma kadki)
                  lda tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,y
                  cmp #$04                                           ; Czy 4-ry razy lub wicej "ASTRONAUTA" osign lew lub praw krawd "kadki"? (czyli w sumie 2x przeszed z lewej do prawej strony "kadki")
                  jcs Anim_Astro_skip4                               ; TAK!

                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$01 tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; =1 "ASTRONAUTA" przesuwa si w prawo
                  jmp Anim_Astro_skip9
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; "ASTRONAUTA" natrafi na murek lub kadk i tutaj obsugujemy to zdarzenie
Anim_Astro_skip9  ldx index_tab_Addr_SPRITE_ScreenBuff40x25              ; pobierz, w ktrym wierszu jest aktualnie obrabiany SPRITE #1-#7 - wskanik na tablice z adresami+wsp.Y, po 3-bajty dla kadego wiersza
                  lda tab_Addr_SPRITE_ScreenBuff40x25+2,x                ; pobierz wsp.Y dla wiersza o numerze zapisanym w rej.X
                  tax
                  :2 inx                                                 ; +2
                  lda Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                                  ; *2
                  tay
                  txa
                  sta Sprite1_PosY,y                                     ; zapisz do wsp.Y SPRITE'a (powikszon o +2)
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$00 tab_Anim_Speed_Jump_Down,y                    ; inicjacja wartoci jak bdziemy dodawa do wsp.Y "ASTRONAUTY"...
                  mva #$07 tab_7x_Add_Speed_Jump_Down_to_PosY,y          ; ...i inicjacja licznika ile razy dodamy t warto
                  lda tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y     ; Czy "ASTRONAUTA" wykonuje ruch w lewo lub prawo?
                  bne Anim_Astro_skipA                                   ; TAK!

; aktualnie "ASTRONAUTA" si nie rusza tylko stoi w miejscu
                  tya
                  asl @
                  tay
                  lda Sprite1_PosY,y                                     ; pobierz wsp.Y SPRITE'a
                  cmp #$DA                                               ; >=218 (czyli spr. czy "ASTRONAUTA" dotar ju do samego dou planszy?)
                  jcs Astronaut_Transform_More_Dangerous_Opponent        ; przeksztacenie "ASTRONAUTY" w groniejszego przeciwnika!

; "ASTRONAUTA" nie dotar jeszcze do samego dou planszy
                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$01 tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; =1 "ASTRONAUTA" przemieszcza si w prawo
                  jsr Restore_Do_Number_SPRITE_1_7
                  jmp Do_Move_skip3                                       ; powrt do ptli gwnej

; aktualnie "ASTRONAUTA" przesuwa si albo w lewo albo w prawo
Anim_Astro_skipA  cmp #$01                                               ; Czy "ASTRONAUTA" przesuwa si w prawo?
                  jne Anim_Astro_skipF                                   ; TAK!

; aktualnie "ASTRONAUTA" przesuwa si w prawo
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25      ; oblicz w address1, nad ktrym bajtem w ScreenBuff40x25 znajduje si SPRITE #1-#7
                  jsr address1_SBW_40bytes                               ; wczeniejszy wiersz         ..X
                  jsr address1_SBW_40bytes                               ; wczeniejszy wiersz         ...
                  jsr address1_ADW_1byte                                 ; nastpna kolumna            ...
                  ldy #$00
                  lda (address1),y                                       ; pobierz bajt z obliczonej wyej pozycji - (address1)
                  tay
                  lda tab_Action_for_256Chars,y                          ; przeszukaj tablice aby dla danego bajtu odczyta "kod akcji"
                  cmp #$01                                               ; Czy "kod akcji" = $01? czyli natrafiono na murek lub kadke
                  bne Anim_Astro_skipB                                   ; NIE!

; natrafiono na murek lub kadk wic nie mona wykona ruchu "ASTRONAUTY"
                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$02 tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; =2 "ASTRONAUTA" przesuwa si w lewo
                  jsr Restore_Do_Number_SPRITE_1_7                        ; odtworzenie zapamitanej wczeniej zmiennej "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                       ; powrt do ptli gwnej

; natrafiono na jakie to planszy wic mona wykona ruch "ASTRONAUTY" w prawo
Anim_Astro_skipB  lda Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  adb Sprite1_PosX,y #$01                                ; dodaj do wsp.X obrabianego SPRITE'a #1-#7 +1 - na przerwaniu VBL zostanie narysowany na nowej pozycji X
                  jsr Astronaut_Change_PosX                              ; ust. znacznik, e zmienia si wsp.X "ASTRONAUTY"
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Fourth_Frame_Astronaut_Sprite,y
                  cmp #$04                                               ; Czy ju 4-ta ramka od ost. narysowania "ASTRONAUTY"?
                  beq Anim_Astro_skipC                                   ; TAK!

                  adb tab_Every_Fourth_Frame_Astronaut_Sprite,y #$01     ; +1 do licznika zliczajcego ramki do 4-rech
                  jsr Restore_Do_Number_SPRITE_1_7                       ; odtworzenie zmiennej "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                      ; powrt do ptli gownej

; to jest 4-ta ramka wic naley narysowa "ASTRONAUTE" (wypeni jego wzr now definicj)
Anim_Astro_skipC  mva #$00 tab_Every_Fourth_Frame_Astronaut_Sprite,y

Anim_Astro_loop2  lda index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y  ; pobierz wskanik na kolejn klatk
                  tax
                  lda tab_4th_clips_Move_Opponent_Astronaut_Right,x      ; pobierz kolejn z 4-rech klatek animujcych ruch "ASTRONAUTY" w prawo
                  beq Anim_Astro_skipE                                   ; =0 oznacza, e wywietlono ju wszystkie klatki z tej tablicy

                  sta tab_Addr_SPRITE_Pattern,y                          ; zapisz wskanik(*64+$4000), ktry suy do obl. adresu z danymi wzoru SPRITE'a #1-#7

                  adb index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y #$01 ; +1 aktualizuj wskanik wskazujcy na kolejn klatk z tablicy
                  jsr Restore_Do_Number_SPRITE_1_7                       ; odtwrz zapamitan zmienn "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                      ; powrt do ptli gwnej

Anim_Astro_skipE  mva #$00 index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y  ; ustaw wskanik na pocztek tablicy z klatkami animacyjnymi dla "ASTRONAUTY"
                  jmp Anim_Astro_loop2
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; aktualnie "ASTRONAUTA" przesuwa si w lewo
Anim_Astro_skipF  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25      ; oblicz w address1, nad ktrym bajtem w ScreenBuff40x25 znajduje si SPRITE #1-#7
                  jsr address1_SBW_40bytes                               ; wczeniejszy wiersz  X..
                  jsr address1_SBW_40bytes                               ; wczeniejszy wiersz  ...
                  jsr address1_SBW_1byte                                 ; poprzednia kolumna   ...
                  ldy #$00
                  lda (address1),y                                       ; pobierz bajt z obliczonej wyej pozycji - (address1)
                  tay
                  lda tab_Action_for_256Chars,y                          ; przeszukaj tablice aby dla danego bajtu odczyta "kod akcji"
                  cmp #$01
                  bne Anim_Astro_skipG

                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$01 tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y ; =1 "ASTRONAUTA" przesuwa si w prawo
                  jsr Restore_Do_Number_SPRITE_1_7                        ; odtworzenie zapamitanej wczeniej zmiennej "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                       ; powrt do ptli gwnej                                           

; natrafiono na jakie to planszy wic mona przesun "ASTRONAUTE" w lewo
Anim_Astro_skipG  lda Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  sbb Sprite1_PosX,y #$01                                ; odejmij od wsp.X obrabianego SPRITE'a #1-#7 -1
                  jsr Astronaut_Change_PosX                              ; ust. znacznik, e zmienia si wsp.X "ASTRONAUTY"
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Fourth_Frame_Astronaut_Sprite,y
                  cmp #$04
                  beq Anim_Astro_skipH

                  adb tab_Every_Fourth_Frame_Astronaut_Sprite,y #$01     ; +1 do licznika zliczajcego ramki do 4-rech
                  jsr Restore_Do_Number_SPRITE_1_7                       ; odtworzenie zmiennej "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                      ; powrt do ptli gownej

Anim_Astro_skipH  mva #$00 tab_Every_Fourth_Frame_Astronaut_Sprite,y

Anim_Astro_skipI  lda index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y ; pobierz wskanik na kolejn klatk
                  tax
                  lda tab_4th_clips_Move_Opponent_Astronaut_Left,x       ; pobierz kolejn klatk animacyjn ruchu przeciwnika "ASTRONAUTY" w lewo
                  beq Anim_Astro_skipJ                                               ; =0 - oznacza, e ju wywietlono wszystkie 4-ry klatki

                  sta tab_Addr_SPRITE_Pattern,y                          ; zapisz wskanik(*64+$4000), ktry suy do obl. adresu z danymi wzoru SPRITE'a #1-#7
                  adb index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y #$01 ; +1 aktualizuj wskanik na kolejn klatk "ASTRONAUTY" w lewo
                  jsr Restore_Do_Number_SPRITE_1_7                       ; odtwrz zapamitan wczeniej zmienn "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                      ; powrt do gwnej ptli

Anim_Astro_skipJ  mva #$00 index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right,y ; wic zapisz, e klatki ruchu "ASTRONAUTY" w lewo maj by pobierane od pocztku
                  jmp Anim_Astro_skipI
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; "ASTRONAUTA" aktualnie stoi w miejscu
Astronaut_Stand   ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$91 tab_Addr_SPRITE_Pattern,y                     ; zapisz wskanik(*64+$4000), ktry suy do obl. adresu z danymi wzoru SPRITE'a #1-#7 - $91 - to klatka przeciwnika "ASTRONAUTY", ktry patrzy prosto na nas
                  jsr Anim_Astronaut_Jump_Down                           ; Animuj "ASTRONAUTE" spadajcego w d
                  jsr Restore_Do_Number_SPRITE_1_7                       ; odtwrz zmienn "Do_Number_SPRITE_1_7"
                  jmp Do_Move_skip3                                      ; powrt do gwnej ptli
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; "ASTRONAUTA" dotar do samego dou i teraz przemienia si w groniejszego przeciwnika!
Astronaut_Transform_More_Dangerous_Opponent
                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$0C tab_Type_SPRITES_1_7,y                         ; wstaw "12" jako typ SPRITE'a - pojawienie si nowego przeciwnika
                  ldy index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform
                  lda tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform,y
                  ldy Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  sta tab_Show_Type_Sprite1_7_After_Animation_Appearing,y ; jaki typ SPRITE'a ma si pojawi zaraz po animacji, e za chwil co si pojawi
                  jsr Restore_Do_Number_SPRITE_1_7                        ; odtwrz zmienn "Do_Number_SPRITE_1_7"
                  inc index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform
                  jmp Do_Move_skip3                                       ; powrt do ptli gwnej
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura dodaje +1 do tablicy jeeli "ASTRONAUTA" osign lewy lub prawy brzeg "kadki" (te po ktrych moe skaka BOMB JACK)
Astronaut_Reach_Left_or_Right_Edge_FootBridge
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  adb tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,y #$01
                  rts

index_tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform         .byte $00                         ; licznik wskazujcy na coraz groniejszego przeciwnika, w ktrego przeksztaca si kady kolejny "ASTRONAUTA"
tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7 .byte $00,$00,$00,$00,$00,$00,$00 ; +1 za kadym razem kiedy "ASTRONAUTA" dojdzie do lewego lub prawego brzegu "kadki" (te po ktrych moe skaka BOMB JACK)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia znacznik w tablicy jeeli "ASTRONAUTA" zmieni swoj wsp. X o +1 lub -1
Astronaut_Change_PosX
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$01 tab_Is_Astronaut_Change_PosX,y
                  rts

tab_Is_Astronaut_Change_PosX .byte $00,$00,$00,$00,$00,$00,$00           ; =1 "ASTRONAUTA" zmieni swoj wsp.X, =0 nie zmieni
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura sprawdza czy moe si pojawi nowy przeciwnik "ASTRONAUTA" na ekranie? (jeeli TAK to dodaje go)
Show_New_Astronaut
                  ldy Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Astronaut_Change_PosX,y                     ; =0? Czy "ASTRONAUTA" nie wykona adnego ruchu zmieniajcego wsp. X?(-1 lub +1)
                  jeq Anim_Astro_skipP                                   ; TAK!

; "ASTRONAUTA" wykona ruchu zmieniajcy wsp.X (+1 lub -1)
                  lda Do_Number_SPRITE_1_7                               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                                  ; *2
                  tay
                  mva Sprite1_PosY,y Store_Sprite1_PosY                  ; zapamitaj wsp.Y SPRITE'a #1-#7

                  ldy #$07                                               ; SPRITES #1-#7 (UWAGA! powinna by wart. #$06 bo pod $07 jest ju wsp. Sprite1_X)

Anim_Astro_loop3  lda tab_Type_SPRITES_1_7,y                             ; UWAGA! tutaj tak naprawd pobieramy Sprite1_PosX (bo rej. Y=7!!!, a ta tablica ma tylko elementy od 0 do 6)
                  cmp #$0E                                               ; Czy typ = 14? Czyli wolne miejsce, w ktrym moe si pojawi kolejny przeciwnik na planszy
                  beq Anim_Astro_skipQ                                   ; TAK!

                  dey                                                    ; rey.Y -1
                  bpl Anim_Astro_loop3

; <>$0E - brak wolnych miejsc na pojawienie si nowego przeciwnika na ekranie!
Anim_Astro_skipP  mva #$00 Is_New_Astronaut_Appear
                  rts

; pojawianie si nowego przeciwnika "ASTRONAUTY" na ekranie
Anim_Astro_skipQ  mva #$00 tab_Add_One_if_Astronaut_Reach_Left_or_Right_Edge_FootBridge_Sprites1_7,y
                  mva #$01 Is_New_Astronaut_Appear
                  sty Do_Number_SPRITE_1_7                               ; zapisz numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  sta tab_Type_SPRITES_1_7,y                             ; wstaw "1" jako typ SPRITE'a - "ASTRONAUTA"
                  mva Opposite_Direction_Move_New_Apper_Astronaut_than_Old_Astronaut tab_Is_Astronaut_Move_Left_or_Right_or_Stand,y
                  tya
                  asl @                                                  ; *2
                  tay
                  mva Store_Sprite1_PosX Sprite1_PosX,y                  ; odtwrz zapamitan wsp.X SPRITE'a #1-#7
                  mva Store_Sprite1_PosY Sprite1_PosY,y                  ; odtwrz zapamitan wsp.Y SPRITE'a #1-#7

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura odtwarza zapamitan wczeniej zmienn Do_Number_SPRITE_1_7
Restore_Do_Number_SPRITE_1_7
                  mva Store_Do_Number_SPRITE_1_7 Do_Number_SPRITE_1_7    ; odtwrz zapamitany wczeniej numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  rts

Store_Sprite1_PosX                      .byte $00                           ; zapamitatuje wsp.X powikszon o +8, pniej wykorzystywana jest do odtworzenia wsp.X powikszonej o +8
tab_Every_Second_Frame_Drill_UFO_Sprite .byte $00,$00,$00,$00,$00,$00,$00   ; 0-rysuj "WIDERKA" lub "UFO", 1-nie rysuj "WIDERKA" lub "UFO" (dziki temu rysujemy co 2-g ramke)

;########################################################################################################################################################
; procka obsugujca zachowanie przeciwnikw "WIDERKA", "KULI Z KROPKAMI", "KULI Z KWADRATOWYMI OKNAMI", "UFO"
;########################################################################################################################################################
Service_Behavior_Drill_DotBall_SquareBall_UFO
                  ldx Do_Number_SPRITE_1_7                                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Type_SPRITES_1_7,x
                  cmp #$02                                                ; Czy "WIDEREK"?
                  beq Beh_Drill_skip1                                     ; TAK!

                  cmp #$06                                                ; Czy "UFO"?
                  bne Beh_Drill_skip3                                     ; NIE!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; obsuga zachowania "WIDERKA" i "UFO"
Beh_Drill_skip1   lda Number_Round_BCD                                    ; Czy numer "RUNDY">=11?
                  cmp #$11
                  bcs Beh_Drill_skip3                                     ; TAK! wic animacja "WIDERKA" i "UFO" co 1 ramk (czyli 2x szybciej ni normalnie)

; numer "RUNDY"<11
                  lda tab_Every_Second_Frame_Drill_UFO_Sprite,x           ; dziki temu warunkowi rysujemy co 2-ga ramk
                  beq Beh_Drill_skip2

                  eor #$01
                  sta tab_Every_Second_Frame_Drill_UFO_Sprite,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skip2   eor #$01
                  sta tab_Every_Second_Frame_Drill_UFO_Sprite,y
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; obsuga zachowania "WIDERKA", "UFO", "KULI Z KROPKAMI" i "KULI Z KWADRATOWYMI OKNAMI"
Beh_Drill_skip3   lda tab_Move_Left_or_Right_Sprite_1_7,x                 ; czy aktualnie SPRITE przesuwa si w prawo?
                  jne Beh_Drill_skipB                                     ; TAK!

; SPRITE aktualnie przesuwa si w lewo - testuj sposobem #1 (s dwa sposoby bo dziki temu jak SPRITE napotka przeszkod z lewej strony to j omija)
                  lda Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x
                  cmp #$08                                                ; czy testowa co jest z lewej strony SPRITE'a?
                  jeq Beh_Drill_skip7                                     ; TAK!

                  lda Is_Sprite1_7_Block_During_Move_Left,x               ; czy podczas ruchu w lewo SPRITE zosta przyblokowany przez "kadk" lub "murek"?
                  beq Beh_Drill_skip4                                     ; NIE!

                  dec Is_Sprite1_7_Block_During_Move_Left,x               ; TAK! wic wykonaj ruch w gr lub w d, eby omin blokad
                  jmp Beh_Move_Up_or_Down                                 ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d

; sprawd jaki bajt znajduje si przy SPRITE'cie z prawej strony i jeeli to jest jakie to to dodaj do wsp.X SPRITE'a +2
Beh_Drill_skip4   inc Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x
                  mva Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x Is_Sprite1_7_Block_During_Move_Left,x

                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldx Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy     ...X
                  jsr address1_ADW_1byte                             ; nastpna kolumna                                    ...
                  jsr address1_ADW_1byte                             ; nastpna kolumna                                    ...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code         ; pobierz "kod akcji"
                  cmp #$01                                           ; Czy kod akcji to kod "murka" lub "kadki"?
                  bne Beh_Drill_skip6                                ; NIE!

; TAK! natrafiono na "murek" lub "kadk"
Beh_Drill_skip5   mva #$08 Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x ; dziki temu wyk. proc. spr. co jest z lewej strony
                  jmp Beh_Move_Up_or_Down                                          ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d

; NIE! natrafiono na jakie to planszy
Beh_Drill_skip6   ldy #$28                                           ; 40 - wiersz niej                                   ...
                  jsr Get_Byte_address1_and_Find_Action_Code         ;                                                     ...X
                  cmp #$01                                           ; czy "murek" lub "kadka"?                           ...
                  jeq Beh_Drill_skip5                                ; TAK!

; NIE! natrafiono na jakie to planszy - cofamy SPRITE'a w prawo o +2 - dziki temu omija on przeszkod ("murek" lub "kadka")
                  jsr CoordinateX_add_One_Sprite1_7                  ; +1 wsp.X SPRITE'a
                  jsr CoordinateX_add_One_Sprite1_7                  ; +1 wsp.X SPRITE'a
                  mva #$08 Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x                                    ; dziki temu wyk. proc. spr. co jest z lewej strony
                  jmp Beh_Move_Up_or_Down                            ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; SPRITE aktualnie przesuwa si w lewo - testuj sposobem #2 (s dwa sposoby bo dziki temu jak SPRITE napotka przeszkod z lewej strony to j omija)
Beh_Drill_skip7   lda Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  beq Beh_Drill_skip8a

                  lda Is_2x_Block_Right_Side_Sprite1_7,x
                  beq Beh_Drill_skip8

                  dec Is_2x_Block_Right_Side_Sprite1_7,x
                  jmp Beh_Move_Up_or_Down                            ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d

Beh_Drill_skip8   dec Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  mva Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x Is_2x_Block_Right_Side_Sprite1_7,x

; sprawd jaki bajt znajduje si przy SPRITE'cie z lewej strony
Beh_Drill_skip8a  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz                                      X...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz                                       ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna                                        ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna
                  ldx Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01                                           ; czy "murek" lub "kadka"?
                  bne Beh_Drill_skipA                                ; NIE!

; TAK! natrafiono na "murek" lub "kadk"
Beh_Drill_skip9   mva #$00 Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x    ; dziki temu zostanie wyk. proc. spr. co jest z prawej strony
                  jmp Beh_Move_Up_or_Down                            ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d

; NIE! nie natrafiono na "murek" lub "kadk"
Beh_Drill_skipA   ldy #$28                                           ; 40 -wiersz niej                                          ...
                  jsr Get_Byte_address1_and_Find_Action_Code         ;                                                          X...
                  cmp #$01                                           ; czy "murek" lub "kadka"?                                 ...
                  jeq Beh_Drill_skip9                                ; TAK!

; przesunicie SPRITE'a w lewo o -1
                  jsr CoordinateX_sub_One_Sprite1_7                  ; odejmij od wsp.X SPRITE'a -1
                  jmp Beh_Move_Up_or_Down                            ; skocz do czci sprawdzajcej dla ruchu SPRITE'a w gr lub w d
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; SPRITE aktualnie przesuwa si w prawo
Beh_Drill_skipB   lda Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  cmp #$08
                  jeq Beh_Drill_skipE

                  lda Is_Sprite1_7_Block_During_Move_Right,x
                  beq Beh_Drill_skipC

                  dec Is_Sprite1_7_Block_During_Move_Right,x
                  jmp Beh_Move_Up_or_Down

; SPRITE aktualnie przesuwa si w prawo - testuj sposobem #1 (s dwa sposoby bo dziki temu jak SPRITE napotka przeszkod z prawej strony to j omija)
Beh_Drill_skipC   inc Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  mva Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x Is_Sprite1_7_Block_During_Move_Right,x

                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldx Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy   X...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna                                 ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna                                 ...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01                                           ; Czy kod akcji to kod "murka" lub "kadki"?
                  bne Beh_Drill_skipD                                ; NIE!

; TAK! natrafiono na "murek" lub "kadk"
Beh_Drill_skipCa  mva #$08 Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  jmp Beh_Move_Up_or_Down

; NIE! nie natrafiono na "murek" lub "kadk"
Beh_Drill_skipD   ldy #$28                                           ; 40 - wiersz niej                                 ...
                  jsr Get_Byte_address1_and_Find_Action_Code         ;                                                  X...
                  cmp #$01                                           ; Czy kod akcji to kod "murka" lub "kadki"?        ...
                  jeq Beh_Drill_skipCa                               ; TAK!

                  jsr CoordinateX_sub_One_Sprite1_7                  ; -1 wsp.X SPRITE'a
                  jsr CoordinateX_sub_One_Sprite1_7                  ; -1 wsp.X SPRITE'a
                  mva #$08 Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x
                  jmp Beh_Move_Up_or_Down
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; SPRITE aktualnie przesuwa si w prawo - testuj sposobem #2 (s dwa sposoby bo dziki temu jak SPRITE napotka przeszkod z prawej strony to j omija)
Beh_Drill_skipE   lda Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x
                  jeq Beh_Drill_skipFa

                  lda Is_2x_Block_Left_Side_Sprite1_7,x
                  beq Beh_Drill_skipF

                  dec Is_2x_Block_Left_Side_Sprite1_7,x
                  jmp Beh_Move_Up_or_Down

Beh_Drill_skipF   dec Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x
                  mva Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7,x Is_2x_Block_Left_Side_Sprite1_7,x

Beh_Drill_skipFa  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldx Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  jsr address1_ADW_1byte                              ; nastpna kolumna                                   ...X
                  jsr address1_ADW_1byte                              ; nastpna kolumna                                   ...
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz                                ...
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01
                  bne Beh_Drill_skipH

Beh_Drill_skipG   mva #$00 Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7,x
                  jmp Beh_Move_Up_or_Down

Beh_Drill_skipH   ldy #$28                                            ; 40 - wiersz niej                                  ...
                  jsr Get_Byte_address1_and_Find_Action_Code          ;                                                    ...X
                  cmp #$01                                            ;                                                    ...
                  jeq Beh_Drill_skipG                                 ;

                  jsr CoordinateX_add_One_Sprite1_7                   ; dodaj do wsp.X SPRITE'a +1
                  jmp Beh_Move_Up_or_Down
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; badanie dla ruchu SPRITE'a do gry lub na d
Beh_Move_Up_or_Down
                  lda tab_Move_Up_or_Down_Sprite_1_7,x
                  jne Beh_Drill_skipO

; aktualnie SPRITE przesuwa si do gry
                  lda Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  cmp #$08
                  jeq Beh_Drill_skipL

                  lda Is_Sprite1_7_Block_During_Move_Up,x
                  beq Beh_Drill_skipJ

                  dec Is_Sprite1_7_Block_During_Move_Up,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipJ   inc Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  mva Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x Is_Sprite1_7_Block_During_Move_Up,x
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25    ;                                                       ...
                  jsr address1_SBW_1byte                               ; poprzednia kolumna                                    ...
                  ldx Do_Number_SPRITE_1_7                             ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy       X..
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01
                  bne Beh_Drill_skipK

Beh_Drill_skipJa  mva #$08 Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipK   ldy #$02                                             ;                                                       ...
                  jsr Get_Byte_address1_and_Find_Action_Code           ;                                                       ...
                  cmp #$01                                             ;                                                       ..X
                  jeq Beh_Drill_skipJa

                  jsr CoordinateY_add_One_Sprite1_7                    ; dodaj do wsp.Y SPRITE'a +1
                  jsr CoordinateY_add_One_Sprite1_7                    ; dodaj od wsp.Y SPRITE'a +1
                  mva #$08 Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Beh_Drill_skipL   lda Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  beq Beh_Drill_skipMa

                  lda Is_2x_Block_Down_Side_Sprite1_7,x
                  beq Beh_Drill_skipM

                  dec Is_2x_Block_Down_Side_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipM   dec Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  mva Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x Is_2x_Block_Down_Side_Sprite1_7,x

Beh_Drill_skipMa  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25  ;                                                       X
                  ldx Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy       ...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz                                   ...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz                                   ...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz
                  jsr address1_SBW_1byte                             ; poprzednia kolumna
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01
                  bne Beh_Drill_skipN

Beh_Drill_skipMa  mva #$00 Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
                                                                     ;                                                         X
Beh_Drill_skipN   ldy #$02                                           ;                                                       ...
                  jsr Get_Byte_address1_and_Find_Action_Code         ;                                                       ...
                  cmp #$01                                           ;                                                       ...
                  jeq Beh_Drill_skipMa

                  jsr CoordinateY_sub_One_Sprite1_7                  ; odejmij od wsp.Y SPRITE'a -1
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; aktualnie SPRITE przesuwa si w d
Beh_Drill_skipO   lda Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  cmp #$08
                  jeq Beh_Drill_skipR

                  lda Is_Sprite1_7_Block_During_Move_Down,x
                  beq Beh_Drill_skipP

                  dec Is_Sprite1_7_Block_During_Move_Down,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipP   inc Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  mva Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x Is_Sprite1_7_Block_During_Move_Down,x
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25   ;                                                     X
                  ldx Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy     ...
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz                                 ...
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz                                 ...
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz
                  jsr address1_SBW_1byte                              ; poprzednia kolumna
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code
                  cmp #$01
                  bne Beh_Drill_skipQ

Beh_Drill_skipPa  mva #$08 Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
                                                                      ;                                                       X
Beh_Drill_skipQ   ldy #$02                                            ;                                                     ...
                  jsr Get_Byte_address1_and_Find_Action_Code          ;                                                     ...
                  cmp #$01                                            ;                                                     ...
                  jeq Beh_Drill_skipPa

                  jsr CoordinateY_sub_One_Sprite1_7                   ; odejmij od wsp.Y SPRITE'a -1
                  jsr CoordinateY_sub_One_Sprite1_7                   ; odejmij od wsp.Y SPRITE'a -1
                  mva #$08 Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Beh_Drill_skipR   lda Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  beq Beh_Drill_skipSa

                  lda Is_2x_Block_Up_Side_Sprite1_7,x
                  beq Beh_Drill_skipS

                  dec Is_2x_Block_Up_Side_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipS   dec Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x
                  mva Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7,x Is_2x_Block_Up_Side_Sprite1_7,x

Beh_Drill_skipSa  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25   ;                                                         ...
                  jsr address1_SBW_1byte                              ; poprzednia kolumna                                      ...
                  ldx Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy         X..
                  ldy #$00
                  jsr Get_Byte_address1_and_Find_Action_Code          ; pobierz "kod akcji"
                  cmp #$01                                            ; czy natrafiono na "murek" lub "kadk"?
                  bne Beh_Drill_skipW  ;slow                          ; NIE!

; pod nogami SPRITE'a z lewej lub z prawej strony natrafiono na "murek" lub "kadk"
Beh_Drill_skipT   mva #$00 Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7,x
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO

Beh_Drill_skipW   ldy #$02                                            ;                                                         ...
                  jsr Get_Byte_address1_and_Find_Action_Code          ; pobierz "kod akcji"                                     ...
                  cmp #$01                                            ; czy natrafiono na "murek" lub "kadk"?                 ..X
                  jeq Beh_Drill_skipT                                 ; TAK!

; pod nogami SPRITE'a zarwno z lewej jak i prawej strony nie ma "murka" lub "kadki"
                  jsr CoordinateY_add_One_Sprite1_7                         ; dodaj do wsp.Y SPRITE'a +1
                  jmp Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; pobranie bajtu z pozycji (address1) i odszukanie na jego podstawie "kodu akcji"
Get_Byte_address1_and_Find_Action_Code
                  lda (address1),y
                  tay
                  lda tab_Action_for_256Chars,y
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wyznacznie kierunku ruchu SPRITE'a
Determine_Move_Direction_Drill_DotBall_SquareBall_UFO
                  ldx Do_Number_SPRITE_1_7                    ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_100th_Move_Follow_BOMB_JACK,x ; czy licznik osign ju 0?
                  beq Beh_Drill_skipZ                         ; TAK!

                  dec tab_Every_100th_Move_Follow_BOMB_JACK,x ; -1 licznik
                  jmp Beh_Drill_skipA3                        ; skok do biernego ruchu SPRITE'a (bez zwaania na to gdzie aktualnie znajduje si BOMB JACK)

; prba zmiany ruchu SPRITE'a tak, eby mg dopa BOMB JACK-a
Beh_Drill_skipZ   lda Do_Number_SPRITE_1_7                  ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                     ; *2
                  tax
                  ldy Do_Number_SPRITE_1_7                  ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda Sprite0_PosX
                  cmp Sprite1_PosX,x                        ; czy wsp.X BOMB JACKA < wsp.X PRZECIWNIKA?
                  bcc Beh_Drill_skipA1                      ; TAK!

                  mva #$01 tab_Move_Left_or_Right_Sprite_1_7,y ; NIE! wic PRZECIWNIK ma si przesuwa w prawo! (eby zbliy si do BOMB JACK-a)
                  jmp Beh_Drill_skipA1a

Beh_Drill_skipA1  mva #$00 tab_Move_Left_or_Right_Sprite_1_7,y ; TAK! wic PRZECIWNIK ma si przesuwa w lewo! (eby zbliy si do BOMB JACK-a)

Beh_Drill_skipA1a lda Sprite0_PosY
                  cmp Sprite1_PosY,x                        ; czy wsp.Y BOMB JACKA < wsp.Y PRZECIWNIKA?
                  bcc Beh_Drill_skipA2                      ; TAK!

                  mva #$01 tab_Move_Up_or_Down_Sprite_1_7,y ; NIE! wic PRZECIWNIK ma si przesuwa w d (eby zbliy si do BOMB JACK-a)
                  jmp Beh_Drill_skipA2a

Beh_Drill_skipA2  mva #$00 tab_Move_Up_or_Down_Sprite_1_7,y ; TAK! wic PRZECIWNIK ma si przesuwa do gry (eby zbliy si do BOMB JACK-a)

Beh_Drill_skipA2a mva #$64 tab_Every_100th_Move_Follow_BOMB_JACK,y ; 100x animuj zgodnie z zachowaniem "LITER", czyli nie zwaajc na to gdzie jest BOMB JACK (a raz na 100 razy tak modyfikuj ruch, eby zblia si do BOMB JACK-a)
                  jsr Random_Value_Value_x2                        ; losowanie przypadkowej wartoci
                  jsr Random_Change_Direction_Move_Sprites1_7      ; zmie kierunek ruchu SPRITE'a (lewo<->prawo lub gra<->d)

; skok do ruchu biernego SPRITE'a czyli nie zwaamy na to gdzie jest BOMB JACK aktualnie
Beh_Drill_skipA3  jmp Next_Clip_for_LetterP_FeelerBall_UFO         ; skocz do procki animujcej zachowanie "LITER"

tab_Every_100th_Move_Follow_BOMB_JACK .byte $00,$00,$00,$00,$00,$00,$00 ; 100-0 - jak osignie 0 to wywoanie procedury ledzcej gdzie jest BOMB JACK i prba zmiany ruchu tak, eby go dopa
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; zmiana kierunku ruchu lewo<->prawo lub gra<->d
Random_Change_Direction_Move_Sprites1_7
                  jsr Random_Register_A                   ; wylosuj przypadkow warto w rej.A (0-255)
                  cmp #$96                                ; czy losowa warto < 150?
                  bcc Change_Move_skip1                   ; TAK!

                  cmp #$DC                                ; czy losowa wato < 220?
                  bcc Change_Move_skip0                   ; TAK!

; zmiana ruchu na przeciwny gra<->d
                  ldx Do_Number_SPRITE_1_7                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Move_Up_or_Down_Sprite_1_7,x    ; zmiana ruchu SPRITE'a (gra<->d)
                  eor #$01                                ; 0<->1
                  sta tab_Move_Up_or_Down_Sprite_1_7,x

Change_Move_skip0 rts

Change_Move_skip1 cmp #$14                                ; czy losowa warto >= 20?
                  bcs Change_Move_skip0                   ; TAK!

; zmiana ruchu na przeciwny lewo<->prawo
                  ldx Do_Number_SPRITE_1_7                ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Move_Left_or_Right_Sprite_1_7,x ; zmiana ruchu SPRITE'a (lewo<->prawo)
                  eor #$01                                ; 0<->1
                  sta tab_Move_Left_or_Right_Sprite_1_7,x
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; Y=X, A=A*2, X=A
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Calculate_X_mul_2 txa
                  tay
                  asl @
                  tax
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
CoordinateX_add_One_Sprite1_7
                  jsr Calculate_X_mul_2
                  inc Sprite1_PosX,x                       ; +1 wsp.X (SPRITES #1-#7)
                  tya                                      ; odtwrz zapamitany rej.X
                  tax
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
CoordinateX_sub_One_Sprite1_7
                  jsr Calculate_X_mul_2
                  dec Sprite1_PosX,x                       ; -1 wsp.X (SPRITES #1-#7)
                  tya                                      ; odtwrz zapamitany rej.X
                  tax
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
CoordinateY_sub_One_Sprite1_7
                  jsr Calculate_X_mul_2
                  dec Sprite1_PosY,x                       ; -1 wsp.Y (SPRITES #1-#7)
                  tya                                      ; odtwrz zapamitany rej.X
                  tax
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
CoordinateY_add_One_Sprite1_7
                  jsr Calculate_X_mul_2
                  inc Sprite1_PosY,x                       ; +1 wsp.Y (SPRITES #1-#7)
                  tya                                      ; odtwrz zapamitany rej.X
                  tax
                  rts

tab_Move_Left_or_Right_Sprite_1_7 .byte $00,$00,$00,$00,$00,$00,$00 ; w ktr stron przesuwa si SPRITE #1-#7 (0 - w lewo, 1 - w prawo)
;--------------------------------------------------------------------------------------------------------------------------------------------------------
tab_Move_Up_or_Down_Sprite_1_7                         .byte $00,$00,$00,$00,$00,$00,$00 ;  =1 SPRITE ma si przesuwa w d, =0 w gr

Is_Test_Left_or_Right_Side_During_Move_Left_Sprite1_7  .byte $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z prawej strony, =8 z lewej
Is_Test_Left_or_Right_Side_During_Move_Right_Sprite1_7 .byte $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z prawej strony, =8 z lewej

Is_Sprite1_7_Block_During_Move_Left                    .byte $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w lewo SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Right_Side_Sprite1_7                       .byte $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z prawej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Right                   .byte $00,$00,$00,$00,$00,$00,$00 ; =1 podczas ruchu w prawo SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Left_Side_Sprite1_7                        .byte $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z lewej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Up                      .byte $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w gr SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Down_Side_Sprite1_7                        .byte $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z dolnej strony SPRITE'a

Is_Sprite1_7_Block_During_Move_Down                    .byte $00,$00,$00,$00,$00,$00,$00 ;  =1 podczas ruchu w d SPRITE zosta przyblokowany przez "kadk" lub "murek", =0 nie zosta

Is_2x_Block_Up_Side_Sprite1_7                          .byte $00,$00,$00,$00,$00,$00,$00 ; <>0 2x wykryta blokada z grnej strony SPRITE'a

Is_Test_Up_or_Down_Side_During_Move_Down_Sprite1_7     .byte $00,$00,$00,$00,$00,$00,$00 ;  =0 testowa z dolnej strony, =8 z grnej
Is_Test_Up_or_Down_Side_During_Move_Up_Sprite1_7       .byte $08,$08,$08,$08,$08,$08,$08 ;  =0 testowa z dolnej strony, =8 z grnej

2B22               .byte $00 ;nie uywane???

;########################################################################################################################################################
; procedura odpowiada za animacje SPRITE'a "WIDERKA"
;########################################################################################################################################################
Do_Animation_Drill_Sprite
                  ldy Do_Number_SPRITE_1_7                          ; pobierz numer aktualnego SPRITE'a
                  mva #$0C D028,y                                   ; ustaw kolor dla SPRITE'a #1-#7 na rednioszary
                  lda tab_Move_Left_or_Right_Sprite_1_7,y           ; w ktr stron przesuwa si SPRITE #1-#7 (0 - w lewo, 1 - w prawo)
                  beq Anim_Drill_skip2

                  mwa #tab_8th_clips_Move_Opponent_Drill_Right Next_Clip_change+1
Anim_Drill_skip1  jmp Service_Behavior_Drill_DotBall_SquareBall_UFO

Anim_Drill_skip2  mwa #tab_4th_clips_Move_Opponent_Drill_Left Next_Clip_change+1
                  jmp Anim_Drill_skip1

;########################################################################################################################################################
; procedura odpowiada za animacje SPRITE'w "KULI Z CZӣKAMI", "KULI Z KWADRATOWYMI OKNAMI", "KULI Z KROPKAMI", "UMIECHNITEJ BUZI", "LITERY P"
;########################################################################################################################################################
Do_Animation_Feeler_Square_DotBall_SmilingFace_LetterP_Sprite
                  ldy Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Type_SPRITES_1_7,y
                  cmp #$04
                  jeq Do_Animation_Square_Ball_Sprite

                  cmp #$08
                  beq Do_Animation_Letter_P_Sprite

                  cmp #$07
                  beq Do_Animation_Smiling_Face_Sprite

                  cmp #$03
                  jeq Do_Animation_Feeler_Ball_Sprite
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "KULI Z KROPKAMI" - $05
                  mva #$0B D028,y                                  ; ustaw ciemnoszary kolor dla SPRITE'w #1-#7
                  mva #<tab_3th_clips_Move_Opponent_Dot_Ball Next_Clip_change+1
                  mva #>tab_3th_clips_Move_Opponent_Dot_Ball Next_Clip_change+2
                  jmp Service_Behavior_Drill_DotBall_SquareBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "LITERY P"
Do_Animation_Letter_P_Sprite
                  jsr Can_Show_LetterP_on_Board
                  mva #$00 Sprite0_7_PosX_8bit                     ; wyzeruj bit8=0 dla SPRITE'w #0-#7
                  ldy Do_Number_SPRITE_1_7                         ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva ColorRAM40x25+$0070 D028,y                   ; ustaw kolor dla SPRITE'w #1-#7 (pobierz kolor z migajcego napisu "SCORE" na prawym panelu)
                  mva #<tab_6th_clips_Move_Letter_P Next_Clip_change+1
                  mva #>tab_6th_clips_Move_Letter_P Next_Clip_change+2
                  mva #$01 Add_to_CoordinateX_Sprite_1_7
                  mva #$02 Add_to_CoordinateY_Sprite_1_7
                  jmp Service_Behavior_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "UMIECHNITEJ BUZI"
Do_Animation_Smiling_Face_Sprite
                  ldy Do_Number_SPRITE_1_7                         ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda Time_Get_SmilingFace_Soon_Finish
                  cmp #$19                                         ; 25
                  bcs Anim_Face_skip1

; czasu na zebranie jest ju poniej 25 jednostek (1 jednostka = 1/50s)
                  mva #$06 Choose_Play_SFX
                  lda D028,y                                       ; pobierz kolor dla aktualnego SPRITE'a
                  eor #$08                                         ; bit3 0<->1
                  sta D026                                         ; VicMltClr1 - %11 - Sprite extra color #1 - powoduje to miganie "UMIECHNITYCH BUZIEK"
                  jmp Anim_Face_skip2

;2BBA              ldy Do_Number_SPRITE_1_7                         ; ??? nieuywane!

; czasu na zebranie jest rwno lub wicej ni 25 jednostek (1 jednostka = 1/50s)
Anim_Face_skip1   lda #$08                                         ; kolor pomaraczowy

Anim_Face_skip2   sta D028,y                                       ; ustaw kolor dla SPRITE'a #1-#7
                  mva #<tab_5th_clips_Move_Opponent_Smiling_Face Next_Clip_change+1
                  mva #>tab_5th_clips_Move_Opponent_Smiling_Face Next_Clip_change+2
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "KULI Z CZUKAMI"
Do_Animation_Feeler_Ball_Sprite
                  ldy Do_Number_SPRITE_1_7                         ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Second_Frame_Feeler_Ball_Sprite,y        ; 0-rysuj "KUL Z CZUKAMI", 1-nie rysuj "KULI Z CZUKAMI" (dziki temu KULA jest rys. co 2 ramki)
                  beq Anim_Feeler_skip1

; nie rysuj "KULI Z CZUKAMI"
                  eor #$01                                         ; zmiana 0<->1
                  sta tab_Every_Second_Frame_Feeler_Ball_Sprite,y
                  jmp Do_Move_skip3                                ; powrt do gwnej ptli

; rysuj "KUL Z CZUKAMI"
Anim_Feeler_skip1 eor #$01                                         ; zmiana 0<->1
                  sta tab_Every_Second_Frame_Feeler_Ball_Sprite,y        ; 0-rysuj "KUL Z CZUKAMI", 1-nie rysuj "KULI Z CZUKAMI" (dziki temu KULA jest rys. co 2 ramki)
                  mva #$0C D028,y                                  ; ustaw kolor rednioszary dla SPRITE'a #1-#7
                  mva #<tab_8th_clips_Move_Opponent_Feeler_Ball Next_Clip_change+1
                  mva #>tab_8th_clips_Move_Opponent_Feeler_Ball Next_Clip_change+2
                  mva #$01 Add_to_CoordinateX_Sprite_1_7
                  mva #$02 Add_to_CoordinateY_Sprite_1_7
                  jmp Service_Behavior_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "KULI Z KWADRATOWYMI OKNAMI"
Do_Animation_Square_Ball_Sprite
                  mva #$01 D028,y                                     ; ustaw kolor biay dla SPRITE'a #1-#7
                  mva #<tab_6th_clips_Move_Opponent_Square_Ball Next_Clip_change+1
                  mva #>tab_6th_clips_Move_Opponent_Square_Ball Next_Clip_change+2
                  jmp Service_Behavior_Drill_DotBall_SquareBall_UFO

tab_Every_Second_Frame_Feeler_Ball_Sprite .byte $00,$00,$00,$00,$00,$00,$00 ; 0-rysuj "KUL Z CZUKAMI", 1-nie rysuj "KULI Z CZUKAMI" (dziki temu "KULA" jest rys. co 2 ramki)

;########################################################################################################################################################
; procedura obsuguje zachowanie "LITERY P", "KULI Z CZUKAMI" i "UFO"
;########################################################################################################################################################
Service_Behavior_LetterP_FeelerBall_UFO
                  lda bits0_1_Right_Down,y
                  and #$01                                            ; zostaw tylko bit0
                  beq Beh_Letter_skip0                                ; SPRITE przesuwa si w lewo
                  jmp Beh_Letter_skip4                                ; SPRITE przesuwa si w prawo

Beh_Letter_loop0  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda bits0_1_Right_Down,y
                  and #$02                                            ; zostaw tylko bit1
                  jne Beh_Letter_skipB                                ; SPRITE przesuwa si w d
                  jmp Beh_Letter_skip6                                ; SPRITE przesuwa si w gr
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ruch SPRITE'a w lewo
Beh_Letter_skip0  lda Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosX,y                                  ; pobierz wsp.X SPRITE'a #1-#7
                  cmp #$19                                            ; Czy wsp.X jest rwna 25?
                  bne Beh_Letter_skip2                                ; NIE!

; natrafiono na "murek" lub "kadk"
Beh_Letter_loop1  jsr Beh_Letter_skip1                                ; TAK!
                  jmp Beh_Letter_skip5

; natrafiono na "murek" lub "kadk"
Beh_Letter_loop2  jsr Beh_Letter_skip1
                  jmp Beh_Letter_skip3
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Beh_Letter_skip1  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda bits0_1_Right_Down,y
                  eor #$01
                  sta bits0_1_Right_Down,y
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Beh_Letter_skip2  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25 ;                                   ...
                  jsr address1_SBW_1byte                            ; poprzednia kolumna                X..
                  jsr address1_SBW_40bytes                          ; poprzedni wiersz                  ...
                  ldy #$00
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq Beh_Letter_loop1                              ; TAK!
                                                                    ;                                   X..
; nie natrafiono na "murek" lub "kadk"
                  jsr address1_SBW_40bytes                          ; poprzedni wiersz                  ...
                  lda (address1),y                                  ;                                   ...
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq Beh_Letter_loop1                              ; TAK!

; nie natrafiono na "murek" lub "kadk"
Beh_Letter_skip3  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  sbb Sprite1_PosX,y Add_to_CoordinateX_Sprite_1_7  ; odejmij od wsp.X SPRITE'a - czyli ruch w lewo
                  jmp Beh_Letter_loop0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ruch SPRITE'a w prawo
Beh_Letter_skip4  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosX,y                                ; pobierz wsp.X SPRITE'a #1-#7
                  cmp #$F0                                          ; Czy wsp.X jest rwna 240?
                  jeq Beh_Letter_loop2                              ; TAK!

; nie natrafiono na "murek" lub "kadk"
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25 ;                                   ...
                  jsr address1_ADW_1byte                            ; nastpna kolumna                  ..X
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz               ...
                  ldy #$00
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq Beh_Letter_loop2                              ; TAK!
                                                                    ;                                   ..X
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz               ...
                  lda (address1),y                                  ;                                   ...
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq Beh_Letter_loop2                              ; TAK!

; nie natrafiono na "murek" lub "kadk"
Beh_Letter_skip5  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay

                  adb Sprite1_PosX,y Add_to_CoordinateX_Sprite_1_7  ; dodaj do wsp.X SPRITE'a czyli ruch w prawo
                  jmp Beh_Letter_loop0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ; ruch SPRITE'a w gr
Beh_Letter_skip6  lda Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosY,y                             ; pobierz wsp.Y SPRITE'a #1-#7
                  cmp #$32                                       ; Czy wsp.Y jest rwna lub wiksza ni 50?
                  bcs Beh_Letter_skip9                           ; TAK!

; natrafiono na "murek" lub "kadk"
Beh_Letter_skip7  jsr Beh_Letter_proc1
                  jmp Beh_Letter_skipC

; natrafiono na "murek" lub "kadk"
Beh_Letter_skip8  jsr Beh_Letter_proc1
                  jmp Beh_Letter_skipA
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Beh_Letter_proc1  ldy Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda bits0_1_Right_Down,y
                  eor #$02
                  sta bits0_1_Right_Down,y
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; nie natrafiono na "murek" lub "kadk"                            ;                                  X
Beh_Letter_skip9  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25 ;                                 ...
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz             ...
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz             ...
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz
                  ldy #$00
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  beq Beh_Letter_skip7  ;slow                       ; TAK!

; nie natrafiono na "murek" lub "kadk"
Beh_Letter_skipA  ldy Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  tya
                  asl @
                  tay
                  sbb Sprite1_PosY,y Add_to_CoordinateY_Sprite_1_7  ; odejmij od wsp.Y czyli ruch SPRITE'a w gr
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ruch SPRITE'a w d
Beh_Letter_skipB  lda Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosY,y                             ; 220
                  cmp #$DC
                  bcc Beh_Letter_skipBb

; natrafiono na "murek" lub "kadk"
Beh_Letter_skipBa jmp Beh_Letter_skip8

; pobierz bajt spod (address1)
Beh_Letter_skipBb jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25  ;                             ...
                  ldy #$00                                           ;                             ...
                  lda (address1),y                                   ;                             .X.
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                           ; czy "murek" lub "kadka"?
                  beq Beh_Letter_skipBa                              ; TAK!

; nie natrafiono na "murek" lub "kadk"
Beh_Letter_skipC  lda Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  adb Sprite1_PosY,y Add_to_CoordinateY_Sprite_1_7   ; dodaj do wsp.Y SPRITE'a czyli ruch w d
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; tutaj wywietlamy kolejn klatk animacyjn
Next_Clip_for_LetterP_FeelerBall_UFO
                  ldy Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Third_Frame_Move_Sprite,y
                  cmp #$03
                  beq Next_Clip_skip1

                  add tab_Every_Third_Frame_Move_Sprite,y #$01
                  jmp Do_Move_skip3                              ; powrt do gwnej ptli

Next_Clip_skip1   mva #$00 tab_Every_Third_Frame_Move_Sprite,y

Next_Clip_loop1   lda index_tab_clips_Move_Opponent,y            ; pobierz wskanik (SPRITE zgodnie z rej.Y)
                  tax

Next_Clip_change  lda tab_6th_clips_Move_Opponent_Square_Ball,x  ; UWAGA! tutaj jest modyfikacja kodu gry czasami! wic moe by odwoanie do innej tablicy
                  beq Next_Clip_skip2                            ; =0? jeeli tak tzn., e wywietlono ju wszystkie klatki animacji

                  sta tab_Addr_SPRITE_Pattern,y                  ; ustaw wygld SPRITE'a #1-#7
                  adb index_tab_clips_Move_Opponent,y #$01       ; +1 wskaniki - aby wskazywa na kolejn klatk
                  jmp Do_Move_skip3                              ; powrt do ptli gwnej

Next_Clip_skip2   mva #$00 index_tab_clips_Move_Opponent,y       ; ustaw wskanik na pierwsz klatk (SPRITE zgodnie z rej.Y)
                  jmp Next_Clip_loop1

Add_to_CoordinateX_Sprite_1_7 .byte $00                          ; warto, o ktr zwikszamy wsp.X (SPRITES #1-#7)

; nie uywane???
2D92 00           brk
2D93 00           brk
2D94 00           brk
2D95 00           brk
2D96 00           brk
2D97 00           brk

Add_to_CoordinateY_Sprite_1_7 .byte $00                          ; warto, o ktr zwikszamy wsp.Y (SPRITES #1-#7)

; nie uywane???
2D99 00           brk
2D9A 00           brk
2D9B 00           brk
2D9C 00           brk
2D9D 00           brk
2D9E 00           brk

;########################################################################################################################################################
; procedura sprawdza czy mona wywietli "LITERE P"? Jeeli tak to losuje wsp.X i Y (lewy-grny rg lub prawy-dolny rg)
;########################################################################################################################################################
tab_Can_Show_LetterP_on_Board .byte $00,$00,$00,$00,$00,$00,$00 ; 0 - mona wywietli "LITERE P", 1 - nie mona (SPRITES #1-#7)(UWAGA! ustawiane na 0 przed kad kolejn plansz oraz po zebraniu pewnej iloci BOMB!)

Can_Show_LetterP_on_Board
                  ldy Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Can_Show_LetterP_on_Board,y            ; Czy mona wywietli "LITERE P"?
                  jeq Can_LetterP_skip1                                       ; TAK!

                  rts

Can_LetterP_skip1 mva #$01 tab_Can_Show_LetterP_on_Board,y
                  jsr Random_Register_A
                  cmp #$7D                                       ; 125
                  bcc Can_LetterP_skip2

                  lda Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                          ; *2
                  tay
                  mva #$3C Sprite1_PosX,y                        ; wsp.X=60 - lewy,grny rg - na tej pozycji pojawia si "LITERA P"
                  sta      Sprite1_PosY,y                        ; wsp.Y=60
                  rts

Can_LetterP_skip2 lda Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                          ; *2
                  tay
                  mva #$C8 Sprite1_PosX,y                        ; wsp.X=200 - prawy,dolny rg - na tej pozycji pojawia si "LITERA P"
                  sta      Sprite1_PosY,y                        ; wsp.Y=200
                  rts

Can_Show_LetterEB_on_Board .byte $00 ; 0 - nie mona wywietli "LITERY E lub B", $01-$FF - mona wywietli

;########################################################################################################################################################
; procedura animuje SPRITE'a w ksztacie "UFO"
;########################################################################################################################################################
Do_Animation_UFO_Sprite
                  mva #<tab_6th_clips_Move_Opponent_UFO Beh_Letter_change+1
                  mva #>tab_6th_clips_Move_Opponent_UFO Beh_Letter_change+2
                  ldx Do_Number_SPRITE_1_7                                  ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$0C D028,x                                           ; ustaw kolor rednioszary dla SPRITE'a #1-#7

Anim_UFO_loop1    lda tab_Every_Second_Frame_UFO_Sprite,x
                  beq Anim_UFO_skip1

                  lda tab_After_255_Clips_Change_Behavior_UFO,x             ; =0?
                  beq Anim_UFO_skip2  ;slow                                 ; TAK!

                  dec tab_After_255_Clips_Change_Behavior_UFO,x
                  jmp Service_Behavior_Drill_DotBall_SquareBall_UFO

Anim_UFO_skip1    lda tab_After_255_Clips_Change_Behavior_UFO,x             ; =0?
                  beq Anim_UFO_skip2                                        ; TAK!

                  dec tab_After_255_Clips_Change_Behavior_UFO,x             ; -1
                  mva #$01 Add_to_CoordinateX_Sprite_1_7
                  mva #$02 Add_to_CoordinateY_Sprite_1_7
                  jmp Service_Behavior_LetterP_FeelerBall_UFO

Anim_UFO_skip2    lda tab_Every_Second_Frame_UFO_Sprite,x
                  eor #$01
                  sta tab_Every_Second_Frame_UFO_Sprite,x
                  mva #$FF tab_After_255_Clips_Change_Behavior_UFO,x        ; co 255 klatek zmiana sposobu zachowania "UFO"
                  jmp Anim_UFO_loop1

tab_After_255_Clips_Change_Behavior_UFO .byte $00,$00,$00,$00,$00,$00,$00   ; ($FF-$00) =$00 - zmie sposb zachowania "UFO"
tab_Every_Second_Frame_UFO_Sprite       .byte $00,$00,$00,$00,$00,$00,$00   ; 0 - rys. "UFO", 1- nie rys. "UFO" (rysowanie co 2-g ramk)

;########################################################################################################################################################
; procedura odpowiada za animacje SPRITE'a "PTASZKA"
;########################################################################################################################################################
Do_Animation_Bird_Sprite
                  ldy Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$0B D028,y                                   ; ustaw kolor ciemnoszary dla SPRITE'a #1-#7
                  lda Number_Round_BCD                              ; pobierz numer rundy w BCD
                  cmp #$06                                          ; czy "RUNDA">=6
                  bcs Anim_Bird_skip1                               ; TAK!
; "RUNDA"<6
                  inc Service_Bird_Every_2th_Frame
                  lda Service_Bird_Every_2th_Frame
                  and #$02                                          ; czy bit0=1?
                  jne Do_Move_skip3                                 ; TAK! powrt do gwnej ptli - dziki jeeli "RUNDA"<6 to "PTASZEK" jest obs. co 2 ramke
; "RUNDA">=6
Anim_Bird_skip1   lda tab_Is_Change_PosX_or_PosY_Bird,y             ; czy zmienia wsp.X "PTASZKA"?
                  jne Anim_Bird_skipB                               ; TAK!

; NIE! zmieni wsp.Y "PTASZKA"
                  jsr Next_Clip_Bird_Move_Up_or_Down                ; wywietl kolejn klatk "PTASZKA"

                  lda Choose_Move_Up_Down_Bird                      ; Jaki ruch naley wykona "PTASZKIEM"? w gr czy w d?
                  beq Anim_Bird_skip2                               ; =0 - skok do czci dla ruchu SPRITE'a w d lub w gr (zaley od wsp.Y)
                  cmp #$01
                  beq Anim_Bird_skip3                               ; =1 - skok do czci dla ruchu SPRITE'a w d
                  jmp Anim_Bird_skip7                               ; =2 - skok do czci dla ruchu SPRITE'a w gr
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; testowanie wsp.Y - ruch SPRITE'a w d
Anim_Bird_skip2   tya
                  asl @                                             ; *2
                  tay
                  lda Sprite1_PosY,y                                ; Czy wsp.Y SPRITE'a #1-#7...
                  cmp Sprite0_PosY                                  ; ...jest rwna wsp.Y BOMB JACK-a?
                  jeq Anim_Bird_End2                                ; TAK!
                  bcs Anim_Bird_skip7                               ; NIE! jest wiksza czyli skok do czci dla ruchu SPRITE'a w gr

; NIE! wsp.Y SPRITE'a < wsp.Y BOMB JACK-a wic ruch SPRITE'a w d
Anim_Bird_skip3   jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25 ;                     ...
                  ldy #$00                                          ;                     ...
                  lda (address1),y                                  ;                     .X.
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  bne Anim_Bird_skip6                               ; NIE!
                  jmp Anim_Bird_skip4a                              ; TAK!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_Bird_skip4   lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                             ; *2
                  tay
                  lda Sprite1_PosX,y                                ; Czy wsp.X SPRITE'a #1-#7...
                  cmp Sprite0_PosX                                  ; ...jest rwna wsp.X BOMB JACK-a?
                  jne Anim_Bird_End2                                ; NIE!

; TAK! wsprzdne X s rwne
Anim_Bird_skip4a  ldy Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Change_PosX_or_PosY_Bird,y
                  eor #$01
                  sta tab_Is_Change_PosX_or_PosY_Bird,y
                  jsr Random_Register_A                             ; wylosuj jak warto w rej.A

                  cmp #$8C                                          ; 140
                  bcc Anim_Bird_skip5

                  mva #$01 Choose_Move_Left_Right_Bird              ; trzeba omin przeszkod - wic ustaw ruch "PTASZKA" w prawo
                  mva #$4B Counter_Move_Left_Right_Up_Down_Bird     ; 75
                  jmp Anim_Bird_End

Anim_Bird_skip5   mva #$02 Choose_Move_Left_Right_Bird              ; trzeba omin przeszkod - wic ustaw ruch "PTASZKA" w lewo
                  mva #$4B Counter_Move_Left_Right_Up_Down_Bird     ; 75
                  jmp Do_Move_skip3                                 ; powrt do ptli gwnej
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_Bird_skip6   clc
                  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                             ; *2
                  tay
                  lda Sprite1_PosY,y                                ; pobierz wsp.Y SPRITE'a #1-#7
                  cmp #$DC                                          ; Czy wsp.Y jest rwna 220?
                  jeq Anim_Bird_skip4                               ; TAK!

                  adb Sprite1_PosY,y #$01                           ; dodaj do wsp.Y SPRITE'a +1
                  jmp Anim_Bird_End
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; testowanie wsp.Y - ruch SPRITE'a w gr
Anim_Bird_skip7   jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldy #$00
                  sbb address1 #$78                                 ; -120 (3 wiersze)
                  bcs Anim_Bird_skip8

                  dec address1+1
                                                                    ;                                 X
Anim_Bird_skip8   lda (address1),y                                  ;                                ...
                  tax                                               ;                                ...
                  lda tab_Action_for_256Chars,x                     ;                                ...
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq Anim_Bird_skip4a                              ; TAK!

                  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosY,y                                ; pobierz wsp.Y SPRITE'a #1-#7
                  cmp #$32                                          ; Czy wsp.Y jest rwna 50?
                  jeq Anim_Bird_skip4                               ; TAK!

                  sbb Sprite1_PosY,y #$01                           ; -1 wsp.Y

Anim_Bird_End     dec Counter_Move_Left_Right_Up_Down_Bird          ; -1
                  lda Counter_Move_Left_Right_Up_Down_Bird          ; czy nadal przesuwa "PTASZKA" zgodnie z ustalonym wczeiej kierunkiem?
                  jpl Do_Move_skip3                                 ; TAK! powrt do gwnej ptli

; NIE! "zresetowanie" zmiennych, eby moliwe byo ponowne wyznaczenie kierunku ruchu "PTASZKA"
Anim_Bird_End2    mva #$64 Counter_Move_Left_Right_Up_Down_Bird     ; 100
                  mva #$00 Choose_Move_Up_Down_Bird                 ; zapisz warto neutraln
                  sta      Choose_Move_Left_Right_Bird              ; zapisz warto neutraln
                  ldy Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Change_PosX_or_PosY_Bird,y
                  eor #$01
                  sta tab_Is_Change_PosX_or_PosY_Bird,y
                  jmp Do_Move_skip3                                 ; powrt do gwnej ptli
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; testowanie wsp.X - ruch SPRITE'a w prawo
Anim_Bird_skipB   lda Choose_Move_Left_Right_Bird                   ; Jaki ruch naley wykona "PTASZKIEM"? w lewo czy w prawo?
                  beq Anim_Bird_skipC                               ; =0 - skok do czci dla ruchu SPRITE'a w lewo lub w prawo (zaley od wsp.X)
                  cmp #$01
                  jeq Anim_Bird_skipD                               ; =1 - skok do czci dla ruchu SPRITE'a w prawo
                  jmp Anim_Bird_skipI                               ; =2 - skok do czci dla ruchu SPRITE'a w lewo
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_Bird_skipC   tya
                  asl @                                             ; *2
                  tay
                  lda Sprite1_PosX,y                                ; Czy wsp.X SPRITE'a #1-#7...
                  cmp Sprite0_PosX                                  ; ...jest rwna wsp.X BOMB JACK-a?
                  jeq Anim_Bird_End2                                ; TAK!
                  jcs Anim_Bird_skipI                               ; NIE! jest wiksza

; NIE! jest mniejsza czyli ruch w prawo
Anim_Bird_skipD   jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldy #$00                                         ;                                ...
                  jsr address1_SBW_40bytes                         ; wczeniejszy wiersz            ..X
                  jsr address1_ADW_1byte                           ; nastpna kolumna               ...
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                         ; czy "murek" lub "kadka"?
                  bne Anim_Bird_skipH                              ; NIE!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; natrafiono na "murek" lub "kadk"
During_Move_Left_or_Right_Bird_Detect_Blocade
                  lda Do_Number_SPRITE_1_7                         ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosY,y                               ; Czy wsp.Y SPRITE'a #1-#7...
                  cmp Sprite0_PosY                                 ; ...jest rwna wsp.Y BOMB JACK-a?
                  bne Anim_Bird_skipG                              ; NIE!

; TAK! wsprzdne Y s rwne
                  ldy Do_Number_SPRITE_1_7                         ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Is_Change_PosX_or_PosY_Bird,y
                  eor #$01
                  sta tab_Is_Change_PosX_or_PosY_Bird,y
                  jsr Random_Register_A                            ; wylosuj warto w rej.A
                  cmp #$8C                                         ; czy losowa warto < 140
                  bcc Anim_Bird_skipF                              ; TAK!

                  mva #$01 Choose_Move_Up_Down_Bird                ; trzeba omin przeszkod - wic ustaw ruch "PTASZKA" w d
                  mva #$4B Counter_Move_Left_Right_Up_Down_Bird    ; 75
                  jmp Anim_Bird_End

Anim_Bird_skipF   mva #$02 Choose_Move_Up_Down_Bird                ; trzeba omin przeszkod - wic ustaw ruch "PTASZKA" w gr
                  mva #$64 Counter_Move_Left_Right_Up_Down_Bird    ; 100
                  jmp Anim_Bird_End

Anim_Bird_skipG   jmp Anim_Bird_End2
;---------------------------------------------------------------------------------------------------------------------------------------------------------
; nie natrafiono na "murek" lub "kadk"
Anim_Bird_skipH   jsr address1_SBW_40bytes                          ; wczeniejszy wiersz          ..X
                  lda (address1),y                                  ;                              ...
                  tax                                               ;                              ...
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq During_Move_Left_or_Right_Bird_Detect_Blocade ; TAK!

                  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosX,y                                ; pobierz wsp.X SPRITE'a #1-#7
                  cmp #$FA                                          ; Czy wsp.X jest rwna 250?
                  jeq During_Move_Left_or_Right_Bird_Detect_Blocade ; TAK! - "murek"

                  adb Sprite1_PosX,y  #$01                          ; dodaj do wsp.X SPRITE'a +1
                  jsr Next_Clip_Bird_Move_Right                     ; wywietl kolejn klatk SPRITE'a
                  jmp Anim_Bird_End
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; testowanie wsp.X - ruch SPRITE'a w lewo
Anim_Bird_skipI   jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  ldy #$00                                          ;                                   ...
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz               X..
                  jsr address1_SBW_1byte                            ; poprzednia kolumna                ...
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq During_Move_Left_or_Right_Bird_Detect_Blocade ; TAK!
                                                                    ;                                   X..
                  jsr address1_SBW_40bytes                          ; wczeniejszy wiersz               ...
                  lda (address1),y                                  ;                                   ...
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                          ; czy "murek" lub "kadka"?
                  jeq During_Move_Left_or_Right_Bird_Detect_Blocade ; TAK!

                  lda Do_Number_SPRITE_1_7                          ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                             ; *2
                  tay
                  lda Sprite1_PosX,y                                ; pobierz wsp.X SPRITE'a #1-#7
                  cmp #$18                                          ; Czy wsp.X jest rwna 24?
                  jeq During_Move_Left_or_Right_Bird_Detect_Blocade ; TAK!

                  sbb Sprite1_PosX,y #$01                           ; odejmij od wsp.X SPRITE'a +1
                  jsr Next_Clip_Bird_Move_Left                      ; wywietl kolejn klatk SPRITE'a
                  jmp Anim_Bird_End
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wywietlenie kolejnej klatki, jeeli "PTASZEK" przesuwa si gr lub w d
Next_Clip_Bird_Move_Up_or_Down
                  mva #<tab_6th_clips_Move_Opponent_Bird_Up_Down Next_Bird_Change+1
                  mva #>tab_6th_clips_Move_Opponent_Bird_Up_Down Next_Bird_Change+2
                  jsr Next_Clip_for_Bird
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wywietlamy kolejn klatk "PTASZKA"
Next_Clip_for_Bird
                  ldy Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Third_Frame_Move_Bird_Sprite,y
                  cmp #$03
                  beq Next_Bird_skip1

                  adb tab_Every_Third_Frame_Move_Bird_Sprite,y #$01  ; +1 licznik - co 3 ramk ma by zmiana def. SPRITE'a
                  rts

Next_Bird_skip1   mva #$00 tab_Every_Third_Frame_Move_Bird_Sprite,y

Next_Bird_loop1   lda index_tab_clips_Move_Bird,y
                  tax
Next_Bird_Change  lda tab_6th_clips_Move_Opponent_Bird_Up_Down,x     ; UWAGA! modyfikacja kodu! wcale nie musi tutaj by ta akurat tablica!
                  beq Next_Bird_skip2

                  sta tab_Addr_SPRITE_Pattern,y                      ; ustaw adres klatki dla SPRITE'a  ($4000+(wskanik)*$40)
                  adb index_tab_clips_Move_Bird,y #$01               ; +1 - licznik wskazujcy na kolejn klatk
                  rts

Next_Bird_skip2   mva #$00   index_tab_clips_Move_Bird,y
                  jmp Next_Bird_loop1
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wywietlenie kolejnej klatki, jeeli "PTASZEK" przesuwa si w prawo
Next_Clip_Bird_Move_Right
                  mva #<tab_6th_clips_Move_Opponent_Bird_Right Next_Bird_Change+1
                  mva #>tab_6th_clips_Move_Opponent_Bird_Right Next_Bird_Change+2
                  jsr Next_Clip_for_Bird
                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; wywietlenie kolejnej klatki, jeeli "PTASZEK" przesuwa si w lewo
Next_Clip_Bird_Move_Left
                  mva #<tab_6th_clips_Move_Opponent_Bird_Left Next_Bird_Change+1
                  mva #>tab_6th_clips_Move_Opponent_Bird_Left Next_Bird_Change+2
                  jsr Next_Clip_for_Bird
                  rts

;########################################################################################################################################################
; animacja pokazywana przed pojawieniem si nowego przeciwnika
;########################################################################################################################################################
Do_Animation_New_Opponent_Appear_Sprite
                  ldy Do_Number_SPRITE_1_7               ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Every_Second_Frame_New_Appear_Sprite,y
                  cmp #$02
                  beq Anim_New_skip1

                  adb tab_Every_Second_Frame_New_Appear_Sprite,y #$01
                  jmp Do_Move_skip3

; wywietlamy pojawianie si SPRITE'a (np: najpierw pojawia si "dymek"($99), potem "trafienie"($98), potem "kko"($97) i dopiero nowy przeciwnik)
Anim_New_skip1    mva #$00 tab_Every_Second_Frame_New_Appear_Sprite,y
                  lda index_tab_7th_clips_New_Opponent_Appear,y         ; pobierz wskanik dla SPRITE'a #1-#7
                  tax
                  lda tab_7th_clips_New_Opponent_Appear,x               ; pobierz kolejn klatk zgodnie z wskanikiem
                  beq Anim_New_skip2                                    ; Czy wskanik = 0? jeeli tak tzn., e ju wywietlono wszystkie klatki

                  sta        tab_Addr_SPRITE_Pattern,y                  ; ustaw wygld SPRITE'a
                  mva #$08   D028,y                                     ; ustaw kolor pomaraczowy dla SPRITE'a #1-#7
                  adb index_tab_7th_clips_New_Opponent_Appear,y #$01    ; +1 aby wskanik wskazywa kolejn klatk
                  jmp Do_Move_skip3                                     ; powrt do gwnej ptli

; wywietlono ju wszystkie klatki animacji pojawiania si przeciwnika - teraz ma pokaza si posta przzeciwnika
Anim_New_skip2    mva #$00   index_tab_clips_Move_Opponent,y
                  sta        tab_Every_Third_Frame_Move_Sprite,y
                  sta        index_tab_7th_clips_New_Opponent_Appear,y  ; wskazanie na pierwsz klatk
                  mva tab_Show_Type_Sprite1_7_After_Animation_Appearing,y tab_Type_SPRITES_1_7,y
                  jmp Do_Move_skip3                                     ; powrt do ptli gwnej

;########################################################################################################################################################
; procedura obsuguje spadajce litery B i E, ktre moe zebra BOMB JACK
;########################################################################################################################################################
Do_Animation_Letter_E_B_Sprite
                  ldx Do_Number_SPRITE_1_7                        ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda Can_Show_LetterEB_on_Board                  ; Czy mona wywietli "LITERE E lub B"?
                  jeq Anim_LetEB_End                              ; =0 NIE!

                  dec Can_Show_LetterEB_on_Board
                  mva #$00 Sprite0_7_PosX_8bit                    ; bit8=0 wsp.X dla SPRITE'w #0-#7
                  ldy Do_Number_SPRITE_1_7                        ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  lda tab_Type_SPRITES_1_7,y
                  cmp #$0A                                        ; Czy "LITERA B"?
                  beq Do_Animation_Letter_B_Sprite                ; TAK!
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "LITERY E"
                  mva #<tab_8th_clips_Letter_E Beh_Letter_change+1
                  mva #>tab_8th_clips_Letter_E Beh_Letter_change+2
                  jmp Anim_LetEB_skip0
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; animacja "LITERY B"
Do_Animation_Letter_B_Sprite
                  mva #<tab_8th_clips_Letter_B Beh_Letter_change+1
                  mva #>tab_8th_clips_Letter_B Beh_Letter_change+2

Anim_LetEB_skip0  mva ColorRAM40x25+$0070 D028,y                     ; ustaw kolor dla SPRITE'a (pobierz kolor od pierwszej litery migajcego napisu "SCORE" na prawym panelu)...
                                                                     ; ...dziki temu literka do zebrania te bdzie miga!
                  lda tab_Move_Left_or_Right_or_Down_LetterEB,y
                  jeq Anim_LetEB_skip3                               ; =0 - wylosuj miejsce, gdzie pokae si "LITERA" na planszy
                  lda tab_Move_Left_or_Right_or_Down_LetterEB,y
                  cmp #$01                                           ; =1 - ruch w lewo "LITERY"
                  jeq Anim_LetEB_skip9
                  cmp #$02                                           ; =2 - ruch w prawo "LITERY"
                  jeq Anim_LetEB_loop1

; =3 - ruch w d "LITERY"
                  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25  ; obl. adres miejsca, nad ktrym jest SPRITE      ...
                  ldy #$00                                           ;                                                 ...
                  lda (address1),y                                   ; pobierz kod znaku spod tego adresu              .X.
                  tax
                  lda tab_Action_for_256Chars,x                      ; pobierz "kod akcji" dla tego znaku
                  cmp #$01                                           ; czy to jaka "kadka" lub "zielony margines"?
                  beq Anim_LetEB_skip1                               ; TAK!

; NIE! wic mona wykona ruch "LITERY" w d
                  jsr Anim_Astronaut_Jump_Down
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO

; TAK! wykryto na dole "murek" lub "kadk"
Anim_LetEB_skip1  ldx index_tab_Addr_SPRITE_ScreenBuff40x25
                  lda tab_Addr_SPRITE_ScreenBuff40x25+2,x            ; pobierz wsp.Y
                  tax
                  :2 inx                                             ; +2
                  lda Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  txa
                  sta Sprite1_PosY,y
                  ldy Do_Number_SPRITE_1_7                           ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$00 tab_Anim_Speed_Jump_Down,y
                  mva #$07 tab_7x_Add_Speed_Jump_Down_to_PosY,y
                  jsr Random_Register_A                              ; losuj warto w rej.A
                  cmp #$82                                           ; czy losowa warto < 130?
                  bcc Anim_LetEB_skip2                               ; TAK!

Anim_LetEB_skip1a ldy Do_Number_SPRITE_1_7                           ; NIE! numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$02 tab_Move_Left_or_Right_or_Down_LetterEB,y                                    ; ruch w prawo
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO

Anim_LetEB_skip2  lda #$01                                           ; ruch w lewo
                  jmp Anim_LetEB_skip1a
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_LetEB_skip3  jsr Random_Register_A                               ; losuj warto w rej.A
                  cmp #$82                                            ; czy losowa warto jest < 130?
                  bcc Anim_LetEB_skip5                                ; TAK!

                  sec                                                 ; NIE!
                  sbc #$0C                                            ; -12
                  tax

Anim_LetEB_skip4  lda Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @                                               ; *2
                  tay
                  txa
                  sta      Sprite1_PosX,y                             ; ustaw. wylosowan wczeniej wsp.X dla "LITERY"
                  mva #$46 Sprite1_PosY,y                             ; ustaw wsp.Y = 80
                  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$03 tab_Move_Left_or_Right_or_Down_LetterEB,y
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO

Anim_LetEB_skip5  adc #$2A                                            ; +42
                  tax
                  jmp Anim_LetEB_skip4

Anim_LetEB_loop1  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz                  ...X
                  jsr address1_SBW_40bytes                            ; wczeniejszy wiersz                  ...
                  jsr address1_ADW_1byte                              ; nastpna kolumna                     ...
                  jsr address1_ADW_1byte                              ; nastpna kolumna
                  ldy #$00
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                            ; czy "murek" lub "kadka"?
                  bne Anim_LetEB_skip6                                ; NIE!

; TAK! wykryto z prawej strony "murek" lub "kadk"
                  mva #$01 tab_Move_Left_or_Right_or_Down_LetterEB+6                                     ; ruch w lewo
                  jmp Anim_LetEB_skip9

; NIE! nie wykryto z prawej strony "mureka" lub "kadki"
Anim_LetEB_skip6  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25   ;                                      ...
                  ldy #$00                                            ;                                      ...
                  lda (address1),y                                    ;                                      .X.
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                            ; czy "murek" lub "kadka"?
                  beq Anim_LetEB_skip8                                ; NIE!

; TAK! wykryto na dole "murek" lub "kadk"
                  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$03 tab_Move_Left_or_Right_or_Down_LetterEB,y                                     ; ruch w d
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_LetEB_skip7  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$01 tab_Move_Left_or_Right_or_Down_LetterEB,y                                     ; ruch w lewo
                  jmp Anim_LetEB_skipC
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; spr. czy prawy margines osignito?
Anim_LetEB_skip8  lda Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosX,y
                  cmp #$F7                                            ; czy wsp.X "LITERY" = 247?
                  beq Anim_LetEB_skip7                                ; TAK!

; NIE! wic mona przesun "LITERE" w prawo
                  add #$01
                  sta Sprite1_PosX,y
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; obsuga ruchu "LITERY" w lewo lub w d - dziki temu ruch "LITERY" zawsze w d, chyba, e "kadka" przyblokuje to ruch w lewo
Anim_LetEB_skip9  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz          X...
                  jsr address1_SBW_40bytes                           ; wczeniejszy wiersz           ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna            ...
                  jsr address1_SBW_1byte                             ; poprzednia kolumna
                  ldy #$00
                  lda (address1),y
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                           ; czy "murek" lub "kadka"?
                  bne Anim_LetEB_skipA                               ; NIE!

; TAK! "murek" lub "kadka" - czyli ruch w lewo przyblokowany
                  mva #$02 tab_Move_Left_or_Right_or_Down_LetterEB+6                                     ; ruch w prawo
                  jmp Anim_LetEB_loop1

; NIE! ruch w lewo moliwy
Anim_LetEB_skipA  jsr Calculate_address1_SPRITE_1_7_ScreenBuff40x25   ;                              ...
                  ldy #$00                                            ;                              ...
                  lda (address1),y                                    ;                              .X.
                  tax
                  lda tab_Action_for_256Chars,x
                  cmp #$01                                            ; czy "murek" lub "kadka"?
                  beq Anim_LetEB_skipC                                ; TAK! wic ruch w lewo

; NIE! ruch w d moliwy (ma on wyszy piorytet ni w lewo wic wykonaj)
                  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$03 tab_Move_Left_or_Right_or_Down_LetterEB,y                                     ; ruch w d
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Anim_LetEB_skipB  ldy Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  mva #$02 tab_Move_Left_or_Right_or_Down_LetterEB,y                                     ; ruch w prawo
                  jmp Anim_LetEB_skip8

; spr. czy lewy margines osignito?
Anim_LetEB_skipC  lda Do_Number_SPRITE_1_7                            ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  asl @
                  tay
                  lda Sprite1_PosX,y
                  cmp #$23                                            ; czy wsp.X "LITERY" = 35?
                  beq Anim_LetEB_skipB                                ; TAK! czyli osignito lewy margines

; NIE! wic mona przesun "LITERE" w lewo
                  sub #$01                                            ; -1
                  sta Sprite1_PosX,y
                  jmp Next_Clip_for_LetterP_FeelerBall_UFO

Anim_LetEB_End    mva #$0C tab_Type_SPRITES_1_7+6                              ; ustaw na animacj pojawiania si nowego przeciwnika
                  mva #$00 tab_Move_Left_or_Right_or_Down_LetterEB+6
                  sta      tab_Show_Type_Sprite1_7_After_Animation_Appearing+6 ; =0 SPRITE nie uywany
                  jmp Do_Move_skip3                                            ; powrt do ptli gwnej
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; 7 bajtowa tablica
tab_Move_Left_or_Right_or_Down_LetterEB .byte $00,$00,$00,$00,$00,$00,$00         ; =0 - wylosuj miejsce pojawienia si "LITERY", =1 - ruch w lewo, =2 - ruch w prawo, =3 - ruch w d 
tab_8th_clips_Letter_B                  .byte $7C,$7C,$7D,$7D,$7E,$7E,$7D,$7D,$00 ; 8 klatek obracajcej si litery "B", ktr moe zebra BOMB JACK!
tab_8th_clips_Letter_E                  .byte $7F,$7F,$80,$80,$7E,$7E,$80,$80,$00 ; 8 klatek obracajcej si litery "E", ktr moe zebra BOMB JACK!

3277              .byte $00 ; nie uywane???
3278              .byte $00 ; nie uywane???

;########################################################################################################################################################
; procedura oblicza w (address1) adres bajtu w ScreenBuff40x25 nad, ktrym znajduje si dany SPRITE
; SPRITE pokrywa 3x3 znaki na ekranie wic wyliczamy adres znaku "X": (patrz niej)
;     ...
;     ...
;     .X.
;########################################################################################################################################################
Calculate_address1_SPRITE_1_7_ScreenBuff40x25
                  lda Do_Number_SPRITE_1_7                       ; numer aktualnego SPRITE'a #1-#7
                  asl @                                          ; *2
                  tay
                  lda Sprite1_PosX,y                             ; pobierz wsp.X
                  sub #$0C                                       ; -12 (rysujemy na ekranie, a nie na marginesie)
                  :3 lsr @                                       ; /8 - obl. wsp.X  w bajtach...
                  tax
                  sta Sprite0_7_PosX_div_8                       ; ...i zapamitaj

                  lda Sprite1_PosY,y                             ; pobierz wsp.Y
                  sub #$1A                                       ; -26 (rysujemy na ekranie, a nie na marginesie)
                  :3 lsr a                                       ; /8 - obl. wsp.Y w bajtach...
                  sta Sprite0_7_PosY_div_8                       ; ...i zapamitaj
                  asl @                                          ; *2
                  add Sprite0_7_PosY_div_8                       ; powysze instrukcje to nic innego jak oblicznie: rej.A = wsp.Y*3
                  tay
                  mwa tab_Addr_SPRITE_ScreenBuff40x25,y address1 ; pobierz adres SPRITE'a na pozycji w ScreenBuff40x25
                  adb address1 Sprite0_7_PosX_div_8              ; dodaj wsp.X/8 do (address1) - dla aktualnego SPRITE'a
                  bcc Calc_addr_skip1

                  inc address1+1

Calc_addr_skip1   tya
                  tax
                  stx index_tab_Addr_SPRITE_ScreenBuff40x25      ; zapisz wiersz
                  rts

;########################################################################################################################################################
; animacja spadajcego przeciwnika "ASTRONAUTY" w d (np: kiedy zeskakuje z kadki)
; procka wykorzystywana take przez spadajce "LITERY E i B"
;########################################################################################################################################################
Anim_Astronaut_Jump_Down
                  lda Do_Number_SPRITE_1_7                       ; numer SPRITE'a #1-#7, ktry aktualnie obrabiamy
                  tay
                  asl @                                          ; *2
                  tax
                  sbb tab_7x_Add_Speed_Jump_Down_to_PosY,y #$01  ; -1 licznik ile razy naley doda wart. z "tab_Anim_Speed_Jump_Down" do wsp.Y "ASTRONAUTY"
                  bne Anim_Down_skip1

                  mva #$07 tab_7x_Add_Speed_Jump_Down_to_PosY,y  ; ustaw licznik od pocztku
                  lda      tab_Anim_Speed_Jump_Down,y
                  cmp #$08
                  beq Anim_Down_skip1

                  add tab_Anim_Speed_Jump_Down,y #$01            ; +1

Anim_Down_skip1   adb Sprite1_PosY,x tab_Anim_Speed_Jump_Down,y  ; dodanie do wsp.Y wartoci z jak szybkoci ma spada "ASTRONAUTA" (1-8)
                  rts

;########################################################################################################################################################
; procedura losuje jedn warto, zapamituje j, nastpnie mnoy j x2 i rwnie zapamituje
;########################################################################################################################################################
Random_Value_Value_x2
                  mva D012 Random_Value                           ; VicRaster
                  asl @                                           ; *2
                  sta      Random_Value_x2
                  beq Random_Value_Value_x2                       ; =0? jeeli tak to losuj jeszcze raz!

                  rts

;########################################################################################################################################################
; procedura losuje w rej.A losow warto (warto ta ma jeszcze wiksz przypadkow ni te losowane w procedurze wyej)
;########################################################################################################################################################
Random_Register_A lda Random_Value                                ; np: $2B,$56
                  asl @                                           ; np: $2B*2 = 56
                  rol Random_Value_x2                             ; np: $2B,$AC
                  rol Random_Value                                ; np: $56,$AC

                  lda Random_Value_x2                             ; np: rej.A=$AC
                  eor Random_Value                                ; np: rej.A eor $56 = $FA
                  adc Random_Value_x2                             ; np: $FA + $AC = $A6
                  sta Random_Value                                ; np: $A6

                  rts                                             ; np: rej.A=$A6

;########################################################################################################################################################
; procedura rysuje zielon ramk, ktra otacza ekran gry
;########################################################################################################################################################
Draw_Green_Border ldx #$27                     ;39-0 (40 kolumn)

Draw_Green_loop1  lda #$FE
                  sta ScreenBuff40x25+$0000,x  ; ramka otaczajca w pierwszym wierszu
                  sta ScreenBuff40x25+$03C0,x  ; ramka otaczajca w ostatnim wierszu
                  lda #$0D
                  sta ColorRAM40x25+$0000,x    ; atrybut dla ramki w 1-szym wierszu
                  sta ColorRAM40x25+$03C0,x    ; atrybut dla ramki w ostatnim wierszu
                  dex
                  bpl Draw_Green_loop1

                  mwa #ColorRAM40x25   address2
                  mwa #ScreenBuff40x25 address1

                  ldx #$18                     ;24-0 (25 wierszy)

Draw_Green_loop2  ldy #$00                     ; rysuje zielon ramk otaczajc z lewej strony ekranu
                  mva #$FE (address1),y
                  mva #$0D (address2),y

                  ldy #$1E                     ;30 - rys. zielon ramk z prawej strony
                  mva #$FE (address1),y
                  mva #$0D (address2),y

                  ldy #$27                     ;39 - rys. zielon ramk z prawej strony
                  mva #$FE (address1),y
                  mva #$0D (address2),y

                  adw address1 #$28            ; przejd wiersz niej
                  adw address2 #$28            ; przejd wiersz niej

                  clc
                  dex
                  bpl Draw_Green_loop2

                  rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
Random_Value            .byte $00 ; tutaj zapamitujemy losow warto...
Random_Value_x2         .byte $00 ; ...a tutaj zapamitujemy t sam warto x2

Repeat_PosY_Ground      .byte $00 ; ile razy wykona ptle modyfikujc wsp.Y BOMB JACK-a (tak, eby zlecia na ziemie lub kadk po zablokowaniu jego lotu w gr)
Offset_PosY_Ground      .byte $00 ; o ile zmodyfikowa w kolejnym przejciu ptli wsp. Y BOMB JACK-a
Sprite0_PosX            .byte $00 ; zawiera aktualn wsp.X dla SPRITE'a #0
Sprite0_PosY            .byte $00 ; zawiera aktualn wsp.Y(bity 0-7) dla SPRITE'a #0
Sprite0_7_PosX_8bit     .byte $00 ; zawiera 8-my bit wsp.X dla SPRITE'w #0 - #7
Sprite0_7_PosX_div_8    .byte $00 ; przechowuje wyliczon kolumne (wsp.X / 8) dla SPRITE #x

Is_Collision_with_LEDGE_BOMB_JACK .byte $00 ; zawiera warto 0(NIE) lub 1(TAK)

Store_Action            .byte $00 ; "kod akcji" dla kadego z 256 znakw w zestawie (np: $01 tzn. e to jest zielony margines lub kadka)
Sprite0_7_PosY_div_8    .byte $00 ; przechowuje wyliczony wiersz (wsp.Y / 8) dla SPRITE #x

Add_PosY_BOMB_JACK_Better_Jump    dta $00 ; ile naley doda do wsp.Y podczas skoku BOMB JACK-a (+5 jeeli skok tylko z FIRE, +6 jeeli skok z FIRE+UP)

Is_No_Flight_BOMB_JACK  .byte $00 ; =0 - BOMB JACK lata! / =1 - BOMB JACK nie lata!

Decrease_Value_Add_PosY_during_JUMP_BOMB_JACK dta $00 ; zmniejsza warto dodawan do wsp.Y BOMB JACK-a podczas jego skoku

Is_FIRE_Still_Pressed   .byte $00 ; =0 FIRE niewcinity, =1 FIRE wcinity i wci trzymany

Is_Set_Store_Action                  .byte $00 ; Czy zapamita kod akcji w Store_Action? =1 TAK!
count_loop1                          .byte $00 ; licznik ptli
Do_Number_SPRITE_1_7                 .byte $00 ; przechowuje, ktry SPRITE #1-#7 w danej chwili jest obsugiwany (przyjmuje wartoi: 0-6)
Counter_Move_Left_Right_Up_Down_Bird .byte $32 ; licznik ile razy przesun "PTASZKA" z ustalonym ju kierunku (jeeli licznik dojdzie do -1 to "reset" i ponowne ustalanie kierunku ruchu "PTASZKA")
Choose_Move_Up_Down_Bird             .byte $00 ; =1 ruch SPRITE'a w d,   =2 ruch w gr, =0 warto neutralna (na podstawie porwnania wsp.Y "PTASZKA" i BOMB JACKA bdzie wykonany ruch w gr lub w d)
Choose_Move_Left_Right_Bird          .byte $00 ; =1 ruch SPRITE'a w prawo, =2 ruch w lewo, =0 warto neutralna (na podstawie porwnania wsp.X "PTASZKA" i BOMB JACKA bdzie wykonany ruch w lewo lub w prawo)
Service_Bird_Every_2th_Frame         .byte $00 ; bit0 zminiany raz na 0, a raz na 1 - dziki temu obsuga "PTASZKA" jest realizowana co 2-g ramk

tab_Show_Type_Sprite1_7_After_Animation_Appearing         .byte $00,$00,$00,$00,$00,$00,$00 ; jaki typ SPRITE'a ma si pojawi po zakoczeniu animacji "POJAWIANIA SI"
tab_More_Dangerous_Opponent_for_Next_Astronauts_Transform .byte $00,$00,$00,$00,$00         ; np: $02,$02,$02,$06,$00 ($02-DRILL, $06-UFO) Typy groniejszych przeciwnikw dla kolejnych "ASTRONAUTW", ktrzy podlegaj transformacji

3390              .byte $00

;dana
Index_charset     .byte $00         ; wskanik*4 wskazuje, ktry zestaw ksztatw znakw bdzie wybrany
Char_Board1       .word $E000       ; 1KB - plansza gry #1 (ekran gry #1)
Attribute1        .word $0906       ;
                  .word $E400       ; 1KB - plansza gry #2 (ekran gry #2)
                  .word $0C06
                  .word $E800       ; 1KB - plansza gry #3 (ekran gry #3)
                  .word $0C06
                  .word $EC00       ; 1KB - plansza gry #4 (ekran gry #4)
                  .word $0C06
                  .word $F000       ; 1KB - plansza gry #5 (ekran gry #5)
                  .word $0709

tab5_char         .byte $34,$4F,$2F,$4F,$20  ; jakim znakiem wypeni pi pierwszych wierszy ekranu

Attrib_Board1     .word $A000       ; 1KB atrybutw - plansza gry #1 (ekran gry #1)
                  .word $A400       ; 1KB atrybutw - plansza gry #2 (ekran gry #2)
                  .word $F400       ; 1KB atrybutw - plansza gry #3 (ekran gry #3)
                  .word $F800       ; 1KB atrybutw - plansza gry #4 (ekran gry #4)
                  .word $FC00       ; 1KB atrybutw - plansza gry #5 (ekran gry #5)

; adresy 2KB obszarw z ksztatami znakw - kady zestaw dla jednej planszy (w sumie pi plansz mamy)
tab_addr_charsets .word $A800       ; 2 KB
                  .word $B000
                  .word $B800
                  .word $C000
                  .word $C800

; tablica zawiera adresy danych dla rysowania paskw dla poszczeglnych ekranw gry
tab_addr_char_bars
 ;          1           2           3           4           5           6           7           8           9           10
 .word adr_ledge01,adr_ledge02,adr_ledge03,adr_ledge04,adr_ledge05,adr_ledge06,adr_ledge07,adr_ledge08,adr_ledge09,adr_ledge10
 .word adr_ledge11,adr_ledge12,adr_ledge13,adr_ledge14,adr_ledge10,adr_ledge15,adr_ledge04,adr_ledge03,adr_ledge01,adr_ledge01

; tablica z adresami danych, ktre ustawiaj wszystkie sprite'y na pocztku kadej planszy
tab_parameters_for_sprites
 .dw adr_sprit01,adr_sprit02,adr_sprit03,adr_sprit04,adr_sprit05,adr_sprit06,adr_sprit07,adr_sprit08,adr_sprit09,adr_sprit10
 .dw adr_sprit11,adr_sprit12,adr_sprit13,adr_sprit14,adr_sprit05,adr_sprit15,adr_sprit02,adr_sprit01

; dane po 6-bajtw
; bajt    0 - dugo rysowanego paska (ten po ktrym skaczemy)
; bajt    1 - atrybut(kolor) paska
; bajt    2 - znak paska (zwykle $FF)
; bajt    3 - o ile przesun aby rysowa pasek na nowej pozycji (zwykle +1)
; bajty 4,5 - offset, od ktrego rysujemy pasek
adr_ledge01 dta $08,$0B,$FF,$01,a($00AF),$04,$0B,$FF,$01,a($00F7),$07,$0B,$FF,$01,a($023C),$04,$0B,$FF,$01,a($02D4),$09,$0B,$FF,$01,a($0332),$00,$00,$00,$00,a($0000) ; UWAGA! tutaj same $00 - kod wykrywa to miejsce i od pierwszej wartoci <>$00 zmienia sposb interpretowania danych z tej tablicy
adr_sprit01 dta     $01,    $0E,    $0E,    $0E,    $00,    $0B,    $00 ; typy SPRITE'w, ktre pojawi si na planszy (SPRITES #1-#7) ($01-ASTRONAUT, $0B-BIRD, $0E-??)
            dta $50,$46,$00,$00,$00,$00,$00,$00,$00,$00,$32,$46,$00,$00 ; pocztkowe wsp.X i Y dla SPRITES #1-#7
            dta     $00,    $06,    $02,    $02,    $02                 ; (typy SPRITE'w - na jakiego gorszego przeciwnika moemy si przeksztaci) przepisuje te dane w odwrotnej kolejnoci do tablicy

adr_ledge02 dta $06,$0B,$FF,$01,a($00F1),$06,$0B,$FF,$01,a($0108),$05,$0B,$FF,$01,a($01E5),$06,$0B,$FF,$01,a($01F4),$05,$0B,$FF,$01,a($02D8),$05,$0B,$FF,$01,a($02E2),$00,$00,$00,$00,a($0000)
adr_sprit02 dta     $01,    $0E,    $0E,    $0E,   $0E,     $0B,    $00
            dta $2D,$32,$2D,$32,$2A,$C8,$A0,$32,$E6,$32,$C8,$D2,$AA,$5A
            dta     $05,    $06,    $05,    $05,   $05

adr_ledge03 dta $05,$0B,$FF,$01,$CF,$00,$05,$0B,$FF,$01,$DA,$00,$05,$0B,$FF,$01,$65,$02,$05,$0B,$FF,$01,$FD,$02,$05,$0B,$FF,$01,$0D,$03,$00,$00,$00,$00,$00,$00
adr_sprit03 dta $0E,$01,$0E,$00,$0E,$0B,$00
            dta $B4,$C8,$51,$32,$2A,$C8,$A0,$D2,$B5,$32,$C8,$DC,$D2,$A0
            dta $04,$04,$06,$04,$04

adr_ledge04 dta $06,$0B,$FF,$01,$F5,$00,$06,$0B,$FF,$01,$04,$01,$06,$0B,$FF,$01,$D5,$02,$06,$0B,$FF,$01,$E4,$02,$00,$00,$00,$00,$00,$00
adr_sprit04 dta $0E,$01,$0E,$0E,$0E,$0B,$00
            dta $12,$C8,$51,$32,$2A,$C8,$A0,$32,$DC,$AA,$C8,$C8,$D2,$A0
            dta $03,$06,$03,$03,$03

adr_ledge05 dta $00,$00,$00,$00,$00,$00
adr_sprit05 dta $01,$01,$01,$01,$01,$0B,$00
            dta $B4,$64,$B4,$5A,$B4,$55,$B4,$50,$46,$46,$B4,$46,$00,$00
            dta $06,$06,$04,$04,$04

adr_ledge06 dta $08,$0B,$FF,$01,$19,$01,$06,$0B,$FF,$01,$D7,$00,$07,$0B,$FF,$01,$CC,$01,$06,$0B,$F9,$28,$F4,$01,$0E,$0B,$FF,$01,$AF,$02,$00,$00,$00,$00,$00,$00
adr_sprit06 dta $0E,$0E,$0E,$0E,$01,$0B,$00
            dta $01,$01,$01,$01,$01,$01,$01,$01,$96,$32,$D2,$50,$00,$00
            dta $02,$04,$04,$06,$06

adr_ledge07 dta $06,$0B,$FF,$01,$D5,$00,$07,$0B,$FF,$01,$96,$01,$07,$0B,$FF,$01,$A3,$01,$07,$0B,$FF,$01,$36,$02,$07,$0B,$FF,$01,$43,$02,$06,$0B,$FF,$01,$05,$03,$00,$00,$00,$00,$00,$00
adr_sprit07 dta $0E,$0E,$0E,$0E,$01,$0B,$00
            dta $01,$01,$01,$01,$01,$01,$01,$01,$96,$32,$46,$46,$00,$00
            dta $06,$02,$04,$05,$03

adr_ledge08 dta $07,$0B,$F9,$28,$AA,$00,$07,$0B,$F9,$28,$B4,$00,$07,$0B,$F9,$28,$3A,$02,$07,$0B,$F9,$28,$44,$02,$07,$0B,$FF,$01,$94,$01,$07,$0B,$FF,$01,$A4,$01,$07,$0B,$FF,$01,$34,$02,$07,$0B,$FF,$01,$44,$02,$00,$00,$00,$00,$00,$00
adr_sprit08 dta $01,$0E,$0E,$0E,$01,$0B,$00
            dta $46,$32,$01,$01,$01,$01,$01,$01,$DC,$32,$BE,$C8,$00,$00
            dta $03,$03,$05,$05,$03

adr_ledge09 dta $04,$0B,$FF,$01,$AF,$00,$03,$0B,$F9,$28,$D7,$00,$05,$0B,$FF,$01,$4F,$01,$07,$0B,$FF,$01,$ED,$01,$03,$0B,$F9,$28,$18,$02,$04,$0B,$FF,$01,$90,$02,$0E,$0B,$FF,$01,$26,$03,$00,$00,$00,$00,$00,$00
adr_sprit09 dta $01,$0E,$0E,$0E,$0E,$0B,$00
            dta $96,$32,$01,$01,$01,$01,$01,$01,$01,$01,$DC,$32,$00,$00
            dta $06,$06,$02,$04,$03

adr_ledge10 dta $00,$00,$00,$00,$00,$00
adr_sprit10 dta $01,$01,$01,$01,$01,$0B,$00
            dta $32,$32,$50,$32,$6E,$32,$8C,$32,$AA,$32,$C8,$32,$00,$00
            dta $06,$06,$05,$04,$04

adr_ledge11 dta $08,$0B,$FF,$01,$CE,$00,$06,$0B,$FF,$01,$DB,$00,$0C,$0B,$F9,$28,$F6,$00,$0C,$0B,$F9,$28,$08,$01,$05,$0B,$FF,$01,$D6,$02,$0A,$0B,$FF,$01,$DF,$02,$00,$00,$00,$00,$00,$00
adr_sprit11 dta $01,$0E,$0E,$0E,$0E,$0B,$00
            dta $50,$32,$01,$01,$01,$01,$01,$01,$01,$01,$C8,$C8,$00,$00
            dta $06,$06,$05,$05,$02

adr_ledge12 dta $05,$0B,$FF,$01,$19,$01,$05,$0B,$FF,$01,$09,$02,$05,$0B,$FF,$01,$F9,$02,$05,$0B,$FF,$01,$E1,$00,$05,$0B,$FF,$01,$D1,$01,$05,$0B,$FF,$01,$C1,$02,$00,$00,$00,$00,$00,$00
adr_sprit12 dta $01,$01,$0E,$0E,$0E,$0B,$00
            dta $50,$32,$DC,$32,$01,$01,$01,$01,$01,$01,$C8,$C8,$00,$00
            dta $06,$03,$04,$04,$03

adr_ledge13 dta $03,$0B,$FF,$01,$AA,$00,$03,$0B,$FF,$01,$B2,$00,$05,$0B,$F9,$28,$F5,$00,$05,$0B,$F9,$28,$35,$02,$05,$0B,$F9,$28,$09,$01,$05,$0B,$F9,$28,$49,$02,$05,$0B,$FF,$01,$75,$01,$05,$0B,$FF,$01,$8D,$02,$04,$0B,$FF,$01,$29,$03,$04,$0B,$FF,$01,$32,$03,$03,$0B,$F9,$28,$C1,$01,$03,$0B,$F9,$28,$CD,$01,$00,$00,$00,$00,$00,$00
adr_sprit13 dta $01,$0E,$0E,$0E,$0E,$0B,$00
            dta $96,$50,$01,$01,$01,$01,$01,$01,$01,$01,$C8,$C8,$01,$01
            dta $06,$06,$06,$04,$04

adr_ledge14 dta $13,$0B,$FF,$01,$F6,$00,$0B,$0B,$F9,$28,$1E,$01,$0B,$0B,$F9,$28,$30,$01,$05,$0B,$FF,$01,$04,$03,$00,$00,$00,$00,$00,$00
adr_sprit14 dta $01,$0E,$0E,$0E,$0E,$0B,$00,$50,$32,$01,$01,$01,$01,$01,$01,$01,$01,$C8,$46,$01,$01,$06,$04,$04,$05,$02

adr_ledge15 dta $09,$0B,$FF,$01,$A5,$00,$06,$0B,$F9,$28,$CD,$00,$09,$0B,$FF,$01,$BD,$01,$07,$0B,$F9,$28,$42,$02,$07,$0B,$F9,$28,$47,$02,$04,$0B,$FF,$01,$BB,$02,$00,$00,$00,$00,$00,$00
adr_sprit15 dta $01,$0E,$0E,$0E,$0E,$0B,$00
            dta $50,$32,$01,$01,$01,$01,$01,$01,$01,$01,$C8,$D2,$01,$01
            dta $06,$06,$06,$04,$04

Count_Char_Bar    .byte $00   ; zlicza o jakiej dugoci ma by pasek
Attrib_Char_Bar   .byte $00   ; przechowuje atrybut(kolor) jakim narysujemy pasek
Char_Bar          .byte $00   ; przechowuje kod znaku paska (zwykle $FF)
Pos_Char_Bar      .byte $00   ; warto, ktr si dodaje w celu obliczenia nastpnej pozycji paska (po ktrych skacze BOMB JACK)
Offset_Char_Bar   .word $0000 ; offset, od ktrego bdziemy rysowa pasek (do tego dodajemy ScreenBuff40x25 lub ColorRAM40x25, eby mie peny adres)

index_tab4clips_Move_BOMB_JACK     .byte $00                 ; wskazuje na kolejn klatk, ktr naley pobra, aby uzyska ruch BOMB JACK-a w prawo lub w lewo (na 4-rech klatkach)
tab_4clips_Move_BOMB_JACK_Left     .byte $B6,$B7,$B8,$B9,$00 ; 4-ry klatki animacji ruchu BOMB JACKA w lewo (pierwsza pod $6D80)
tab_4clips_Move_BOMB_JACK_Right    .byte $B2,$B3,$B4,$B5,$00 ; 4-ry klatki animacji ruchu BOMB JACKA w prawo (pierwsza pod $6C80)
Delay_Move_BOMB_JACK_Left_or_Right .byte $00                 ; (wartoci $00-$03) opnienie pomidzy kolejnymi klatkach wywietlanymi dla uzyskania ruchu w prawo lub w lewo

; tablica zawiera adresy dla SPRITE'w #1-#7 (aby obliczy adres naley: warto*64+$4000)
tab_Addr_SPRITE_Pattern                  .byte $A9,$00,$A9,$00,$A9,$00,$00     ; $A9 - klatka ze spadajcym BOMB JACK-iem
tab_7th_clips_New_Opponent_Appear        .byte $99,$98,$99,$98,$98,$97,$98,$00 ; kolejne klatki pojawiajce si przed pokazaniem si nowego przeciwnika($97-"kko",$98-"trafienie",$99-"dymek")
tab_Every_Fourth_Frame_Astronaut_Sprite  .byte $00,$00,$00,$00,$00,$00,$00     ; $00-$04 - zlicza do 4-rech (SPRITES #1-#7) - dziki temu rysujemy "ASTRONAUTE" co 4-t ramk
tab_Every_Third_Frame_Move_Sprite        .byte $00,$00,$00,$00,$00,$00,$00     ; $00-$03 - zlicza do 3-ch (SPRITES #1-#7) - dziki temu rysujemy "WIDEREKA lub KUL lub LITERE PEB lub UFO lub BUKE" co 3-ci ramk
tab_Every_Third_Frame_Move_Bird_Sprite   .byte $00,$00,$00,$00,$00,$00,$00     ; $00-$03 - zlicza do 3-ch (SPRITES #1-#7) - dziki temu rysujemy "PTASZKA" co 3-ci ramk

; nie uywane???
37FB 00           brk
37FC 00           brk
37FD 00           brk
37FE 00           brk
37FF 00           brk
3800 00           brk

tab_Every_Second_Frame_New_Appear_Sprite                  .byte $00,$00,$00,$00,$00,$00,$00 ; $00-$02 - zlicza do 2-ch (SPRITES #1-#7) - dziki temu rysujemy "POJAWIANIE SI NOWEGO PRZECIWNIKA" co 2-g ramk
tab_4th_clips_Move_Opponent_Astronaut_Left                .byte $8D,$8E,$8F,$90,$00         ; 4-ry klatki z animacj przeciwnika "KOSMONAUTY" - ruch w lewo (*64+$4000) (na kocu $00, eby wiedzie, e to koniec tablicy)
tab_4th_clips_Move_Opponent_Astronaut_Right               .byte $89,$8A,$8B,$8C,$00         ; 4-ry klatki z animacj przeciwnika "KOSMONAUTY" - ruch w prawo (*64+$4000) (na kocu $00, eby wiedzie, e to koniec tablicy)
index_tab_4th_clips_Move_Opponent_Astronaut_Left_or_Right .byte $00,$00,$00,$00,$00,$00,$00 ; tablica dla SPRITE'w #1-#7 - zawiera wskanik na klatk z dwch powyszych tablic!
index_tab_clips_Move_Opponent                             .byte $00,$00,$00,$00,$00,$00,$00 ; wskanik na kolejn klatk, aby przesun SPRITE #1-#7
index_tab_clips_Move_Bird                                 .byte $00,$00,$00,$00,$00,$00,$00 ; wskanik na kolejn klatk, aby przesun "PTAKA" (SPRITE #1-#7)

; nie uywane???
3821 00           brk
3822 00           brk
3823 00           brk
3824 00           brk
3825 00           brk
3826 00           brk

index_tab_7th_clips_New_Opponent_Appear                   .byte $00,$00,$00,$00,$00,$00,$00 ; tablica dla SPRITE'w #1-#7 - zawiera wskanik na klatk z tablicy "tab_7th_clips_New_Opponent_Appear"
;--------------------------------------------------------------------------------------------------------------------------------------------------------
tab_6th_clips_Move_Opponent_Square_Ball  .byte $60,$61,$62,$63,$64,$65,$00         ; 6 klatek animacyjnych przesuwajcej si w lewo lub prawo "KULI Z KWADRATOWYMI OKNAMI"
tab_3th_clips_Move_Opponent_Dot_Ball     .byte $66,$67,$68,$00                     ; 3 klatki animacyjne przesuwajcej si w lewo lub prawo "KULI Z KROPKAMI"
tab_5th_clips_Move_Opponent_Smiling_Face .byte $81,$82,$83,$84,$85,$00             ; 5 klatek animacyjnych "UMIECHNITEJ BUZI" - pojawiaj si one w miejscu przeciwnikw jeeli BOMB JACK zbierze litere P!
tab_6th_clips_Move_Opponent_Bird_Up_Down .byte $86,$87,$88,$88,$87,$86,$00         ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w gr lub d" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Opponent_Bird_Left    .byte $75,$76,$77,$77,$76,$75,$00         ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w lewo" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Opponent_Bird_Right   .byte $6A,$6B,$6C,$6C,$6B,$6A,$00         ; 6 klatek animacyjnych "PTAKA przemieszczajcego si w prawo" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_6th_clips_Move_Letter_P              .byte $94,$94,$95,$95,$96,$96,$00         ; 6 klatek animacyjnych "LITERY P" - w sumie klatek jest tylko 3, ale powtarzaj si!
tab_8th_clips_Move_Opponent_Feeler_Ball  .byte $78,$79,$7A,$7B,$78,$79,$7A,$7B,$00 ; 8 klatek animacyjnych "KULI Z CZUKAMI"
tab_4th_clips_Move_Opponent_Drill_Left   .byte $6D,$6E,$6F,$70,$00                 ; 4-ry klatki animacyjne "WIDERKA" przesuwajcego si w lewo
tab_8th_clips_Move_Opponent_Drill_Right  .byte $71,$72,$73,$74,$71,$72,$73,$74,$00 ; 8 klatek animacyjnych "WIDERKA" przesuwajcego si w prawo
tab_6th_clips_Move_Opponent_UFO          .byte $A4,$A5,$A6,$A4,$A5,$A6,$00         ; 6 klatek animacyjnych "SPODKA"
tab_Is_Sprite1_7_on_Screen               .byte $00,$00,$00,$00,$00,$00,$00         ; =0 SPRITE #1-#7 nie jest jeszcze narysowany na ekranie, =1 jest ju
tab_Type_SPRITES_1_7                     .byte $00,$00,$00,$00,$00,$00,$00         ; tablica zawiera jaki typ duszka(np: "WIDEREK") jest wywietlany na SPRITE'ach #1-#7 (UWAGA: jeeli na pozycji jest $00 to oznacza, e ten SPRITE nie jest wywietlany aktualnie)

; wsprzdne X i Y dla SPRITE'w #1 - #7
Sprite1_PosX      .byte $32
Sprite1_PosY      .byte $32

                  .byte $46 ; Sprite2_PosX
                  .byte $32 ; Sprite2_PosY

                  .byte $5A ; Sprite3_PosX
                  .byte $32 ; Sprite3_PosY

                  .byte $6E ; Sprite4_PosX
                  .byte $32 ; Sprite4_PosY

                  .byte $82 ; Sprite5_PosX
                  .byte $32 ; Sprite5_PosY

                  .byte $C3 ; Sprite6_PosX
                  .byte $32 ; Sprite6_PosY

                  .byte $EB ; Sprite7_PosX
                  .byte $32 ; Sprite7_PosY

tab_Is_Astronaut_Move_Left_or_Right_or_Stand .byte $00,$00,$00,$00,$00,$00,$00 ; Czy "ASTRONAUTA" przesuwa si aktualnie w lewo(=2), prawo(=1) czy stoi(=0) w miejscu?
bits0_1_Right_Down                           .byte $03,$02,$03,$02,$03,$02,$03 ; bit0=1 spr. z prawej strony SPRITE'a, bit1=1 spr. z dolnej strony SPRITE'a
tab_Is_Change_PosX_or_PosY_Bird              .byte $00,$00,$00,$00,$00,$00,$00 ; =1 zmieniaj wsp.X "PTASZKA", =0 zmieniaj wsp.Y "PTASZKA"
tab_7x_Add_Speed_Jump_Down_to_PosY           .byte $07,$07,$07,$07,$07,$07,$07 ; licznik ile razy trzeba jeszcze doda warto z "tab_Anim_Speed_Jump_Down" do wsp.Y "ASTRONAUTY"
tab_Anim_Speed_Jump_Down                     .byte $00,$00,$00,$00,$00,$00,$00 ; warto od 1-8 dodawana do wsp.X SPRITE'a #1-#7 - wskazuje jak szybko ma spada w d "ASTRONAUTA"

; tablica ze znakami definiujcymi BOMBY
tab_bombs         .byte $ED,$EE  ; grne bajty BOMBY - pojawiaj si na niebie
                  .byte $EF,$F0  ; dolne bajty BOMBY

                  .byte $F1,$F2  ; grne bajty BOMBY - pojawiaj si na planszy
                  .byte $F3,$F4  ; dolne bajty BOMBY

                  .byte $F5,$F6  ; grne bajty BOMBY - pojawiaj si na planszy
                  .byte $F7,$F8  ; dolne bajty BOMBY

BOMB              .byte 0,0      ; cztery znaki BOMBY
                  .byte 0,0

Count_Bomb        .byte 0        ; licznik zliczajcy ile BOMB narysowa
Pos_Bomb          .byte 0        ; ile doda do pozycji X lub Y dla narysowania nastpnej BOMBY

; tablica z adresami danych ze zdefiniowanymi ukadami BOMB dla kolejnych ekranw
tab_pos_bombs_on_screens
                  .word Bombs_screen1,Bombs_screen2,Bombs_screen3,Bombs_screen4,Bombs_screen5
                  .word Bombs_screen6,Bombs_screen7,Bombs_screen8,Bombs_screen9,Bombs_screenA
                  .word Bombs_screenB,Bombs_screenC,Bombs_screenD,Bombs_screenE,Bombs_screen2
                  .word Bombs_screenF,Bombs_screen2,Bombs_screen3,Bombs_screen1,Bombs_screen1
                  .word Bombs_screen1

; dane do rozrysowania ukadu BOMB na 1-szym ekranie
; pierwszy bajt - $00-$02 wskazuje pozycje w tablicy tab_bombs (4-ry znaki rozrysowujce BOMB)
; drugi bajt    - ile naley doda do pozycji X (lub Y) aby narysowa kolejn BOMB w danym wierszu (kolumnie)
; trzeci bajt   - ile BOMB naley narysowa w wierszu
; 4,5 bajt      - przesunicie wzgldem ScreenBuff40x25 lub ColorRAM gdzie zaczynamy rysowa BOMBY
Bombs_screen1 dta $00,$03,$03,a($002C),$00,$03,$03,a($003E),$00,$03,$04,a($00D5),$00,$78,$04,a($0141),$00,$78,$04,a($015C),$02,$03,$03,a($0373),$02,$03,$03,a($02E2),$FF
Bombs_screen2 dta $00,$03,$03,a($0033),$00,$03,$03,a($0079),$00,$03,$03,a($008D),$01,$03,$03,a($00FB),$01,$03,$03,a($0194),$01,$03,$03,a($01A2),$02,$03,$03,a($0285),$02,$03,$03,a($0291),$FF
Bombs_screen3 dta $00,$03,$02,a($0029),$00,$03,$02,a($0041),$00,$03,$02,a($007F),$00,$03,$02,a($008A),$02,$78,$03,a($0122),$00,$78,$03,a($012A),$00,$03,$03,a($02A9),$02,$03,$03,a($02BE),$01,$04,$02,a($0376),$02,$04,$02,a($0382),$FF
Bombs_screen4 dta $00,$03,$03,a($00A2),$00,$03,$03,a($0192),$01,$03,$03,a($0282),$00,$03,$03,a($0372),$00,$03,$03,a($00B5),$00,$03,$03,a($01A5),$01,$03,$03,a($0295),$00,$03,$03,a($0385),$FF
Bombs_screen5 dta $00,$78,$06,a($007C),$00,$78,$06,a($0083),$00,$78,$06,a($008A),$00,$78,$06,a($0091),$FF
Bombs_screen6 dta $00,$03,$02,a($0029),$00,$03,$02,a($0087),$00,$03,$02,a($0041),$01,$03,$02,a($0169),$02,$78,$04,a($01E1),$02,$03,$02,a($02D6),$02,$03,$03,a($02DE),$00,$03,$03,a($017E),$00,78,$04,a($01FC),$FF
Bombs_screen7 dta $00,$03,$03,a($007D),$00,$03,$03,a($008C),$02,$03,$03,a($01E5),$02,$03,$03,a($01F3),$02,$78,$03,a($0281),$02,$78,$03,a($028B),$02,$78,$03,a($0293),$02,$78,$03,a($029C),$FF
Bombs_screen8 dta $00,$78,$03,a($0054),$00,$78,$03,a($005B),$00,$78,$03,a($0062),$00,$78,$03,a($0069),$00,$03,$03,a($01E2),$00,$03,$03,a($01F5),$02,$78,$03,a($0260),$00,$78,$03,a($026D),$FF
Bombs_screen9 dta $00,$03,$03,a($003D),$01,$78,$03,a($00CC),$01,$78,$03,a($00D0),$00,$03,$03,a($0156),$01,$03,$03,a($0244),$01,$03,$03,a($02D4),$00,$50,$03,a($02E7),$00,$50,$03,a($02EC),$FF
Bombs_screenA dta $00,$03,$03,a($002B),$00,$03,$03,a($003C),$00,$03,$04,a($00FE),$00,$78,$04,a($015C),$00,$78,$04,a($0141),$00,$03,$03,a($0307),$00,$03,$03,a($0371),$FF
Bombs_screenB dta $00,$78,$03,a($002C),$00,$78,$03,a($0041),$02,$78,$03,a($00F7),$00,$78,$03,a($0089),$02,$78,$03,a($01A6),$02,$78,$03,a($023B),$02,$78,$03,a($0281),$00,$78,$03,a($029C),$FF
Bombs_screenC dta $00,$50,$03,a($0029),$00,$03,$03,a($003E),$01,$03,$03,a($00D5),$00,$78,$03,a($0144),$00,$78,$02,a($010C),$02,$78,$04,a($0181),$02,$50,$03,a($02EC),$02,$03,$03,a($0371),$FF
Bombs_screenD dta $00,$03,$03,a($002D),$00,$03,$03,a($003B),$00,$78,$03,a($0141),$00,$78,$03,a($015C),$00,$78,$03,a($00CF),$00,$78,$03,a($00DE),$02,$50,$03,a($023B),$00,$50,$03,a($0242),$FF
Bombs_screenE dta $01,$03,$03,a($00A4),$00,$03,$03,a($00B3),$00,$78,$03,a($0141),$02,$78,$03,a($015C),$02,$78,$03,a($019B),$00,$78,$03,a($01A1),$00,$78,$03,a($0284),$00,$78,$03,a($0299),$FF
Bombs_screenF dta $00,$03,$06,a($0029),$00,$03,$03,a($00CE),$00,$03,$02,a($016E),$00,$78,$04,a($00BC),$00,$03,$03,a($00FF),$00,$03,$06,a($0378),$FF

; tablica zawiera "kod akcji" dla wszystkich 256 znakw uywanych w zestawie (dla ekranu z polem gry)
; $01 - oznacza, e ten znak na ekranie to zielona ramka(otaczajca pole gry) lub kadka, po ktrej skacze BOMB JACK
; $02 -  lewy grny rg BOMB-y do zebrania
; $03 - prawy grny rg BOMB-y do zebrania
; $04 -  lewy dolny rg BOMB-y do zebrania
; $05 - prawy dolny rg BOMB-y do zebrania
tab_Action_for_256Chars
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
                  .db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$02,$03,$04
                  .db $05,$02,$03,$04,$05,$02,$03,$04,$05,$01,$01,$01,$01,$01,$01,$01

index_tab_Addr_SPRITE_ScreenBuff40x25 .byte $00    ; wskanik do tablicy "tab_Addr_SPRITE_ScreenBuff40x25"
                                                   ; bajty 0,1: adres pozycji na ekranie jeeli wiersz=0
                                                   ;    bajt 2: wsp.Y dla wiersza=0
                                                   ; bajty 3,4: powtrka od pocztku! patrz bajty 0,1

3C43 00           brk         ; nigdzie nie wykorzystywane???
3C44 00           brk         ; nigdzie nie wykorzystywane???

StoreA_address1   .word $0000 ; zapamituje do pniejszego odtworzenia (address1)

3C47 00           brk
3C48 00           brk 
3C49 00           brk
3C4A 00           brk
3C4B 00           brk
3C4C 00           brk 
3C4D 00           brk
3C4E 00           brk
3C4F 00           brk
3C50 00           brk 
3C51 00           brk 
3C52 00           brk
3C53 00           brk
3C54 00           brk
3C55 00           brk
3C56 00           brk
3C57 00           brk
3C58 00           brk
3C59 00           brk
3C5A 00           brk
3C5B 00           brk
3C5C 00           brk
3C5D 00           brk
3C5E 00           brk

; data
Counter_Blink_BOMBS        .byte $00 ; licznik zebranych migajcych BOMB 
count_draw                 .byte $00 ; licznik narysowanych BOMB na planszy

3C61 00           brk

Is_Blink_BOMB              .byte $00 ; =0 nie naley miga BOMB-, <>0 naley miga BOMB-

3C63 00           brk
Store_Sprite1_PosY                                             .byte $00 ; zmienna tymczasowa dla zapamitania i pniejszego odtworzenia "Sprite1_PosY"
Opposite_Direction_Move_New_Apper_Astronaut_than_Old_Astronaut .byte $00 ; w lewo(=2) czy w prawo(=1)? ma si zacz przesuwa nowy "ASTRONAUTA", ktry si pojawi
Store_Do_Number_SPRITE_1_7                                     .byte $00 ; zmienna tymczasowa dla zapamitania i pniejszego odtworzenia "Do_Number_SPRITE_1_7"
Is_New_Astronaut_Appear                                        .byte $00 ; =1 pojawi si nowy przeciwnik "ASTRONAUTA", =0 nie pojawi si nowy przeciwnik (bo np: ju max. liczba przeciwnikw na ekranie)

; tablica z gotowymi (bezwzgldnymi) adresami, kolejnych wierszy ScreenBuff40x25 w zalenoci od wsp.Y SPRITE'a ...
; ...oraz pozycj Y dla SPRITE'a, eby znalaz si pod tym adresem na ekranie (+wsp. X)
; czyli adres nastpny jest co 3bajty!!! ($5000,$1C,$5028,$24,$5050,$2C,$5078 itd.)
tab_Addr_SPRITE_ScreenBuff40x25
 .db $00,$50,$1C,$28,$50,$24,$50,$50,$2C,$78,$50,$34,$A0,$50,$3C,$C8,$50,$44,$F0,$50,$4C,$18,$51,$54,$40,$51,$5C,$68,$51,$64,$90,$51,$6C,$B8,$51,$74,$E0
 .db $51,$7C,$08,$52,$84,$30,$52,$8C,$58,$52,$94,$80,$52,$9C,$A8,$52,$A4,$D0,$52,$AC,$F8,$52,$B4,$20,$53,$BC,$48,$53,$C4,$70,$53,$CC,$98,$53,$D4,$C0,$53
 .db $DC,$E8,$53,$DC

Text_Scroll1 ;+$0D trzeba doda  "WELCOME TO ..."
3CB6 56 17        lsr 17,x
3CB8 05 0C        ora 0C
3CBA 03 0F        slo (0F,x)
3CBC 0D 05 56     ora 5605
3CBF 14 0F        nop 0F,x
3CC1 56 14        lsr 14,x
3CC3 08           php
3CC4 05 56        ora 56
3CC6 21 1F        and (1F,x)
3CC8 56 16        lsr 16,x
3CCA 05 12        ora 12
3CCC 13 09        slo (09),y
3CCE 0F 0E 56     slo 560E
3CD1 0F 06 56     slo 5606
3CD4 14 08        nop 08,x
3CD6 05 56        ora 56
3CD8 14 05        nop 05,x
3CDA 0B 08        anc #08
3CDC 01 0E        ora (0E,x)
3CDE 56 01        lsr 01,x
3CE0 12           kil
3CE1 03 01        slo (01,x)
3CE3 04 05        nop 05
3CE5 56 07        lsr 07,x
3CE7 01 0D        ora (0D,x)
3CE9 05 56        ora 56
3CEB 02           kil
3CEC 0F 0D 02     slo 020D
3CEF 0A           asl a
3CF0 01 03        ora (03,x)
3CF2 0B 56        anc #56
3CF4 56 56        lsr 56,x
3CF6 56 56        lsr 56,x
3CF8 56 56        lsr 56,x
3CFA 56 56        lsr 56,x
3CFC 56 56        lsr 56,x
3CFE 03 0F        slo (0F,x)
3D00 04 05        nop 05
3D02 04 56        nop 56
3D04 02           kil
3D05 19 56 03     ora 0356,y
3D08 08           php
3D09 12           kil
3D0A 09 13        ora #13
3D0C 56 08        lsr 08,x
3D0E 01 12        ora (12,x)
3D10 16 05        asl 05,x
3D12 19 56 56     ora 5656,y
3D15 56 14        lsr 14,x
3D17 08           php
3D18 01 0E        ora (0E,x)
3D1A 0B 13        anc #13
3D1C 56 14        lsr 14,x
3D1E 0F 56 12     slo 1256
3D21 0F 12 19     slo 1912
3D24 56 07        lsr 07,x
3D26 12           kil
3D27 05 05        ora 05
3D29 0E 56 06     asl 0656
3D2C 0F 12 56     slo 5612
3D2F 14 08        nop 08,x
3D31 05 56        ora 56
3D33 07 12        slo 12
3D35 01 10        ora (10,x)
3D37 08           php
3D38 09 03        ora #03
3D3A 13 56        slo (56),y
3D3C 56 56        lsr 56,x
3D3E 56 56        lsr 56,x
3D40 56 56        lsr 56,x
3D42 56 01        lsr 01,x
3D44 0E 04 56     asl 5604
3D47 14 0F        nop 0F,x
3D49 56 0D        lsr 0D,x
3D4B 01 12        ora (12,x)
3D4D 0B 56        anc #56
3D4F 03 0F        slo (0F,x)
3D51 0F 0B 13     slo 130B
3D54 05 19        ora 19
3D56 56 06        lsr 06,x
3D58 0F 12 56     slo 5612
3D5B 14 08        nop 08,x
3D5D 05 56        ora 56
3D5F 0D 15 13     ora 1315
3D62 09 03        ora #03
3D64 56 56        lsr 56,x
3D66 56 56        lsr 56,x
3D68 56 56        lsr 56,x
3D6A 56 56        lsr 56,x
3D6C 01 0C        ora (0C,x)
3D6E 13 0F        slo (0F),y
3D70 56 14        lsr 14,x
3D72 0F 56 07     slo 0756
3D75 01 16        ora (16,x)
3D77 09 0E        ora #0E
3D79 56 08        lsr 08,x
3D7B 01 12        ora (12,x)
3D7D 16 05        asl 05,x
3D7F 19 56 01     ora 0156,y
3D82 0E 04 56     asl 5604
3D85 03 0C        slo (0C,x)
3D87 01 12        ora (12,x)
3D89 05 56        ora 56
3D8B 10 0F        bpl 3D9C
3D8D 0D 05 12     ora 1205
3D90 0F 19 56     slo 5619
3D93 06 0F        asl 0F
3D95 12           kil
3D96 56 01        lsr 01,x
3D98 0C 0C 56     nop 560C
3D9B 14 08        nop 08,x
3D9D 05 09        ora 09
3D9F 12           kil
3DA0 56 08        lsr 08,x
3DA2 05 0C        ora 0C
3DA4 10 56        bpl 3DFC
3DA6 56 56        lsr 56,x
3DA8 56 56        lsr 56,x
3DAA 56 56        lsr 56,x
3DAC 56 FF        lsr FF,x

; 19*2=38 bajtw - kolejne adresy dla kolejnych plansz gry (jak wida w sumie, aby przejcia BOMB JACK-a naley ukoczy 19 plansz)
; zawiera adresy do tablic(dla kadej planszy osobna) gdzie s przechowywane wskaniki na podstawie, ktrych mona wyliczy lewy grny rg kolejnej BOMBY, ktra ma miga
tab_Address_Next_Blink_Bomb_BOARD
                  .word Pointer_Address_Next_Blink_Bomb_BOARD_01,Pointer_Address_Next_Blink_Bomb_BOARD_02,Pointer_Address_Next_Blink_Bomb_BOARD_03,Pointer_Address_Next_Blink_Bomb_BOARD_04,Pointer_Address_Next_Blink_Bomb_BOARD_05
                  .word Pointer_Address_Next_Blink_Bomb_BOARD_06,Pointer_Address_Next_Blink_Bomb_BOARD_07,Pointer_Address_Next_Blink_Bomb_BOARD_08,Pointer_Address_Next_Blink_Bomb_BOARD_09,Pointer_Address_Next_Blink_Bomb_BOARD_0A
                  .word Pointer_Address_Next_Blink_Bomb_BOARD_0B,Pointer_Address_Next_Blink_Bomb_BOARD_0C,Pointer_Address_Next_Blink_Bomb_BOARD_0D,Pointer_Address_Next_Blink_Bomb_BOARD_0E,Pointer_Address_Next_Blink_Bomb_BOARD_02
                  .word Pointer_Address_Next_Blink_Bomb_BOARD_0F,Pointer_Address_Next_Blink_Bomb_BOARD_02,Pointer_Address_Next_Blink_Bomb_BOARD_03,Pointer_Address_Next_Blink_Bomb_BOARD_04

; tablica 24 bajtowa (bo do zebrania na kadej planszy s 24 BOMB-y)
; te wartoci s zapisywane w odpowiedniej pozycji tablicy tab_Screen_BOMB+1
; warto_z_poniszej_tablicy * 2 + ScreenText40x25 - w ten sposb obliczamy offset(powikszony o $0400) lewego grnego rogu kolejnej BOMB-y, ktra bdzie miga
Pointer_Address_Next_Blink_Bomb_BOARD_01 dta $01,$02,$17,$06,$03,$04,$07,$08,$09,$0E,$0B,$0C,$0D,$00,$0F,$10,$11,$0A,$05,$12,$13,$14,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_02 dta $03,$00,$01,$04,$05,$0C,$07,$08,$0B,$02,$09,$0A,$0D,$0E,$12,$10,$11,$06,$13,$14,$15,$16,$17,$0F
Pointer_Address_Next_Blink_Bomb_BOARD_03 dta $14,$00,$03,$05,$01,$04,$07,$02,$0B,$08,$09,$0C,$0D,$11,$0F,$10,$0A,$12,$13,$06,$15,$16,$17,$0E
Pointer_Address_Next_Blink_Bomb_BOARD_04 dta $0B,$00,$01,$0C,$03,$04,$0F,$06,$07,$15,$09,$0A,$0D,$0E,$02,$10,$11,$05,$13,$14,$08,$16,$17,$12
Pointer_Address_Next_Blink_Bomb_BOARD_05 dta $01,$02,$03,$04,$05,$0F,$07,$08,$12,$0A,$0B,$00,$0D,$0E,$09,$10,$11,$06,$13,$14,$15,$16,$17,$0C
Pointer_Address_Next_Blink_Bomb_BOARD_06 dta $04,$00,$01,$02,$05,$07,$08,$06,$09,$0A,$0B,$17,$03,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_07 dta $01,$02,$03,$04,$05,$15,$0C,$06,$07,$0A,$0B,$0F,$0D,$0E,$00,$10,$11,$08,$13,$14,$09,$16,$17,$12
Pointer_Address_Next_Blink_Bomb_BOARD_08 dta $01,$02,$09,$04,$05,$00,$07,$08,$17,$0A,$0B,$06,$14,$0C,$0D,$0E,$0F,$10,$03,$12,$13,$11,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_09 dta $08,$00,$01,$04,$05,$0F,$03,$06,$07,$15,$09,$0A,$0D,$0E,$12,$10,$11,$0C,$13,$14,$0B,$16,$17,$02
Pointer_Address_Next_Blink_Bomb_BOARD_0A dta $01,$02,$14,$06,$03,$04,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$00,$17,$12,$13,$05,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0B dta $01,$02,$12,$04,$05,$09,$07,$08,$0F,$0A,$0B,$00,$0D,$0E,$06,$10,$11,$03,$13,$14,$17,$0C,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0C dta $01,$02,$09,$04,$05,$0E,$00,$06,$07,$0A,$0B,$0F,$08,$0C,$0D,$10,$11,$12,$13,$14,$17,$03,$15,$16
Pointer_Address_Next_Blink_Bomb_BOARD_0D dta $06,$00,$01,$15,$03,$04,$07,$08,$0F,$0A,$0B,$02,$09,$0C,$0D,$10,$11,$12,$13,$14,$05,$16,$17,$0E
Pointer_Address_Next_Blink_Bomb_BOARD_0E dta $09,$00,$01,$04,$05,$06,$07,$08,$12,$0A,$0B,$15,$0D,$0E,$03,$0C,$0F,$10,$13,$14,$02,$16,$17,$11
Pointer_Address_Next_Blink_Bomb_BOARD_0F dta $01,$02,$03,$04,$05,$06,$07,$08,$09,$0A,$0B,$0C,$0D,$0E,$0F,$10,$11,$12,$13,$14,$15,$16,$17,$00
;--------------------------------------------------------------------------------------------------------------------------------------------------------
3F3C 00           brk
3F3D FF 00 FF     isc FF00,x
3F40 00           brk
3F41 FF 00 FF     isc FF00,x
3F44 00           brk
3F45 FF 00 FF     isc FF00,x
3F48 00           brk
3F49 FF 00 FF     isc FF00,x
3F4C 00           brk
3F4D FF 00 FF     isc FF00,x
3F50 00           brk
3F51 FF 00 FF     isc FF00,x
3F54 00           brk
3F55 FF 00 FF     isc FF00,x
3F58 00           brk
3F59 FF 00 FF     isc FF00,x
3F5C 00           brk
3F5D FF 00 FF     isc FF00,x
3F60 00           brk
3F61 FF 00 FF     isc FF00,x
3F64 00           brk
3F65 FF 00 FF     isc FF00,x
3F68 00           brk
3F69 FF 00 FF     isc FF00,x
3F6C 00           brk
3F6D FF 00 FF     isc FF00,x
3F70 00           brk
3F71 FF 00 FF     isc FF00,x
3F74 00           brk
3F75 FF 00 FF     isc FF00,x
3F78 00           brk 
3F79 FF 00 FF     isc FF00,x
3F7C 00           brk
3F7D FF 00 FF     isc FF00,x
3F80 00           brk 
3F81 FF 00 FF     isc FF00,x
3F84 00           brk
3F85 FF 00 FF     isc FF00,x
3F88 00           brk 
3F89 FF 00 FF     isc FF00,x
3F8C 00           brk
3F8D FF 00 FF     isc FF00,x
3F90 00           brk 
3F91 FF 00 FF     isc FF00,x
3F94 00           brk 
3F95 FF 00 FF     isc FF00,x
3F98 00           brk 
3F99 FF 00 FF     isc FF00,x
3F9C 00           brk
3F9D FF 00 FF     isc FF00,x
3FA0 00           brk 
3FA1 FF 00 FF     isc FF00,x
3FA4 00           brk 
3FA5 FF 00 FF     isc FF00,x
3FA8 00           brk
3FA9 FF 00 FF     isc FF00,x
3FAC 00           brk
3FAD FF 00 FF     isc FF00,x
3FB0 00           brk 
3FB1 FF 00 FF     isc FF00,x
3FB4 00           brk
3FB5 FF 00 FF     isc FF00,x
3FB8 00           brk
3FB9 FF 00 FF     isc FF00,x
3FBC 00           brk
3FBD FF 00 FF     isc FF00,x
3FC0 00           brk
3FC1 FF 00 FF     isc FF00,x
3FC4 00           brk
3FC5 FF 00 FF     isc FF00,x
3FC8 00           brk 
3FC9 FF 00 FF     isc FF00,x
3FCC 00           brk
3FCD FF 00 FF     isc FF00,x
3FD0 00           brk 
3FD1 FF 00 FF     isc FF00,x
3FD4 00           brk
3FD5 FF 00 FF     isc FF00,x
3FD8 00           brk 
3FD9 FF 00 FF     isc FF00,x
3FDC 00           brk
3FDD FF 00 FF     isc FF00,x
3FE0 00           brk 
3FE1 FF 00 FF     isc FF00,x
3FE4 00           brk 
3FE5 FF 00 FF     isc FF00,x
3FE8 00           brk 
3FE9 FF 00 FF     isc FF00,x
3FEC 00           brk
3FED FF 00 FF     isc FF00,x
3FF0 00           brk 
3FF1 FF 00 FF     isc FF00,x
3FF4 00           brk 
3FF5 FF 00 FF     isc FF00,x
3FF8 00           brk
3FF9 FF 00 FF     isc FF00,x
3FFC 00           brk
3FFD FF 9F 8C     isc 8C9F,x
4000 03 26        slo (26,x)
4002 06 26        asl 26
4004 01 01        ora (01,x)
4006 26 F5        rol F5
4008 00           brk
4009 01 07        ora (07,x)
400B 07 07        slo 07
400D 1F 1F 1F     slo 1F1F,x
4010 15 7E        ora 7E,x
4012 FF FF FF     isc FFFF,x
4015 FF FF FF     isc FFFF,x
4018 55 AA        eor AA,x
401A EA           nop
401B FE FF FF     inc FFFF,x
401E FF FF 50     isc 50FF,x
4021 A5 AA        lda AA
4023 AA           tax
4024 EA           nop
4025 FE FF FF     inc FFFF,x
4028 00           brk 
4029 00           brk 
402A 40           rti
402B 90 90        bcc 3FBD  ;slow
402D A4 E4        ldy E4
402F F4 1F        nop 1F,x
4031 1F 7F 7F     slo 7F7F,x
4034 6A           ror a
4035 6A           ror a
4036 6A           ror a
4037 55 FF        eor FF,x
4039 FF FF FF     isc FFFF,x
403C FF AB AA     isc AAAB,x
403F 55 FF        eor FF,x
4041 FF FF FF     isc FFFF,x
4044 FF FF AF     isc AFFF,x
4047 55 FF        eor FF,x
4049 FF FF FF     isc FFFF,x
404C FF FF FF     isc FFFF,x
404F FF FD FD     isc FDFD,x
4052 FD FD FD     sbc FDFD,x
4055 FD FD F5     sbc F5FD,x
4058 15 15        ora 15,x
405A 15 00        ora 00,x
405C 00           brk 
405D 00           brk
405E 01 01        ora (01,x)
4060 6A           ror a
4061 6A           ror a
4062 6A           ror a
4063 6A           ror a
4064 6A           ror a
4065 6A           ror a
4066 AA           tax
4067 AA           tax
4068 94 94        sty 94,x
406A 94 94        sty 94,x
406C 95 92        sta 92,x
406E 6A           ror a
406F 6A           ror a
4070 6B 6A        arr #6A
4072 6A           ror a
4073 6A           ror a
4074 AA           tax
4075 AA           tax
4076 AA           tax
4077 AA           tax
4078 F5 A5        sbc A5,x
407A 95 95        sta 95,x
407C 55 55        eor 55,x
407E 95 95        sta 95,x
4080 01 01        ora (01,x)
4082 01 01        ora (01,x)
4084 01 07        ora (07,x)
4086 07 07        slo 07
4088 FE FF FF     inc FFFF,x
408B FF FF FD     isc FDFF,x
408E FD FD 6A     sbc 6AFD,x
4091 7F 57 51     rra 5157,x
4094 51 41        eor (41),y
4096 41 41        eor (41,x)
4098 AA           tax
4099 EA           nop
409A FF FF FF     isc FFFF,x
409D FF FF FF     isc FFFF,x
40A0 95 97        sta 97,x
40A2 57 5F        sre 5F,x
40A4 5F 5F 5F     sre 5F5F,x
40A7 5F 07 07     sre 0707,x
40AA 07 1F        slo 1F
40AC 1F 1A 1A     slo 1A1A,x
40AF 1A           nop
40B0 FD FD FD     sbc FDFD,x
40B3 FF FF AA     isc AAFF,x
40B6 AA           tax
40B7 AA           tax
40B8 47 47        sre 47
40BA 5F FF FA     sre FAFF,x
40BD AA           tax
40BE AA           tax
40BF AA           tax
40C0 FF FF FF     isc FFFF,x
40C3 FF AA AA     isc AAAA,x
40C6 AA           tax
40C7 AA           tax
40C8 57 57        sre 57,x
40CA 57 D5        sre D5,x
40CC 95 95        sta 95,x
40CE A5 95        lda 95
40D0 1A           nop
40D1 1A           nop
40D2 6A           ror a
40D3 6A           ror a
40D4 6A           ror a
40D5 6A           ror a
40D6 6A           ror a
40D7 55 AA        eor AA,x
40D9 AA           tax
40DA AA           tax
40DB AA           tax
40DC AA           tax
40DD AA           tax
40DE A9 55        lda #55
40E0 AA           tax
40E1 AA           tax
40E2 AA           tax
40E3 AA           tax
40E4 AA           tax
40E5 A5 55        lda 55
40E7 55 AA        eor AA,x
40E9 AA           tax
40EA A9 A5        lda #A5
40EC 55 55        eor 55,x
40EE 54 40        nop 40,x
40F0 95 54        sta 54,x
40F2 50 50        bvc 4144  ;slow
40F4 40           rti
40F5 00           brk 
40F6 00           brk
40F7 00           brk
40F8 15 15        ora 15,x
40FA 15 00        ora 00,x
40FC 00           brk
40FD 00           brk
40FE 00           brk 
40FF 00           brk 
4100 00           brk
4101 00           brk 
4102 00           brk
4103 00           brk 
4104 00           brk
4105 00           brk
4106 00           brk 
4107 00           brk 
4108 55 55        eor 55,x
410A 40           rti
410B 00           brk 
410C 00           brk
410D 00           brk 
410E 00           brk
410F 00           brk 
4110 55 40        eor 40,x
4112 00           brk
4113 00           brk
4114 00           brk 
4115 00           brk
4116 00           brk
4117 00           brk
4118 00           brk 
4119 00           brk
411A 00           brk
411B 00           brk
411C 00           brk 
411D 01 15        ora (15,x)
411F 55 1F        eor 1F,x
4121 1F 7D 7D     slo 7D7D,x
4124 7D 5D 54     adc 545D,x
4127 55 55        eor 55,x
4129 75 7D        adc 7D,x
412B FD FD F5     sbc F5FD,x
412E F5 75        sbc 75,x
4130 55 55        eor 55,x
4132 55 55        eor 55,x
4134 55 55        eor 55,x
4136 55 55        eor 55,x
4138 55 55        eor 55,x
413A D5 D5        cmp D5,x
413C 55 55        eor 55,x
413E 55 55        eor 55,x
4140 55 55        eor 55,x
4142 15 01        ora 01,x
4144 00           brk
4145 00           brk 
4146 00           brk 
4147 00           brk 
4148 55 55        eor 55,x
414A 55 55        eor 55,x
414C 00           brk
414D 00           brk 
414E 00           brk
414F 00           brk 
4150 05 05        ora 05
4152 01 00        ora (00,x)
4154 00           brk
4155 00           brk 
4156 00           brk
4157 00           brk
4158 50 40        bvc 419A
415A 40           rti
415B 00           brk
415C 00           brk 
415D 00           brk
415E 00           brk 
415F 00           brk 
4160 55 55        eor 55,x
4162 55 00        eor 00,x
4164 00           brk 
4165 00           brk 
4166 00           brk
4167 00           brk
4168 45 45        eor 45
416A 05 00        ora 00  ;CpuDataDir
416C 00           brk
416D 00           brk
416E 00           brk 
416F 00           brk 
4170 00           brk
4171 00           brk 
4172 00           brk
4173 00           brk 
4174 30 30        bmi 41A6
4176 00           brk
4177 00           brk 
4178 05 06        ora 06
417A 07 07        slo 07
417C 1F 1F 1F     slo 1F1F,x
417F 1F 54 A5     slo A554,x
4182 A5 E5        lda E5
4184 F9 FD FD     sbc FDFD,y
4187 FD 00 00     sbc 0000,x
418A 00           brk 
418B 00           brk 
418C 00           brk
418D 41 41        eor (41,x)
418F 41 15        eor (15,x)
4191 1E 7E 7F     asl 7F7E,x
4194 7F AF AB     rra ABAF,x
4197 AA           tax
4198 54 A4        nop A4,x
419A A5 A5        lda A5
419C A5 E5        lda E5
419E F5 F5        sbc F5,x
41A0 6A           ror a
41A1 6A           ror a
41A2 6A           ror a
41A3 6A           ror a
41A4 AA           tax
41A5 FA           nop
41A6 FE FF FF     inc FFFF,x
41A9 BF AB AA     lax AAAB,x
41AC AA           tax
41AD AA           tax
41AE AA           tax
41AF EA           nop
41B0 46 56        lsr 56
41B2 57 5F        sre 5F,x
41B4 9F 9F AB     ahx AB9F,y
41B7 AA           tax
41B8 AA           tax
41B9 AA           tax
41BA AA           tax
41BB FA           nop
41BC FE FF FF     inc FFFF,x
41BF FF B5 A5     isc A5B5,x
41C2 A5 94        lda 94
41C4 94 D4        sty D4,x
41C6 D4 D4        nop D4,x
41C8 7F 7F 5F     rra 5F7F,x
41CB 5F 5F 5A     sre 5A5F,x
41CE 5A           nop
41CF 56 FA        lsr FA,x
41D1 FF FF FF     isc FFFF,x
41D4 FF FF AF     isc AFFF,x
41D7 AA           tax
41D8 AA           tax
41D9 AA           tax
41DA FA           nop
41DB FF FF FF     isc FFFF,x
41DE FF FF AF     isc AFFF,x
41E1 AB AA        lax #AA
41E3 AA           tax
41E4 FA           nop
41E5 FF FF FF     isc FFFF,x
41E8 D4 D4        nop D4,x
41EA D4 94        nop 94,x
41EC 14 15        nop 15,x
41EE 51 51        eor (51),y
41F0 55 AA        eor AA,x
41F2 AA           tax
41F3 FF FF AA     isc AAFF,x
41F6 FF 55 55     isc 5555,x
41F9 FF AA FF     isc FFAA,x
41FC FF AA AA     isc AAAA,x
41FF 55 AF        eor AF,x
4201 A9 A9        lda #A9
4203 A9 E5        lda #E5
4205 F5 F5        sbc F5,x
4207 D5 FF        cmp FF,x
4209 BF AB AA     lax AAAB,x
420C AA           tax
420D FF FF FF     isc FFFF,x
4210 51 57        eor (57),y
4212 57 56        sre 56,x
4214 56 5A        lsr 5A,x
4216 5F 5F 5F     sre 5F5F,x
4219 5F 5D 5D     sre 5D5D,x
421C 69 69        adc #69
421E A9 55        lda #55
4220 7F 7F 5F     rra 5F7F,x
4223 5F 5A 59     sre 595A,x
4226 59 55 D5     eor D555,y
4229 D7 57        dcp 57,x
422B 56 56        lsr 56,x
422D 46 46        lsr 46
422F 45 FF        eor FF
4231 FD A9 A9     sbc A9A9,x
4234 A9 A9        lda #A9
4236 A9 55        lda #55
4238 5F 5F 7A     sre 7A5F,x
423B 6A           ror a
423C 6A           ror a
423D 6A           ror a
423E 6A           ror a
423F 55 00        eor 00,x
4241 05 5F        ora 5F
4243 6F 6F 6F     rra 6F6F
4246 6B 6B        arr #6B
4248 55 EA        eor EA,x
424A EA           nop
424B EA           nop
424C EA           nop
424D FA           nop
424E FA           nop
424F FA           nop
4250 40           rti
4251 D5 FE        cmp FE,x
4253 FE FE BE     inc BEFE,x
4256 BE BE 00     ldx 00BE,y
4259 00           brk
425A 50 94        bvc 41F0  ;slow
425C A5 A5        lda A5
425E BD BD 00     lda 00BD,x
4261 00           brk 
4262 00           brk 
4263 00           brk 
4264 00           brk 
4265 00           brk 
4266 40           rti
4267 40           rti
4268 6B 7A        arr #7A
426A 7A           nop
426B 55 1A        eor 1A,x
426D 1A           nop
426E 1E 1E FE     asl FE1E,x
4271 FE FE 55     inc 55FE,x
4274 B4 B4        ldy B4,x
4276 B4 A4        ldy A4,x
4278 BE BE BE     ldx BEBE,y
427B 6E 1E 1E     ror 1E1E
427E 1E 6E BD     asl BD6E,x
4281 BD BD BD     lda BDBD,x
4284 B5 B5        lda B5,x
4286 B5 95        lda 95,x
4288 40           rti
4289 40           rti
428A 40           rti
428B 40           rti
428C 40           rti
428D 00           brk
428E 00           brk
428F 00           brk 
4290 6E 6B 6B     ror 6B6B
4293 7A           nop
4294 FE BE AF     inc AFBE,x
4297 AB 90        lax #90
4299 91 D7        sta (D7),y
429B DB 7A 7E     dcp 7E7A,y
429E 6E 5F 6E     ror 6E5F
42A1 EE EE EE     inc EEEE
42A4 FA           nop
42A5 FE BA BE     inc BEBA,x
42A8 D4 D4        nop D4,x
42AA D4 F5        nop F5,x
42AC F5 FD        sbc FD,x
42AE F9 F9 00     sbc 00F9,y
42B1 00           brk 
42B2 00           brk 
42B3 00           brk
42B4 00           brk 
42B5 00           brk
42B6 40           rti
42B7 40           rti
42B8 E9 F9        sbc #F9
42BA FD FD A4     sbc A4FD,x
42BD A4 F4        ldy F4
42BF F5 07        sbc 07,x
42C1 06 06        asl 06
42C3 06 1F        asl 1F
42C5 1F 6A FE     slo FE6A,x
42C8 AA           tax
42C9 EE EE BE     inc BEEE
42CC AF EF FF     lax FFEF
42CF AF F9 F9     lax F9F9
42D2 E9 E9        sbc #E9
42D4 E9 E5        sbc #E5
42D6 A5 A5        lda A5
42D8 40           rti
42D9 40           rti
42DA 40           rti
42DB 40           rti
42DC 40           rti
42DD 40           rti
42DE 40           rti
42DF 40           rti
42E0 FF FF AA     isc AAFF,x
42E3 AA           tax
42E4 AA           tax
42E5 AA           tax
42E6 AA           tax
42E7 55 FF        eor FF,x
42E9 EA           nop
42EA AA           tax
42EB AA           tax
42EC AA           tax
42ED AA           tax
42EE A5 55        lda 55
42F0 FD A9 A9     sbc A9A9,x
42F3 A9 A6        lda #A6
42F5 96 56        stx 56,y
42F7 56 55        lsr 55,x
42F9 FF BF BA     isc BABF,x
42FC AF EB EE     lax EEEB
42FF EB 55        sbc #55
4301 EA           nop
4302 FF FF AB     isc ABFF,x
4305 EA           nop
4306 FE BF 55     inc 55BF,x
4309 AA           tax
430A FA           nop
430B FF FF AF     isc AFFF,x
430E AA           tax
430F EA           nop
4310 55 A9        eor A9,x
4312 A9 FD        lda #FD
4314 F5 F5        sbc F5,x
4316 F5 A5        sbc A5,x
4318 EE EA EB     inc EBEA
431B 57 07        sre 07,x
431D 07 07        slo 07
431F 06 EB        asl EB
4321 BA           tsx
4322 BE AF EB     ldx EBAF,y
4325 EA           nop
4326 BA           tsx
4327 BA           tsx
4328 FE FF AF     inc AFFF,x
432B A5 E5        lda E5
432D F5 F5        sbc F5,x
432F B5 95        lda 95,x
4331 D5 D5        cmp D5,x
4333 55 57        eor 57,x
4335 57 07        sre 07,x
4337 07 1B        slo 1B
4339 1A           nop
433A 1A           nop
433B 1A           nop
433C 7A           nop
433D 7E 7E 7E     ror 7E7E,x
4340 FE EE EF     inc EFEE,x
4343 EF EB BB     isc BBEB
4346 BB BA 94     las 94BA,y
4349 94 94        sty 94,x
434B 94 50        sty 50,x
434D 50 50        bvc 439F
434F 50 1A        bvc 436B
4351 1A           nop
4352 1A           nop
4353 1A           nop
4354 7E 7F 7D     ror 7D7F,x
4357 7F FE FE     rra FEFE,x
435A FE FE FE     inc FEFE,x
435D FE FF FF     inc FFFF,x
4360 B9 B9 BD     lda BDB9,y
4363 BD AD A5     lda A5AD,x
4366 A5 A5        lda A5
4368 41 41        eor (41,x)
436A 41 41        eor (41,x)
436C 44 07        nop 07
436E 07 07        slo 07
4370 AF AF A9     lax A9AF
4373 A9 A5        lda #A5
4375 A6 D6        ldx D6
4377 DA           nop
4378 FF FF FF     isc FFFF,x
437B FF FF FF     isc FFFF,x
437E FF FF A5     isc A5FF,x
4381 A5 94        lda 94
4383 94 94        sty 94,x
4385 94 50        sty 50,x
4387 50 1A        bvc 43A3
4389 1A           nop
438A 1A           nop
438B 1E 7E 7E     asl 7E7E,x
438E 7E 7F FA     ror FA7F,x
4391 FA           nop
4392 BE BF AF     ldx AFBF,y
4395 AF AB AB     lax ABAB
4398 FF FD FD     isc FDFD,x
439B FD F5 F5     sbc F5F5,x
439E D5 54        cmp 54,x
43A0 51 41        eor (41),y
43A2 41 41        eor (41,x)
43A4 01 00        ora (00,x)
43A6 00           brk
43A7 00           brk 
43A8 FF BF BF     isc BFBF,x
43AB AF 55 55     lax 5555
43AE 55 00        eor 00,x
43B0 AB A9        lax #A9
43B2 E9 E9        sbc #E9
43B4 55 55        eor 55,x
43B6 55 00        eor 00,x
43B8 55 7E        eor 7E,x
43BA 7A           nop
43BB 6A           ror a
43BC 6A           ror a
43BD 6A           ror a
43BE 6A           ror a
43BF 6A           ror a
43C0 55 AB        eor AB,x
43C2 AB AF        lax #AF
43C4 AF AF BF     lax BFAF
43C7 BF 40 40     lax 4040,x
43CA 54 54        nop 54,x
43CC 54 D4        nop D4,x
43CE D5 D5        cmp D5,x
43D0 01 01        ora (01,x)
43D2 01 01        ora (01,x)
43D4 06 06        asl 06
43D6 06 1A        asl 1A
43D8 6A           ror a
43D9 6A           ror a
43DA 6A           ror a
43DB 1B 1B 1F     slo 1F1B,y
43DE 1F 07 FF     slo FF07,x
43E1 FF FF FF     isc FFFF,x
43E4 FF FF FF     isc FFFF,x
43E7 FF F5 F9     isc F9F5,x
43EA FA           nop
43EB FA           nop
43EC FA           nop
43ED FA           nop
43EE FA           nop
43EF FA           nop
43F0 5A           nop
43F1 6A           ror a
43F2 AA           tax
43F3 AA           tax
43F4 AA           tax
43F5 AA           tax
43F6 AA           tax
43F7 AA           tax
43F8 07 07        slo 07
43FA 01 01        ora (01,x)
43FC 00           brk
43FD 00           brk
43FE 00           brk 
43FF 00           brk 
4400 FF FF FF     isc FFFF,x
4403 FF 7F 5F     isc 5F7F,x
4406 15 05        ora 05,x
4408 EA           nop
4409 EA           nop
440A EA           nop
440B EA           nop
440C EA           nop
440D EA           nop
440E EA           nop
440F 55 AA        eor AA,x
4411 AA           tax
4412 AA           tax
4413 AA           tax
4414 AA           tax
4415 AA           tax
4416 A9 55        lda #55
4418 00           brk 
4419 00           brk 
441A 00           brk
441B 00           brk 
441C 55 FF        eor FF,x
441E FF FF 00     isc 00FF,x
4421 00           brk 
4422 00           brk
4423 00           brk
4424 55 FF        eor FF,x
4426 FF FF 00     isc 00FF,x
4429 00           brk
442A 00           brk
442B 00           brk 
442C 50 D0        bvc 43FE  ;slow
442E D4 D4        nop D4,x
4430 00           brk
4431 00           brk 
4432 00           brk 
4433 00           brk
4434 00           brk
4435 01 06        ora (06,x)
4437 1F 00 00     slo 0000,x
443A 00           brk
443B 00           brk
443C 54 A9        nop A9,x
443E AA           tax
443F FA           nop
4440 BF AB A9     lax A9AB,x
4443 A9 E9        lda #E9
4445 FD F5 F5     sbc F5F5,x
4448 FF FF AF     isc AFFF,x
444B AA           tax
444C AA           tax
444D AA           tax
444E AA           tax
444F FA           nop
4450 D4 F5        nop F5,x
4452 F5 F5        sbc F5,x
4454 A5 A5        lda A5
4456 A6 A6        ldx A6
4458 1F 7F 7F     slo 7F7F,x
445B FF FF FF     isc FFFF,x
445E AF AA FF     lax FFAA
4461 FF FF FF     isc FFFF,x
4464 FF FF FF     isc FFFF,x
4467 BF B5 A5     lax A5B5,x
446A 65 55        adc 55
446C D4 54        nop 54,x
446E D4 D4        nop D4,x
4470 7D 77 77     adc 7777,x
4473 17 1F        slo 1F,x
4475 1F 1B 06     slo 061B,x
4478 A6 E6        ldx E6
447A F6 DF        inc DF,x
447C DF DF DF     dcp DFDF,x
447F DF AA AA     dcp AAAA,x
4482 AA           tax
4483 AA           tax
4484 FA           nop
4485 FD FD FD     sbc FDFD,x
4488 AA           tax
4489 AA           tax
448A 96 55        stx 55,y
448C 55 51        eor 51,x
448E 40           rti
448F 40           rti
4490 55 55        eor 55,x
4492 67 A7        rra A7
4494 9F 9F AF     ahx AF9F,y
4497 AB DA        lax #DA
4499 6A           ror a
449A 7A           nop
449B DE F6 FF     dec FFF6,x
449E FF FF 9F     isc 9FFF,x
44A1 6F 6B 6A     rra 6A6B
44A4 6A           ror a
44A5 6A           ror a
44A6 6A           ror a
44A7 6A           ror a
44A8 F5 F5        sbc F5,x
44AA F5 F5        sbc F5,x
44AC B5 A5        lda A5,x
44AE A5 A5        lda A5
44B0 40           rti
44B1 00           brk 
44B2 00           brk 
44B3 00           brk
44B4 00           brk
44B5 40           rti
44B6 40           rti
44B7 40           rti
44B8 AB AA        lax #AA
44BA AA           tax
44BB AA           tax
44BC AA           tax
44BD EA           nop
44BE EA           nop
44BF FA           nop
44C0 FF FF FF     isc FFFF,x
44C3 BF BF AF     lax AFBF,x
44C6 AF AB 7A     lax 7AAB
44C9 7E 7E 7F     ror 7F7E,x
44CC 7F 1F 1F     rra 1F1F,x
44CF 1F A9 A9     slo A9A9,x
44D2 A9 A9        lda #A9
44D4 EA           nop
44D5 EA           nop
44D6 FA           nop
44D7 FE 40 44     inc 4440,x
44DA 54 59        nop 59,x
44DC 5A           nop
44DD 6A           ror a
44DE AA           tax
44DF AA           tax
44E0 FA           nop
44E1 55 55        eor 55,x
44E3 55 50        eor 50,x
44E5 50 50        bvc 4537  ;slow
44E7 00           brk 
44E8 AB 6A        lax #6A
44EA 6A           ror a
44EB 6A           ror a
44EC 6A           ror a
44ED 6A           ror a
44EE 15 05        ora 05,x
44F0 DF DF D7     dcp D7DF,x
44F3 B7 B7        lax B7,y
44F5 A5 55        lda 55
44F7 55 FE        eor FE,x
44F9 FF FF FF     isc FFFF,x
44FC FF FF 7F     isc 7FFF,x
44FF 55 AA        eor AA,x
4501 AA           tax
4502 AA           tax
4503 EA           nop
4504 FA           nop
4505 FE F5 55     inc 55F5,x
4508 00           brk 
4509 00           brk
450A 00           brk
450B 00           brk 
450C 05 46        ora 46
450E 96 A6        stx A6,y
4510 00           brk
4511 00           brk 
4512 00           brk 
4513 00           brk
4514 55 AA        eor AA,x
4516 AA           tax
4517 AA           tax
4518 00           brk
4519 00           brk 
451A 00           brk
451B 00           brk 
451C 50 90        bvc 44AE  ;slow
451E 90 95        bcc 44B5  ;slow
4520 00           brk 
4521 00           brk 
4522 00           brk 
4523 00           brk 
4524 00           brk 
4525 00           brk
4526 01 01        ora (01,x)
4528 F4 FD        nop FD,x
452A FD F5 F5     sbc F5F5,x
452D D7 D7        dcp D7,x
452F D7 AA        dcp AA,x
4531 FF FF FF     isc FFFF,x
4534 FF FF FF     isc FFFF,x
4537 FF 95 95     isc 9595,x
453A D4 D4        nop D4,x
453C D4 D4        nop D4,x
453E D5 51        cmp 51,x
4540 06 06        asl 06
4542 1A           nop
4543 1F 7F 7F     slo 7F7F,x
4546 FF FF 5F     isc 5FFF,x
4549 5B 5A 5A     sre 5A5A,y
454C 5A           nop
454D 5A           nop
454E 1A           nop
454F 1A           nop
4550 FF FF BF     isc BFFF,x
4553 AB AA        lax #AA
4555 AA           tax
4556 AA           tax
4557 AA           tax
4558 51 57        eor (57),y
455A 57 5F        sre 5F,x
455C 5F 6B 6A     sre 6A6B,x
455F AA           tax
4560 FF FF FF     isc FFFF,x
4563 FF FF FF     isc FFFF,x
4566 BF A9 1A     lax 1AA9,x
4569 1A           nop
456A 1E 1F 1F     asl 1F1F,x
456D 1F 1F 1F     slo 1F1F,x
4570 AA           tax
4571 AA           tax
4572 AA           tax
4573 AA           tax
4574 EA           nop
4575 FA           nop
4576 FE FF AA     inc AAFF,x
4579 AA           tax
457A AA           tax
457B AA           tax
457C AA           tax
457D AA           tax
457E AA           tax
457F AA           tax
4580 A9 A5        lda #A5
4582 A5 94        lda 94
4584 94 54        sty 54,x
4586 50 90        bvc 4518
4588 1F 1F 5F     slo 5F1F,x
458B 5F 9F 9F     sre 9F9F,x
458E A7 A6        lax A6
4590 FF FF FD     isc FDFF,x
4593 FD FD FD     sbc FDFD,x
4596 FD FD EA     sbc EAFD,x
4599 FA           nop
459A FE FF FF     inc FFFF,x
459D 7F 7F 7F     rra 7F7F,x
45A0 90 90        bcc 4532
45A2 A4 A4        ldy A4
45A4 E4 F9        cpx F9
45A6 FD FD A9     sbc A9FD,x
45A9 A9 A5        lda #A5
45AB A5 96        lda 96
45AD 56 5A        lsr 5A,x
45AF 55 BD        eor BD,x
45B1 A5 A5        lda A5
45B3 A5 A5        lda A5
45B5 A5 A5        lda A5
45B7 55 5F        eor 5F,x
45B9 1F 07 07     slo 0707,x
45BC 07 01        slo 01  ;CpuDataPort
45BE 01 01        ora (01,x)
45C0 FF FF FF     isc FFFF,x
45C3 FF FF FF     isc FFFF,x
45C6 FF 55 40     isc 4055,x
45C9 40           rti
45CA D0 D0        bne 459C
45CC F4 F4        nop F4,x
45CE FD 55 00     sbc 0055,x
45D1 00           brk
45D2 00           brk
45D3 00           brk 
45D4 00           brk
45D5 55 AA        eor AA,x
45D7 AA           tax
45D8 00           brk 
45D9 00           brk
45DA 00           brk 
45DB 00           brk
45DC 00           brk 
45DD 55 A9        eor A9,x
45DF A8           tay
45E0 AA           tax
45E1 AA           tax
45E2 AA           tax
45E3 FA           nop
45E4 FF FF FF     isc FFFF,x
45E7 FD A9 A5     sbc A5A9,x
45EA A5 94        lda 94
45EC 94 50        sty 50,x
45EE 50 40        bvc 4630  ;slow
45F0 FD F5 F5     sbc F5F5,x
45F3 D4 D4        nop D4,x
45F5 50 50        bvc 4647  ;slow
45F7 40           rti
45F8 40           rti
45F9 00           brk 
45FA 00           brk
45FB 00           brk
45FC 00           brk 
45FD 00           brk 
45FE 00           brk 
45FF 00           brk 
4600 55 55        eor 55,x
4602 55 00        eor 00,x
4604 00           brk 
4605 00           brk
4606 00           brk 
4607 00           brk 
4608 15 15        ora 15,x
460A 15 00        ora 00,x
460C 00           brk 
460D 00           brk
460E 00           brk
460F 00           brk
4610 00           brk 
4611 00           brk
4612 54 54        nop 54,x
4614 54 54        nop 54,x
4616 54 54        nop 54,x
4618 00           brk 
4619 00           brk
461A A8           tay
461B A8           tay
461C A8           tay
461D A8           tay
461E A8           tay
461F A8           tay
4620 7E 7A 7E     ror 7E7A,x
4623 7A           nop
4624 7E 7A 7E     ror 7E7A,x
4627 7A           nop
4628 BD AD BD     lda BDAD,x
462B AD BD AD     lda ADBD
462E BD AD 05     lda 05AD,x
4631 1A           nop
4632 1A           nop
4633 7B 7F 7A     rra 7A7F,y
4636 7E 7A 50     ror 507A,x
4639 A4 A4        ldy A4
463B ED FD AD     sbc ADFD
463E BD AD 7D     lda 7DAD,x
4641 7B 7E 7B     rra 7B7E,y
4644 7F 1A 1A     rra 1A1A,x
4647 05 7D        ora 7D
4649 ED BD ED     sbc EDBD
464C FD A4 A4     sbc A4A4,x
464F 50 00        bvc 4651
4651 00           brk 
4652 00           brk
4653 00           brk
4654 00           brk 
4655 00           brk
4656 00           brk
4657 00           brk
4658 00           brk 
4659 00           brk
465A 00           brk 
465B 00           brk
465C 00           brk 
465D 00           brk 
465E 00           brk
465F 00           brk
4660 00           brk 
4661 00           brk 
4662 00           brk
4663 00           brk
4664 00           brk 
4665 00           brk 
4666 00           brk
4667 00           brk
4668 00           brk 
4669 00           brk 
466A 00           brk
466B 00           brk 
466C 00           brk 
466D 00           brk
466E 00           brk
466F 00           brk
4670 00           brk 
4671 00           brk 
4672 00           brk 
4673 00           brk 
4674 00           brk 
4675 00           brk
4676 00           brk 
4677 00           brk
4678 00           brk 
4679 FD 00 FF     sbc FF00,x
467C 00           brk
467D FF 6C 15     isc 156C,x
4680 00           brk 
4681 00           brk
4682 FC FC FC     nop FCFC,x
4685 FC FC FC     nop FCFC,x
4688 55 75        eor 75,x
468A DD DD FD     cmp FDDD,x
468D DD DD DD     cmp DDDD,x
4690 55 F5        eor F5,x
4692 DD DD F5     cmp F5DD,x
4695 DD DD F5     cmp F5DD,x
4698 55 7D        eor 7D,x
469A D5 D5        cmp D5,x
469C D5 D5        cmp D5,x
469E D5 7D        cmp 7D,x
46A0 55 F5        eor F5,x
46A2 DD DD DD     cmp DDDD,x
46A5 DD DD F5     cmp F5DD,x
46A8 55 FD        eor FD,x
46AA D5 D5        cmp D5,x
46AC F5 D5        sbc D5,x
46AE D5 FD        cmp FD,x
46B0 55 FD        eor FD,x
46B2 D5 D5        cmp D5,x
46B4 F5 D5        sbc D5,x
46B6 D5 D5        cmp D5,x
46B8 55 7D        eor 7D,x
46BA D5 D5        cmp D5,x
46BC D5 DD        cmp DD,x
46BE DD 7D 55     cmp 557D,x
46C1 DD DD DD     cmp DDDD,x
46C4 FD DD DD     sbc DDDD,x
46C7 DD 55 FD     cmp FD55,x
46CA 75 75        adc 75,x
46CC 75 75        adc 75,x
46CE 75 FD        adc FD,x
46D0 55 FD        eor FD,x
46D2 75 75        adc 75,x
46D4 75 75        adc 75,x
46D6 F5 F5        sbc F5,x
46D8 55 DD        eor DD,x
46DA DD DD F5     cmp F5DD,x
46DD DD DD DD     cmp DDDD,x
46E0 55 D5        eor D5,x
46E2 D5 D5        cmp D5,x
46E4 D5 D5        cmp D5,x
46E6 D5 FD        cmp FD,x
46E8 55 DD        eor DD,x
46EA FD FD FD     sbc FDFD,x
46ED DD DD DD     cmp DDDD,x
46F0 55 75        eor 75,x
46F2 FD DD DD     sbc DDDD,x
46F5 DD DD DD     cmp DDDD,x
46F8 55 75        eor 75,x
46FA DD DD DD     cmp DDDD,x
46FD DD DD 75     cmp 75DD,x
4700 55 F5        eor F5,x
4702 DD DD F5     cmp F5DD,x
4705 D5 D5        cmp D5,x
4707 D5 55        cmp 55,x
4709 75 DD        adc DD,x
470B DD DD DD     cmp DDDD,x
470E FD 7D 55     sbc 557D,x
4711 F5 DD        sbc DD,x
4713 DD F5 DD     cmp DDF5,x
4716 DD DD 55     cmp 55DD,x
4719 7D D5 D5     adc D5D5,x
471C 75 5D        adc 5D,x
471E 5D F5 55     eor 55F5,x
4721 FD 75 75     sbc 7575,x
4724 75 75        adc 75,x
4726 75 75        adc 75,x
4728 55 DD        eor DD,x
472A DD DD DD     cmp DDDD,x
472D DD DD 75     cmp 75DD,x
4730 55 DD        eor DD,x
4732 DD DD DD     cmp DDDD,x
4735 DD 75 75     cmp 7575,x
4738 55 DD        eor DD,x
473A DD DD FD     cmp FDDD,x
473D FD FD DD     sbc DDFD,x
4740 55 DD        eor DD,x
4742 DD DD 75     cmp 75DD,x
4745 DD DD DD     cmp DDDD,x
4748 55 DD        eor DD,x
474A DD DD CD     cmp CDDD,x
474D 75 75        adc 75,x
474F 75 55        adc 55,x
4751 FD 5D 7D     sbc 7D5D,x
4754 75 D5        adc D5,x
4756 D5 FD        cmp FD,x
4758 55 75        eor 75,x
475A DD DD DD     cmp DDDD,x
475D DD DD 75     cmp 75DD,x
4760 55 F5        eor F5,x
4762 75 75        adc 75,x
4764 75 75        adc 75,x
4766 75 FD        adc FD,x
4768 55 F5        eor F5,x
476A DD 5D 75     cmp 755D,x
476D 75 D5        adc D5,x
476F FD 55 F5     sbc F555,x
4772 5D 5D 7D     eor 7D5D,x
4775 5D 5D F5     eor F55D,x
4778 55 D5        eor D5,x
477A D5 DD        cmp DD,x
477C DD FD 5D     cmp 5DFD,x
477F 5D 55 FD     eor FD55,x
4782 D5 D5        cmp D5,x
4784 FD 5D 5D     sbc 5D5D,x
4787 F5 55        sbc 55,x
4789 7D D5 D5     adc D5D5,x
478C F5 DD        sbc DD,x
478E DD 75 55     cmp 5575,x
4791 FD 5D 5D     sbc 5D5D,x
4794 75 75        adc 75,x
4796 D5 D5        cmp D5,x
4798 55 75        eor 75,x
479A DD DD 75     cmp 75DD,x
479D DD DD 75     cmp 75DD,x
47A0 55 7D        eor 7D,x
47A2 DD DD 7D     cmp 7DDD,x
47A5 5D 75 75     eor 7575,x
47A8 AA           tax
47A9 AA           tax
47AA 80 80        nop #80
47AC 80 80        nop #80
47AE 80 80        nop #80
47B0 AA           tax
47B1 AA           tax
47B2 00           brk 
47B3 00           brk
47B4 00           brk
47B5 00           brk 
47B6 00           brk 
47B7 00           brk
47B8 AA           tax
47B9 AA           tax
47BA 00           brk
47BB 00           brk
47BC 00           brk
47BD 00           brk 
47BE 00           brk 
47BF 00           brk
47C0 AA           tax
47C1 A9 01        lda #01
47C3 01 01        ora (01,x)
47C5 01 01        ora (01,x)
47C7 01 80        ora (80,x)
47C9 80 80        nop #80
47CB 80 80        nop #80
47CD 80 95        nop #95
47CF 55 00        eor 00,x
47D1 00           brk 
47D2 00           brk
47D3 00           brk 
47D4 00           brk
47D5 00           brk 
47D6 55 55        eor 55,x
47D8 00           brk
47D9 00           brk
47DA 00           brk 
47DB 00           brk
47DC 00           brk
47DD 00           brk
47DE 55 55        eor 55,x
47E0 01 01        ora (01,x)
47E2 01 01        ora (01,x)
47E4 01 01        ora (01,x)
47E6 55 55        eor 55,x
47E8 00           brk 
47E9 00           brk
47EA F3 C3        isc (C3),y
47EC C3 C3        dcp (C3,x)
47EE F3 00        isc (00),y
47F0 00           brk
47F1 00           brk
47F2 33 33        rla (33),y
47F4 F3 33        isc (33),y
47F6 33 00        rla (00),y
47F8 00           brk
47F9 00           brk
47FA C3 33        dcp (33,x)
47FC 33 C3        rla (C3),y
47FE 33 00        rla (00),y

; data
57E7              .byte 0

; obszar $7301-$739F same $FF

;syf
73A0 0D 00 00     ora 0000  ;CpuDataDir
73A3 00           brk
73A4 3E 2A 00     rol 002A,x
73A7 0A           asl a
73A8 41 09        eor (09,x)
73AA 00           brk
73AB 3C 32 01     nop 0132,x
73AE 01 41        ora (41,x)
73B0 07 20        slo 20
73B2 30 04        bmi 73B8
73B4 0A           asl a
73B5 0A           asl a
73B6 41 09        eor (09,x)
73B8 40           rti
73B9 00           brk
73BA 00           brk
73BB 00           brk
73BC 00           brk
73BD 00           brk
73BE 01 02        ora (02,x)
73C0 02           kil
73C1 01 0F        ora (0F,x)
73C3 00           brk
73C4 00           brk
73C5 00           brk
73C6 00           brk
73C7 00           brk
73C8 01 02        ora (02,x)
73CA 02           kil
73CB 00           brk
73CC 00           brk
73CD 01 00        ora (00,x)
73CF 00           brk
73D0 00           brk
73D1 00           brk

;dana
73D2 00           brk

73D3 01 00        ora (00,x)
73D5 00           brk
73D6 01 00        ora (00,x)
73D8 00           brk
73D9 00           brk
73DA 00           brk
73DB 00           brk
73DC 3C 01 00     nop 0001,x
73DF 00           brk
73E0 C8           iny
73E1 00           brk
73E2 00           brk
73E3 00           brk
73E4 00           brk
73E5 00           brk
73E6 00           brk
73E7 00           brk
73E8 0A           asl a
73E9 0A           asl a
73EA 00           brk
73EB 00           brk
73EC 00           brk
73ED 00           brk
73EE 00           brk
73EF 00           brk
73F0 00           brk
73F1 00           brk
73F2 00           brk
73F3 00           brk
73F4 00           brk
73F5 00           brk
73F6 00           brk
73F7 00           brk
73F8 00           brk
73F9 00           brk
73FA 00           brk
73FB 00           brk
73FC 00           brk
73FD 00           brk
73FE 00           brk
73FF 00           brk
7400 00           brk
7401 00           brk
7402 00           brk
7403 00           brk
7404 07 07        slo 07

; dane
7406 06 06        asl 06

7408 00           brk
7409 00           brk
740A 00           brk
740B 00           brk
740C 00           brk
740D 00           brk
740E 00           brk
740F 00           brk
7410 00           brk
7411 32           kil
7412 3C 00 00     nop 0000,x
7415 00           brk
7416 00           brk
7417 00           brk

; dane
7418 02           kil
7419 02           kil
741A 04           .byte $04

741B 00           .byte 0
741C 00           brk
741D 00           brk
741E 00           brk
741F 00           brk
7420 58           cli

;dane
7421 02           kil
7422 02           kil
7423 02           kil
7424 6E 91 8A     ror 8A91
7427 91 A6        sta (A6),y
7429 91 00        sta (00),y

742B 00           brk
742C 4C 00 00     jmp 0000
742F 00           brk
7430 00           brk
7431 00           brk
7432 00           brk
7433 00           brk
7434 00           brk
7435 00           brk
7436 00           brk
7437 00           brk
7438 00           brk
7439 00           brk
743A 00           brk
743B 00           brk
743C 00           brk
743D 00           brk
743E 00           brk
743F 00           brk

7440 FF FF FF     isc FFFF,x
7443 FF FF FF     isc FFFF,x
7446 FF FF        .byte $FF,$FF
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; ??? procka odgrywajca SID-a ???
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc7448          mva $7E2F $4B
                  mva $7E30 $4C
                  mva $7E31 $4D
                  mva $7E32 $4E

                  ldy #$00
                  dec $7407
                  beq proc7466_skip1

                  jmp 7754

proc7466_skip1    lda $7406
                  sta $7407
                  lda $7404
                  and #$01
                  bne proc7476_skip2

                  jmp proc7566_skipX

proc7476_skip2    ldx #$00
                  lda $740E
                  beq $74AF

                  cmp #F6
                  bne proc7487_skip3

                  jsr 7DD6
                  jmp proc7566_skipX

proc7487_skip3    cmp #F7
7489 D0 06        bne 7491

                  jsr 7E2B
                  jmp proc7566_skipX
                  cmp #F8
                  bne 749B

7495 20 2C 7E     jsr 7E2C
7498 4C 66 75     jmp proc7566_skipX

749B C9 F9        cmp #F9
749D D0 06        bne 74A5

749F 20 2D 7E     jsr 7E2D
74A2 4C 66 75     jmp proc7566_skipX
74A5 C9 FA        cmp #FA
74A7 D0 03        bne 74AC

74A9 20 2E 7E     jsr 7E2E
74AC 4C 66 75     jmp proc7566_skipX

74AF CE 18 74     dec 7418
74B2 F0 03        beq 74B7

74B4 4C 66 75     jmp proc7566_skipX
74B7 B1 4B        lda (4B),y
74B9 D0 03        bne 74BE

74BB 4C 58 7A     jmp 7A58
74BE C9 F6        cmp #F6
74C0 90 55        bcc 7517  ;slow

74C2 C8           iny
74C3 B1 4B        lda (4B),y
74C5 8D 1B 74     sta 741B
74C8 CE 1B 74     dec 741B
74CB 88           dey
74CC B1 4B        lda (4B),y
74CE C9 F6        cmp #F6
74D0 D0 0A        bne 74DC

74D2 8D 0E 74     sta 740E
74D5 20 11 7E     jsr 7E11
74D8 C8           iny
74D9 4C 59 75     jmp 7559
74DC C9 F7        cmp #F7
74DE D0 0A        bne 74EA

74E0 8D 0E 74     sta 740E
74E3 20 2B 7E     jsr 7E2B
74E6 C8           iny
74E7 4C 59 75     jmp 7559
74EA C9 F8        cmp #F8
74EC D0 0A        bne 74F8

74EE 8D 0E 74     sta 740E
74F1 20 2C 7E     jsr 7E2C
74F4 C8           iny
74F5 4C 59 75     jmp 7559
74F8 C9 F9        cmp #F9
74FA D0 0A        bne 7506  ;slow

74FC 8D 0E 74     sta 740E
74FF 20 2D 7E     jsr 7E2D
7502 C8           iny
7503 4C 59 75     jmp 7559
7506 C9 FA        cmp #FA
7508 F0 03        beq 750D

750A 4C 59 75     jmp 7559
750D 8D 0E 74     sta 740E
7510 20 2E 7E     jsr 7E2E
7513 C8           iny
7514 4C 59 75     jmp 7559
7517 C9 C8        cmp #C8
7519 90 03        bcc 751E

751B 4C E2 7A     jmp 7AE2
751E 8D 18 74     sta 7418
7521 AD E9 73     lda 73E9
7524 8D E8 73     sta 73E8
7527 C8           iny
7528 B1 4B        lda (4B),y
752A F0 19        beq 7545

752C 20 6E 7D     jsr 7D6E
752F AD 11 74     lda 7411
7532 8D A5 73     sta 73A5
7535 AD 12 74     lda 7412
7538 8D A4 73     sta 73A4
753B AD 05 74     lda 7405
753E 29 01        and #01
7540 D0 03        bne 7545

7542 4C 59 75     jmp 7559
7545 AE A8 73     ldx 73A8
7548 CA           dex
7549 8E 04 D4     stx D404  ;Sid1Ctrl
754C B1 4B        lda (4B),y
754E F0 09        beq 7559

7550 E8           inx
7551 8E 04 D4     stx D404  ;Sid1Ctrl
7554 A9 00        lda #00
7556 8D CD 73     sta 73CD
7559 C8           iny
755A 18           clc
755B 98           tya
755C 65 4B        adc 4B
755E 85 4B        sta 4B
7560 A5 4C        lda 4C
7562 69 00        adc #00
7564 85 4C        sta 4C
proc7566_skipX A0 00        ldy #00
7568 AD 04 74     lda 7404
756B 29 02        and #02
756D D0 03        bne 7572

756F 4C 5D 76     jmp 765D
7572 A2 07        ldx #07
7574 AD 0F 74     lda 740F
7577 F0 32        beq 75AB

7579 C9 F6        cmp #F6
757B D0 06        bne 7583

757D 20 D6 7D     jsr 7DD6
7580 4C 5D 76     jmp 765D
7583 C9 F7        cmp #F7
7585 D0 06        bne 758D

7587 20 2B 7E     jsr 7E2B
758A 4C 5D 76     jmp 765D
758D C9 F8        cmp #F8
758F D0 06        bne 7597

7591 20 2C 7E     jsr 7E2C
7594 4C 5D 76     jmp 765D
7597 C9 F9        cmp #F9
7599 D0 06        bne 75A1

759B 20 2D 7E     jsr 7E2D
759E 4C 5D 76     jmp 765D
75A1 C9 FA        cmp #FA
75A3 D0 03        bne 75A8

75A5 20 2E 7E     jsr 7E2E
75A8 4C 5D 76     jmp 765D
75AB CE 19 74     dec 7419
75AE F0 03        beq 75B3

75B0 4C 5D 76     jmp 765D
75B3 B1 4D        lda (4D),y
75B5 D0 03        bne 75BA

75B7 4C 86 7A     jmp 7A86
75BA C9 F6        cmp #F6
75BC 90 55        bcc 7613  ;slow

75BE C8           iny
75BF B1 4D        lda (4D),y
75C1 8D 1C 74     sta 741C
75C4 CE 1C 74     dec 741C
75C7 88           dey
75C8 B1 4D        lda (4D),y
75CA C9 F6        cmp #F6
75CC D0 0A        bne 75D8

75CE 8D 0F 74     sta 740F
75D1 20 11 7E     jsr 7E11
75D4 C8           iny
75D5 4C 50 76     jmp 7650
75D8 C9 F7        cmp #F7
75DA D0 0A        bne 75E6

75DC 8D 0F 74     sta 740F
75DF 20 2B 7E     jsr 7E2B
75E2 C8           iny
75E3 4C 50 76     jmp 7650
75E6 C9 F8        cmp #F8
75E8 D0 0A        bne 75F4

75EA 8D 0F 74     sta 740F
75ED 20 2C 7E     jsr 7E2C
75F0 C8           iny
75F1 4C 50 76     jmp 7650
75F4 C9 F9        cmp #F9
75F6 D0 0A        bne 7602  ;slow

75F8 8D 0F 74     sta 740F
75FB 20 2D 7E     jsr 7E2D
75FE C8           iny
75FF 4C 50 76     jmp 7650
7602 C9 FA        cmp #FA
7604 F0 03        beq 7609

7606 4C 5D 76     jmp 765D
7609 8D 0F 74     sta 740F
760C 20 2E 7E     jsr 7E2E
760F C8           iny
7610 4C 50 76     jmp 7650
7613 C9 C8        cmp #C8
7615 90 03        bcc 761A

7617 4C 27 7C     jmp 7C27
761A 8D 19 74     sta 7419
761D AD EB 73     lda 73EB
7620 8D EA 73     sta 73EA
7623 C8           iny
7624 B1 4D        lda (4D),y
7626 F0 19        beq 7641

7628 20 6E 7D     jsr 7D6E
762B AD 11 74     lda 7411
762E 8D AC 73     sta 73AC
7631 AD 12 74     lda 7412
7634 8D AB 73     sta 73AB
7637 AD 05 74     lda 7405
763A 29 02        and #02
763C D0 03        bne 7641

763E 4C 50 76     jmp 7650
7641 AE AF 73     ldx 73AF
7644 CA           dex
7645 8E 0B D4     stx D40B  ;Sid2Ctrl
7648 B1 4D        lda (4D),y

764A F0 04        beq 7650
764C E8           inx
764D 8E 0B D4     stx D40B  ;Sid2Ctrl
7650 C8           iny
7651 18           clc
7652 98           tya
7653 65 4D        adc 4D
7655 85 4D        sta 4D
7657 A5 4E        lda 4E
7659 69 00        adc #00
765B 85 4E        sta 4E
765D A0 00        ldy #00
765F AD 04 74     lda 7404
7662 29 04        and #04
7664 D0 03        bne 7669

7666 4C 54 77     jmp 7754
7669 A2 0E        ldx #0E
766B AD 10 74     lda 7410
766E F0 32        beq 76A2

7670 C9 F6        cmp #F6
7672 D0 06        bne 767A

7674 20 D6 7D     jsr 7DD6
7677 4C 54 77     jmp 7754
767A C9 F7        cmp #F7
767C D0 06        bne 7684

767E 20 2B 7E     jsr 7E2B
7681 4C 54 77     jmp 7754
7684 C9 F8        cmp #F8
7686 D0 06        bne 768E

7688 20 2C 7E     jsr 7E2C
768B 4C 54 77     jmp 7754
768E C9 F9        cmp #F9
7690 D0 06        bne 7698

7692 20 2D 7E     jsr 7E2D
7695 4C 54 77     jmp 7754
7698 C9 FA        cmp #FA
769A D0 03        bne 769F

769C 20 2E 7E     jsr 7E2E
769F 4C 54 77     jmp 7754
76A2 CE 1A 74     dec 741A
76A5 F0 03        beq 76AA

76A7 4C 54 77     jmp 7754
76AA B1 4F        lda (4F),y
76AC D0 03        bne 76B1

76AE 4C B4 7A     jmp 7AB4
76B1 C9 F6        cmp #F6
76B3 90 55        bcc 770A  ;slow

76B5 C8           iny
76B6 B1 4F        lda (4F),y
76B8 8D 1D 74     sta 741D
76BB CE 1D 74     dec 741D
76BE 88           dey
76BF B1 4F        lda (4F),y
76C1 C9 F6        cmp #F6
76C3 D0 0A        bne 76CF

76C5 8D 10 74     sta 7410
76C8 20 11 7E     jsr 7E11
76CB C8           iny
76CC 4C 47 77     jmp 7747
76CF C9 F7        cmp #F7
76D1 D0 0A        bne 76DD

76D3 8D 10 74     sta 7410
76D6 20 2B 7E     jsr 7E2B
76D9 C8           iny
76DA 4C 47 77     jmp 7747
76DD C9 F8        cmp #F8
76DF D0 0A        bne 76EB

76E1 8D 10 74     sta 7410
76E4 20 2C 7E     jsr 7E2C
76E7 C8           iny
76E8 4C 47 77     jmp 7747
76EB C9 F9        cmp #F9
76ED D0 0A        bne 76F9

76EF 8D 10 74     sta 7410
76F2 20 2D 7E     jsr 7E2D
76F5 C8           iny
76F6 4C 47 77     jmp 7747
76F9 C9 FA        cmp #FA
76FB F0 03        beq 7700  ;slow

76FD 4C 54 77     jmp 7754
7700 8D 10 74     sta 7410
7703 20 2E 7E     jsr 7E2E
7706 C8           iny
7707 4C 47 77     jmp 7747
770A C9 C8        cmp #C8
770C 90 03        bcc 7711

770E 4C DA 7C     jmp 7CDA
7711 8D 1A 74     sta 741A
7714 AD DA 73     lda 73DA
7717 8D D9 73     sta 73D9
771A C8           iny
771B B1 4F        lda (4F),y
771D F0 19        beq 7738

771F 20 6E 7D     jsr 7D6E
7722 AD 11 74     lda 7411
7725 8D B3 73     sta 73B3
7728 AD 12 74     lda 7412
772B 8D B2 73     sta 73B2
772E AD 05 74     lda 7405
7731 29 04        and #04
7733 D0 03        bne 7738

7735 4C 47 77     jmp 7747
7738 AE B6 73     ldx 73B6
773B CA           dex
773C 8E 12 D4     stx D412  ;Sid3Ctrl
773F B1 4F        lda (4F),y
7741 F0 04        beq 7747

7743 E8           inx
7744 8E 12 D4     stx D412  ;Sid3Ctrl
7747 C8           iny
7748 18           clc
7749 98           tya
774A 65 4F        adc 4F
774C 85 4F        sta 4F
774E A5 50        lda 50
7750 69 00        adc #00
7752 85 50        sta 50
7754 AD 05 74     lda 7405
7757 D0 03        bne 775C

7759 4C 04 78     jmp 7804
775C AD A0 73     lda 73A0
775F 8D 18 D4     sta D418  ;SidFltMode
7762 AD A1 73     lda 73A1
7765 8D 17 D4     sta D417  ;SidFltCtrl
7768 AD A2 73     lda 73A2
776B 8D 16 D4     sta D416  ;SidFltMsb
776E AD A3 73     lda 73A3
7771 8D 15 D4     sta D415  ;SidFltLsb
7774 AD 05 74     lda 7405
7777 29 01        and #01
7779 F0 29        beq 77A4

777B AD 0E 74     lda 740E
777E D0 24        bne 77A4

7780 AD A9 73     lda 73A9
7783 8D 05 D4     sta D405  ;Sid1AttDec
7786 AD AA 73     lda 73AA
7789 8D 06 D4     sta D406  ;Sid1SusRel
778C AD A7 73     lda 73A7
778F 8D 03 D4     sta D403  ;Sid1PulseMsb
7792 AD A6 73     lda 73A6
7795 8D 02 D4     sta D402  ;Sid1PulseLsb
7798 AD A5 73     lda 73A5
779B 8D 01 D4     sta D401  ;Sid1FreqMsb
779E AD A4 73     lda 73A4
77A1 8D 00 D4     sta D400  ;Sid1FreqLsb
77A4 AD 05 74     lda 7405
77A7 29 02        and #02
77A9 F0 29        beq 77D4

77AB AD 0F 74     lda 740F
77AE D0 24        bne 77D4

77B0 AD B0 73     lda 73B0
77B3 8D 0C D4     sta D40C  ;Sid2AttDec
77B6 AD B1 73     lda 73B1
77B9 8D 0D D4     sta D40D  ;Sid2SusRel
77BC AD AE 73     lda 73AE
77BF 8D 0A D4     sta D40A  ;Sid2PulseMsb
77C2 AD AD 73     lda 73AD
77C5 8D 09 D4     sta D409  ;Sid2PulseLsb
77C8 AD AC 73     lda 73AC
77CB 8D 08 D4     sta D408  ;Sid2FreqMsb
77CE AD AB 73     lda 73AB
77D1 8D 07 D4     sta D407  ;Sid2FreqLsb
77D4 AD 05 74     lda 7405
77D7 29 04        and #04
77D9 F0 29        beq 7804  ;slow

77DB AD 10 74     lda 7410
77DE D0 24        bne 7804  ;slow

77E0 AD B7 73     lda 73B7
77E3 8D 13 D4     sta D413  ;Sid3AttDec
77E6 AD B8 73     lda 73B8
77E9 8D 14 D4     sta D414  ;Sid3SusRel
77EC AD B5 73     lda 73B5
77EF 8D 11 D4     sta D411  ;Sid3PulseMsb
77F2 AD B4 73     lda 73B4
77F5 8D 10 D4     sta D410  ;Sid3PulseLsb
77F8 AD B3 73     lda 73B3
77FB 8D 0F D4     sta D40F  ;Sid3FreqMsb
77FE AD B2 73     lda 73B2
7801 8D 0E D4     sta D40E  ;Sid3FreqLsb
7804 CE C0 73     dec 73C0
7807 D0 4E        bne 7857

7809 AD BF 73     lda 73BF
780C 8D C0 73     sta 73C0
780F AD BE 73     lda 73BE
7812 29 01        and #01
7814 F0 11        beq 7827

7816 EE A7 73     inc 73A7
7819 AD A7 73     lda 73A7
781C CD C2 73     cmp 73C2
781F 90 06        bcc 7827

7821 AD C1 73     lda 73C1
7824 8D A7 73     sta 73A7
7827 AD BE 73     lda 73BE
782A 29 02        and #02
782C F0 11        beq 783F

782E EE AE 73     inc 73AE
7831 AD AE 73     lda 73AE
7834 CD C2 73     cmp 73C2
7837 90 06        bcc 783F

7839 AD C1 73     lda 73C1
783C 8D AE 73     sta 73AE
783F AD BE 73     lda 73BE
7842 29 04        and #04
7844 F0 11        beq 7857

7846 EE B5 73     inc 73B5
7849 AD B5 73     lda 73B5
784C CD C2 73     cmp 73C2
784F 90 06        bcc 7857

7851 AD C1 73     lda 73C1
7854 8D B5 73     sta 73B5
7857 CE CA 73     dec 73CA
785A F0 03        beq 785F

785C 4C E6 78     jmp 78E6
785F AD C9 73     lda 73C9
7862 8D CA 73     sta 73CA
7865 AD C8 73     lda 73C8
7868 29 01        and #01
786A F0 24        beq 7890

786C AD 0E 74     lda 740E
786F D0 1F        bne 7890

7871 AD CD 73     lda 73CD
7874 D0 0F        bne 7885

7876 18           clc
7877 0E A4 73     asl 73A4
787A 2E A5 73     rol 73A5
787D A9 01        lda #01
787F 8D CD 73     sta 73CD
7882 4C 90 78     jmp 7890
7885 4E A5 73     lsr 73A5
7888 6E A4 73     ror 73A4
788B A9 00        lda #00
788D 8D CD 73     sta 73CD
7890 AD C8 73     lda 73C8
7893 29 02        and #02
7895 F0 24        beq 78BB

7897 AD 0F 74     lda 740F
789A D0 1F        bne 78BB

789C AD CE 73     lda 73CE
789F D0 0F        bne 78B0

78A1 18           clc
78A2 0E AB 73     asl 73AB
78A5 2E AC 73     rol 73AC
78A8 A9 01        lda #01
78AA 8D CE 73     sta 73CE
78AD 4C BB 78     jmp 78BB
78B0 4E AC 73     lsr 73AC
78B3 6E AB 73     ror 73AB
78B6 A9 00        lda #00
78B8 8D CE 73     sta 73CE
78BB AD C8 73     lda 73C8
78BE 29 04        and #04
78C0 F0 24        beq 78E6

78C2 AD 10 74     lda 7410
78C5 D0 1F        bne 78E6

78C7 AD CF 73     lda 73CF
78CA D0 0F        bne 78DB

78CC 18           clc
78CD 0E B2 73     asl 73B2
78D0 2E B3 73     rol 73B3
78D3 A9 01        lda #01
78D5 8D CF 73     sta 73CF
78D8 4C E6 78     jmp 78E6
78DB 4E B3 73     lsr 73B3
78DE 6E B2 73     ror 73B2
78E1 A9 00        lda #00
78E3 8D CF 73     sta 73CF
78E6 AD D2 73     lda 73D2
78E9 29 01        and #01
78EB D0 03        bne 78F0

78ED 4C 59 79     jmp 7959
78F0 AD D2 73     lda 73D2
78F3 29 08        and #08
78F5 F0 0D        beq 7904  ;slow

78F7 AD E8 73     lda 73E8
78FA F0 08        beq 7904  ;slow

78FC CE E8 73     dec 73E8
78FF F0 03        beq 7904

7901 4C 59 79     jmp 7959
7904 CE D3 73     dec 73D3
7907 F0 03        beq 790C

7909 4C 59 79     jmp 7959
790C AD D6 73     lda 73D6
790F 8D D3 73     sta 73D3
7912 AD 0E 74     lda 740E
7915 D0 42        bne 7959

7917 AD E7 73     lda 73E7
791A 29 01        and #01
791C D0 20        bne 793E

791E AD A5 73     lda 73A5
7921 CD DD 73     cmp 73DD
7924 90 33        bcc 7959
7926 F0 31        beq 7959

7928 AD A4 73     lda 73A4
792B 38           sec
792C ED DC 73     sbc 73DC
792F 8D A4 73     sta 73A4
7932 AD A5 73     lda 73A5
7935 ED DB 73     sbc 73DB
7938 8D A5 73     sta 73A5
793B 4C 59 79     jmp 7959
793E AD A5 73     lda 73A5
7941 CD E0 73     cmp 73E0
7944 B0 13        bcs 7959

7946 AD A4 73     lda 73A4
7949 18           clc
794A 6D DC 73     adc 73DC
794D 8D A4 73     sta 73A4
7950 AD A5 73     lda 73A5
7953 6D DB 73     adc 73DB
7956 8D A5 73     sta 73A5
7959 AD D2 73     lda 73D2
795C 29 02        and #02
795E D0 03        bne 7963

7960 4C CC 79     jmp 79CC
7963 AD D2 73     lda 73D2
7966 29 10        and #10
7968 F0 0D        beq 7977

796A AD EA 73     lda 73EA
796D F0 08        beq 7977

796F CE EA 73     dec 73EA
7972 F0 03        beq 7977

7974 4C CC 79     jmp 79CC
7977 CE D4 73     dec 73D4
797A F0 03        beq 797F

797C 4C CC 79     jmp 79CC
797F AD D7 73     lda 73D7
7982 8D D4 73     sta 73D4
7985 AD 0F 74     lda 740F
7988 D0 42        bne 79CC

798A AD E7 73     lda 73E7
798D 29 02        and #02
798F D0 20        bne 79B1

7991 AD AC 73     lda 73AC
7994 CD DE 73     cmp 73DE
7997 90 33        bcc 79CC

7999 F0 31        beq 79CC

799B AD AB 73     lda 73AB
799E 38           sec
799F ED DC 73     sbc 73DC
79A2 8D AB 73     sta 73AB
79A5 AD AC 73     lda 73AC
79A8 ED DB 73     sbc 73DB
79AB 8D AC 73     sta 73AC
79AE 4C CC 79     jmp 79CC
79B1 AD AC 73     lda 73AC
79B4 CD E1 73     cmp 73E1
79B7 B0 13        bcs 79CC

79B9 AD AB 73     lda 73AB
79BC 18           clc
79BD 6D DC 73     adc 73DC
79C0 8D AB 73     sta 73AB
79C3 AD AC 73     lda 73AC
79C6 6D DB 73     adc 73DB
79C9 8D AC 73     sta 73AC
79CC AD D2 73     lda 73D2
79CF 29 04        and #04
79D1 D0 03        bne 79D6

79D3 4C 3F 7A     jmp 7A3F
79D6 AD D2 73     lda 73D2
79D9 29 20        and #20
79DB F0 0D        beq 79EA

79DD AD D9 73     lda 73D9
79E0 F0 08        beq 79EA

79E2 CE D9 73     dec 73D9
79E5 F0 03        beq 79EA

79E7 4C 3F 7A     jmp 7A3F
79EA CE D5 73     dec 73D5
79ED F0 03        beq 79F2

79EF 4C 3F 7A     jmp 7A3F
79F2 AD D8 73     lda 73D8
79F5 8D D5 73     sta 73D5
79F8 AD 10 74     lda 7410
79FB D0 42        bne 7A3F  ;slow

79FD AD E7 73     lda 73E7
7A00 29 04        and #04
7A02 D0 20        bne 7A24

7A04 AD B3 73     lda 73B3
7A07 CD DF 73     cmp 73DF
7A0A 90 33        bcc 7A3F
7A0C F0 31        beq 7A3F

7A0E AD B2 73     lda 73B2
7A11 38           sec
7A12 ED DC 73     sbc 73DC
7A15 8D B2 73     sta 73B2
7A18 AD B3 73     lda 73B3
7A1B ED DB 73     sbc 73DB
7A1E 8D B3 73     sta 73B3
7A21 4C 3F 7A     jmp 7A3F
7A24 AD B3 73     lda 73B3
7A27 CD E6 73     cmp 73E6
7A2A B0 13        bcs 7A3F

7A2C AD B2 73     lda 73B2
7A2F 18           clc
7A30 6D DC 73     adc 73DC
7A33 8D B2 73     sta 73B2
7A36 AD B3 73     lda 73B3
7A39 6D DB 73     adc 73DB
7A3C 8D B3 73     sta 73B3
7A3F 4C 42 7A     jmp 7A42

7A42 A5 4B        lda 4B
7A44 8D 2F 7E     sta 7E2F
7A47 A5 4C        lda 4C
7A49 8D 30 7E     sta 7E30
7A4C A5 4D        lda 4D
7A4E 8D 31 7E     sta 7E31
7A51 A5 4E        lda 4E
7A53 8D 32 7E     sta 7E32
7A56 60           rts
7A57 60           rts
;--------------------------------------------------------------------------------------------------------------------------------------------------------
7A58 AD 24 74     lda 7424
7A5B 85 51        sta 51
7A5D AD 25 74     lda 7425
7A60 85 52        sta 52
7A62 AC 21 74     ldy 7421
7A65 B1 51        lda (51),y
7A67 85 4B        sta 4B
7A69 C8           iny
7A6A B1 51        lda (51),y
7A6C D0 08        bne 7A76
7A6E A0 00        ldy #00
7A70 8C 21 74     sty 7421
7A73 4C 58 7A     jmp 7A58
7A76 85 4C        sta 4C
7A78 C8           iny
7A79 8C 21 74     sty 7421
7A7C A9 01        lda #01
7A7E 8D 18 74     sta 7418
7A81 A0 00        ldy #00
7A83 4C 76 74     jmp proc7476_skip2
7A86 AD 26 74     lda 7426
7A89 85 51        sta 51
7A8B AD 27 74     lda 7427
7A8E 85 52        sta 52
7A90 AC 22 74     ldy 7422
7A93 B1 51        lda (51),y
7A95 85 4D        sta 4D
7A97 C8           iny
7A98 B1 51        lda (51),y
7A9A D0 08        bne 7AA4
7A9C A0 00        ldy #00
7A9E 8C 22 74     sty 7422
7AA1 4C 86 7A     jmp 7A86
7AA4 85 4E        sta 4E
7AA6 C8           iny
7AA7 8C 22 74     sty 7422
7AAA A9 01        lda #01
7AAC 8D 19 74     sta 7419
7AAF A0 00        ldy #00
7AB1 4C 66 75     jmp proc7566_skipX
7AB4 AD 28 74     lda 7428
7AB7 85 51        sta 51
7AB9 AD 29 74     lda 7429
7ABC 85 52        sta 52
7ABE AC 23 74     ldy 7423
7AC1 B1 51        lda (51),y
7AC3 85 4F        sta 4F
7AC5 C8           iny
7AC6 B1 51        lda (51),y
7AC8 D0 08        bne 7AD2
7ACA A0 00        ldy #00
7ACC 8C 23 74     sty 7423
7ACF 4C B4 7A     jmp 7AB4
7AD2 85 50        sta 50
7AD4 C8           iny
7AD5 8C 23 74     sty 7423
7AD8 A9 01        lda #01
7ADA 8D 1A 74     sta 741A
7ADD A0 00        ldy #00
7ADF 4C 5D 76     jmp 765D
7AE2 C9 C8        cmp #C8
7AE4 D0 09        bne 7AEF
7AE6 C8           iny
7AE7 B1 4B        lda (4B),y
7AE9 8D A0 73     sta 73A0
7AEC 4C 10 7C     jmp 7C10
7AEF C9 C9        cmp #C9
7AF1 D0 09        bne 7AFC
7AF3 C8           iny
7AF4 B1 4B        lda (4B),y
7AF6 8D A8 73     sta 73A8
7AF9 4C 10 7C     jmp 7C10
7AFC C9 CA        cmp #CA
7AFE D0 09        bne 7B09
7B00 C8           iny
7B01 B1 4B        lda (4B),y
7B03 8D A9 73     sta 73A9
7B06 4C 10 7C     jmp 7C10
7B09 C9 CB        cmp #CB
7B0B D0 09        bne 7B16
7B0D C8           iny
7B0E B1 4B        lda (4B),y
7B10 8D AA 73     sta 73AA
7B13 4C 10 7C     jmp 7C10
7B16 C9 CC        cmp #CC
7B18 D0 0B        bne 7B25
7B1A AD 04 74     lda 7404
7B1D 09 01        ora #01
7B1F 8D 04 74     sta 7404
7B22 4C 10 7C     jmp 7C10
7B25 C9 CD        cmp #CD
7B27 D0 0B        bne 7B34
7B29 AD 05 74     lda 7405
7B2C 09 01        ora #01
7B2E 8D 05 74     sta 7405
7B31 4C 10 7C     jmp 7C10
7B34 C9 CE        cmp #CE
7B36 D0 0B        bne 7B43
7B38 AD 04 74     lda 7404
7B3B 29 FE        and #FE
7B3D 8D 04 74     sta 7404
7B40 4C 10 7C     jmp 7C10
7B43 C9 CF        cmp #CF
7B45 D0 0B        bne 7B52
7B47 AD 05 74     lda 7405
7B4A 29 FE        and #FE
7B4C 8D 05 74     sta 7405
7B4F 4C 10 7C     jmp 7C10
7B52 C9 D0        cmp #D0
7B54 D0 10        bne 7B66
7B56 A9 01        lda #01
7B58 0D C8 73     ora 73C8
7B5B 8D C8 73     sta 73C8
7B5E A9 01        lda #01
7B60 8D CA 73     sta 73CA
7B63 4C 10 7C     jmp 7C10
7B66 C9 D1        cmp #D1
7B68 D0 10        bne 7B7A
7B6A A9 01        lda #01
7B6C 0D BE 73     ora 73BE
7B6F 8D BE 73     sta 73BE
7B72 A9 01        lda #01
7B74 8D C0 73     sta 73C0
7B77 4C 10 7C     jmp 7C10
7B7A C9 D2        cmp #D2
7B7C D0 12        bne 7B90
7B7E A9 01        lda #01
7B80 0D D2 73     ora 73D2
7B83 29 F7        and #F7
7B85 8D D2 73     sta 73D2
7B88 A9 01        lda #01
7B8A 8D D3 73     sta 73D3
7B8D 4C 10 7C     jmp 7C10
7B90 C9 D3        cmp #D3
7B92 D0 10        bne 7BA4
7B94 A9 09        lda #09
7B96 0D D2 73     ora 73D2
7B99 8D D2 73     sta 73D2
7B9C A9 01        lda #01
7B9E 8D D3 73     sta 73D3
7BA1 4C 10 7C     jmp 7C10
7BA4 C9 D4        cmp #D4
7BA6 D0 0B        bne 7BB3
7BA8 AD C8 73     lda 73C8
7BAB 29 FE        and #FE
7BAD 8D C8 73     sta 73C8
7BB0 4C 10 7C     jmp 7C10
7BB3 C9 D5        cmp #D5
7BB5 D0 0B        bne 7BC2
7BB7 AD BE 73     lda 73BE
7BBA 29 FE        and #FE
7BBC 8D BE 73     sta 73BE
7BBF 4C 10 7C     jmp 7C10
7BC2 C9 D6        cmp #D6
7BC4 D0 0B        bne 7BD1
7BC6 AD D2 73     lda 73D2
7BC9 29 FE        and #FE
7BCB 8D D2 73     sta 73D2
7BCE 4C 10 7C     jmp 7C10
7BD1 C9 D7        cmp #D7
7BD3 D0 0B        bne 7BE0
7BD5 AD D2 73     lda 73D2
7BD8 29 F7        and #F7
7BDA 8D D2 73     sta 73D2
7BDD 4C 10 7C     jmp 7C10
7BE0 C9 D8        cmp #D8
7BE2 D0 0F        bne 7BF3
7BE4 C8           iny
7BE5 B1 4B        lda (4B),y
7BE7 8D A6 73     sta 73A6
7BEA C8           iny
7BEB B1 4B        lda (4B),y
7BED 8D A7 73     sta 73A7
7BF0 4C 10 7C     jmp 7C10
7BF3 C9 D9        cmp #D9
7BF5 D0 09        bne 7C00  ;slow
7BF7 C8           iny
7BF8 B1 4B        lda (4B),y
7BFA 8D 06 74     sta 7406
7BFD 4C 10 7C     jmp 7C10
7C00 C9 DA        cmp #DA
7C02 D0 0C        bne 7C10
7C04 C8           iny
7C05 B1 4B        lda (4B),y
7C07 8D C1 73     sta 73C1
7C0A C8           iny
7C0B B1 4B        lda (4B),y
7C0D 8D C2 73     sta 73C2
7C10 C8           iny
7C11 18           clc
7C12 98           tya
7C13 65 4B        adc 4B
7C15 85 4B        sta 4B
7C17 A5 4C        lda 4C
7C19 69 00        adc #00
7C1B 85 4C        sta 4C
7C1D A0 00        ldy #00
7C1F A9 01        lda #01
7C21 8D 18 74     sta 7418
7C24 4C 76 74     jmp proc7476_skip2
7C27 C9 C9        cmp #C9
7C29 D0 09        bne 7C34
7C2B C8           iny
7C2C B1 4D        lda (4D),y
7C2E 8D AF 73     sta 73AF
7C31 4C C3 7C     jmp 7CC3
7C34 C9 CA        cmp #CA
7C36 D0 09        bne 7C41
7C38 C8           iny
7C39 B1 4D        lda (4D),y
7C3B 8D B0 73     sta 73B0
7C3E 4C C3 7C     jmp 7CC3
7C41 C9 CB        cmp #CB
7C43 D0 09        bne 7C4E
7C45 C8           iny
7C46 B1 4D        lda (4D),y
7C48 8D B1 73     sta 73B1
7C4B 4C C3 7C     jmp 7CC3
7C4E C9 D0        cmp #D0
7C50 D0 10        bne 7C62
7C52 A9 02        lda #02
7C54 0D C8 73     ora 73C8
7C57 8D C8 73     sta 73C8
7C5A A9 01        lda #01
7C5C 8D CA 73     sta 73CA
7C5F 4C C3 7C     jmp 7CC3
7C62 C9 D1        cmp #D1
7C64 D0 0D        bne 7C73
7C66 A9 02        lda #02
7C68 0D BE 73     ora 73BE
7C6B 8D BE 73     sta 73BE
7C6E A9 01        lda #01
7C70 4C C3 7C     jmp 7CC3
7C73 C9 D4        cmp #D4
7C75 D0 0B        bne 7C82
7C77 AD C8 73     lda 73C8
7C7A 29 FD        and #FD
7C7C 8D C8 73     sta 73C8
7C7F 4C C3 7C     jmp 7CC3
7C82 C9 D5        cmp #D5
7C84 D0 0B        bne 7C91
7C86 AD BE 73     lda 73BE
7C89 29 FD        and #FD
7C8B 8D BE 73     sta 73BE
7C8E 4C C3 7C     jmp 7CC3
7C91 C9 D8        cmp #D8
7C93 D0 0C        bne 7CA1
7C95 C8           iny
7C96 B1 4D        lda (4D),y
7C98 8D AD 73     sta 73AD
7C9B C8           iny
7C9C B1 4D        lda (4D),y
7C9E 8D AE 73     sta 73AE
7CA1 C9 D2        cmp #D2
7CA3 D0 12        bne 7CB7
7CA5 A9 02        lda #02
7CA7 0D D2 73     ora 73D2
7CAA 29 EF        and #EF
7CAC 8D D2 73     sta 73D2
7CAF A9 01        lda #01
7CB1 8D D4 73     sta 73D4
7CB4 4C C3 7C     jmp 7CC3
7CB7 C9 D6        cmp #D6
7CB9 D0 08        bne 7CC3
7CBB AD D2 73     lda 73D2
7CBE 29 ED        and #ED
7CC0 8D D2 73     sta 73D2
7CC3 C8           iny
7CC4 18           clc
7CC5 98           tya
7CC6 65 4D        adc 4D
7CC8 85 4D        sta 4D
7CCA A5 4E        lda 4E
7CCC 69 00        adc #00
7CCE 85 4E        sta 4E
7CD0 A0 00        ldy #00
7CD2 A9 01        lda #01
7CD4 8D 19 74     sta 7419
7CD7 4C 66 75     jmp proc7566_skipX
7CDA C9 C9        cmp #C9
7CDC D0 09        bne 7CE7
7CDE C8           iny
7CDF B1 4F        lda (4F),y
7CE1 8D B6 73     sta 73B6
7CE4 4C 57 7D     jmp 7D57
7CE7 C9 CA        cmp #CA
7CE9 D0 09        bne 7CF4
7CEB C8           iny
7CEC B1 4F        lda (4F),y
7CEE 8D B7 73     sta 73B7
7CF1 4C 57 7D     jmp 7D57
7CF4 C9 CB        cmp #CB
7CF6 D0 09        bne 7D01  ;slow
7CF8 C8           iny
7CF9 B1 4F        lda (4F),y
7CFB 8D B8 73     sta 73B8
7CFE 4C 57 7D     jmp 7D57
7D01 C9 D0        cmp #D0
7D03 D0 10        bne 7D15
7D05 A9 04        lda #04
7D07 0D C8 73     ora 73C8
7D0A 8D C8 73     sta 73C8
7D0D A9 01        lda #01
7D0F 8D CA 73     sta 73CA
7D12 4C 57 7D     jmp 7D57
7D15 C9 D1        cmp #D1
7D17 D0 10        bne 7D29
7D19 A9 04        lda #04
7D1B 0D BE 73     ora 73BE
7D1E 8D BE 73     sta 73BE
7D21 A9 01        lda #01
7D23 8D C0 73     sta 73C0
7D26 4C 57 7D     jmp 7D57
7D29 C9 D4        cmp #D4
7D2B D0 0B        bne 7D38
7D2D AD C8 73     lda 73C8
7D30 29 FB        and #FB
7D32 8D C8 73     sta 73C8
7D35 4C 57 7D     jmp 7D57
7D38 C9 D5        cmp #D5
7D3A D0 0B        bne 7D47
7D3C AD BE 73     lda 73BE
7D3F 29 FB        and #FB
7D41 8D BE 73     sta 73BE
7D44 4C 57 7D     jmp 7D57
7D47 C9 D8        cmp #D8
7D49 D0 0C        bne 7D57
7D4B C8           iny
7D4C B1 4F        lda (4F),y
7D4E 8D B4 73     sta 73B4
7D51 C8           iny
7D52 B1 4F        lda (4F),y
7D54 8D B5 73     sta 73B5
7D57 C8           iny
7D58 18           clc
7D59 98           tya
7D5A 65 4F        adc 4F
7D5C 85 4F        sta 4F
7D5E A5 50        lda 50
7D60 69 00        adc #00
7D62 85 50        sta 50
7D64 A0 00        ldy #00
7D66 A9 01        lda #01
7D68 8D 1A 74     sta 741A
7D6B 4C 5D 76     jmp 765D
7D6E 8D 20 74     sta 7420
7D71 29 0F        and #0F
7D73 0A           asl a
7D74 AA           tax
7D75 BD B7 7D     lda 7DB7,x
7D78 8D 11 74     sta 7411
7D7B E8           inx
7D7C BD B7 7D     lda 7DB7,x
7D7F 8D 12 74     sta 7412
7D82 AD 20 74     lda 7420
7D85 29 70        and #70
7D87 4A           lsr a
7D88 4A           lsr a
7D89 4A           lsr a
7D8A 4A           lsr a
7D8B C9 05        cmp #05
7D8D F0 27        beq 7DB6
7D8F 90 15        bcc 7DA6
7D91 18           clc
7D92 0E 12 74     asl 7412
7D95 2E 11 74     rol 7411
7D98 C9 06        cmp #06
7D9A F0 1A        beq 7DB6
7D9C 18           clc
7D9D 0E 12 74     asl 7412
7DA0 2E 11 74     rol 7411
7DA3 4C B6 7D     jmp 7DB6

;syf
7DA6 AA           tax
7DA7 BD D1 7D     lda 7DD1,x
7DAA AA           tax
7DAB 18           clc
7DAC 18           clc
7DAD 4E 11 74     lsr 7411
7DB0 6E 12 74     ror 7412
7DB3 CA           dex
7DB4 10 F5        bpl 7DAB
7DB6 60           rts
7DB7 00           brk 
7DB8 00           brk 
7DB9 21 87        and (87,x)
7DBB 23 86        rla (86,x)
7DBD 25 A2        and A2
7DBF 27 DF        rla DF
7DC1 2A           rol a
7DC2 3E 2C C1     rol C12C,x
7DC5 2F 6B 32     rla 326B
7DC8 3C 35 39     nop 3935,x
7DCB 38           sec
7DCC 63 3B        rra (3B,x)
7DCE BE 3F 4B     ldx 4B3F,y
7DD1 04 03        nop 03
7DD3 02           kil
7DD4 01 00        ora (00,x)
7DD6 E0 00        cpx #00
7DD8 D0 11        bne 7DEB
7DDA CE 1B 74     dec 741B
7DDD F0 01        beq 7DE0
7DDF 60           rts

7DE0 A9 00        lda #00
7DE2 8D 0E 74     sta 740E
7DE5 A9 01        lda #01
7DE7 8D 18 74     sta 7418
7DEA 60           rts

7DEB E0 07        cpx #07
7DED D0 11        bne 7E00  ;slow
7DEF CE 1C 74     dec 741C
7DF2 F0 01        beq 7DF5
7DF4 60           rts

7DF5 A9 00        lda #00
7DF7 8D 0F 74     sta 740F
7DFA A9 01        lda #01
7DFC 8D 19 74     sta 7419
7DFF 60           rts

7E00 CE 1D 74     dec 741D
7E03 F0 01        beq 7E06
7E05 60           rts

7E06 A9 00        lda #00
7E08 8D 10 74     sta 7410
7E0B A9 01        lda #01
7E0D 8D 1A 74     sta 741A
7E10 60           rts

7E11 A9 08        lda #08
7E13 9D 05 D4     sta D405,x
7E16 A9 00        lda #00
7E18 9D 06 D4     sta D406,x
7E1B A9 FA        lda #FA
7E1D 9D 01 D4     sta D401,x
7E20 A9 80        lda #80
7E22 9D 04 D4     sta D404,x
7E25 A9 81        lda #81
7E27 9D 04 D4     sta D404,x
7E2A 60           rts

;syf
7E2B 60           rts
7E2C 60           rts
7E2D 60           rts
7E2E 60           rts

;dane
7E2F              .byte $CF
7E30              .byte $91
7E31              .byte $34
7E32              .byte $93

7E33              .byte $00
Choose_Play_SFX              .byte $00 ; wybiera nr. efektu SFX, odgrywanego na SID
7E35 00           brk
7E36 00           brk
7E37 00           brk
7E38 00           brk
7E39 00           brk
7E3A 00           brk
7E3B 00           brk
7E3C 00           brk
7E3D 00           brk

; player SID-a????
proc7E3E          lda 7E35
7E41 D0 56        bne 7E99

7E43 AD 34 7E     lda Choose_Play_SFX
7E46 D0 03        bne 7E4B

7E48 4C E6 81     jmp 81E6
7E4B C9 01        cmp #01
7E4D D0 06        bne 7E55
7E4F 8D 35 7E     sta 7E35
7E52 4C C6 7E     jmp 7EC6
7E55 C9 02        cmp #02
7E57 D0 06        bne 7E5F
7E59 8D 35 7E     sta 7E35
7E5C 4C 23 7F     jmp 7F23
7E5F C9 03        cmp #03
7E61 D0 06        bne 7E69
7E63 8D 35 7E     sta 7E35
7E66 4C C7 7F     jmp 7FC7
7E69 C9 04        cmp #04
7E6B D0 06        bne 7E73
7E6D 8D 35 7E     sta 7E35
7E70 4C 21 80     jmp 8021
7E73 C9 05        cmp #05
7E75 D0 06        bne 7E7D
7E77 8D 35 7E     sta 7E35
7E7A 4C B1 80     jmp 80B1
7E7D C9 06        cmp #06
7E7F D0 06        bne 7E87
7E81 8D 35 7E     sta 7E35
7E84 4C 2F 81     jmp 812F
7E87 C9 07        cmp #07
7E89 D0 06        bne 7E91
7E8B 8D 35 7E     sta 7E35
7E8E 4C 23 7F     jmp 7F23

7E91 A9 FF        lda #FF
7E93 8D 34 7E     sta Choose_Play_SFX

7E96 4C E6 81     jmp 81E6
7E99 C9 01        cmp #01
7E9B D0 03        bne 7EA0
7E9D 4C 09 7F     jmp 7F09
7EA0 C9 02        cmp #02
7EA2 D0 03        bne 7EA7
7EA4 4C 79 7F     jmp 7F79
7EA7 C9 03        cmp #03
7EA9 D0 03        bne 7EAE
7EAB 4C F1 7F     jmp 7FF1
7EAE C9 04        cmp #04
7EB0 D0 03        bne 7EB5
7EB2 4C 53 80     jmp 8053
7EB5 C9 05        cmp #05
7EB7 D0 03        bne 7EBC
7EB9 4C F0 80     jmp 80F0
7EBC C9 06        cmp #06
7EBE D0 03        bne 7EC3
7EC0 4C 5E 81     jmp 815E
7EC3 4C 98 81     jmp 8198
7EC6 20 E7 81     jsr 81E7
7EC9 A9 00        lda #00
7ECB 8D 05 74     sta 7405
7ECE A9 1F        lda #1F
7ED0 8D 18 D4     sta D418  ;SidFltMode
7ED3 A9 F1        lda #F1
7ED5 8D 17 D4     sta D417  ;SidFltCtrl
7ED8 A9 08        lda #08
7EDA 8D 05 D4     sta D405  ;Sid1AttDec
7EDD A9 64        lda #64
7EDF 8D 15 D4     sta D415  ;SidFltLsb
7EE2 A9 96        lda #96
7EE4 8D 16 D4     sta D416  ;SidFltMsb
7EE7 A9 0A        lda #0A
7EE9 8D 01 D4     sta D401  ;Sid1FreqMsb
7EEC A9 0A        lda #0A
7EEE 8D 00 D4     sta D400  ;Sid1FreqLsb
7EF1 A9 80        lda #80
7EF3 8D 04 D4     sta D404  ;Sid1Ctrl
7EF6 A9 81        lda #81
7EF8 8D 04 D4     sta D404  ;Sid1Ctrl
7EFB A9 00        lda #00
7EFD 8D 06 D4     sta D406  ;Sid1SusRel
7F00 8D 0D D4     sta D40D  ;Sid2SusRel
7F03 8D 38 7E     sta 7E38
7F06 4C E6 81     jmp 81E6
7F09 EE 38 7E     inc 7E38
7F0C AD 38 7E     lda 7E38
7F0F C9 0F        cmp #0F
7F11 D0 0D        bne 7F20
7F13 A9 07        lda #07
7F15 8D 05 74     sta 7405
7F18 A9 00        lda #00
7F1A 8D 35 7E     sta 7E35

7F1D 8D 34 7E     sta Choose_Play_SFX

7F20 4C E6 81     jmp 81E6
7F23 A9 00        lda #00
7F25 8D 36 7E     sta 7E36
7F28 8D 05 74     sta 7405
7F2B 8D 37 7E     sta 7E37
7F2E 8D 38 7E     sta 7E38
7F31 8D 17 D4     sta D417  ;SidFltCtrl
7F34 A9 0F        lda #0F
7F36 8D 3A 7E     sta 7E3A
7F39 8D 05 D4     sta D405  ;Sid1AttDec
7F3C 8D 0C D4     sta D40C  ;Sid2AttDec
7F3F A9 0C        lda #0C
7F41 8D 18 D4     sta D418  ;SidFltMode
7F44 A9 F0        lda #F0
7F46 8D 06 D4     sta D406  ;Sid1SusRel
7F49 8D 0D D4     sta D40D  ;Sid2SusRel
7F4C A9 04        lda #04
7F4E 8D 01 D4     sta D401  ;Sid1FreqMsb
7F51 A9 30        lda #30
7F53 8D 00 D4     sta D400  ;Sid1FreqLsb
7F56 A9 0A        lda #0A
7F58 8D 08 D4     sta D408  ;Sid2FreqMsb
7F5B A9 8F        lda #8F
7F5D 8D 09 D4     sta D409  ;Sid2PulseLsb
7F60 A9 40        lda #40
7F62 8D 04 D4     sta D404  ;Sid1Ctrl
7F65 8D 0B D4     sta D40B  ;Sid2Ctrl
7F68 A9 41        lda #41
7F6A 8D 04 D4     sta D404  ;Sid1Ctrl
7F6D 8D 0B D4     sta D40B  ;Sid2Ctrl

7F70 AD 34 7E     lda Choose_Play_SFX
7F73 8D 35 7E     sta 7E35

7F76 4C E6 81     jmp 81E6
7F79 AD 36 7E     lda 7E36
7F7C 18           clc
7F7D 69 10        adc #10
7F7F 8D 36 7E     sta 7E36
7F82 8D 02 D4     sta D402  ;Sid1PulseLsb
7F85 AD 37 7E     lda 7E37
7F88 69 00        adc #00
7F8A 8D 37 7E     sta 7E37
7F8D 8D 03 D4     sta D403  ;Sid1PulseMsb
7F90 AD 39 7E     lda 7E39
7F93 38           sec
7F94 E9 10        sbc #10
7F96 8D 39 7E     sta 7E39
7F99 8D 09 D4     sta D409  ;Sid2PulseLsb
7F9C AD 3A 7E     lda 7E3A
7F9F E9 00        sbc #00
7FA1 8D 3A 7E     sta 7E3A
7FA4 8D 0A D4     sta D40A  ;Sid2PulseMsb
7FA7 EE 38 7E     inc 7E38
7FAA AD 38 7E     lda 7E38
7FAD C9 FC        cmp #FC
7FAF D0 13        bne 7FC4
7FB1 A9 00        lda #00
7FB3 8D 35 7E     sta 7E35
7FB6 8D 34 7E     sta Choose_Play_SFX
7FB9 8D 04 D4     sta D404  ;Sid1Ctrl
7FBC 8D 0B D4     sta D40B  ;Sid2Ctrl
7FBF A9 07        lda #07
7FC1 8D 05 74     sta 7405
7FC4 4C E6 81     jmp 81E6
7FC7 A9 00        lda #00
7FC9 8D 05 74     sta 7405
7FCC 8D 38 7E     sta 7E38
7FCF 8D 3B 7E     sta 7E3B
7FD2 20 E7 81     jsr 81E7
7FD5 A9 0F        lda #0F
7FD7 8D 18 D4     sta D418  ;SidFltMode
7FDA A9 09        lda #09
7FDC 8D 05 D4     sta D405  ;Sid1AttDec
7FDF A9 80        lda #80
7FE1 8D 04 D4     sta D404  ;Sid1Ctrl
7FE4 A9 81        lda #81
7FE6 8D 04 D4     sta D404  ;Sid1Ctrl
7FE9 A9 03        lda #03
7FEB 8D 35 7E     sta 7E35
7FEE 4C E6 81     jmp 81E6
7FF1 AE 3B 7E     ldx 7E3B
7FF4 BD 12 80     lda 8012,x
7FF7 8D 01 D4     sta D401  ;Sid1FreqMsb
7FFA E8           inx
7FFB 8E 3B 7E     stx 7E3B
7FFE E0 0E        cpx #0E
8000 D0 0D        bne 800F
8002 A9 00        lda #00
8004 8D 35 7E     sta 7E35
8007 8D 34 7E     sta Choose_Play_SFX
800A A9 07        lda #07
800C 8D 05 74     sta 7405
800F 4C E6 81     jmp 81E6
8012 05 0A        ora 0A
8014 0F 14 19     slo 1914
8017 1E 28 3C     asl 3C28,x
801A 50 64        bvc 8080
801C 8C B4 DC     sty DCB4
801F F0 FF        beq 8020
8021 20 E7 81     jsr 81E7
8024 A9 00        lda #00
8026 8D 05 74     sta 7405
8029 A9 0F        lda #0F
802B 8D 18 D4     sta D418  ;SidFltMode
802E A9 00        lda #00
8030 8D 38 7E     sta 7E38
8033 8D 17 D4     sta D417  ;SidFltCtrl
8036 A9 01        lda #01
8038 8D 3B 7E     sta 7E3B
803B 8D 3C 7E     sta 7E3C
803E 8D 3D 7E     sta 7E3D
8041 A9 0F        lda #0F
8043 8D 05 D4     sta D405  ;Sid1AttDec
8046 A9 04        lda #04
8048 8D 34 7E     sta Choose_Play_SFX
804B A9 80        lda #80
804D 8D 04 D4     sta D404  ;Sid1Ctrl
8050 4C E6 81     jmp 81E6
8053 CE 3D 7E     dec 7E3D
8056 D0 4D        bne 80A5
8058 A9 02        lda #02
805A 8D 3D 7E     sta 7E3D
805D AD 3C 7E     lda 7E3C
8060 F0 12        beq 8074
8062 A9 00        lda #00
8064 8D 3C 7E     sta 7E3C
8067 A9 81        lda #81
8069 8D 04 D4     sta D404  ;Sid1Ctrl
806C A9 32        lda #32
806E 8D 01 D4     sta D401  ;Sid1FreqMsb
8071 4C 8B 80     jmp 808B
8074 AE 3B 7E     ldx 7E3B
8077 BD A8 80     lda 80A8,x
807A 8D 01 D4     sta D401  ;Sid1FreqMsb
807D A9 21        lda #21
807F 8D 04 D4     sta D404  ;Sid1Ctrl
8082 A9 01        lda #01
8084 8D 3C 7E     sta 7E3C
8087 E8           inx
8088 8E 3B 7E     stx 7E3B
808B AD 38 7E     lda 7E38
808E EE 38 7E     inc 7E38
8091 C9 0A        cmp #0A
8093 D0 10        bne 80A5
8095 A9 00        lda #00
8097 8D 35 7E     sta 7E35
809A 8D 34 7E     sta Choose_Play_SFX
809D 8D 04 D4     sta D404  ;Sid1Ctrl
80A0 A9 07        lda #07
80A2 8D 05 74     sta 7405
80A5 4C E6 81     jmp 81E6
80A8 02           kil
80A9 04 08        nop 08
80AB 10 20        bpl 80CD
80AD 40           rti
80AE 80 C8        nop #C8
80B0 FF A9 00     isc 00A9,x
80B3 8D 05 74     sta 7405
80B6 20 E7 81     jsr 81E7
80B9 A9 F0        lda #F0
80BB 8D 06 D4     sta D406  ;Sid1SusRel
80BE 8D 0D D4     sta D40D  ;Sid2SusRel
80C1 A9 0F        lda #0F
80C3 8D 05 D4     sta D405  ;Sid1AttDec
80C6 AD 0C D4     lda D40C  ;Sid2AttDec
80C9 A9 0A        lda #0A
80CB 8D 18 D4     sta D418  ;SidFltMode
80CE A9 1E        lda #1E
80D0 8D 37 7E     sta 7E37
80D3 A9 21        lda #21
80D5 8D 3A 7E     sta 7E3A
80D8 A9 20        lda #20
80DA 8D 0B D4     sta D40B  ;Sid2Ctrl
80DD 8D 04 D4     sta D404  ;Sid1Ctrl
80E0 A9 21        lda #21
80E2 8D 0B D4     sta D40B  ;Sid2Ctrl
80E5 8D 04 D4     sta D404  ;Sid1Ctrl
80E8 A9 05        lda #05
80EA 8D 35 7E     sta 7E35
80ED 4C E6 81     jmp 81E6
80F0 AD 37 7E     lda 7E37
80F3 8D 01 D4     sta D401  ;Sid1FreqMsb
80F6 EE 37 7E     inc 7E37
80F9 AD 37 7E     lda 7E37
80FC C9 32        cmp #32
80FE D0 05        bne 8105
8100 A9 1E        lda #1E
8102 8D 37 7E     sta 7E37
8105 AD 3A 7E     lda 7E3A
8108 8D 08 D4     sta D408  ;Sid2FreqMsb
810B EE 3A 7E     inc 7E3A
810E AD 3A 7E     lda 7E3A
8111 C9 32        cmp #32
8113 D0 05        bne 811A
8115 A9 1E        lda #1E
8117 8D 3A 7E     sta 7E3A
811A AD 34 7E     lda Choose_Play_SFX
811D D0 0D        bne 812C
811F A9 00        lda #00
8121 8D 35 7E     sta 7E35
8124 A9 07        lda #07
8126 8D 05 74     sta 7405
8129 20 E7 81     jsr 81E7
812C 4C E6 81     jmp 81E6
812F 20 E7 81     jsr 81E7
8132 A9 00        lda #00
8134 8D 05 74     sta 7405
8137 8D 38 7E     sta 7E38
813A 8D 3B 7E     sta 7E3B
813D A9 0F        lda #0F
813F 8D 18 D4     sta D418  ;SidFltMode
8142 A9 0A        lda #0A
8144 8D 05 D4     sta D405  ;Sid1AttDec
8147 A9 04        lda #04
8149 8D 03 D4     sta D403  ;Sid1PulseMsb
814C A9 40        lda #40
814E 8D 04 D4     sta D404  ;Sid1Ctrl
8151 A9 41        lda #41
8153 8D 04 D4     sta D404  ;Sid1Ctrl
8156 A9 06        lda #06
8158 8D 35 7E     sta 7E35
815B 4C E6 81     jmp 81E6
815E AE 3B 7E     ldx 7E3B
8161 BD 82 81     lda 8182,x
8164 8D 01 D4     sta D401  ;Sid1FreqMsb
8167 E8           inx
8168 8E 3B 7E     stx 7E3B
816B E0 0A        cpx #0A
816D D0 10        bne 817F
816F A9 00        lda #00
8171 8D 35 7E     sta 7E35
8174 8D 34 7E     sta Choose_Play_SFX
8177 20 E7 81     jsr 81E7
817A A9 07        lda #07
817C 8D 05 74     sta 7405
817F 4C E6 81     jmp 81E6
8182 64 5A        nop 5A
8184 50 46        bvc 81CC
8186 3C 32 28     nop 2832,x
8189 1E 14 13     asl 1314,x
818C 12           kil
818D 11 10        ora (10),y
818F 0F 0E 0D     slo 0D0E
8192 0C 0A 09     nop 090A
8195 08           php
8196 07 06        slo 06
8198 AD 36 7E     lda 7E36
819B 18           clc
819C 69 20        adc #20
819E 8D 36 7E     sta 7E36
81A1 8D 02 D4     sta D402  ;Sid1PulseLsb
81A4 AD 37 7E     lda 7E37
81A7 69 00        adc #00
81A9 8D 37 7E     sta 7E37
81AC 8D 03 D4     sta D403  ;Sid1PulseMsb
81AF AD 39 7E     lda 7E39
81B2 38           sec
81B3 E9 20        sbc #20
81B5 8D 39 7E     sta 7E39
81B8 8D 09 D4     sta D409  ;Sid2PulseLsb
81BB AD 3A 7E     lda 7E3A
81BE E9 00        sbc #00
81C0 8D 3A 7E     sta 7E3A
81C3 8D 0A D4     sta D40A  ;Sid2PulseMsb
81C6 EE 38 7E     inc 7E38
81C9 AD 38 7E     lda 7E38
81CC C9 7E        cmp #7E
81CE D0 13        bne 81E3
81D0 A9 00        lda #00
81D2 8D 35 7E     sta 7E35
81D5 8D 34 7E     sta Choose_Play_SFX
81D8 8D 04 D4     sta D404  ;Sid1Ctrl
81DB 8D 0B D4     sta D40B  ;Sid2Ctrl
81DE A9 07        lda #07
81E0 8D 05 74     sta 7405
81E3 4C E6 81     jmp 81E6
81E6 60           rts

81E7 A9 00        lda #00
81E9 8D 18 D4     sta D418  ;SidFltMode
81EC 8D 05 D4     sta D405  ;Sid1AttDec
81EF 8D 0C D4     sta D40C  ;Sid2AttDec
81F2 8D 06 D4     sta D406  ;Sid1SusRel
81F5 8D 0D D4     sta D40D  ;Sid2SusRel
81F8 8D 04 D4     sta D404  ;Sid1Ctrl
81FB 8D 0B D4     sta D40B  ;Sid2Ctrl
81FE 60           rts

81FF 78           sei
8200 A9 3E        lda #3E
8202 8D 14 03     sta IRQ_VECT
8205 A9 7E        lda #7E
8207 8D 15 03     sta IRQ_VECT+1
820A A9 00        lda #00
820C 8D 35 7E     sta 7E35
820F 8D 34 7E     sta Choose_Play_SFX
8212 58           cli
8213 60           rts

; obszar $8214-$83FF  - same wartoci $FF tutaj byy!

;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia jakie wartoci???
proc8400          mva #$97 4B
                  mva #$84 4C
                  mva #$63 4D
                  mva #$86 4E
                  mva #$DE 4F
                  mva #$89 50
                  mva #$67 7424
                  mva #$84 7425
                  mva #$77 7426
                  mva #$84 7427
                  mva #$87 7428
                  mva #$84 7429
                  mva #$04 7406
                  mva #$01 73D6
                  sta 73D7
                  mva #$00 73DB
                  mva #$3C 73DC
                  mva #$04 7407
                  sta 7418
                  sta 7419
                  sta 741A
                  mva #$02 7421
                  sta 7422
                  sta 7423
                  rts

;syf
8467 97 84        sax 84,y
8469 97 84        sax 84,y
846B 01 85        ora (85,x)
846D 01 85        ora (85,x)
846F 8E 85 8E     stx 8E85
8472 85 00        sta 00  ;CpuDataDir
8474 00           brk
8475 00           brk
8476 00           brk
8477 63 86        rra (86,x)
8479 63 86        rra (86,x)
847B C7 86        dcp 86
847D C7 86        dcp 86
847F 52           kil
8480 87 52        sax 52
8482 87 00        sax 00  ;CpuDataDir
8484 00           brk
8485 00           brk
8486 00           brk
8487 DE 89 DE     dec DE89,x
848A 89 88        nop #88
848C 8A           txa
848D 88           dey
848E 8A           txa
848F 33 8B        rla (8B),y
8491 33 8B        rla (8B),y
8493 00           brk
8494 00           brk
8495 00           brk 
8496 00           brk 
8497 D0 D8        bne 8471
8499 0A           asl a
849A 0A           asl a
849B 08           php
849C 00           brk
849D 04 4B        nop 4B
849F 04 51        nop 51
84A1 04 53        nop 53
84A3 04 51        nop 51
84A5 04 4B        nop 4B
84A7 0C 53 04     nop 0453
84AA 4B 04        alr #04
84AC 51 04        eor (04),y
84AE 53 04        sre (04),y
84B0 51 04        eor (04),y
84B2 4B 0C        alr #0C
84B4 53 04        sre (04),y
84B6 4A           lsr a
84B7 04 4B        nop 4B
84B9 04 51        nop 51
84BB 04 4B        nop 4B
84BD 04 4A        nop 4A
84BF 0C 51 04     nop 0451
84C2 4A           lsr a
84C3 04 4B        nop 4B
84C5 04 51        nop 51
84C7 04 4B        nop 4B
84C9 04 4A        nop 4A
84CB 0C 51 04     nop 0451
84CE 48           pha
84CF 04 4A        nop 4A
84D1 04 4B        nop 4B
84D3 04 4A        nop 4A
84D5 04 48        nop 48
84D7 0C 4B 04     nop 044B
84DA 48           pha
84DB 04 4A        nop 4A
84DD 04 4B        nop 4B
84DF 04 4A        nop 4A
84E1 04 48        nop 48
84E3 10 4B        bpl 8530  ;slow
84E5 0C 4A 08     nop 084A
84E8 48           pha
84E9 0C 46 0C     nop 0C46
84EC 44 04        nop 04
84EE 46 04        lsr 04
84F0 44 CA        nop CA
84F2 0B 10        anc #10
84F4 43 10        sre (10,x)
84F6 47 10        sre 10
84F8 4A           lsr a
84F9 10 54        bpl 854F  ;slow
84FB 40           rti
84FC 53 CA        sre (CA),y
84FE 09 00        ora #00
8500 00           brk
8501 CA           dex
8502 09 D5        ora #D5
8504 D8           cld
8505 01 02        ora (02,x)
8507 08           php
8508 00           brk
8509 04 4B        nop 4B
850B 04 51        nop 51
850D 04 53        nop 53
850F 04 51        nop 51
8511 04 4B        nop 4B
8513 0C 53 04     nop 0453
8516 4B 04        alr #04
8518 51 04        eor (04),y
851A 53 04        sre (04),y
851C 51 04        eor (04),y
851E 4B 0C        alr #0C
8520 51 04        eor (04),y
8522 4A           lsr a
8523 04 4B        nop 4B
8525 04 51        nop 51
8527 04 4B        nop 4B
8529 04 4A        nop 4A
852B 0C 51 04     nop 0451
852E 4A           lsr a
852F 04 4B        nop 4B
8531 04 51        nop 51
8533 04 4B        nop 4B
8535 04 4A        nop 4A
8537 0C 4B 04     nop 044B
853A 48           pha
853B 04 4A        nop 4A
853D 04 4B        nop 4B
853F 04 4A        nop 4A
8541 04 48        nop 48
8543 0C 4B 04     nop 044B
8546 48           pha
8547 04 4A        nop 4A
8549 04 4B        nop 4B
854B 04 4A        nop 4A
854D 04 48        nop 48
854F 0C 4B 04     nop 044B
8552 48           pha
8553 04 4A        nop 4A
8555 04 4B        nop 4B
8557 04 4A        nop 4A
8559 04 48        nop 48
855B 0C 4B 04     nop 044B
855E 48           pha
855F 04 4A        nop 4A
8561 04 4B        nop 4B
8563 04 4A        nop 4A
8565 04 48        nop 48
8567 0C 4B 04     nop 044B
856A 48           pha
856B 04 4A        nop 4A
856D 04 4B        nop 4B
856F 04 4A        nop 4A
8571 04 48        nop 48
8573 0C 4B 04     nop 044B
8576 48           pha
8577 04 4A        nop 4A
8579 04 4B        nop 4B
857B 04 4A        nop 4A
857D 04 48        nop 48
857F 04 4A        nop 4A
8581 D3 D0        dcp (D0),y
8583 CA           dex
8584 0F 40 6A     slo 6A40
8587 D6 CA        dec CA,x
8589 0A           asl a
858A D1 00        cmp (00),y
858C 00           brk 
858D 00           brk
858E CA           dex
858F 0A           asl a
8590 DA           nop
8591 00           brk 
8592 04 D4        nop D4
8594 04 00        nop 00  ;CpuDataDir
8596 04 5B        nop 5B
8598 04 5A        nop 5A
859A 04 5B        nop 5B
859C 04 58        nop 58
859E 04 5B        nop 5B
85A0 04 53        nop 53
85A2 04 58        nop 58
85A4 08           php
85A5 4B 04        alr #04
85A7 4B 18        alr #18
85A9 58           cli
85AA 04 5B        nop 5B
85AC 04 5A        nop 5A
85AE 04 5B        nop 5B
85B0 04 58        nop 58
85B2 04 5B        nop 5B
85B4 04 53        nop 53
85B6 04 58        nop 58
85B8 08           php
85B9 4B 04        alr #04
85BB 4B 18        alr #18
85BD 58           cli
85BE 04 5A        nop 5A
85C0 04 58        nop 58
85C2 04 5A        nop 5A
85C4 04 57        nop 57
85C6 04 5A        nop 5A
85C8 04 51        nop 51
85CA 04 57        nop 57
85CC 08           php
85CD 4A           lsr a
85CE 04 4A        nop 4A
85D0 18           clc
85D1 57 04        sre 04,x
85D3 5A           nop
85D4 04 58        nop 58
85D6 04 5A        nop 5A
85D8 04 57        nop 57
85DA 04 5A        nop 5A
85DC 04 51        nop 51
85DE 04 57        nop 57
85E0 08           php
85E1 4A           lsr a
85E2 04 4A        nop 4A
85E4 18           clc
85E5 57 04        sre 04,x
85E7 58           cli
85E8 04 56        nop 56
85EA 04 58        nop 58
85EC 04 54        nop 54
85EE 04 58        nop 58
85F0 04 4B        nop 4B
85F2 04 54        nop 54
85F4 08           php
85F5 48           pha
85F6 04 48        nop 48
85F8 18           clc
85F9 54 04        nop 04,x
85FB 58           cli
85FC 04 56        nop 56
85FE 04 58        nop 58
8600 04 54        nop 54
8602 04 58        nop 58
8604 04 4B        nop 4B
8606 04 54        nop 54
8608 08           php
8609 48           pha
860A 04 48        nop 48
860C 18           clc
860D 54 04        nop 04,x
860F 58           cli
8610 04 56        nop 56
8612 04 58        nop 58
8614 04 54        nop 54
8616 04 58        nop 58
8618 04 51        nop 51
861A 04 54        nop 54
861C 08           php
861D 48           pha
861E 04 48        nop 48
8620 18           clc
8621 54 04        nop 04,x
8623 58           cli
8624 04 56        nop 56
8626 04 58        nop 58
8628 04 54        nop 54
862A 04 58        nop 58
862C 04 51        nop 51
862E 04 54        nop 54
8630 08           php
8631 48           pha
8632 04 48        nop 48
8634 18           clc
8635 54 04        nop 04,x
8637 57 04        sre 04,x
8639 55 04        eor 04,x
863B 57 04        sre 04,x
863D 53 04        sre (04),y
863F 57 04        sre 04,x
8641 51 04        eor (04),y
8643 57 08        sre 08,x
8645 4A           lsr a
8646 04 4A        nop 4A
8648 18           clc
8649 53 04        sre (04),y
864B 57 04        sre 04,x
864D 55 04        eor 04,x
864F 57 04        sre 04,x
8651 53 04        sre (04),y
8653 57 04        sre 04,x
8655 51 04        eor (04),y
8657 57 08        sre 08,x
8659 4A           lsr a
865A 04 4A        nop 4A
865C 14 53        nop 53,x
865E DA           nop
865F 01 0F        ora (0F,x)
8661 00           brk
8662 00           brk
8663 CA           dex
8664 09 D8        ora #D8
8666 0A           asl a
8667 0A           asl a
8668 D4 D1        nop D1,x
866A D6 08        dec 08,x
866C 00           brk
866D 04 48        nop 48
866F 04 4A        nop 4A
8671 04 4B        nop 4B
8673 04 4A        nop 4A
8675 04 48        nop 48
8677 0C 4B 04     nop 044B
867A 48           pha
867B 04 4A        nop 4A
867D 04 4B        nop 4B
867F 04 4A        nop 4A
8681 04 48        nop 48
8683 0C 4B 04     nop 044B
8686 46 04        lsr 04
8688 48           pha
8689 04 4A        nop 4A
868B 04 48        nop 48
868D 04 46        nop 46
868F 0C 4A 04     nop 044A
8692 46 04        lsr 04
8694 48           pha
8695 04 4A        nop 4A
8697 04 48        nop 48
8699 04 46        nop 46
869B 0C 4A 04     nop 044A
869E 44 04        nop 04
86A0 46 04        lsr 04
86A2 48           pha
86A3 04 46        nop 46
86A5 04 44        nop 44
86A7 0C 48 04     nop 0448
86AA 44 04        nop 04
86AC 46 04        lsr 04
86AE 48           pha
86AF 04 46        nop 46
86B1 04 44        nop 44
86B3 10 48        bpl 86FD
86B5 34 00        nop 00,x
86B7 CA           dex
86B8 0B 10        anc #10
86BA 00           brk
86BB 10 43        bpl 8700  ;slow
86BD 10 47        bpl 8706  ;slow
86BF 10 4A        bpl 870B  ;slow
86C1 40           rti
86C2 47 CA        sre CA
86C4 09 00        ora #00
86C6 00           brk 
86C7 D8           cld
86C8 01 02        ora (02,x)
86CA D5 D0        cmp D0,x
86CC D6 08        dec 08,x
86CE 00           brk 
86CF 04 46        nop 46
86D1 04 4A        nop 4A
86D3 04 4B        nop 4B
86D5 04 4A        nop 4A
86D7 04 46        nop 46
86D9 0C 4B 04     nop 044B
86DC 46 04        lsr 04
86DE 4A           lsr a
86DF 04 4B        nop 4B
86E1 04 4A        nop 4A
86E3 04 46        nop 46
86E5 0C 4A 04     nop 044A
86E8 46 04        lsr 04
86EA 48           pha
86EB 04 4A        nop 4A
86ED 04 48        nop 48
86EF 04 46        nop 46
86F1 0C 4A 04     nop 044A
86F4 46 04        lsr 04
86F6 48           pha
86F7 04 4A        nop 4A
86F9 04 48        nop 48
86FB 04 46        nop 46
86FD 0C 48 04     nop 0448
8700 43 04        sre (04,x)
8702 43 04        sre (04,x)
8704 48           pha
8705 04 43        nop 43
8707 04 43        nop 43
8709 0C 48 04     nop 0448
870C 43 04        sre (04,x)
870E 43 04        sre (04,x)
8710 48           pha
8711 04 43        nop 43
8713 04 43        nop 43
8715 0C 48 04     nop 0448
8718 44 04        nop 04
871A 46 04        lsr 04
871C 48           pha
871D 04 46        nop 46
871F 04 44        nop 44
8721 0C 48 04     nop 0448
8724 44 04        nop 04
8726 46 04        lsr 04
8728 48           pha
8729 04 46        nop 46
872B 04 44        nop 44
872D 0C 48 04     nop 0448
8730 44 04        nop 04
8732 46 04        lsr 04
8734 48           pha
8735 04 46        nop 46
8737 04 44        nop 44
8739 0C 48 04     nop 0448
873C 44 04        nop 04
873E 46 04        lsr 04
8740 48           pha
8741 04 46        nop 46
8743 04 44        nop 44
8745 04 48        nop 48
8747 D2           kil
8748 CA           dex
8749 0F 40 67     slo 6740
874C D6 CA        dec CA,x
874E 09 00        ora #00
8750 00           brk
8751 00           brk
8752 CA           dex
8753 07 D4        slo D4
8755 D8           cld
8756 64 02        nop 02
8758 C9 21        cmp #21
875A 02           kil
875B 38           sec
875C 02           kil
875D 3B 02 43     rla 4302,y
8760 02           kil
8761 48           pha
8762 02           kil
8763 4B 02        alr #02
8765 53 02        sre (02),y
8767 58           cli
8768 02           kil
8769 5B 02 5B     sre 5B02,y
876C 02           kil
876D 58           cli
876E 02           kil
876F 53 02        sre (02),y
8771 4B 02        alr #02
8773 48           pha
8774 02           kil
8775 43 02        sre (02,x)
8777 3B 02 38     rla 3802,y
877A 02           kil
877B 38           sec
877C 02           kil
877D 3B 02 43     rla 4302,y
8780 02           kil
8781 48           pha
8782 02           kil
8783 4B 02        alr #02
8785 53 02        sre (02),y
8787 58           cli
8788 02           kil
8789 5B 02 5B     sre 5B02,y
878C 02           kil
878D 58           cli
878E 02           kil
878F 53 02        sre (02),y
8791 4B 02        alr #02
8793 48           pha
8794 02           kil
8795 43 02        sre (02,x)
8797 3B 02 38     rla 3802,y
879A 02           kil
879B 38           sec
879C 02           kil
879D 3B 02 43     rla 4302,y
87A0 02           kil
87A1 48           pha
87A2 02           kil
87A3 4B 02        alr #02
87A5 53 02        sre (02),y
87A7 58           cli
87A8 02           kil
87A9 5B 02 5B     sre 5B02,y
87AC 02           kil
87AD 58           cli
87AE 02           kil
87AF 53 02        sre (02),y
87B1 4B 02        alr #02
87B3 48           pha
87B4 02           kil
87B5 43 02        sre (02,x)
87B7 3B 02 38     rla 3802,y
87BA 02           kil
87BB 38           sec
87BC 02           kil
87BD 3B 02 43     rla 4302,y
87C0 02           kil
87C1 48           pha
87C2 02           kil
87C3 4B 02        alr #02
87C5 53 02        sre (02),y
87C7 58           cli
87C8 02           kil
87C9 5B 02 5B     sre 5B02,y
87CC 02           kil
87CD 58           cli
87CE 02           kil
87CF 53 02        sre (02),y
87D1 4B 02        alr #02
87D3 48           pha
87D4 02           kil
87D5 43 02        sre (02,x)
87D7 3B 02 38     rla 3802,y
87DA 02           kil
87DB 33 02        rla (02),y
87DD 37 02        rla 02,x
87DF 3A           nop
87E0 02           kil
87E1 43 02        sre (02,x)
87E3 47 02        sre 02
87E5 4A           lsr a
87E6 02           kil
87E7 53 02        sre (02),y
87E9 57 02        sre 02,x
87EB 57 02        sre 02,x
87ED 53 02        sre (02),y
87EF 4A           lsr a
87F0 02           kil
87F1 47 02        sre 02
87F3 43 02        sre (02,x)
87F5 3A           nop
87F6 02           kil
87F7 37 02        rla 02,x
87F9 33 02        rla (02),y
87FB 33 02        rla (02),y
87FD 37 02        rla 02,x
87FF 3A           nop
8800 02           kil
8801 43 02        sre (02,x)
8803 47 02        sre 02
8805 4A           lsr a
8806 02           kil
8807 53 02        sre (02),y
8809 57 02        sre 02,x
880B 57 02        sre 02,x
880D 53 02        sre (02),y
880F 4A           lsr a
8810 02           kil
8811 47 02        sre 02
8813 43 02        sre (02,x)
8815 3A           nop
8816 02           kil
8817 37 02        rla 02,x
8819 33 02        rla (02),y
881B 33 02        rla (02),y
881D 37 02        rla 02,x
881F 3A           nop
8820 02           kil
8821 43 02        sre (02,x)
8823 47 02        sre 02
8825 4A           lsr a
8826 02           kil
8827 53 02        sre (02),y
8829 57 02        sre 02,x
882B 57 02        sre 02,x
882D 53 02        sre (02),y
882F 4A           lsr a
8830 02           kil
8831 47 02        sre 02
8833 43 02        sre (02,x)
8835 3A           nop
8836 02           kil
8837 37 02        rla 02,x
8839 33 02        rla (02),y
883B 33 02        rla (02),y
883D 37 02        rla 02,x
883F 3A           nop
8840 02           kil
8841 43 02        sre (02,x)
8843 47 02        sre 02
8845 4A           lsr a
8846 02           kil
8847 53 02        sre (02),y
8849 57 02        sre 02,x
884B 57 02        sre 02,x
884D 53 02        sre (02),y
884F 4A           lsr a
8850 02           kil
8851 47 02        sre 02
8853 43 02        sre (02,x)
8855 3A           nop
8856 02           kil
8857 37 02        rla 02,x
8859 33 02        rla (02),y
885B 34 02        nop 02,x
885D 38           sec
885E 02           kil
885F 3B 02 44     rla 4402,y
8862 02           kil
8863 48           pha
8864 02           kil
8865 4B 02        alr #02
8867 54 02        nop 02,x
8869 58           cli
886A 02           kil
886B 58           cli
886C 02           kil
886D 54 02        nop 02,x
886F 4B 02        alr #02
8871 48           pha
8872 02           kil
8873 44 02        nop 02
8875 3B 02 38     rla 3802,y
8878 02           kil
8879 34 02        nop 02,x
887B 34 02        nop 02,x
887D 38           sec
887E 02           kil
887F 3B 02 44     rla 4402,y
8882 02           kil
8883 48           pha
8884 02           kil
8885 4B 02        alr #02
8887 54 02        nop 02,x
8889 58           cli
888A 02           kil
888B 58           cli
888C 02           kil
888D 54 02        nop 02,x
888F 4B 02        alr #02
8891 48           pha
8892 02           kil
8893 44 02        nop 02
8895 3B 02 38     rla 3802,y
8898 02           kil
8899 34 02        nop 02,x
889B 34 02        nop 02,x
889D 38           sec
889E 02           kil
889F 3B 02 44     rla 4402,y
88A2 02           kil
88A3 48           pha
88A4 02           kil
88A5 4B 02        alr #02
88A7 54 02        nop 02,x
88A9 58           cli
88AA 02           kil
88AB 58           cli
88AC 02           kil
88AD 54 02        nop 02,x
88AF 4B 02        alr #02
88B1 48           pha
88B2 02           kil
88B3 44 02        nop 02
88B5 3B 02 38     rla 3802,y
88B8 02           kil
88B9 34 02        nop 02,x
88BB 34 02        nop 02,x
88BD 38           sec
88BE 02           kil
88BF 3B 02 44     rla 4402,y
88C2 02           kil
88C3 48           pha
88C4 02           kil
88C5 4B 02        alr #02
88C7 54 02        nop 02,x
88C9 58           cli
88CA 02           kil
88CB 58           cli
88CC 02           kil
88CD 54 02        nop 02,x
88CF 4B 02        alr #02
88D1 48           pha
88D2 02           kil
88D3 44 02        nop 02
88D5 3B 02 38     rla 3802,y
88D8 02           kil
88D9 34 02        nop 02,x
88DB 31 02        and (02),y
88DD 34 02        nop 02,x
88DF 38           sec
88E0 02           kil
88E1 41 02        eor (02,x)
88E3 44 02        nop 02
88E5 48           pha
88E6 02           kil
88E7 51 02        eor (02),y
88E9 54 02        nop 02,x
88EB 54 02        nop 02,x
88ED 51 02        eor (02),y
88EF 48           pha
88F0 02           kil
88F1 44 02        nop 02
88F3 41 02        eor (02,x)
88F5 38           sec
88F6 02           kil
88F7 34 02        nop 02,x
88F9 31 02        and (02),y
88FB 31 02        and (02),y
88FD 34 02        nop 02,x
88FF 38           sec
8900 02           kil
8901 41 02        eor (02,x)
8903 44 02        nop 02
8905 48           pha
8906 02           kil
8907 51 02        eor (02),y
8909 54 02        nop 02,x
890B 54 02        nop 02,x
890D 51 02        eor (02),y
890F 48           pha
8910 02           kil
8911 44 02        nop 02
8913 41 02        eor (02,x)
8915 38           sec
8916 02           kil
8917 34 02        nop 02,x
8919 31 02        and (02),y
891B 31 02        and (02),y
891D 34 02        nop 02,x
891F 38           sec
8920 02           kil
8921 41 02        eor (02,x)
8923 44 02        nop 02
8925 48           pha
8926 02           kil
8927 51 02        eor (02),y
8929 54 02        nop 02,x
892B 54 02        nop 02,x
892D 51 02        eor (02),y
892F 48           pha
8930 02           kil
8931 44 02        nop 02
8933 41 02        eor (02,x)
8935 38           sec
8936 02           kil
8937 34 02        nop 02,x
8939 31 02        and (02),y
893B 31 02        and (02),y
893D 34 02        nop 02,x
893F 38           sec
8940 02           kil
8941 41 02        eor (02,x)
8943 44 02        nop 02
8945 48           pha
8946 02           kil
8947 51 02        eor (02),y
8949 54 02        nop 02,x
894B 54 02        nop 02,x
894D 51 02        eor (02),y
894F 48           pha
8950 02           kil
8951 44 02        nop 02
8953 41 02        eor (02,x)
8955 38           sec
8956 02           kil
8957 34 02        nop 02,x
8959 31 02        and (02),y
895B 33 02        rla (02),y
895D 37 02        rla 02,x
895F 3A           nop
8960 02           kil
8961 43 02        sre (02,x)
8963 47 02        sre 02
8965 4A           lsr a
8966 02           kil
8967 53 02        sre (02),y
8969 57 02        sre 02,x
896B 57 02        sre 02,x
896D 53 02        sre (02),y
896F 4A           lsr a
8970 02           kil
8971 47 02        sre 02
8973 43 02        sre (02,x)
8975 3A           nop
8976 02           kil
8977 37 02        rla 02,x
8979 33 02        rla (02),y
897B 33 02        rla (02),y
897D 37 02        rla 02,x
897F 3A           nop
8980 02           kil
8981 43 02        sre (02,x)
8983 47 02        sre 02
8985 4A           lsr a
8986 02           kil
8987 53 02        sre (02),y
8989 57 02        sre 02,x
898B 57 02        sre 02,x
898D 53 02        sre (02),y
898F 4A           lsr a
8990 02           kil
8991 47 02        sre 02
8993 43 02        sre (02,x)
8995 3A           nop
8996 02           kil
8997 37 02        rla 02,x
8999 33 02        rla (02),y
899B 33 02        rla (02),y
899D 37 02        rla 02,x
899F 3A           nop
89A0 02           kil
89A1 43 02        sre (02,x)
89A3 47 02        sre 02
89A5 4A           lsr a
89A6 02           kil
89A7 53 02        sre (02),y
89A9 57 02        sre 02,x
89AB 57 02        sre 02,x
89AD 53 02        sre (02),y
89AF 4A           lsr a
89B0 02           kil
89B1 47 02        sre 02
89B3 43 02        sre (02,x)
89B5 3A           nop
89B6 02           kil
89B7 37 02        rla 02,x
89B9 33 02        rla (02),y
89BB 33 02        rla (02),y
89BD 37 02        rla 02,x
89BF 3A           nop
89C0 02           kil
89C1 43 02        sre (02,x)
89C3 47 02        sre 02
89C5 4A           lsr a
89C6 02           kil
89C7 53 02        sre (02),y
89C9 57 02        sre 02,x
89CB 57 02        sre 02,x
89CD 53 02        sre (02),y
89CF 4A           lsr a
89D0 02           kil
89D1 47 02        sre 02
89D3 43 02        sre (02,x)
89D5 3A           nop
89D6 02           kil
89D7 37 02        rla 02,x
89D9 33 C9        rla (C9),y
89DB 41 00        eor (00,x)
89DD 00           brk
89DE 04 18        nop 18
89E0 04 28        nop 28
89E2 F6 04        inc 04,x
89E4 04 18        nop 18
89E6 04 28        nop 28
89E8 F6 04        inc 04,x
89EA F6 08        inc 08,x
89EC 04 18        nop 18
89EE 04 28        nop 28
89F0 F6 04        inc 04,x
89F2 04 18        nop 18
89F4 04 28        nop 28
89F6 F6 04        inc 04,x
89F8 F6 08        inc 08,x
89FA 04 13        nop 13
89FC 04 23        nop 23
89FE F6 04        inc 04,x
8A00 04 13        nop 13
8A02 04 23        nop 23
8A04 F6 04        inc 04,x
8A06 F6 08        inc 08,x
8A08 04 13        nop 13
8A0A 04 23        nop 23
8A0C F6 04        inc 04,x
8A0E 04 13        nop 13
8A10 04 23        nop 23
8A12 F6 04        inc 04,x
8A14 F6 08        inc 08,x
8A16 04 14        nop 14
8A18 04 24        nop 24
8A1A F6 04        inc 04,x
8A1C 04 14        nop 14
8A1E 04 24        nop 24
8A20 F6 04        inc 04,x
8A22 F6 08        inc 08,x
8A24 04 14        nop 14
8A26 04 24        nop 24
8A28 F6 04        inc 04,x
8A2A 04 14        nop 14
8A2C 04 24        nop 24
8A2E F6 04        inc 04,x
8A30 F6 08        inc 08,x
8A32 04 16        nop 16
8A34 04 26        nop 26
8A36 F6 04        inc 04,x
8A38 04 16        nop 16
8A3A 04 26        nop 26
8A3C F6 04        inc 04,x
8A3E F6 08        inc 08,x
8A40 04 16        nop 16
8A42 04 26        nop 26
8A44 F6 04        inc 04,x
8A46 04 16        nop 16
8A48 04 26        nop 26
8A4A F6 04        inc 04,x
8A4C F6 08        inc 08,x
8A4E 04 13        nop 13
8A50 04 23        nop 23
8A52 F6 04        inc 04,x
8A54 04 13        nop 13
8A56 04 23        nop 23
8A58 F6 04        inc 04,x
8A5A F6 08        inc 08,x
8A5C 04 13        nop 13
8A5E 04 23        nop 23
8A60 F6 04        inc 04,x
8A62 04 13        nop 13
8A64 04 23        nop 23
8A66 F6 04        inc 04,x
8A68 F6 08        inc 08,x
8A6A 04 13        nop 13
8A6C 04 23        nop 23
8A6E F6 04        inc 04,x
8A70 04 13        nop 13
8A72 04 23        nop 23
8A74 F6 04        inc 04,x
8A76 F6 08        inc 08,x
8A78 04 13        nop 13
8A7A 04 23        nop 23
8A7C F6 04        inc 04,x
8A7E 04 13        nop 13
8A80 04 23        nop 23
8A82 F6 04        inc 04,x
8A84 F6 08        inc 08,x
8A86 00           brk
8A87 00           brk
8A88 04 1B        nop 1B
8A8A 04 2B        nop 2B
8A8C F6 04        inc 04,x
8A8E 04 1B        nop 1B
8A90 04 2B        nop 2B
8A92 F6 04        inc 04,x
8A94 F6 08        inc 08,x
8A96 04 1B        nop 1B
8A98 04 2B        nop 2B
8A9A F6 04        inc 04,x
8A9C 04 1B        nop 1B
8A9E 04 2B        nop 2B
8AA0 F6 04        inc 04,x
8AA2 F6 08        inc 08,x
8AA4 04 16        nop 16
8AA6 04 26        nop 26
8AA8 F6 04        inc 04,x
8AAA 04 16        nop 16
8AAC 04 26        nop 26
8AAE F6 04        inc 04,x
8AB0 F6 08        inc 08,x
8AB2 04 16        nop 16
8AB4 04 26        nop 26
8AB6 F6 04        inc 04,x
8AB8 04 16        nop 16
8ABA 04 26        nop 26
8ABC F6 04        inc 04,x
8ABE F6 08        inc 08,x
8AC0 04 18        nop 18
8AC2 04 28        nop 28
8AC4 F6 04        inc 04,x
8AC6 04 18        nop 18
8AC8 04 28        nop 28
8ACA F6 04        inc 04,x
8ACC F6 08        inc 08,x
8ACE 04 18        nop 18
8AD0 04 28        nop 28
8AD2 F6 04        inc 04,x
8AD4 04 18        nop 18
8AD6 04 28        nop 28
8AD8 F6 04        inc 04,x
8ADA F6 08        inc 08,x
8ADC 04 14        nop 14
8ADE 04 24        nop 24
8AE0 F6 04        inc 04,x
8AE2 04 14        nop 14
8AE4 04 24        nop 24
8AE6 F6 04        inc 04,x
8AE8 F6 08        inc 08,x
8AEA 04 14        nop 14
8AEC 04 24        nop 24
8AEE F6 04        inc 04,x
8AF0 04 14        nop 14
8AF2 04 24        nop 24
8AF4 F6 04        inc 04,x
8AF6 F6 08        inc 08,x
8AF8 04 11        nop 11
8AFA 04 21        nop 21
8AFC F6 04        inc 04,x
8AFE 04 11        nop 11
8B00 04 21        nop 21
8B02 F6 04        inc 04,x
8B04 F6 08        inc 08,x
8B06 04 11        nop 11
8B08 04 21        nop 21
8B0A F6 04        inc 04,x
8B0C 04 11        nop 11
8B0E 04 21        nop 21
8B10 F6 04        inc 04,x
8B12 F6 08        inc 08,x
8B14 04 13        nop 13
8B16 04 23        nop 23
8B18 F6 04        inc 04,x
8B1A 04 13        nop 13
8B1C 04 23        nop 23
8B1E F6 04        inc 04,x
8B20 F6 08        inc 08,x
8B22 04 13        nop 13
8B24 04 23        nop 23
8B26 F6 04        inc 04,x
8B28 04 13        nop 13
8B2A 04 23        nop 23
8B2C F6 04        inc 04,x
8B2E F6 08        inc 08,x
8B30 00           brk 
8B31 00           brk 
8B32 00           brk
8B33 04 18        nop 18
8B35 04 28        nop 28
8B37 F6 04        inc 04,x
8B39 04 18        nop 18
8B3B 04 28        nop 28
8B3D F6 04        inc 04,x
8B3F F6 08        inc 08,x
8B41 04 18        nop 18
8B43 04 28        nop 28
8B45 F6 04        inc 04,x
8B47 04 18        nop 18
8B49 04 28        nop 28
8B4B F6 04        inc 04,x
8B4D F6 08        inc 08,x
8B4F 04 18        nop 18
8B51 04 28        nop 28
8B53 F6 04        inc 04,x
8B55 04 18        nop 18
8B57 04 28        nop 28
8B59 F6 04        inc 04,x
8B5B F6 08        inc 08,x
8B5D 04 18        nop 18
8B5F 04 28        nop 28
8B61 F6 04        inc 04,x
8B63 04 18        nop 18
8B65 04 28        nop 28
8B67 F6 04        inc 04,x
8B69 F6 08        inc 08,x
8B6B 04 13        nop 13
8B6D 04 23        nop 23
8B6F F6 04        inc 04,x
8B71 04 13        nop 13
8B73 04 23        nop 23
8B75 F6 04        inc 04,x
8B77 F6 08        inc 08,x
8B79 04 13        nop 13
8B7B 04 23        nop 23
8B7D F6 04        inc 04,x
8B7F 04 13        nop 13
8B81 04 23        nop 23
8B83 F6 04        inc 04,x
8B85 F6 08        inc 08,x
8B87 04 13        nop 13
8B89 04 23        nop 23
8B8B F6 04        inc 04,x
8B8D 04 13        nop 13
8B8F 04 23        nop 23
8B91 F6 04        inc 04,x
8B93 F6 08        inc 08,x
8B95 04 13        nop 13
8B97 04 23        nop 23
8B99 F6 04        inc 04,x
8B9B 04 13        nop 13
8B9D 04 23        nop 23
8B9F F6 04        inc 04,x
8BA1 F6 08        inc 08,x
8BA3 04 14        nop 14
8BA5 04 24        nop 24
8BA7 F6 04        inc 04,x
8BA9 04 14        nop 14
8BAB 04 24        nop 24
8BAD F6 04        inc 04,x
8BAF F6 08        inc 08,x
8BB1 04 14        nop 14
8BB3 04 24        nop 24
8BB5 F6 04        inc 04,x
8BB7 04 14        nop 14
8BB9 04 24        nop 24
8BBB F6 04        inc 04,x
8BBD F6 08        inc 08,x
8BBF 04 14        nop 14
8BC1 04 24        nop 24
8BC3 F6 04        inc 04,x
8BC5 04 14        nop 14
8BC7 04 24        nop 24
8BC9 F6 04        inc 04,x
8BCB F6 08        inc 08,x
8BCD 04 14        nop 14
8BCF 04 24        nop 24
8BD1 F6 04        inc 04,x
8BD3 04 14        nop 14
8BD5 04 24        nop 24
8BD7 F6 04        inc 04,x
8BD9 F6 08        inc 08,x
8BDB 04 11        nop 11
8BDD 04 21        nop 21
8BDF F6 04        inc 04,x
8BE1 04 11        nop 11
8BE3 04 21        nop 21
8BE5 F6 04        inc 04,x
8BE7 F6 08        inc 08,x
8BE9 04 11        nop 11
8BEB 04 21        nop 21
8BED F6 04        inc 04,x
8BEF 04 11        nop 11
8BF1 04 21        nop 21
8BF3 F6 04        inc 04,x
8BF5 F6 08        inc 08,x
8BF7 04 11        nop 11
8BF9 04 21        nop 21
8BFB F6 04        inc 04,x
8BFD 04 11        nop 11
8BFF 04 21        nop 21
8C01 F6 04        inc 04,x
8C03 F6 08        inc 08,x
8C05 04 11        nop 11
8C07 04 21        nop 21
8C09 F6 04        inc 04,x
8C0B 04 11        nop 11
8C0D 04 21        nop 21
8C0F F6 04        inc 04,x
8C11 F6 08        inc 08,x
8C13 04 13        nop 13
8C15 04 23        nop 23
8C17 F6 04        inc 04,x
8C19 04 13        nop 13
8C1B 04 23        nop 23
8C1D F6 04        inc 04,x
8C1F F6 08        inc 08,x
8C21 04 13        nop 13
8C23 04 23        nop 23
8C25 F6 04        inc 04,x
8C27 04 13        nop 13
8C29 04 23        nop 23
8C2B F6 04        inc 04,x
8C2D F6 08        inc 08,x
8C2F 04 13        nop 13
8C31 04 23        nop 23
8C33 F6 04        inc 04,x
8C35 04 13        nop 13
8C37 04 23        nop 23
8C39 F6 04        inc 04,x
8C3B F6 08        inc 08,x
8C3D 04 13        nop 13
8C3F 04 23        nop 23
8C41 F6 04        inc 04,x
8C43 04 13        nop 13
8C45 04 23        nop 23
8C47 F6 04        inc 04,x
8C49 F6 08        inc 08,x
8C4B 00           brk 
8C4C 00           brk
8C4D 00           brk
                  .byte $1E
;--------------------------------------------------------------------------------------------------------------------------------------------------------
;dupa
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc8C4F          mva #$BC 4B
                  mva #$8C 4C
                  mva #$00 4D
                  mva #$8D 4E
                  mva #$44 4F
                  mva #$8D 50
                  mva #$A4 7424
                  mva #$8C 7425
                  mva #$AC 7426
                  mva #$8C 7427
                  mva #$B4 7428
                  mva #$8C 7429
                  mva #$03 7406
                  mva #$04 7407
                  sta 7418
                  sta 7419
                  sta 741A
                  mva #$02 7421
                  sta 7422
                  sta 7423
                  rts

;syf
8CA4 BC 8C BC     ldy BC8C,x
8CA7 8C 00 00     sty 0000  ;CpuDataDir
8CAA 00           brk
8CAB 00           brk
8CAC 00           brk
8CAD 8D 00 8D     sta 8D00
8CB0 00           brk
8CB1 00           brk
8CB2 00           brk
8CB3 00           brk
8CB4 44 8D        nop 8D
8CB6 44 8D        nop 8D
8CB8 00           brk 
8CB9 00           brk 
8CBA 00           brk 
8CBB 00           brk 
8CBC D4 D1        nop D1,x
8CBE 04 51        nop 51
8CC0 04 55        nop 55
8CC2 04 58        nop 58
8CC4 04 61        nop 61
8CC6 04 65        nop 65
8CC8 04 61        nop 61
8CCA 04 58        nop 58
8CCC 04 55        nop 55
8CCE 04 4A        nop 4A
8CD0 04 51        nop 51
8CD2 04 55        nop 55
8CD4 04 5A        nop 5A
8CD6 04 61        nop 61
8CD8 04 5A        nop 5A
8CDA 04 55        nop 55
8CDC 04 51        nop 51
8CDE 04 46        nop 46
8CE0 04 4A        nop 4A
8CE2 04 51        nop 51
8CE4 04 56        nop 56
8CE6 04 5A        nop 5A
8CE8 04 56        nop 56
8CEA 04 51        nop 51
8CEC 04 4A        nop 4A
8CEE 04 48        nop 48
8CF0 04 4C        nop 4C
8CF2 04 53        nop 53
8CF4 04 58        nop 58
8CF6 04 5C        nop 5C
8CF8 04 58        nop 58
8CFA 04 53        nop 53
8CFC 04 4C        nop 4C
8CFE 00           brk 
8CFF 00           brk 
8D00 D4 D1        nop D1,x
8D02 04 65        nop 65
8D04 04 61        nop 61
8D06 04 58        nop 58
8D08 04 55        nop 55
8D0A 04 51        nop 51
8D0C 04 55        nop 55
8D0E 04 58        nop 58
8D10 04 61        nop 61
8D12 04 61        nop 61
8D14 04 5A        nop 5A
8D16 04 55        nop 55
8D18 04 51        nop 51
8D1A 04 4A        nop 4A
8D1C 04 51        nop 51
8D1E 04 55        nop 55
8D20 04 5A        nop 5A
8D22 04 5A        nop 5A
8D24 04 56        nop 56
8D26 04 51        nop 51
8D28 04 4A        nop 4A
8D2A 04 46        nop 46
8D2C 04 4A        nop 4A
8D2E 04 51        nop 51
8D30 04 56        nop 56
8D32 04 5C        nop 5C
8D34 04 58        nop 58
8D36 04 53        nop 53
8D38 04 4C        nop 4C
8D3A 04 48        nop 48
8D3C 04 4C        nop 4C
8D3E 04 53        nop 53
8D40 04 58        nop 58
8D42 00           brk
8D43 00           brk
8D44 D4 D5        nop D5,x
8D46 18           clc
8D47 21 08        and (08,x)
8D49 1C 18 1A     nop 1A18,x
8D4C 08           php
8D4D 18           clc
8D4E 18           clc
8D4F 16 08        asl 08,x
8D51 1A           nop
8D52 18           clc
8D53 18           clc
8D54 08           php
8D55 1C 00 00     nop 0000,x
8D58 35           .byte $35
;--------------------------------------------------------------------------------------------------------------------------------------------------------
;
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc8D59          mva #$D4 4B
                  mva #$8D 4C
                  mva #$4C 4D
                  mva #$8E 4E
                  mva #$B8 4F
                  mva #$8E 50
                  mva #$AE 7424
                  mva #$8D 7425
                  mva #$BA 7426
                  mva #$8D 7427
                  mva #$C6 7428
                  mva #$8D 7429
                  mva #$04 7406
                  mva #$04 7407
                  sta 7418
                  sta 7419
                  sta 741A
                  mva #$02 7421
                  sta 7422
                  sta 7423
                  rts

;syf
8DAE D4 8D        nop 8D,x
8DB0 3E 8E 3E     rol 3E8E,x
8DB3 8E 3E 8E     stx 8E3E
8DB6 00           brk
8DB7 00           brk
8DB8 00           brk
8DB9 00           brk
8DBA 4C 8E AA     jmp AA8E
8DBD 8E AA 8E     stx 8EAA
8DC0 AA           tax
8DC1 8E 00 00     stx 0000  ;CpuDataDir
8DC4 00           brk
8DC5 00           brk
8DC6 B8           clv
8DC7 8E C6 8E     stx 8EC6
8DCA 16 8F        asl 8F,x
8DCC 16 8F        asl 8F,x
8DCE 16 8F        asl 8F,x
8DD0 00           brk
8DD1 00           brk
8DD2 00           brk
8DD3 00           brk
8DD4 C9 41        cmp #41
8DD6 D1 D0        cmp (D0),y
8DD8 CA           dex
8DD9 09 CB        ora #CB
8DDB 00           brk
8DDC 04 48        nop 48
8DDE 04 4A        nop 4A
8DE0 04 4C        nop 4C
8DE2 04 4B        nop 4B
8DE4 04 4C        nop 4C
8DE6 04 4B        nop 4B
8DE8 04 4C        nop 4C
8DEA 04 4B        nop 4B
8DEC 04 4C        nop 4C
8DEE 04 51        nop 51
8DF0 08           php
8DF1 4C 08 4A     jmp 4A08
8DF4 08           php
8DF5 4A           lsr a
8DF6 04 47        nop 47
8DF8 04 48        nop 48
8DFA 04 4A        nop 4A
8DFC 04 49        nop 49
8DFE 04 4A        nop 4A
8E00 04 49        nop 49
8E02 04 4A        nop 4A
8E04 04 49        nop 49
8E06 04 4A        nop 4A
8E08 04 4C        nop 4C
8E0A 08           php
8E0B 4A           lsr a
8E0C 08           php
8E0D 48           pha
8E0E 08           php
8E0F 48           pha
8E10 04 3C        nop 3C
8E12 04 41        nop 41
8E14 04 43        nop 43
8E16 04 42        nop 42
8E18 04 43        nop 43
8E1A 04 42        nop 42
8E1C 08           php
8E1D 43 08        sre (08,x)
8E1F 53 08        sre (08),y
8E21 53 08        sre (08),y
8E23 51 08        eor (08),y
8E25 4C 08 4A     jmp 4A08
8E28 CA           dex
8E29 0A           asl a
8E2A 10 4C        bpl 8E78
8E2C 10 4A        bpl 8E78
8E2E 04 48        nop 48
8E30 02           kil
8E31 43 04        sre (04,x)
8E33 45 02        eor 02
8E35 43 04        sre (04,x)
8E37 3C 08 38     nop 3808,x
8E3A 20 58 00     jsr 0058
8E3D 00           brk
8E3E 64 00        nop 00  ;CpuDataDir
8E40 64 00        nop 00  ;CpuDataDir
8E42 64 00        nop 00  ;CpuDataDir
8E44 64 00        nop 00  ;CpuDataDir
8E46 64 00        nop 00  ;CpuDataDir
8E48 64 00        nop 00  ;CpuDataDir
8E4A 00           brk
8E4B 00           brk
8E4C C9 41        cmp #41
8E4E CA           dex
8E4F 09 D0        ora #D0
8E51 D1 CB        cmp (CB),y
8E53 00           brk
8E54 08           php
8E55 00           brk
8E56 04 48        nop 48
8E58 04 47        nop 47
8E5A 04 48        nop 48
8E5C 04 47        nop 47
8E5E 04 48        nop 48
8E60 04 47        nop 47
8E62 04 48        nop 48
8E64 04 4A        nop 4A
8E66 08           php
8E67 48           pha
8E68 08           php
8E69 45 08        eor 08
8E6B 45 04        eor 04
8E6D 43 04        sre (04,x)
8E6F 45 04        eor 04
8E71 47 04        sre 04
8E73 46 04        lsr 04
8E75 47 04        sre 04
8E77 46 04        lsr 04
8E79 47 04        sre 04
8E7B 46 04        lsr 04
8E7D 47 04        sre 04
8E7F 48           pha
8E80 08           php
8E81 43 08        sre (08,x)
8E83 43 08        sre (08,x)
8E85 43 04        sre (04,x)
8E87 38           sec
8E88 04 3A        nop 3A
8E8A 04 3C        nop 3C
8E8C 04 3B        nop 3B
8E8E 04 3C        nop 3C
8E90 04 3B        nop 3B
8E92 08           php
8E93 3C 08 4C     nop 4C08,x
8E96 08           php
8E97 4C 08 48     jmp 4808
8E9A 08           php
8E9B 48           pha
8E9C 08           php
8E9D 44 CA        nop CA
8E9F 0A           asl a
8EA0 10 43        bpl 8EE5
8EA2 10 41        bpl 8EE5
8EA4 18           clc
8EA5 00           brk
8EA6 20 53 00     jsr 0053
8EA9 00           brk
8EAA 64 00        nop 00  ;CpuDataDir
8EAC 64 00        nop 00  ;CpuDataDir
8EAE 64 00        nop 00  ;CpuDataDir
8EB0 64 00        nop 00  ;CpuDataDir
8EB2 64 00        nop 00  ;CpuDataDir
8EB4 64 00        nop 00  ;CpuDataDir
8EB6 00           brk
8EB7 00           brk
8EB8 C9 41        cmp #41
8EBA CA           dex
8EBB 09 D4        ora #D4
8EBD D5 D6        cmp D6,x
8EBF D8           cld
8EC0 0A           asl a
8EC1 0A           asl a
8EC2 08           php
8EC3 00           brk
8EC4 00           brk
8EC5 00           brk
8EC6 08           php
8EC7 18           clc
8EC8 04 23        nop 23
8ECA 04 23        nop 23
8ECC 08           php
8ECD 13 08        slo (08),y
8ECF 23 08        rla (08,x)
8ED1 1A           nop
8ED2 04 25        nop 25
8ED4 04 25        nop 25
8ED6 08           php
8ED7 15 08        ora 08,x
8ED9 25 08        and 08
8EDB 13 04        slo (04),y
8EDD 1A           nop
8EDE 04 1A        nop 1A
8EE0 08           php
8EE1 0A           asl a
8EE2 08           php
8EE3 1A           nop
8EE4 08           php
8EE5 18           clc
8EE6 04 23        nop 23
8EE8 04 23        nop 23
8EEA 08           php
8EEB 13 08        slo (08),y
8EED 23 08        rla (08,x)
8EEF 18           clc
8EF0 04 23        nop 23
8EF2 04 23        nop 23
8EF4 08           php
8EF5 13 08        slo (08),y
8EF7 23 08        rla (08,x)
8EF9 21 04        and (04,x)
8EFB 34 04        nop 04,x
8EFD 34 08        nop 08,x
8EFF 18           clc
8F00 08           php
8F01 34 08        nop 08,x
8F03 18           clc
8F04 04 23        nop 23
8F06 04 23        nop 23
8F08 08           php
8F09 13 08        slo (08),y
8F0B 23 08        rla (08,x)
8F0D 28           plp
8F0E 08           php
8F0F 23 08        rla (08,x)
8F11 18           clc
8F12 28           plp
8F13 18           clc
8F14 00           brk
8F15 00           brk
8F16 64 00        nop 00  ;CpuDataDir
8F18 64 00        nop 00  ;CpuDataDir
8F1A 64 00        nop 00  ;CpuDataDir
8F1C 64 00        nop 00  ;CpuDataDir
8F1E 64 00        nop 00  ;CpuDataDir
8F20 64 00        nop 00  ;CpuDataDir
8F22 00           brk
8F23 00           brk
8F24 00           brk
;--------------------------------------------------------------------------------------------------------------------------------------------------------
;
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc8F25          mva #$92 4B
                  mva #$8F 4C
                  mva #$B7 4D
                  mva #$8F 4E
                  mva #$DC 4F
                  mva #$8F 50
                  mva #$7A 7424
                  mva #$8F 7425
                  mva #$82 7426
                  mva #$8F 7427
                  mva #$8A 7428
                  mva #$8F 7429
                  mva #$04 7406
                  mva #$04 7407
                  sta 7418
                  sta 7419
                  sta 741A
                  mva #$02 7421
                  sta 7422
                  sta 7423
                  rts

;syf
8F7A 92           kil
8F7B 8F 92 8F     sax 8F92
8F7E 00           brk
8F7F 00           brk
8F80 00           brk
8F81 00           brk
8F82 B7 8F        lax 8F,y
8F84 B7 8F        lax 8F,y
8F86 00           brk
8F87 00           brk
8F88 00           brk
8F89 00           brk
8F8A DC 8F DC     nop DC8F,x
8F8D 8F 00 00     sax 0000  ;CpuDataDir
8F90 00           brk
8F91 00           brk
8F92 C9 41        cmp #41
8F94 CA           dex
8F95 09 CB        ora #CB
8F97 00           brk
8F98 D1 D6        cmp (D6),y
8F9A D0 04        bne 8FA0
8F9C 6A           ror a
8F9D 04 65        nop 65
8F9F 04 61        nop 61
8FA1 04 5A        nop 5A
8FA3 04 55        nop 55
8FA5 04 51        nop 51
8FA7 0C 4A 0C     nop 0C4A
8FAA 6A           ror a
8FAB 04 6A        nop 6A
8FAD 04 6C        nop 6C
8FAF 04 6A        nop 6A
8FB1 10 69        bpl 901C  ;slow
8FB3 20 00 00     jsr 0000
8FB6 00           brk
8FB7 C9 41        cmp #41
8FB9 CA           dex
8FBA 09 CB        ora #CB
8FBC 00           brk
8FBD D5 D0        cmp D0,x
8FBF D6 04        dec 04,x
8FC1 4A           lsr a
8FC2 04 51        nop 51
8FC4 04 55        nop 55
8FC6 04 5A        nop 5A
8FC8 04 61        nop 61
8FCA 04 65        nop 65
8FCC 0C 6A 0C     nop 0C6A
8FCF 65 04        adc 04
8FD1 61 04        adc (04,x)
8FD3 61 04        adc (04,x)
8FD5 61 10        adc (10,x)
8FD7 5C 20 00     nop 0020,x
8FDA 00           brk
8FDB 00           brk
8FDC C9 41        cmp #41
8FDE CA           dex
8FDF 0A           asl a
8FE0 CB 00        axs #00
8FE2 0C 1A 0C     nop 0C1A
8FE5 25 0C        and 0C
8FE7 1A           nop
8FE8 0C 1A 0C     nop 0C1A
8FEB 25 10        and 10
8FED 15 20        ora 20,x
8FEF 00           brk
8FF0 00           brk
8FF1 00           brk
8FF2 00           brk
8FF3 00           brk
8FF4 00           brk
;--------------------------------------------------------------------------------------------------------------------------------------------------------
;
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc8FF5          mva #$62 4B
                  mva #$90 4C
                  mva #$9D 4D
                  mva #$90 4E
                  mva #$EC 4F
                  mva #$90 50
                  mva #$4A 7424
                  mva #$90 7425
                  mva #$52 7426
                  mva #$90 7427
                  mva #$5A 7428
                  mva #$90 7429
                  mva #$04 7406
                  mva #$04 7407
                  sta 7418
                  sta 7419
                  sta 741A
                  mva #$02 7421
                  sta 7422
                  sta 7423
                  rts

;syf
904A 62           kil
904B 90 62        bcc 90AF
904D 90 00        bcc 904F
904F 00           brk
9050 00           brk
9051 00           brk
9052 9D 90 9D     sta 9D90,x
9055 90 00        bcc 9057
9057 00           brk
9058 00           brk
9059 00           brk
905A EC 90 EC     cpx EC90
905D 90 00        bcc 905F
905F 00           brk 
9060 00           brk
9061 00           brk 
9062 C9 41        cmp #41
9064 CA           dex
9065 09 CB        ora #CB
9067 00           brk 
9068 D1 D6        cmp (D6),y
906A D0 08        bne 9074
906C 55 04        eor 04,x
906E 5A           nop
906F 04 55        nop 55
9071 08           php
9072 51 04        eor (04),y
9074 55 04        eor 04,x
9076 51 08        eor (08),y
9078 4A           lsr a
9079 04 51        nop 51
907B 04 4A        nop 4A
907D 10 45        bpl 90C4
907F 04 45        nop 45
9081 04 4A        nop 4A
9083 04 51        nop 51
9085 04 4A        nop 4A
9087 04 4C        nop 4C
9089 04 4A        nop 4A
908B 08           php
908C 49 04        eor #04
908E 49 04        eor #04
9090 4C 04 53     jmp 5304
9093 04 4C        nop 4C
9095 08           php
9096 51 10        eor (10),y
9098 4A           lsr a
9099 C7 00        dcp 00  ;CpuDataDir
909B 00           brk
909C 00           brk
909D C9 41        cmp #41
909F CA           dex
90A0 05 CB        ora CB
90A2 20 D5 D4     jsr D4D5
90A5 D6 04        dec 04,x
90A7 5A           nop
90A8 04 65        nop 65
90AA 04 61        nop 61
90AC 04 65        nop 65
90AE 04 5A        nop 5A
90B0 04 65        nop 65
90B2 04 61        nop 61
90B4 04 65        nop 65
90B6 04 5A        nop 5A
90B8 04 65        nop 65
90BA 04 61        nop 61
90BC 04 65        nop 65
90BE 04 5A        nop 5A
90C0 04 65        nop 65
90C2 04 61        nop 61
90C4 04 65        nop 65
90C6 04 5A        nop 5A
90C8 04 65        nop 65
90CA 04 61        nop 61
90CC 04 65        nop 65
90CE 04 55        nop 55
90D0 04 5C        nop 5C
90D2 04 59        nop 59
90D4 04 5C        nop 5C
90D6 04 55        nop 55
90D8 04 5C        nop 5C
90DA 04 59        nop 59
90DC 04 5C        nop 5C
90DE 04 5A        nop 5A
90E0 04 65        nop 65
90E2 04 61        nop 61
90E4 04 65        nop 65
90E6 0C 00 C7     nop C700
90E9 00           brk
90EA 00           brk
90EB 00           brk
90EC C9 41        cmp #41
90EE CA           dex
90EF 0A           asl a
90F0 CB 10        axs #10
90F2 08           php
90F3 1A           nop
90F4 08           php
90F5 1A           nop
90F6 08           php
90F7 1A           nop
90F8 08           php
90F9 1A           nop
90FA 08           php
90FB 1A           nop
90FC 08           php
90FD 1A           nop
90FE 08           php
90FF 1A           nop
9100 08           php
9101 1A           nop
9102 08           php
9103 1A           nop
9104 08           php
9105 1A           nop
9106 08           php
9107 15 08        ora 08,x
9109 15 08        ora 08,x
910B 15 08        ora 08,x
910D 15 08        ora 08,x
910F 1A           nop
9110 10 1A        bpl 912C
9112 C7 00        dcp 00  ;CpuDataDir
9114 00           brk
9115 00           brk
9116 FF FF FF     isc FFFF,x
;--------------------------------------------------------------------------------------------------------------------------------------------------------
; procedura ustawia rne zmienne
;--------------------------------------------------------------------------------------------------------------------------------------------------------
proc9119          mva #$C2 4B
                  mva #$91 4C
                  mva #$27 4D
                  mva #$93 4E
                  mva #$85 4F
                  mva #$95 50
                  mva #$6E 7424
                  mva #$91 7425
                  mva #$8A 7426
                  mva #$91 7427
                  mva #$A6 7428
                  mva #$91 7429
                  mva #$06 7406
                  mva #$04 7407
                  sta $7418
                  sta $7419
                  sta $741A
                  mva #$02 7421
                  sta $7422
                  sta $7423
                  rts

;syf
916E C2 91        nop #91
9170 C2 91        nop #91
9172 14 92        nop 92,x
9174 14 92        nop 92,x
9176 60           rts

9177 92           kil
9178 60           rts

9179 92           kil
917A C2 91        nop #91
917C C2 91        nop #91
917E C2 92        nop #92
9180 C2 92        nop #92
9182 F5 92        sbc 92,x
9184 C2 92        nop #92
9186 00           brk
9187 00           brk
9188 00           brk
9189 00           brk
918A 27 93        rla 93
918C 27 93        rla 93
918E D2           kil
918F 93 D2        ahx (D2),y
9191 93 1F        ahx (1F),y
9193 94 1F        sty 1F,x
9195 94 27        sty 27,x
9197 93 27        ahx (27),y
9199 93 8F        ahx (8F),y
919B 94 8F        sty 8F,x
919D 94 14        sty 14,x
919F 95 8F        sta 8F,x
91A1 94 00        sty 00,x
91A3 00           brk 
91A4 00           brk
91A5 00           brk 
91A6 85 95        sta 95
91A8 85 95        sta 95
91AA E4 95        cpx 95
91AC E4 95        cpx 95
91AE 2A           rol a
91AF 96 2A        stx 2A,y
91B1 96 85        stx 85,y
91B3 95 85        sta 85,x
91B5 95 70        sta 70,x
91B7 96 70        stx 70,y
91B9 96 B6        stx B6,y
91BB 96 70        stx 70,y
91BD 96 00        stx 00,y
91BF 00           brk
91C0 00           brk 
91C1 00           brk 
91C2 C9 41        cmp #41
91C4 CA           dex
91C5 09 CB        ora #CB
91C7 00           brk 
91C8 D1 D6        cmp (D6),y
91CA D0 C8        bne 9194
91CC 0D 04 45     ora 4504
91CF 04 48        nop 48
91D1 04 48        nop 48
91D3 02           kil
91D4 51 02        eor (02),y
91D6 53 04        sre (04),y
91D8 55 04        eor 04,x
91DA 51 08        eor (08),y
91DC 51 04        eor (04),y
91DE 45 04        eor 04
91E0 48           pha
91E1 04 48        nop 48
91E3 02           kil
91E4 51 02        eor (02),y
91E6 55 04        eor 04,x
91E8 55 04        eor 04,x
91EA 53 08        sre (08),y
91EC 53 04        sre (04),y
91EE 45 04        eor 04
91F0 48           pha
91F1 04 48        nop 48
91F3 02           kil
91F4 55 02        eor 02,x
91F6 58           cli
91F7 04 58        nop 58
91F9 04 56        nop 56
91FB 08           php
91FC 56 04        lsr 04,x
91FE 58           cli
91FF 04 56        nop 56
9201 04 55        nop 55
9203 04 53        nop 53
9205 04 51        nop 51
9207 04 4C        nop 4C
9209 04 4A        nop 4A
920B 04 4C        nop 4C
920D CB 20        axs #20
920F 20 51 00     jsr 0051
9212 00           brk 
9213 00           brk 
9214 C8           iny
9215 0F 04 51     slo 5104
9218 04 56        nop 56
921A 04 56        nop 56
921C 02           kil
921D 5A           nop
921E 02           kil
921F 5B 04 61     sre 6104,y
9222 04 5A        nop 5A
9224 08           php
9225 5A           nop
9226 02           kil
9227 61 02        adc (02,x)
9229 63 02        rra (02,x)
922B 61 02        adc (02,x)
922D 5B 02 5A     sre 5A02,y
9230 02           kil
9231 5B 02 5A     sre 5A02,y
9234 02           kil
9235 58           cli
9236 04 56        nop 56
9238 04 5A        nop 5A
923A 08           php
923B 51 04        eor (04),y
923D 51 04        eor (04),y
923F 56 04        lsr 04,x
9241 56 02        lsr 02,x
9243 5A           nop
9244 02           kil
9245 5B 04 61     sre 6104,y
9248 04 5A        nop 5A
924A 08           php
924B 5A           nop
924C 02           kil
924D 61 02        adc (02,x)
924F 63 02        rra (02,x)
9251 61 02        adc (02,x)
9253 5B 02 5A     sre 5A02,y
9256 02           kil
9257 58           cli
9258 02           kil
9259 56 02        lsr 02,x
925B 55 10        eor 10,x
925D 56 00        lsr 00,x
925F 00           brk 
9260 02           kil
9261 66 02        ror 02
9263 63 02        rra (02,x)
9265 5B 02 56     sre 5602,y
9268 02           kil
9269 53 02        sre (02),y
926B 4B 04        alr #04
926D 46 02        lsr 02
926F 46 02        lsr 02
9271 4A           lsr a
9272 02           kil
9273 51 02        eor (02),y
9275 56 02        lsr 02,x
9277 5A           nop
9278 02           kil
9279 61 04        adc (04,x)
927B 66 02        ror 02
927D 65 02        adc 02
927F 66 02        ror 02
9281 65 02        adc 02
9283 63 02        rra (02,x)
9285 61 02        adc (02,x)
9287 63 02        rra (02,x)
9289 61 02        adc (02,x)
928B 5B 04 5A     sre 5A04,y
928E 04 5B        nop 5B
9290 08           php
9291 61 02        adc (02,x)
9293 66 02        ror 02
9295 63 02        rra (02,x)
9297 5B 02 56     sre 5602,y
929A 02           kil
929B 53 02        sre (02),y
929D 4B 04        alr #04
929F 46 02        lsr 02
92A1 46 02        lsr 02
92A3 4A           lsr a
92A4 02           kil
92A5 51 02        eor (02),y
92A7 56 02        lsr 02,x
92A9 5A           nop
92AA 02           kil
92AB 61 04        adc (04,x)
92AD 66 02        ror 02
92AF 65 02        adc 02
92B1 66 02        ror 02
92B3 65 02        adc 02
92B5 63 02        rra (02,x)
92B7 61 02        adc (02,x)
92B9 5B 02 5A     sre 5A02,y
92BC 02           kil
92BD 58           cli
92BE 10 56        bpl 9316  ;slow
92C0 00           brk 
92C1 00           brk 
92C2 D4 C8        nop C8,x
92C4 0C 04 5A     nop 5A04
92C7 04 61        nop 61
92C9 04 56        nop 56
92CB 04 5A        nop 5A
92CD 04 58        nop 58
92CF 04 5B        nop 5B
92D1 04 55        nop 55
92D3 04 58        nop 58
92D5 04 56        nop 56
92D7 04 55        nop 55
92D9 04 56        nop 56
92DB 04 58        nop 58
92DD 10 5A        bpl 9339  ;slow
92DF 04 5A        nop 5A
92E1 04 61        nop 61
92E3 04 56        nop 56
92E5 04 5A        nop 5A
92E7 04 58        nop 58
92E9 04 5B        nop 5B
92EB 04 55        nop 55
92ED 04 58        nop 58
92EF 18           clc
92F0 56 08        lsr 08,x
92F2 00           brk 
92F3 00           brk 
92F4 00           brk 
92F5 04 63        nop 63
92F7 04 66        nop 66
92F9 04 5B        nop 5B
92FB 04 63        nop 63
92FD 04 61        nop 61
92FF 04 64        nop 64
9301 04 5A        nop 5A
9303 04 61        nop 61
9305 04 5B        nop 5B
9307 04 5A        nop 5A
9309 04 5B        nop 5B
930B 04 61        nop 61
930D 08           php
930E 63 08        rra (08,x)
9310 5B 04 63     sre 6304,y
9313 04 66        nop 66
9315 04 5B        nop 5B
9317 04 63        nop 63
9319 04 61        nop 61
931B 04 64        nop 64
931D 04 5A        nop 5A
931F 04 61        nop 61
9321 18           clc
9322 5B 08 00     sre 0008,y
9325 00           brk
9326 00           brk 
9327 C9 41        cmp #41
9329 CA           dex
932A 07 CB        slo CB
932C 20 D8 01     jsr 01D8
932F 01 02        ora (02,x)
9331 51 02        eor (02),y
9333 58           cli
9334 02           kil
9335 55 02        eor 02,x
9337 58           cli
9338 02           kil
9339 51 02        eor (02),y
933B 58           cli
933C 02           kil
933D 55 02        eor 02,x
933F 58           cli
9340 02           kil
9341 51 02        eor (02),y
9343 58           cli
9344 02           kil
9345 55 02        eor 02,x
9347 58           cli
9348 02           kil
9349 51 02        eor (02),y
934B 58           cli
934C 02           kil
934D 55 02        eor 02,x
934F 58           cli
9350 02           kil
9351 51 02        eor (02),y
9353 58           cli
9354 02           kil
9355 55 02        eor 02,x
9357 58           cli
9358 02           kil
9359 51 02        eor (02),y
935B 58           cli
935C 02           kil
935D 55 02        eor 02,x
935F 58           cli
9360 02           kil
9361 58           cli
9362 02           kil
9363 63 02        rra (02,x)
9365 5C 02 63     nop 6302,x
9368 02           kil
9369 58           cli
936A 02           kil
936B 63 02        rra (02,x)
936D 5C 02 63     nop 6302,x
9370 02           kil
9371 51 02        eor (02),y
9373 58           cli
9374 02           kil
9375 55 02        eor 02,x
9377 58           cli
9378 02           kil
9379 51 02        eor (02),y
937B 58           cli
937C 02           kil
937D 55 02        eor 02,x
937F 58           cli
9380 02           kil
9381 56 02        lsr 02,x
9383 61 02        adc (02,x)
9385 5A           nop
9386 02           kil
9387 61 02        adc (02,x)
9389 56 02        lsr 02,x
938B 61 02        adc (02,x)
938D 5A           nop
938E 02           kil
938F 61 02        adc (02,x)
9391 58           cli
9392 02           kil
9393 63 02        rra (02,x)

                  org $9800
title_chars_9800  ins "title_chars_9800"  ; 800 bajtw - 40x20 - znaki ekranu tytuowego
                  
                  org $9C00
title_attrib_9c00 ins "title_attrib_9C00" ; 760 bajtw - 40x19 - atrybuty znakowe ekranu tytuowego

                  org $A000 ;-$A7FF   plansze 1 i 2 - 30x20 znakw (po 1KB)

                  org $A800 ;-$CFFF   zestawy 1,2,3,4,5, ksztatw znakw (po 2KB)
                  
                  org $F400 ;-$FFFF   plansze 3,4,5, - 30x20 znakw (po 1KB)
